/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ColorUtils {
    private static final double THRESHOLD = 4.5;
    private static final String DISABLED_PREFIX = "Disabled";

    @NotNull
    public static String getContrastWarningMessage(@NotNull Map<String, Color> contrastColorsWithDescription, @NotNull Color color, boolean isBackground) {
        ImmutableSet.Builder lowContrastColorsBuilder = ImmutableSet.builder();
        for (Map.Entry<String, Color> contrastColor : contrastColorsWithDescription.entrySet()) {
            Color backgroundColor;
            String colorDescription = contrastColor.getKey();
            if (colorDescription.startsWith(DISABLED_PREFIX)) continue;
            Color otherColor = contrastColor.getValue();
            if (isBackground) {
                backgroundColor = ColorUtils.worstContrastColor(otherColor, color);
                color = ColorUtils.alphaBlending(color, backgroundColor);
                otherColor = ColorUtils.alphaBlending(otherColor, color);
            } else {
                backgroundColor = ColorUtils.worstContrastColor(color, otherColor);
                otherColor = ColorUtils.alphaBlending(otherColor, backgroundColor);
                color = ColorUtils.alphaBlending(color, otherColor);
            }
            if (!(ColorUtils.calculateContrastRatio(color, otherColor) < 4.5)) continue;
            lowContrastColorsBuilder.add((Object)colorDescription);
        }
        ImmutableSet lowContrastColors = lowContrastColorsBuilder.build();
        if (!lowContrastColors.isEmpty()) {
            return "<html>Not enough contrast with " + ThemeEditorUtils.generateWordEnumeration((Collection<String>)lowContrastColors);
        }
        return "";
    }

    @NotNull
    public static Color worstContrastColor(@NotNull Color foreground, @NotNull Color background) {
        int backgroundAlpha = background.getAlpha();
        int r = ColorUtils.worstContrastComponent(foreground.getRed(), background.getRed(), backgroundAlpha);
        int g = ColorUtils.worstContrastComponent(foreground.getGreen(), background.getGreen(), backgroundAlpha);
        int b = ColorUtils.worstContrastComponent(foreground.getBlue(), background.getBlue(), backgroundAlpha);
        return new Color(r, g, b);
    }

    private static int worstContrastComponent(int foregroundComponent, int backgroundComponent, int backgroundAlpha) {
        if (backgroundAlpha == 255) {
            return 0;
        }
        int component = (255 * foregroundComponent - backgroundAlpha * backgroundComponent) / (255 - backgroundAlpha);
        return IdeResourcesUtil.clamp(component, 0, 255);
    }

    @NotNull
    public static Color alphaBlending(@NotNull Color foreground, @NotNull Color background) {
        float foregroundAlpha = (float)foreground.getAlpha() / 255.0f;
        float backgroundAlpha = (float)background.getAlpha() / 255.0f;
        float a = foregroundAlpha + backgroundAlpha * (1.0f - foregroundAlpha);
        float r = ColorUtils.alphaBlendingComponent(foreground.getRed(), foregroundAlpha, background.getRed(), backgroundAlpha);
        float g = ColorUtils.alphaBlendingComponent(foreground.getGreen(), foregroundAlpha, background.getGreen(), backgroundAlpha);
        float b = ColorUtils.alphaBlendingComponent(foreground.getBlue(), foregroundAlpha, background.getBlue(), backgroundAlpha);
        return new Color(r, g, b, a);
    }

    private static float alphaBlendingComponent(int foregroundComponent, float foregroundAlpha, int backgroundComponent, float backgroundAlpha) {
        float alpha = foregroundAlpha + backgroundAlpha * (1.0f - foregroundAlpha);
        if ((double)Math.abs(alpha) < 0.001) {
            return 1.0f;
        }
        return (foregroundAlpha * (float)foregroundComponent + backgroundAlpha * (float)backgroundComponent * (1.0f - foregroundAlpha)) / (255.0f * alpha);
    }

    public static double calculateContrastRatio(@NotNull Color color1, @NotNull Color color2) {
        double color1Luminance = ColorUtils.calculateColorLuminance(color1);
        double color2Luminance = ColorUtils.calculateColorLuminance(color2);
        return (Math.max(color1Luminance, color2Luminance) + 0.05) / (Math.min(color2Luminance, color1Luminance) + 0.05);
    }

    private static double calculateColorLuminance(@NotNull Color color) {
        return ColorUtils.calculateLuminanceContribution((double)color.getRed() / 255.0) * 0.2126 + ColorUtils.calculateLuminanceContribution((double)color.getGreen() / 255.0) * 0.7152 + ColorUtils.calculateLuminanceContribution((double)color.getBlue() / 255.0) * 0.0722;
    }

    private static double calculateLuminanceContribution(double colorValue) {
        if (colorValue <= 0.03928) {
            return colorValue / 12.92;
        }
        return Math.pow((colorValue + 0.055) / 1.055, 2.4);
    }
}

