/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.StringResourceEditor;
import com.android.tools.idea.editors.strings.table.FrozenColumnTable;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableCellRenderer;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.awt.Font;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StringsCellRenderer
extends FrozenColumnTableCellRenderer<StringResourceTableModel> {
    private static final SimpleTextAttributes CELL_ERROR_ATTRIBUTES = new SimpleTextAttributes(8, (Color)JBColor.red);

    StringsCellRenderer() {
    }

    @Override
    void customizeCellRenderer(@NotNull FrozenColumnTable<StringResourceTableModel> table2, @Nullable Object value2, int viewRowIndex, int viewColumnIndex) {
        Font f;
        if (!(value2 instanceof String)) {
            return;
        }
        String s = (String)value2;
        if (StringUtil.containsChar((String)s, (char)'\n')) {
            s = StringsCellRenderer.clip(s);
        }
        int modelRowIndex = table2.convertRowIndexToModel(viewRowIndex);
        int modelColumnIndex = table2.convertColumnIndexToModel(viewColumnIndex);
        String problem = table2.getModel().getCellProblem(modelRowIndex, modelColumnIndex);
        SimpleTextAttributes attributes = problem == null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : (modelColumnIndex == 0 ? SimpleTextAttributes.ERROR_ATTRIBUTES : CELL_ERROR_ATTRIBUTES);
        Font currentFont = table2.getFont();
        if (!currentFont.equals(f = StringResourceEditor.getFont(currentFont))) {
            this.setFont(f);
        }
        this.setToolTipText(problem);
        this.append(s, attributes);
    }

    private static String clip(String str) {
        int end = str.indexOf(10);
        return end < 0 ? str : str.substring(0, end) + "[...]";
    }
}

