/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.ide.common.resources.ValueXmlHelper;
import com.android.tools.idea.editors.strings.StringResourceEditor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public final class StringTableCellEditor
extends DefaultCellEditor {
    StringTableCellEditor() {
        this(new JTextField());
    }

    @VisibleForTesting
    StringTableCellEditor(@NotNull JTextField component) {
        super(component);
    }

    @VisibleForTesting
    public void setCellEditorValue(@NotNull Object value2) {
        this.delegate.setValue(value2);
    }

    @Override
    public JTextComponent getComponent() {
        return (JTextComponent)this.editorComponent;
    }

    @Override
    @NotNull
    public Component getTableCellEditorComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, int row, int column) {
        JComponent component = (JComponent)super.getTableCellEditorComponent(table2, value2, selected, row, column);
        component.setBorder(new LineBorder((Color)JBColor.BLACK));
        component.setFont(StringResourceEditor.getFont(component.getFont()));
        return component;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            ValueXmlHelper.escapeResourceStringAsXml((String)((String)this.getCellEditorValue()));
            return super.stopCellEditing();
        }
        catch (IllegalArgumentException exception) {
            this.getComponent().setBorder(new LineBorder((Color)JBColor.RED));
            return false;
        }
    }
}

