/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.rendering.FlagManager;
import com.android.tools.idea.rendering.Locale;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

final class LocaleRenderer
implements TableCellRenderer {
    private final TableCellRenderer myRenderer;

    LocaleRenderer(@NotNull TableCellRenderer renderer2) {
        this.myRenderer = renderer2;
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, boolean focused, int row, int column) {
        Component component = this.myRenderer.getTableCellRendererComponent(table2, value2, selected, focused, row, column);
        TableModel model2 = table2.getModel();
        if (component instanceof JLabel && model2 instanceof StringResourceTableModel) {
            Locale locale = ((StringResourceTableModel)model2).getLocale(table2.convertColumnIndexToModel(column));
            assert (locale != null);
            if (FlagManager.showFlagsForLanguages()) {
                ((JLabel)component).setIcon(locale.getFlagImage());
            } else {
                ((JLabel)component).setIcon(null);
            }
        }
        return component;
    }
}

