/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringsWriteUtils {
    public static void removeLocale(@NotNull Locale locale, @NotNull AndroidFacet facet2, @NotNull Object requestor) {
        WriteCommandAction.writeCommandAction((Project)facet2.getModule().getProject()).withName("Remove " + locale + " Locale").withGlobalUndo().run(() -> {
            FolderConfiguration configuration = new FolderConfiguration();
            configuration.setLocaleQualifier(locale.qualifier);
            String name = configuration.getFolderName(ResourceFolderType.VALUES);
            ResourceFolderManager.getInstance(facet2).getFolders().stream().map(directory -> directory.findChild(name)).filter(Objects::nonNull).forEach(directory -> StringsWriteUtils.delete(directory, requestor));
        });
    }

    private static void delete(@NotNull VirtualFile file2, @NotNull Object requestor) {
        try {
            file2.delete(requestor);
        }
        catch (IOException exception) {
            Logger.getInstance(StringsWriteUtils.class).warn((Throwable)exception);
        }
    }

    public static boolean setAttributeForItems(final @NotNull Project project, final @NotNull String attribute, final @Nullable String value2, @NotNull List<ResourceItem> items2) {
        if (items2.isEmpty()) {
            return false;
        }
        final ArrayList tags2 = Lists.newArrayListWithExpectedSize((int)items2.size());
        HashSet files2 = Sets.newHashSetWithExpectedSize((int)items2.size());
        for (ResourceItem item : items2) {
            XmlTag tag = IdeResourcesUtil.getItemTag(project, item);
            if (tag == null) {
                return false;
            }
            tags2.add(tag);
            files2.add(tag.getContainingFile());
        }
        final boolean deleteTag = attribute.equals("name") && (value2 == null || value2.isEmpty());
        new WriteCommandAction.Simple(project, "Setting attribute " + attribute, files2.toArray(PsiFile.EMPTY_ARRAY)){

            public void run() {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                for (XmlTag tag : tags2) {
                    if (deleteTag) {
                        tag.delete();
                        continue;
                    }
                    tag.setAttribute(attribute, value2);
                }
            }
        }.execute();
        return true;
    }

    public static boolean setItemText(final @NotNull Project project, @NotNull ResourceItem item, final @NotNull String value2) {
        if (value2.isEmpty()) {
            return StringsWriteUtils.setAttributeForItems(project, "name", null, Collections.singletonList(item));
        }
        final XmlTag tag = IdeResourcesUtil.getItemTag(project, item);
        if (tag != null) {
            new WriteCommandAction.Simple(project, "Setting value of " + item.getName(), new PsiFile[]{tag.getContainingFile()}){

                public void run() {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                    for (XmlTagChild child : tag.getValue().getChildren()) {
                        child.delete();
                    }
                    XmlElementFactory factory2 = XmlElementFactory.getInstance((Project)project);
                    XmlTag text2 = factory2.createTagFromText((CharSequence)("<string>" + StringsWriteUtils.escapeResourceStringAsXml(value2) + "</string>"));
                    for (XmlTagChild psiElement : text2.getValue().getChildren()) {
                        tag.add((PsiElement)psiElement);
                    }
                }
            }.execute();
            return true;
        }
        return false;
    }

    @Nullable
    public static ResourceItem createItem(@NotNull AndroidFacet facet2, @NotNull VirtualFile resFolder, @Nullable Locale locale, final @NotNull String name, final @NotNull String value2, final boolean translatable) {
        final Project project = facet2.getModule().getProject();
        XmlFile resourceFile = StringsWriteUtils.getStringResourceFile(project, resFolder, locale);
        if (resourceFile == null) {
            return null;
        }
        final XmlTag root2 = resourceFile.getRootTag();
        if (root2 == null) {
            return null;
        }
        new WriteCommandAction.Simple(project, "Creating string " + name, new PsiFile[]{resourceFile}){

            public void run() {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                XmlTag child = root2.createChildTag(ResourceType.STRING.getName(), root2.getNamespace(), StringsWriteUtils.escapeResourceStringAsXml(value2), false);
                child.setAttribute("name", name);
                child.setAttribute("translatable", translatable ? null : "false");
                root2.addSubTag(child, false);
            }
        }.execute();
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return StringsWriteUtils.getStringResourceItem(facet2, name, locale);
        }
        return (ResourceItem)ApplicationManager.getApplication().runReadAction(() -> StringsWriteUtils.getStringResourceItem(facet2, name, locale));
    }

    @Nullable
    private static ResourceItem getStringResourceItem(@NotNull AndroidFacet facet2, @NotNull String key, @Nullable Locale locale) {
        LocalResourceRepository repository = ResourceRepositoryManager.getModuleResources(facet2);
        repository.sync();
        List<ResourceItem> items2 = repository.getResources(ResourceNamespace.TODO(), ResourceType.STRING, key);
        for (ResourceItem item : items2) {
            Locale l;
            LocaleQualifier qualifier;
            FolderConfiguration config = item.getConfiguration();
            LocaleQualifier localeQualifier = qualifier = config == null ? null : config.getLocaleQualifier();
            if (!(qualifier == null ? locale == null : (l = Locale.create(qualifier)).equals(locale))) continue;
            return item;
        }
        return null;
    }

    @Nullable
    static XmlFile getStringResourceFile(@NotNull Project project, final @NotNull VirtualFile resFolder, @Nullable Locale locale) {
        XmlFile resourceFile;
        FolderConfiguration configuration = new FolderConfiguration();
        if (locale != null) {
            configuration.setLocaleQualifier(locale.qualifier);
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        final String valuesFolderName = configuration.getFolderName(ResourceFolderType.VALUES);
        VirtualFile valuesFolder = resFolder.findChild(valuesFolderName);
        if (valuesFolder == null && (valuesFolder = (VirtualFile)new WriteCommandAction<VirtualFile>(project, "Creating directory " + valuesFolderName, new PsiFile[]{manager.findFile(resFolder)}){

            public void run(@NotNull Result<VirtualFile> result2) {
                try {
                    result2.setResult((Object)resFolder.createChildDirectory((Object)this, valuesFolderName));
                }
                catch (IOException ex) {
                    result2.setResult(null);
                }
            }
        }.execute().getResultObject()) == null) {
            return null;
        }
        String resourceFileName = IdeResourcesUtil.getDefaultResourceFileName(ResourceType.STRING);
        if (resourceFileName == null) {
            return null;
        }
        VirtualFile resourceVirtualFile = valuesFolder.findChild(resourceFileName);
        if (resourceVirtualFile == null) {
            PsiDirectory valuesDir = manager.findDirectory(valuesFolder);
            if (valuesDir == null) {
                return null;
            }
            try {
                resourceFile = IdeResourcesUtil.createFileResource(resourceFileName, valuesDir, "", ResourceType.STRING.getName(), true);
            }
            catch (Exception ex) {
                return null;
            }
        } else {
            PsiFile resourcePsiFile = manager.findFile(resourceVirtualFile);
            if (!(resourcePsiFile instanceof XmlFile)) {
                return null;
            }
            resourceFile = (XmlFile)resourcePsiFile;
        }
        return resourceFile;
    }

    @NotNull
    private static String escapeResourceStringAsXml(@NotNull String xml) {
        try {
            return ValueXmlHelper.escapeResourceStringAsXml((String)xml);
        }
        catch (IllegalArgumentException exception) {
            Logger.getInstance(StringsWriteUtils.class).warn((Throwable)exception);
            return xml;
        }
    }
}

