/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.ui;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollOverTree
extends Tree {
    private final List<TreeHoverListener> mHoverListeners = Lists.newArrayList();
    @Nullable
    private TreePath mHoverPath = null;

    public RollOverTree() {
        this(JTree.getDefaultTreeModel());
    }

    public RollOverTree(TreeNode root2) {
        this(new DefaultTreeModel(root2, false));
    }

    public RollOverTree(TreeModel treemodel) {
        super(treemodel);
        this.setOpaque(false);
        RollOverAdapter adapter = new RollOverAdapter();
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
    }

    @Nullable
    public TreePath getPathForEvent(@NotNull MouseEvent e) {
        int row = this.getClosestRowForLocation(e.getX(), e.getY());
        Rectangle bounds2 = this.getRowBounds(row);
        if (bounds2 == null) {
            row = -1;
        } else if (bounds2.y + bounds2.height < e.getY()) {
            row = -1;
        }
        return row == -1 ? null : this.getPathForRow(row);
    }

    public void updateHoverPath(@Nullable TreePath hoverPath) {
        if (!Objects.equal((Object)this.mHoverPath, (Object)hoverPath)) {
            this.repaint(this.mHoverPath);
            this.mHoverPath = hoverPath;
            this.repaint(this.mHoverPath);
            for (TreeHoverListener listener2 : this.mHoverListeners) {
                listener2.onTreeCellHover(hoverPath);
            }
        }
    }

    private void repaint(@Nullable TreePath path2) {
        Rectangle r;
        if (path2 != null && (r = this.getPathBounds(path2)) != null) {
            this.repaint(0, r.y, this.getWidth(), r.height);
        }
    }

    protected void paintComponent(Graphics g) {
        if (this.mHoverPath != null && !this.mHoverPath.equals(this.getSelectionPath())) {
            g.setColor(UIUtil.AQUA_SEPARATOR_BACKGROUND_COLOR);
            Rectangle r = this.getPathBounds(this.mHoverPath);
            if (r != null) {
                g.fillRect(0, r.y, this.getWidth(), r.height);
            }
        }
        super.paintComponent(g);
    }

    public void addTreeHoverListener(@NotNull TreeHoverListener listener2) {
        this.mHoverListeners.add(listener2);
    }

    public void removeTreeHoverListener(@NotNull TreeHoverListener listener2) {
        this.mHoverListeners.remove(listener2);
    }

    public static interface TreeHoverListener {
        public void onTreeCellHover(@Nullable TreePath var1);
    }

    private class RollOverAdapter
    extends MouseAdapter {
        private RollOverAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RollOverTree.this.updateHoverPath(RollOverTree.this.getPathForEvent(e));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RollOverTree.this.updateHoverPath(null);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            RollOverTree.this.updateHoverPath(RollOverTree.this.getPathForEvent(e));
        }
    }
}

