/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.analysis;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisContext;
import com.android.tools.idea.diagnostics.hprof.analysis.GCRootPathsTree$Status$WhenMappings;
import com.android.tools.idea.diagnostics.hprof.analysis.RefIndexUtil;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.navigator.ObjectNavigator;
import com.android.tools.idea.diagnostics.hprof.navigator.RootReason;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import com.android.tools.idea.diagnostics.hprof.util.IntList;
import com.android.tools.idea.diagnostics.hprof.util.TruncatingPrintBuffer;
import com.android.tools.idea.diagnostics.hprof.util.UByteList;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\t\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree;", "", "context", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisContext;", "treeDisplayOptions", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$TreeDisplayOptions;", "allObjectsOfClass", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "(Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisContext;Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$TreeDisplayOptions;Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;)V", "countOfIgnoredObjects", "", "objectSizeStrategy", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "topNode", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RootNode;", "getDisposedDominatorNodes", "", "", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "printTree", "", "registerObject", "", "objectId", "AllObjectsSameSizeStrategy", "DirectByteBufferNativeSizeStrategy", "Edge", "Node", "ObjectSizeCalculationStrategy", "RegularNode", "RootNode", "SizeFromObjectNavigatorStrategy", "Status", "intellij.android.core"})
public final class GCRootPathsTree {
    private final RootNode topNode;
    private int countOfIgnoredObjects;
    private final ObjectSizeCalculationStrategy objectSizeStrategy;
    private final AnalysisContext context;
    private final AnalysisConfig.TreeDisplayOptions treeDisplayOptions;

    /*
     * WARNING - void declaration
     */
    public final void registerObject(int objectId) {
        ObjectNavigator nav = this.context.getNavigator();
        IntList parentMapping = this.context.getParentList();
        UByteList refIndexMapping = this.context.getRefIndexList();
        IntList sizesMapping = this.context.getSizesList();
        TIntHashSet disposedObjectsIDsSet = this.context.getDisposedObjectsIDs();
        TIntArrayList gcPath = new TIntArrayList();
        TIntArrayList fieldsPath = new TIntArrayList();
        TIntArrayList sizesPath = new TIntArrayList();
        int objectIterationId = objectId;
        int parentId = parentMapping.get(objectIterationId);
        int maxTreeDepth = this.treeDisplayOptions.getMaximumTreeDepth();
        for (int count = 0; count < maxTreeDepth && parentId != objectIterationId; ++count) {
            gcPath.add(objectIterationId);
            fieldsPath.add(refIndexMapping.get(objectIterationId));
            sizesPath.add(sizesMapping.get(objectIterationId));
            objectIterationId = parentId;
            parentId = parentMapping.get(objectIterationId);
        }
        fieldsPath.add(251);
        if (parentId != objectIterationId) {
            int n = this.countOfIgnoredObjects;
            this.countOfIgnoredObjects = n + 1;
            return;
        }
        gcPath.add(objectIterationId);
        sizesPath.add(sizesMapping.get(objectIterationId));
        boolean bl = gcPath.size() == fieldsPath.size();
        boolean bl2 = false;
        int n = 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int size = this.objectSizeStrategy.calculateObjectSize(nav, objectId);
        Node currentNode = this.topNode;
        n = gcPath.size() - 1;
        boolean bl4 = false;
        while (n >= 0) {
            void i2;
            int id = gcPath.get((int)i2);
            ClassDefinition classDefinition = nav.getClassForObjectId(id);
            currentNode = currentNode.addEdge(id, size, sizesPath.get((int)i2), classDefinition, (byte)fieldsPath.get((int)i2), disposedObjectsIDsSet.contains(id));
            --i2;
        }
    }

    @NotNull
    public final String printTree() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        if (this.countOfIgnoredObjects > 0) {
            $this$buildString.append("Ignored " + this.countOfIgnoredObjects + " too-deep objects\n");
        }
        Function1 rootReasonGetter = (Function1)new Function1<Integer, String>(this){
            final /* synthetic */ GCRootPathsTree this$0;
            {
                this.this$0 = gCRootPathsTree;
                super(1);
            }

            @NotNull
            public final String invoke(int id) {
                Object object = GCRootPathsTree.access$getContext$p(this.this$0).getNavigator().getRootReasonForObjectId(id);
                if (object == null || (object = ((RootReason)object).getDescription()) == null) {
                    object = "<Couldn't find root description>";
                }
                return object;
            }
        };
        $this$buildString.append(this.topNode.createHotPathReport(this.treeDisplayOptions, (Function1<? super Integer, String>)rootReasonGetter));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final Map<ClassDefinition, List<RegularNode>> getDisposedDominatorNodes() {
        HashMap result2 = new HashMap();
        this.topNode.collectDisposedDominatorNodes(result2);
        return result2;
    }

    public GCRootPathsTree(@NotNull AnalysisContext context, @NotNull AnalysisConfig.TreeDisplayOptions treeDisplayOptions, @Nullable ClassDefinition allObjectsOfClass) {
        this.context = context;
        this.treeDisplayOptions = treeDisplayOptions;
        this.topNode = new RootNode(this.context.getClassStore());
        this.objectSizeStrategy = ObjectSizeCalculationStrategy.Companion.getBestStrategyForClass(allObjectsOfClass);
    }

    public static final /* synthetic */ AnalysisContext access$getContext$p(GCRootPathsTree $this) {
        return $this.context;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0001\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Status;", "", "(Ljava/lang/String;I)V", "getStatusCharacter", "", "toString", "", "None", "Warning", "LastInPath", "Companion", "intellij.android.core"})
    private static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status None;
        public static final /* enum */ Status Warning;
        public static final /* enum */ Status LastInPath;
        private static final /* synthetic */ Status[] $VALUES;
        public static final Companion Companion;

        static {
            Status[] statusArray = new Status[3];
            Status[] statusArray2 = statusArray;
            statusArray[0] = None = new Status();
            statusArray[1] = Warning = new Status();
            statusArray[2] = LastInPath = new Status();
            $VALUES = statusArray;
            Companion = new Companion(null);
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.getStatusCharacter());
        }

        public final char getStatusCharacter() {
            char c;
            switch (GCRootPathsTree$Status$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    c = ' ';
                    break;
                }
                case 2: {
                    c = '!';
                    break;
                }
                case 3: {
                    c = '*';
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return c;
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String string) {
            return Enum.valueOf(Status.class, string);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Status$Companion;", "", "()V", "getStatus", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Status;", "refIndex", "", "lastInPath", "", "disposed", "intellij.android.core"})
        public static final class Companion {
            @NotNull
            public final Status getStatus(int refIndex, boolean lastInPath, boolean disposed) {
                return lastInPath ? LastInPath : (disposed ? Warning : (refIndex == 252 ? Warning : (refIndex == 253 ? Warning : None)));
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "", "calculateObjectSize", "", "nav", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "id", "Companion", "intellij.android.core"})
    public static interface ObjectSizeCalculationStrategy {
        public static final Companion Companion = Companion.$$INSTANCE;

        public int calculateObjectSize(@NotNull ObjectNavigator var1, int var2);

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy$Companion;", "", "()V", "getBestStrategyForClass", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "intellij.android.core"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            @NotNull
            public final ObjectSizeCalculationStrategy getBestStrategyForClass(@Nullable ClassDefinition classDefinition) {
                if (classDefinition == null || classDefinition.isArray()) {
                    return new SizeFromObjectNavigatorStrategy();
                }
                if (Intrinsics.areEqual((Object)classDefinition.getName(), (Object)"java.nio.DirectByteBuffer")) {
                    return new DirectByteBufferNativeSizeStrategy(classDefinition);
                }
                return new AllObjectsSameSizeStrategy(classDefinition.getInstanceSize() + ClassDefinition.Companion.getOBJECT_PREAMBLE_SIZE());
            }

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$AllObjectsSameSizeStrategy;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "objectSize", "", "(I)V", "calculateObjectSize", "nav", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "id", "intellij.android.core"})
    private static final class AllObjectsSameSizeStrategy
    implements ObjectSizeCalculationStrategy {
        private final int objectSize;

        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id) {
            return this.objectSize;
        }

        public AllObjectsSameSizeStrategy(int objectSize) {
            this.objectSize = objectSize;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$SizeFromObjectNavigatorStrategy;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "()V", "calculateObjectSize", "", "nav", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "id", "intellij.android.core"})
    private static final class SizeFromObjectNavigatorStrategy
    implements ObjectSizeCalculationStrategy {
        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id) {
            nav.goTo(id, ObjectNavigator.ReferenceResolution.NO_REFERENCES);
            return nav.getObjectSize();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$DirectByteBufferNativeSizeStrategy;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;)V", "calculateObjectSize", "", "nav", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "id", "intellij.android.core"})
    private static final class DirectByteBufferNativeSizeStrategy
    implements ObjectSizeCalculationStrategy {
        private final ClassDefinition classDefinition;

        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id) {
            nav.goTo(id, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
            boolean bl = Intrinsics.areEqual((Object)nav.getClass(), (Object)this.classDefinition);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return nav.getExtraData() + nav.getObjectSize();
        }

        public DirectByteBufferNativeSizeStrategy(@NotNull ClassDefinition classDefinition) {
            this.classDefinition = classDefinition;
            boolean bl = Intrinsics.areEqual((Object)this.classDefinition.getName(), (Object)"java.nio.DirectByteBuffer");
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J8\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Node;", "", "addEdge", "objectId", "", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "refIndex", "", "disposed", "", "intellij.android.core"})
    public static interface Node {
        @NotNull
        public Node addEdge(int var1, int var2, int var3, @NotNull ClassDefinition var4, byte var5, boolean var6);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "refIndex", "", "disposed", "", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;BZ)V", "getClassDefinition", "()Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "getDisposed", "()Z", "getRefIndex", "()B", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.android.core"})
    public static final class Edge {
        @NotNull
        private final ClassDefinition classDefinition;
        private final byte refIndex;
        private final boolean disposed;

        @NotNull
        public final ClassDefinition getClassDefinition() {
            return this.classDefinition;
        }

        public final byte getRefIndex() {
            return this.refIndex;
        }

        public final boolean getDisposed() {
            return this.disposed;
        }

        public Edge(@NotNull ClassDefinition classDefinition, byte refIndex, boolean disposed) {
            this.classDefinition = classDefinition;
            this.refIndex = refIndex;
            this.disposed = disposed;
        }

        @NotNull
        public final ClassDefinition component1() {
            return this.classDefinition;
        }

        public final byte component2() {
            return this.refIndex;
        }

        public final boolean component3() {
            return this.disposed;
        }

        @NotNull
        public final Edge copy(@NotNull ClassDefinition classDefinition, byte refIndex, boolean disposed) {
            return new Edge(classDefinition, refIndex, disposed);
        }

        public static /* synthetic */ Edge copy$default(Edge edge, ClassDefinition classDefinition, byte by, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                classDefinition = edge.classDefinition;
            }
            if ((n & 2) != 0) {
                by = edge.refIndex;
            }
            if ((n & 4) != 0) {
                bl = edge.disposed;
            }
            return edge.copy(classDefinition, by, bl);
        }

        @NotNull
        public String toString() {
            return "Edge(classDefinition=" + this.classDefinition + ", refIndex=" + this.refIndex + ", disposed=" + this.disposed + ")";
        }

        public int hashCode() {
            ClassDefinition classDefinition = this.classDefinition;
            int n = ((classDefinition != null ? ((Object)classDefinition).hashCode() : 0) * 31 + Byte.hashCode(this.refIndex)) * 31;
            int n2 = this.disposed ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Edge)) break block3;
                    Edge edge = (Edge)object;
                    if (!Intrinsics.areEqual((Object)this.classDefinition, (Object)edge.classDefinition) || this.refIndex != edge.refIndex || this.disposed != edge.disposed) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020%2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000(0'R(\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Node;", "()V", "edges", "Ljava/util/HashMap;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "getEdges", "()Ljava/util/HashMap;", "setEdges", "(Ljava/util/HashMap;)V", "instances", "Lgnu/trove/TIntHashSet;", "getInstances", "()Lgnu/trove/TIntHashSet;", "pathsCount", "", "getPathsCount", "()I", "setPathsCount", "(I)V", "pathsSize", "getPathsSize", "setPathsSize", "totalSizeInDwords", "getTotalSizeInDwords", "setTotalSizeInDwords", "addEdge", "objectId", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "refIndex", "", "disposed", "", "collectDisposedDominatorNodes", "", "result", "", "", "intellij.android.core"})
    public static final class RegularNode
    implements Node {
        @Nullable
        private HashMap<Edge, RegularNode> edges;
        private int pathsCount;
        private int pathsSize;
        private int totalSizeInDwords;
        @NotNull
        private final TIntHashSet instances = new TIntHashSet(1);

        @Nullable
        public final HashMap<Edge, RegularNode> getEdges() {
            return this.edges;
        }

        public final void setEdges(@Nullable HashMap<Edge, RegularNode> hashMap) {
            this.edges = hashMap;
        }

        public final int getPathsCount() {
            return this.pathsCount;
        }

        public final void setPathsCount(int n) {
            this.pathsCount = n;
        }

        public final int getPathsSize() {
            return this.pathsSize;
        }

        public final void setPathsSize(int n) {
            this.pathsSize = n;
        }

        public final int getTotalSizeInDwords() {
            return this.totalSizeInDwords;
        }

        public final void setTotalSizeInDwords(int n) {
            this.totalSizeInDwords = n;
        }

        @NotNull
        public final TIntHashSet getInstances() {
            return this.instances;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Node addEdge(int objectId, int objectSize, int subgraphSizeInDwords, @NotNull ClassDefinition classDefinition, byte refIndex, boolean disposed) {
            Object object;
            void $this$getOrPut$iv22;
            HashMap<Edge, RegularNode> localEdges = this.edges;
            if (localEdges == null) {
                this.edges = localEdges = new HashMap(1);
            }
            Map map2 = localEdges;
            Edge key$iv = new Edge(classDefinition, refIndex, disposed);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv22.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                RegularNode answer$iv = new RegularNode();
                $this$getOrPut$iv22.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            RegularNode node2 = (RegularNode)object;
            int $this$getOrPut$iv22 = node2.pathsCount;
            node2.pathsCount = $this$getOrPut$iv22 + 1;
            node2.pathsSize = (long)node2.pathsSize + (long)objectSize > (long)Integer.MAX_VALUE ? Integer.MAX_VALUE : (node2.pathsSize += objectSize);
            boolean added = node2.instances.add(objectId);
            if (added) {
                node2.totalSizeInDwords = (long)node2.totalSizeInDwords + (long)subgraphSizeInDwords > (long)Integer.MAX_VALUE ? Integer.MAX_VALUE : (node2.totalSizeInDwords += subgraphSizeInDwords);
            }
            return node2;
        }

        /*
         * WARNING - void declaration
         */
        public final void collectDisposedDominatorNodes(@NotNull Map<ClassDefinition, List<RegularNode>> result2) {
            ArrayDeque<RegularNode> stack = new ArrayDeque<RegularNode>();
            stack.push(this);
            block0: while (true) {
                Collection collection2 = stack;
                boolean bl = false;
                if (!(!collection2.isEmpty())) break;
                RegularNode currentNode = (RegularNode)stack.pop();
                HashMap<Edge, RegularNode> hashMap = currentNode.edges;
                if (hashMap == null) continue;
                Map $this$forEach$iv = hashMap;
                boolean $i$f$forEach = false;
                Map map2 = $this$forEach$iv;
                boolean bl2 = false;
                Iterator iterator = map2.entrySet().iterator();
                while (true) {
                    void edge;
                    Map.Entry element$iv;
                    if (!iterator.hasNext()) continue block0;
                    Map.Entry $dstr$edge$childNode = element$iv = iterator.next();
                    boolean bl3 = false;
                    Object object = $dstr$edge$childNode;
                    boolean bl4 = false;
                    Edge edge2 = (Edge)object.getKey();
                    object = $dstr$edge$childNode;
                    bl4 = false;
                    RegularNode childNode = (RegularNode)object.getValue();
                    if (edge.getDisposed()) {
                        Object object2;
                        void $this$getOrPut$iv;
                        object = result2;
                        ClassDefinition key$iv = edge.getClassDefinition();
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl5 = false;
                            boolean bl6 = false;
                            List answer$iv = new ArrayList();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv;
                        }
                        ((List)object2).add(childNode);
                        continue;
                    }
                    stack.push(childNode);
                }
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0002J \u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001c0\u001bJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001e0\"J\u007f\u0010#\u001a\u00020\u00192\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020%0\"2\b\u0010&\u001a\u0004\u0018\u00010\u000e2\b\u0010'\u001a\u0004\u0018\u00010\u000e2\b\u0010(\u001a\u0004\u0018\u00010\u000e2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010\u000e2\u0006\u0010,\u001a\u00020-2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010.\u001a\u0004\u0018\u00010\u001e2\u0006\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u00101R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00063"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RootNode;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Node;", "classStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;)V", "edges", "Lgnu/trove/TIntObjectHashMap;", "Lkotlin/Pair;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "getEdges", "()Lgnu/trove/TIntObjectHashMap;", "addEdge", "objectId", "", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "refIndex", "", "disposed", "", "calculateTotalInstanceCount", "collectDisposedDominatorNodes", "", "result", "", "", "createHotPathReport", "", "treeDisplayOptions", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$TreeDisplayOptions;", "rootReasonGetter", "Lkotlin/Function1;", "printReportLine", "printFunc", "", "pathsCount", "percent", "instanceSize", "subgraphSize", "", "instanceCount", "status", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Status;", "fieldName", "indent", "text", "(Lkotlin/jvm/functions/Function1;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Long;Ljava/lang/Integer;Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Status;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "StackEntry", "intellij.android.core"})
    public static final class RootNode
    implements Node {
        @NotNull
        private final TIntObjectHashMap<Pair<RegularNode, Edge>> edges;
        private final ClassStore classStore;

        @NotNull
        public final TIntObjectHashMap<Pair<RegularNode, Edge>> getEdges() {
            return this.edges;
        }

        @Override
        @NotNull
        public Node addEdge(int objectId, int objectSize, int subgraphSizeInDwords, @NotNull ClassDefinition classDefinition, byte refIndex, boolean disposed) {
            Pair pair = (Pair)this.edges.get(objectId);
            RegularNode nullableNode = pair != null ? (RegularNode)pair.getFirst() : null;
            RegularNode node2 = null;
            if (nullableNode != null) {
                node2 = nullableNode;
            } else {
                RegularNode newNode = new RegularNode();
                Pair pair2 = new Pair((Object)newNode, (Object)new Edge(classDefinition, refIndex, disposed));
                newNode.getInstances().add(objectId);
                this.edges.put(objectId, (Object)pair2);
                node2 = newNode;
                node2.setTotalSizeInDwords(subgraphSizeInDwords);
            }
            RegularNode regularNode = node2;
            int n = regularNode.getPathsCount();
            regularNode.setPathsCount(n + 1);
            if ((long)node2.getPathsSize() + (long)objectSize > (long)Integer.MAX_VALUE) {
                node2.setPathsSize(Integer.MAX_VALUE);
            } else {
                RegularNode regularNode2 = node2;
                regularNode2.setPathsSize(regularNode2.getPathsSize() + objectSize);
            }
            return node2;
        }

        /*
         * WARNING - void declaration
         */
        private final int calculateTotalInstanceCount() {
            void result2;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            this.edges.forEachValue((TObjectProcedure)new TObjectProcedure<Pair<? extends RegularNode, ? extends Edge>>((Ref.IntRef)result2){
                final /* synthetic */ Ref.IntRef $result;

                public final boolean execute(Pair<RegularNode, Edge> $dstr$node$_u24__u24) {
                    RegularNode node2 = (RegularNode)$dstr$node$_u24__u24.component1();
                    this.$result.element += node2.getPathsCount();
                    return true;
                }
                {
                    this.$result = intRef;
                }
            });
            return result2.element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String createHotPathReport(@NotNull AnalysisConfig.TreeDisplayOptions treeDisplayOptions, @NotNull Function1<? super Integer, String> rootReasonGetter) {
            Object object;
            int n;
            void $this$filterIndexedTo$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            boolean bl6 = false;
            List rootList = new ArrayList();
            this.edges.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Pair<? extends RegularNode, ? extends Edge>>(rootList){
                final /* synthetic */ List $rootList;

                /*
                 * WARNING - void declaration
                 */
                public final boolean execute(int objectId, Pair<RegularNode, Edge> $dstr$node$edge) {
                    void node2;
                    RegularNode regularNode = (RegularNode)$dstr$node$edge.component1();
                    Edge edge = (Edge)$dstr$node$edge.component2();
                    return this.$rootList.add(new Triple((Object)objectId, (Object)node2, (Object)edge));
                }
                {
                    this.$rootList = list;
                }
            });
            int totalInstanceCount = this.calculateTotalInstanceCount();
            int minimumObjectsForReport = Math.min(treeDisplayOptions.getMinimumObjectCount(), (int)(Math.ceil((double)totalInstanceCount / 100.0) * (double)treeDisplayOptions.getMinimumObjectCountPercent()));
            Iterable $this$sortedByDescending$iv = rootList;
            boolean $i$f$sortedByDescending = false;
            boolean bl7 = false;
            Iterable $this$filterIndexed$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Triple it = (Triple)b;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(((RegularNode)it.getSecond()).getPathsSize());
                    it = (Triple)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = ((RegularNode)it.getSecond()).getPathsSize();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
            boolean $i$f$filterIndexed = false;
            Iterable iterable = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv2 = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void $dstr$_u24__u24$node$_u24__u24;
                void element$iv$iv;
                n = index$iv$iv$iv2++;
                boolean bl8 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl9 = false;
                object = (Triple)element$iv$iv;
                int index2 = index$iv$iv;
                boolean bl10 = false;
                RegularNode node2 = (RegularNode)$dstr$_u24__u24$node$_u24__u24.component2();
                if (!(index2 < treeDisplayOptions.getMinimumPaths() || node2.getPathsCount() >= minimumObjectsForReport || node2.getPathsSize() >= treeDisplayOptions.getMinimumObjectSize())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEachIndexed$iv = (List)destination$iv$iv;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void rootNode;
                void rootObjectId;
                void $dstr$rootObjectId$rootNode$rootEdge;
                int n2 = index$iv++;
                boolean bl11 = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Triple index$iv$iv$iv2 = (Triple)item$iv;
                int index3 = n2;
                boolean bl12 = false;
                n = ((Number)$dstr$rootObjectId$rootNode$rootEdge.component1()).intValue();
                RegularNode regularNode = (RegularNode)$dstr$rootObjectId$rootNode$rootEdge.component2();
                Edge rootEdge = (Edge)$dstr$rootObjectId$rootNode$rootEdge.component3();
                String rootReasonString = (String)rootReasonGetter.invoke((Object)((int)rootObjectId));
                int rootPercent = (int)(100.0 * (double)rootNode.getPathsCount() / (double)totalInstanceCount);
                object = $this$buildString;
                String string = "Root " + (index3 + 1) + ':';
                boolean bl13 = false;
                StringBuilder stringBuilder2 = ((StringBuilder)object).append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>($this$buildString){

                    @NotNull
                    public final StringBuilder invoke(@Nullable String p1) {
                        StringBuilder stringBuilder = (StringBuilder)this.receiver;
                        boolean bl = false;
                        StringBuilder stringBuilder2 = stringBuilder.append(p1);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                        return StringsKt.appendln((StringBuilder)stringBuilder2);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinPackage(StringsKt.class, (String)"intellij.android.core");
                    }

                    public final String getName() {
                        return "appendln";
                    }

                    public final String getSignature() {
                        return "appendln(Ljava/lang/StringBuilder;Ljava/lang/String;)Ljava/lang/StringBuilder;";
                    }
                }), rootNode.getPathsCount(), rootPercent, rootNode.getPathsSize(), (long)rootNode.getTotalSizeInDwords() * (long)4, 1, Status.Companion.getStatus(251, false, false), false, null, "", "ROOT: " + rootReasonString);
                object = new TruncatingPrintBuffer(treeDisplayOptions.getHeadLimit(), treeDisplayOptions.getTailLimit(), (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>($this$buildString){

                    @NotNull
                    public final StringBuilder invoke(@Nullable String p1) {
                        StringBuilder stringBuilder = (StringBuilder)this.receiver;
                        boolean bl = false;
                        StringBuilder stringBuilder2 = stringBuilder.append(p1);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                        return StringsKt.appendln((StringBuilder)stringBuilder2);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinPackage(StringsKt.class, (String)"intellij.android.core");
                    }

                    public final String getName() {
                        return "appendln";
                    }

                    public final String getSignature() {
                        return "appendln(Ljava/lang/StringBuilder;Ljava/lang/String;)Ljava/lang/StringBuilder;";
                    }
                }));
                boolean bl14 = false;
                bl13 = false;
                Throwable throwable = null;
                try {
                    TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)object;
                    boolean bl15 = false;
                    ArrayDeque<StackEntry> stack = new ArrayDeque<StackEntry>();
                    stack.push(new StackEntry(null, rootEdge, (RegularNode)rootNode, "", ""));
                    while (!stack.isEmpty()) {
                        void $this$filterIndexedTo$iv$iv2;
                        HashMap<Edge, RegularNode> currentNodeEdges;
                        void classDefinition;
                        void indent;
                        void parentClass;
                        void node3;
                        void refIndexByte;
                        void edge;
                        Object object2 = (StackEntry)stack.pop();
                        ClassDefinition classDefinition2 = ((StackEntry)object2).component1();
                        Edge edge2 = ((StackEntry)object2).component2();
                        RegularNode regularNode2 = ((StackEntry)object2).component3();
                        String string2 = ((StackEntry)object2).component4();
                        String nextIndent = ((StackEntry)object2).component5();
                        void var39_54 = edge;
                        object2 = var39_54.component1();
                        byte by = var39_54.component2();
                        boolean disposed = var39_54.component3();
                        int refIndex = Byte.toUnsignedInt((byte)refIndexByte);
                        this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>(buffer){

                            public final void invoke(@NotNull String p1) {
                                ((TruncatingPrintBuffer)this.receiver).println(p1);
                            }

                            public final KDeclarationContainer getOwner() {
                                return Reflection.getOrCreateKotlinClass(TruncatingPrintBuffer.class);
                            }

                            public final String getName() {
                                return "println";
                            }

                            public final String getSignature() {
                                return "println(Ljava/lang/String;)V";
                            }
                        }), node3.getPathsCount(), (int)(100.0 * (double)node3.getPathsCount() / (double)totalInstanceCount), node3.getPathsSize(), (long)node3.getTotalSizeInDwords() * (long)4, node3.getInstances().size(), Status.Companion.getStatus(refIndex, node3.getEdges() == null, disposed), disposed, RefIndexUtil.INSTANCE.getFieldDescription(refIndex, (ClassDefinition)parentClass, this.classStore), (String)indent, classDefinition.getPrettyName());
                        if (node3.getEdges() == null) {
                            continue;
                        }
                        Iterable $this$sortedByDescending$iv2 = currentNodeEdges.entrySet();
                        boolean $i$f$sortedByDescending2 = false;
                        boolean bl16 = false;
                        Iterable $this$filterIndexed$iv2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator<T>(){

                            public final int compare(T a, T b) {
                                boolean bl = false;
                                Map.Entry it = (Map.Entry)b;
                                boolean bl2 = false;
                                Comparable comparable = Integer.valueOf(((RegularNode)it.getValue()).getPathsSize());
                                it = (Map.Entry)a;
                                Comparable comparable2 = comparable;
                                bl2 = false;
                                Integer n = ((RegularNode)it.getValue()).getPathsSize();
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                            }
                        });
                        boolean $i$f$filterIndexed2 = false;
                        Iterable iterable2 = $this$filterIndexed$iv2;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterIndexedTo2 = false;
                        void $this$forEachIndexed$iv$iv$iv2 = $this$filterIndexedTo$iv$iv2;
                        boolean $i$f$forEachIndexed3 = false;
                        int index$iv$iv$iv32 = 0;
                        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv2) {
                            void e;
                            void element$iv$iv;
                            int n3 = index$iv$iv$iv32++;
                            boolean bl17 = false;
                            if (n3 < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            Object t = item$iv$iv$iv;
                            int index$iv$iv = n3;
                            boolean bl18 = false;
                            Map.Entry entry = (Map.Entry)element$iv$iv;
                            int index4 = index$iv$iv;
                            boolean bl19 = false;
                            if (!(index4 == 0 || ((RegularNode)e.getValue()).getPathsCount() >= minimumObjectsForReport || ((RegularNode)e.getValue()).getPathsSize() >= treeDisplayOptions.getMinimumObjectSize() || (long)((RegularNode)e.getValue()).getTotalSizeInDwords() * (long)4 >= treeDisplayOptions.getMinimumSubgraphSize())) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        List childrenToReport = CollectionsKt.asReversed((List)((List)destination$iv$iv2));
                        if (childrenToReport.size() == 1 && treeDisplayOptions.getSmartIndent()) {
                            stack.push(new StackEntry((ClassDefinition)classDefinition, (Edge)((Map.Entry)childrenToReport.get(0)).getKey(), (RegularNode)((Map.Entry)childrenToReport.get(0)).getValue(), nextIndent, nextIndent));
                            continue;
                        }
                        if (nextIndent.length() >= treeDisplayOptions.getMaximumIndent()) {
                            this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>(buffer){

                                public final void invoke(@NotNull String p1) {
                                    ((TruncatingPrintBuffer)this.receiver).println(p1);
                                }

                                public final KDeclarationContainer getOwner() {
                                    return Reflection.getOrCreateKotlinClass(TruncatingPrintBuffer.class);
                                }

                                public final String getName() {
                                    return "println";
                                }

                                public final String getSignature() {
                                    return "println(Ljava/lang/String;)V";
                                }
                            }), null, null, null, null, null, Status.LastInPath, null, null, nextIndent, "\\-[...]");
                            continue;
                        }
                        Iterable $this$forEachIndexed$iv2 = childrenToReport;
                        boolean $i$f$forEachIndexed4 = false;
                        int index$iv2 = 0;
                        for (Object item$iv2 : $this$forEachIndexed$iv2) {
                            void e;
                            int n4 = index$iv2++;
                            boolean bl20 = false;
                            if (n4 < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            Map.Entry index$iv$iv$iv32 = (Map.Entry)item$iv2;
                            int index5 = n4;
                            boolean bl21 = false;
                            if (index5 == 0) {
                                stack.push(new StackEntry((ClassDefinition)classDefinition, (Edge)e.getKey(), (RegularNode)e.getValue(), nextIndent + "\\-", nextIndent + "  "));
                                continue;
                            }
                            stack.push(new StackEntry((ClassDefinition)classDefinition, (Edge)e.getKey(), (RegularNode)e.getValue(), nextIndent + "+-", nextIndent + "| "));
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        private final void printReportLine(Function1<? super String, ? extends Object> printFunc, Integer pathsCount, Integer percent, Integer instanceSize, Long subgraphSize, Integer instanceCount, Status status, Boolean disposed, String fieldName, String indent, String text2) {
            Object object;
            String disposedString;
            String fieldNameString;
            String instanceCountString;
            String instanceSizeString;
            String percentString;
            String pathsCountString;
            block20: {
                block19: {
                    Object object2;
                    block18: {
                        block17: {
                            int it;
                            Object object3;
                            int it2;
                            block16: {
                                block15: {
                                    boolean bl;
                                    Object object4;
                                    block14: {
                                        block13: {
                                            object4 = pathsCount;
                                            if (object4 == null) break block13;
                                            Integer n = object4;
                                            boolean bl2 = false;
                                            bl = false;
                                            it2 = ((Number)n).intValue();
                                            boolean bl3 = false;
                                            object4 = HeapReportUtils.INSTANCE.toShortStringAsCount(it2);
                                            if (object4 != null) break block14;
                                        }
                                        object4 = "";
                                    }
                                    pathsCountString = StringsKt.padStart$default((String)object4, (int)5, (char)'\u0000', (int)2, null);
                                    object3 = percent;
                                    if (object3 == null) break block15;
                                    Integer n = object3;
                                    bl = false;
                                    it2 = 0;
                                    it = ((Number)n).intValue();
                                    boolean bl4 = false;
                                    object3 = "" + it + '%';
                                    if (object3 != null) break block16;
                                }
                                object3 = "";
                            }
                            percentString = StringsKt.padStart$default((String)object3, (int)4, (char)'\u0000', (int)2, null);
                            object2 = instanceSize;
                            if (object2 == null) break block17;
                            Integer n = object2;
                            it2 = 0;
                            it = 0;
                            int it3 = ((Number)n).intValue();
                            boolean bl = false;
                            object2 = HeapReportUtils.INSTANCE.toShortStringAsSize(it3);
                            if (object2 != null) break block18;
                        }
                        object2 = "";
                    }
                    instanceSizeString = StringsKt.padStart$default((String)object2, (int)6, (char)'\u0000', (int)2, null);
                    Object object5 = instanceCount;
                    if (object5 == null) {
                        object5 = "";
                    }
                    instanceCountString = StringsKt.padStart$default((String)object5.toString(), (int)10, (char)'\u0000', (int)2, null);
                    fieldNameString = fieldName != null ? fieldName + ": " : "";
                    disposedString = Intrinsics.areEqual((Object)disposed, (Object)true) ? " (disposed)" : "";
                    object = subgraphSize;
                    if (object == null) break block19;
                    Long l = object;
                    boolean bl = false;
                    boolean bl5 = false;
                    long it = ((Number)l).longValue();
                    boolean bl6 = false;
                    object = HeapReportUtils.INSTANCE.toShortStringAsSize(it);
                    if (object != null) break block20;
                }
                object = "";
            }
            String subgraphSizeString = StringsKt.padStart$default((String)object, (int)6, (char)'\u0000', (int)2, null);
            printFunc.invoke((Object)('[' + pathsCountString + '/' + percentString + '/' + instanceSizeString + "] " + subgraphSizeString + ' ' + instanceCountString + ' ' + (Object)((Object)status) + ' ' + indent + fieldNameString + text2 + disposedString));
        }

        public final void collectDisposedDominatorNodes(@NotNull Map<ClassDefinition, List<RegularNode>> result2) {
            this.edges.forEachValue((TObjectProcedure)new TObjectProcedure<Pair<? extends RegularNode, ? extends Edge>>(result2){
                final /* synthetic */ Map $result;

                public final boolean execute(Pair<RegularNode, Edge> $dstr$node$_u24__u24) {
                    RegularNode node2 = (RegularNode)$dstr$node$_u24__u24.component1();
                    node2.collectDisposedDominatorNodes(this.$result);
                    return true;
                }
                {
                    this.$result = map2;
                }
            });
        }

        public RootNode(@NotNull ClassStore classStore) {
            this.classStore = classStore;
            this.edges = new TIntObjectHashMap();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J=\u0010\u001a\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RootNode$StackEntry;", "", "parentClass", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "edge", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "node", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "indent", "", "nextIndent", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;Ljava/lang/String;Ljava/lang/String;)V", "getEdge", "()Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "getIndent", "()Ljava/lang/String;", "getNextIndent", "getNode", "()Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "getParentClass", "()Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
        public static final class StackEntry {
            @Nullable
            private final ClassDefinition parentClass;
            @NotNull
            private final Edge edge;
            @NotNull
            private final RegularNode node;
            @NotNull
            private final String indent;
            @NotNull
            private final String nextIndent;

            @Nullable
            public final ClassDefinition getParentClass() {
                return this.parentClass;
            }

            @NotNull
            public final Edge getEdge() {
                return this.edge;
            }

            @NotNull
            public final RegularNode getNode() {
                return this.node;
            }

            @NotNull
            public final String getIndent() {
                return this.indent;
            }

            @NotNull
            public final String getNextIndent() {
                return this.nextIndent;
            }

            public StackEntry(@Nullable ClassDefinition parentClass, @NotNull Edge edge, @NotNull RegularNode node2, @NotNull String indent, @NotNull String nextIndent) {
                this.parentClass = parentClass;
                this.edge = edge;
                this.node = node2;
                this.indent = indent;
                this.nextIndent = nextIndent;
            }

            @Nullable
            public final ClassDefinition component1() {
                return this.parentClass;
            }

            @NotNull
            public final Edge component2() {
                return this.edge;
            }

            @NotNull
            public final RegularNode component3() {
                return this.node;
            }

            @NotNull
            public final String component4() {
                return this.indent;
            }

            @NotNull
            public final String component5() {
                return this.nextIndent;
            }

            @NotNull
            public final StackEntry copy(@Nullable ClassDefinition parentClass, @NotNull Edge edge, @NotNull RegularNode node2, @NotNull String indent, @NotNull String nextIndent) {
                return new StackEntry(parentClass, edge, node2, indent, nextIndent);
            }

            public static /* synthetic */ StackEntry copy$default(StackEntry stackEntry, ClassDefinition classDefinition, Edge edge, RegularNode regularNode, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    classDefinition = stackEntry.parentClass;
                }
                if ((n & 2) != 0) {
                    edge = stackEntry.edge;
                }
                if ((n & 4) != 0) {
                    regularNode = stackEntry.node;
                }
                if ((n & 8) != 0) {
                    string = stackEntry.indent;
                }
                if ((n & 0x10) != 0) {
                    string2 = stackEntry.nextIndent;
                }
                return stackEntry.copy(classDefinition, edge, regularNode, string, string2);
            }

            @NotNull
            public String toString() {
                return "StackEntry(parentClass=" + this.parentClass + ", edge=" + this.edge + ", node=" + this.node + ", indent=" + this.indent + ", nextIndent=" + this.nextIndent + ")";
            }

            public int hashCode() {
                ClassDefinition classDefinition = this.parentClass;
                Edge edge = this.edge;
                RegularNode regularNode = this.node;
                String string = this.indent;
                String string2 = this.nextIndent;
                return ((((classDefinition != null ? ((Object)classDefinition).hashCode() : 0) * 31 + (edge != null ? ((Object)edge).hashCode() : 0)) * 31 + (regularNode != null ? regularNode.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof StackEntry)) break block3;
                        StackEntry stackEntry = (StackEntry)object;
                        if (!Intrinsics.areEqual((Object)this.parentClass, (Object)stackEntry.parentClass) || !Intrinsics.areEqual((Object)this.edge, (Object)stackEntry.edge) || !Intrinsics.areEqual((Object)this.node, (Object)stackEntry.node) || !Intrinsics.areEqual((Object)this.indent, (Object)stackEntry.indent) || !Intrinsics.areEqual((Object)this.nextIndent, (Object)stackEntry.nextIndent)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

