/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.renamer;

import com.android.tools.idea.databinding.psiclass.LightBindingClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.NameSuggester;
import java.util.Locale;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingRenamer
extends AutomaticRenamer {
    public DataBindingRenamer(@NotNull LightBindingClass.LightDataBindingField field2, @NotNull String newName2) {
        PsiNamedElement resourceId = DataBindingRenamer.getResourceIdElement((PsiElement)field2);
        if (resourceId != null) {
            this.myElements.add(resourceId);
        }
        this.suggestAllNames(field2.getName(), newName2);
    }

    @Nullable
    private static PsiNamedElement getResourceIdElement(@NotNull PsiElement element2) {
        PsiElement xmlElement = element2.getNavigationElement();
        if (!(xmlElement instanceof XmlTag)) {
            return null;
        }
        XmlAttribute xmlAttribute = ((XmlTag)xmlElement).getAttribute("id", "http://schemas.android.com/apk/res/android");
        if (xmlAttribute == null) {
            return null;
        }
        XmlAttributeValue valueElement = xmlAttribute.getValueElement();
        if (valueElement == null) {
            return null;
        }
        String id = valueElement.getValue();
        if (!id.startsWith("@+id/")) {
            return null;
        }
        return new ValueResourceElementWrapper(valueElement);
    }

    @NotNull
    protected String suggestNameForElement(@NotNull PsiNamedElement element2, @NotNull NameSuggester suggester, @NotNull String newFieldName, @NotNull String oldFieldName) {
        if (element2 instanceof ValueResourceElementWrapper) {
            CharSequence[] words = NameUtil.splitNameIntoWords((String)newFieldName);
            return "@+id/" + String.join((CharSequence)"_", words).toLowerCase(Locale.US);
        }
        return super.suggestNameForElement(element2, suggester, newFieldName, oldFieldName);
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDialogTitle() {
        return "Rename Resource IDs";
    }

    @Nls
    @NotNull
    public String getDialogDescription() {
        return "Rename resources with the following IDs to:";
    }

    @NotNull
    public String entityName() {
        return "Resource ID";
    }
}

