/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.databinding.LayoutBindingEnabledFacetsProvider;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public final class ConvertLayoutToDataBindingAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        return "Convert to data binding layout";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        if (IdeResourcesUtil.getFolderType(file2) != ResourceFolderType.LAYOUT) {
            return false;
        }
        if (!(file2 instanceof XmlFile)) {
            return false;
        }
        XmlFile xmlFile = (XmlFile)file2;
        XmlTag tag = xmlFile.getRootTag();
        if (tag == null) {
            return false;
        }
        int offset2 = editor2.getCaretModel().getOffset();
        PsiElement element2 = file2.findElementAt(offset2);
        if (element2 == null) {
            return false;
        }
        if (!tag.equals(element2.getParent()) && offset2 >= tag.getTextOffset()) {
            return false;
        }
        if (tag.getName().equals("layout")) {
            return false;
        }
        LayoutBindingEnabledFacetsProvider enabledFacetsProvider = LayoutBindingEnabledFacetsProvider.getInstance(project);
        return !enabledFacetsProvider.getDataBindingEnabledFacets().isEmpty();
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        XmlFile xmlFile = (XmlFile)file2;
        XmlTag root2 = xmlFile.getRootTag();
        assert (root2 != null);
        XmlElementFactory factory2 = XmlElementFactory.getInstance((Project)project);
        XmlTag newRoot = factory2.createTagFromText((CharSequence)"<layout>\n<data>\n\n</data></layout>");
        String rootText = root2.getText();
        newRoot = (XmlTag)root2.replace((PsiElement)newRoot);
        root2 = factory2.createTagFromText((CharSequence)rootText);
        for (XmlAttribute attribute : root2.getAttributes()) {
            String name = attribute.getName();
            if (!name.startsWith("xmlns:")) continue;
            newRoot.setAttribute(name, attribute.getValue());
            attribute.delete();
        }
        XmlAttribute context = root2.getAttribute("context", "http://schemas.android.com/tools");
        if (context != null) {
            root2.setAttribute("context", "http://schemas.android.com/tools", context.getValue());
            context.delete();
        }
        newRoot.addSubTag(root2, false);
    }
}

