/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.scene.target.TargetHelper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SceneHitListener {
    @NotNull
    private SelectionModel mySelectionModel;
    private ScenePicker myPicker = new ScenePicker();
    double myClosestComponentDistance = Double.MAX_VALUE;
    double myClosestTargetDistance = Double.MAX_VALUE;
    ArrayList<SceneComponent> myHitComponents = new ArrayList();
    @NotNull
    final ArrayList<Target> myHitTargets = new ArrayList();
    private Predicate<Target> myTargertFilter = it -> true;

    public SceneHitListener(@NotNull SelectionModel selectionModel) {
        this.mySelectionModel = selectionModel;
        this.myPicker.setSelectListener((a, b) -> this.over(a, b));
    }

    public void setTargetFilter(@Nullable Predicate<Target> filter2) {
        this.myTargertFilter = filter2 != null ? filter2 : it -> true;
    }

    public void find(@NotNull SceneContext transform, @NotNull SceneComponent root2, int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        this.myHitComponents.clear();
        this.myHitTargets.clear();
        this.myClosestComponentDistance = Double.MAX_VALUE;
        this.myClosestTargetDistance = Double.MAX_VALUE;
        this.myPicker.reset();
        root2.addHit(transform, this.myPicker, modifiersEx);
        this.myPicker.find(transform.getSwingXDip(x), transform.getSwingYDip(y));
    }

    public void over(Object over, double dist) {
        if (over instanceof Target) {
            if (!this.myTargertFilter.test((Target)over)) {
                return;
            }
            Target target = (Target)over;
            if (dist < this.myClosestTargetDistance) {
                this.myHitTargets.clear();
                this.myHitTargets.add(target);
                this.myClosestTargetDistance = dist;
            } else if (dist == this.myClosestTargetDistance) {
                this.myHitTargets.add(target);
            }
        } else if (over instanceof SceneComponent) {
            SceneComponent component = (SceneComponent)over;
            if (dist < this.myClosestComponentDistance) {
                this.myHitComponents.clear();
                this.myHitComponents.add(component);
                this.myClosestComponentDistance = dist;
            } else if (dist == this.myClosestComponentDistance) {
                this.myHitComponents.add(component);
            }
        }
    }

    public Target getClosestTarget(@JdkConstants.InputEventMask int modifiersEx) {
        Target candidate;
        int count = this.myHitTargets.size();
        if (count == 0) {
            return null;
        }
        List<NlComponent> selection = this.mySelectionModel.getSelection();
        if ((modifiersEx & 0x200) != 0) {
            candidate = null;
            for (int i2 = count - 1; i2 >= 0; --i2) {
                Target target = this.myHitTargets.get(i2);
                if (!selection.contains(target.getComponent().getNlComponent()) || candidate != null && !TargetHelper.isAbove(target, candidate)) continue;
                candidate = target;
            }
            if (candidate != null) {
                return candidate;
            }
        }
        candidate = this.myHitTargets.get(count - 1);
        boolean inSelection = SceneHitListener.parentInSelection(candidate.getComponent(), selection);
        for (int i3 = count - 2; i3 >= 0; --i3) {
            Target target = this.myHitTargets.get(i3);
            boolean targetParentInSelection = SceneHitListener.parentInSelection(target.getComponent(), selection);
            if (inSelection && !targetParentInSelection || (inSelection || !targetParentInSelection) && !TargetHelper.isAbove(target, candidate)) continue;
            candidate = target;
            inSelection = targetParentInSelection;
        }
        return candidate;
    }

    @Nullable
    public Target getFilteredTarget(Target filteredTarget) {
        Target hit = null;
        boolean found = false;
        for (Target target : this.myHitTargets) {
            if (target == filteredTarget) {
                found = true;
                continue;
            }
            if (!filteredTarget.getClass().isAssignableFrom(target.getClass())) continue;
            hit = target;
        }
        if (hit == null && found) {
            hit = filteredTarget;
        }
        return hit;
    }

    @NotNull
    public ImmutableList<Target> getHitTargets() {
        return ImmutableList.copyOf(this.myHitTargets);
    }

    public SceneComponent getClosestComponent() {
        int count = this.myHitComponents.size();
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return this.myHitComponents.get(0);
        }
        List<NlComponent> selection = this.mySelectionModel.getSelection();
        if (selection.isEmpty()) {
            return this.myHitComponents.get(count - 1);
        }
        SceneComponent candidate = this.myHitComponents.get(count - 1);
        boolean inSelection = selection.contains(candidate.getNlComponent());
        if (inSelection) {
            return candidate;
        }
        for (int i2 = count - 1; i2 >= 0; --i2) {
            SceneComponent target = this.myHitComponents.get(i2);
            if (!SceneHitListener.parentInSelection(target, selection)) continue;
            return target;
        }
        return candidate;
    }

    public SceneComponent getTopHitComponent() {
        int count = this.myHitComponents.size();
        if (count == 0) {
            return null;
        }
        return this.myHitComponents.get(count - 1);
    }

    public ArrayList<SceneComponent> getHitComponents() {
        return this.myHitComponents;
    }

    private static boolean parentInSelection(@NotNull SceneComponent component, @NotNull List<NlComponent> selection) {
        if (selection.isEmpty()) {
            return false;
        }
        while (component != null) {
            if (selection.contains(component.getNlComponent())) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }
}

