/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.editor.ActionToolbarUtil;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssueView;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssuePanel
extends JPanel
implements Disposable,
PropertyChangeListener {
    private static final String ISSUE_PANEL_NAME = "Layout Editor Error Panel";
    private static final String TITLE_NO_ISSUES = "No issues";
    private static final String TITLE_NO_IMPORTANT_ISSUE = "Issues";
    private static final String WARNING = "Warning";
    private static final String ERROR = "Error";
    private static final String ACTION_PREVIOUS = "PREVIOUS";
    private static final String ACTION_NEXT = "next";
    private static final String ACTION_EXPAND = "expand";
    private static final String ACTION_COLLAPSE = "collapse";
    private static final Pattern MULTIPLE_SPACES = Pattern.compile("\\s+");
    private final HashBiMap<Issue, IssueView> myDisplayedError = HashBiMap.create();
    private final IssueModel myIssueModel;
    private final JPanel myErrorListPanel;
    private final JBLabel myTitleLabel;
    private final IssueModel.IssueModelListener myIssueModelListener;
    private final JBScrollPane myScrollPane;
    private final DesignSurface mySurface;
    private final ColumnHeaderPanel myColumnHeaderView;
    private final List<MinimizeListener> myMinimizeListener = new ArrayList<MinimizeListener>();
    private ExpandListener myExpandListener;
    @Nullable
    private IssueView mySelectedIssueView;
    @Nullable
    private Issue mySelectedIssue;
    private boolean hasUserSeenNewErrors;
    private boolean isMinimized;
    private boolean myInitialized;
    private boolean myAutoSize = true;

    public IssuePanel(@NotNull DesignSurface designSurface, @NotNull IssueModel issueModel) {
        super(new BorderLayout());
        this.setName(ISSUE_PANEL_NAME);
        this.myIssueModel = issueModel;
        this.mySurface = designSurface;
        this.myTitleLabel = IssuePanel.createTitleLabel();
        JComponent titlePanel = this.createTitlePanel(this.myTitleLabel);
        this.add((Component)titlePanel, "North");
        this.myErrorListPanel = IssuePanel.createErrorListPanel();
        this.myScrollPane = IssuePanel.createListScrollPane(this.myErrorListPanel);
        this.myColumnHeaderView = new ColumnHeaderPanel();
        this.myScrollPane.setColumnHeaderView((Component)this.myColumnHeaderView);
        this.add((Component)this.myScrollPane, "Center");
        this.updateTitlebarStyle();
        this.myIssueModelListener = this::updateErrorList;
        this.myIssueModel.addErrorModelListener(this.myIssueModelListener);
        this.updateErrorList();
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.registerKeyboardActions();
        this.addFocusListener(this.createFocusListener());
        this.setMinimized(true);
        this.setMinimumSize((Dimension)JBUI.size((int)200));
        UIManager.addPropertyChangeListener(this);
        this.myInitialized = true;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myInitialized) {
            this.updateTitlebarStyle();
            this.updateErrorList();
            this.setMinimumSize((Dimension)JBUI.size((int)200));
        }
    }

    @NotNull
    private FocusListener createFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (IssuePanel.this.mySelectedIssueView != null) {
                    IssuePanel.this.mySelectedIssueView.setFocused(true);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (IssuePanel.this.mySelectedIssueView != null) {
                    IssuePanel.this.mySelectedIssueView.setFocused(false);
                }
            }
        };
    }

    private void registerKeyboardActions() {
        this.getActionMap().put(ACTION_PREVIOUS, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssuePanel.this.keyboardSelect(-1);
            }
        });
        this.getActionMap().put(ACTION_NEXT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssuePanel.this.keyboardSelect(1);
            }
        });
        this.getActionMap().put(ACTION_EXPAND, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssuePanel.this.expandSelectedIssue(true);
            }
        });
        this.getActionMap().put(ACTION_COLLAPSE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssuePanel.this.expandSelectedIssue(false);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), ACTION_PREVIOUS);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), ACTION_NEXT);
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), ACTION_EXPAND);
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), ACTION_COLLAPSE);
    }

    private void expandSelectedIssue(boolean expanded) {
        if (this.mySelectedIssueView != null) {
            this.mySelectedIssueView.setExpanded(expanded);
        }
    }

    private void keyboardSelect(int direction) {
        Component component;
        if (!this.myDisplayedError.isEmpty() && this.mySelectedIssueView == null && (component = this.myErrorListPanel.getComponent(0)) instanceof IssueView) {
            this.setSelectedIssue((IssueView)component);
            return;
        }
        Component[] components = this.myErrorListPanel.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            Component component2 = components[i2];
            if (component2 != this.mySelectedIssueView) continue;
            int selectedIndex = (i2 + (direction >= 0 ? 1 : -1)) % this.myDisplayedError.size();
            if (selectedIndex < 0) {
                selectedIndex += this.myDisplayedError.size();
            }
            assert (components[i2] instanceof IssueView);
            this.setSelectedIssue((IssueView)components[selectedIndex]);
            this.mySelectedIssueView.scrollRectToVisible(this.mySelectedIssueView.getBounds());
            this.myScrollPane.getViewport().setViewPosition(this.mySelectedIssueView.getLocation());
            return;
        }
    }

    @NotNull
    private ActionToolbar createToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new MinimizeAction());
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true);
        ActionToolbarUtil.makeToolbarNavigable(toolbar2);
        toolbar2.setLayoutPolicy(0);
        return toolbar2;
    }

    @NotNull
    private JComponent createTitlePanel(@NotNull JBLabel titleLabel) {
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.add((Component)titleLabel, "West");
        JPanel rightPanel = new JPanel(new FlowLayout(2, 0, 0));
        rightPanel.add(this.createToolbar().getComponent());
        titlePanel.add((Component)rightPanel, "East");
        titlePanel.setBorder(IdeBorderFactory.createBorder((int)8));
        return titlePanel;
    }

    public void disableAutoSize() {
        this.myAutoSize = false;
    }

    @NotNull
    private static JBScrollPane createListScrollPane(@NotNull JPanel content2) {
        JBScrollPane pane = new JBScrollPane((Component)content2);
        pane.setBorder(null);
        pane.setAlignmentX(0.5f);
        pane.getViewport().setBackground(content2.getBackground());
        return pane;
    }

    @NotNull
    private static JPanel createErrorListPanel() {
        AdtSecondaryPanel panel2 = new AdtSecondaryPanel();
        panel2.setLayout(new BoxLayout((Container)panel2, 1));
        return panel2;
    }

    @NotNull
    private static JBLabel createTitleLabel() {
        JBLabel label = new JBLabel(TITLE_NO_IMPORTANT_ISSUE, 2);
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)20));
        return label;
    }

    private void updateErrorList() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (!this.myIssueModel.hasIssues()) {
                this.myTitleLabel.setText(TITLE_NO_ISSUES);
                this.myDisplayedError.clear();
                this.myErrorListPanel.removeAll();
                if (this.myAutoSize) {
                    this.setMinimized(true);
                }
                return;
            }
            this.updateTitlebarStyle();
            boolean needsRevalidate = false;
            ImmutableList<Issue> issues = this.myIssueModel.getIssues();
            if (this.myDisplayedError.isEmpty()) {
                issues.forEach(this::addErrorEntry);
            } else {
                this.removeOldIssues((List<Issue>)issues);
                needsRevalidate = this.displayNewIssues((List<Issue>)issues);
            }
            if (needsRevalidate) {
                this.revalidate();
                this.repaint();
            }
        });
    }

    private void updateTitlebarStyle() {
        Font font = UIUtil.getLabelFont();
        if (!this.hasUserSeenNewErrors && this.isMinimized()) {
            font = font.deriveFont(1);
        }
        this.myTitleLabel.setFont(font);
        int warningCount = this.myIssueModel.getWarningCount();
        int errorCount = this.myIssueModel.getErrorCount();
        if (warningCount == 0 && errorCount == 0) {
            this.myTitleLabel.setText(TITLE_NO_IMPORTANT_ISSUE);
        } else {
            StringBuilder title = new StringBuilder();
            if (warningCount > 0) {
                title.append(warningCount).append(' ').append(StringUtil.pluralize((String)WARNING, (int)warningCount)).append(' ');
            }
            if (errorCount > 0) {
                title.append(errorCount).append(' ').append(StringUtil.pluralize((String)ERROR, (int)errorCount));
            }
            this.myTitleLabel.setText(title.toString());
        }
    }

    private boolean displayNewIssues(@NotNull List<Issue> issues) {
        boolean needsRevalidate = false;
        for (Issue error : issues) {
            if (this.myDisplayedError.containsKey((Object)error)) continue;
            this.addErrorEntry(error);
            needsRevalidate = true;
        }
        return needsRevalidate;
    }

    private void removeOldIssues(@NotNull List<Issue> newIssues) {
        Iterator iterator = this.myDisplayedError.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Issue issue2 = (Issue)entry.getKey();
            if (newIssues.contains(issue2)) continue;
            IssueView issueView = (IssueView)entry.getValue();
            this.myErrorListPanel.remove(issueView);
            iterator.remove();
        }
    }

    private void addErrorEntry(@NotNull Issue error) {
        if (this.myErrorListPanel.getComponentCount() == 0) {
            this.myErrorListPanel.add(Box.createVerticalGlue(), -1);
        }
        IssueView issueView = new IssueView(error, this);
        this.myDisplayedError.put((Object)error, (Object)issueView);
        this.myErrorListPanel.add((Component)issueView, this.getInsertionIndex(issueView));
    }

    private int getInsertionIndex(IssueView issueView) {
        int insertIndex = 0;
        for (int i2 = 0; i2 < this.myErrorListPanel.getComponentCount(); ++i2) {
            Component component = this.myErrorListPanel.getComponent(i2);
            if (!(component instanceof IssueView)) continue;
            if (((IssueView)component).getDisplayPriority() > issueView.getDisplayPriority()) break;
            ++insertIndex;
        }
        return insertIndex;
    }

    @Nullable
    public IssueView getSelectedIssueView() {
        return this.mySelectedIssueView;
    }

    @Override
    public void doLayout() {
        int sourceColumnSize = 0;
        Set issueViews = this.myDisplayedError.values();
        IssueView lastView = null;
        for (IssueView view : issueViews) {
            sourceColumnSize = Math.max(sourceColumnSize, view.getSourceLabelWidth());
        }
        for (IssueView view : issueViews) {
            view.setSourceLabelSize(sourceColumnSize);
            lastView = view;
        }
        super.doLayout();
        if (lastView != null) {
            this.myColumnHeaderView.setColumnsX(lastView.getColumnsX());
        }
    }

    public void setMinimized(boolean minimized) {
        if (minimized == this.isMinimized) {
            return;
        }
        if (!minimized) {
            this.hasUserSeenNewErrors = true;
        }
        this.isMinimized = minimized;
        this.setVisible(!this.isMinimized);
        this.revalidate();
        this.repaint();
        if (!this.myMinimizeListener.isEmpty()) {
            UIUtil.invokeLaterIfNeeded(() -> this.myMinimizeListener.forEach(it -> it.onMinimizeChanged(this.isMinimized)));
        }
    }

    public void addMinimizeListener(@Nullable MinimizeListener listener2) {
        this.myMinimizeListener.add(listener2);
    }

    public void setExpandListener(ExpandListener listener2) {
        this.myExpandListener = listener2;
    }

    @Nullable
    public ExpandListener getExpandListener() {
        return this.myExpandListener;
    }

    @Nullable
    public Issue getSelectedIssue() {
        return this.mySelectedIssue;
    }

    public void dispose() {
        this.myMinimizeListener.clear();
        this.myExpandListener = null;
        this.mySelectedIssue = null;
        this.mySelectedIssueView = null;
        this.myIssueModel.removeErrorModelListener(this.myIssueModelListener);
        UIManager.removePropertyChangeListener(this);
    }

    public boolean isMinimized() {
        return this.isMinimized;
    }

    public void setSelectedIssue(@Nullable IssueView selectedIssue) {
        if (this.mySelectedIssueView != selectedIssue) {
            if (this.mySelectedIssueView != null) {
                this.mySelectedIssueView.setSelected(false);
            }
            this.mySelectedIssueView = selectedIssue;
            if (this.mySelectedIssueView != null) {
                Issue issue2;
                this.mySelectedIssueView.setSelected(true);
                this.mySelectedIssue = issue2 = (Issue)this.myDisplayedError.inverse().get((Object)this.mySelectedIssueView);
                if (issue2 == null) {
                    return;
                }
                issue2.getSource().getOnIssueSelected().invoke((Object)this.mySurface);
            }
        }
    }

    @VisibleForTesting
    public String getTitleText() {
        return this.myTitleLabel.getText();
    }

    @VisibleForTesting
    public IssueModel getIssueModel() {
        return this.myIssueModel;
    }

    @VisibleForTesting
    public boolean containsErrorWithText(@NotNull String text2) {
        return this.myDisplayedError.values().stream().anyMatch(view -> view.getIssueTitle().contains(text2) || MULTIPLE_SPACES.matcher(view.getIssueDescription()).replaceAll(" ").contains(text2));
    }

    @VisibleForTesting
    public String getFullIssueText() {
        return this.myDisplayedError.values().stream().map(view -> view.getIssueTitle() + "\n" + view.getIssueDescription() + "\n\n").collect(Collectors.joining());
    }

    public void showIssueForComponent(NlComponent component, boolean collapseOthers) {
        Issue issue2 = this.myIssueModel.findIssue(component);
        if (issue2 != null) {
            IssueView issueView = (IssueView)this.myDisplayedError.get((Object)issue2);
            if (issueView != null) {
                this.setSelectedIssue(issueView);
                issueView.setExpanded(true);
                if (collapseOthers) {
                    for (IssueView other : this.myDisplayedError.values()) {
                        if (other == issueView) continue;
                        other.setExpanded(false);
                    }
                }
            }
            this.setMinimized(false);
            if (issueView != null) {
                JViewport viewport = this.myScrollPane.getViewport();
                viewport.validate();
                viewport.setViewPosition(issueView.getLocation());
            }
        }
    }

    public int getSuggestedHeight() {
        this.validate();
        int suggestedHeight = this.myTitleLabel.getHeight() + this.myColumnHeaderView.getHeight();
        suggestedHeight = this.mySelectedIssueView != null ? (suggestedHeight += this.mySelectedIssueView.getHeight()) : (suggestedHeight += this.myDisplayedError.size());
        return Math.max(this.getMinimumSize().height, suggestedHeight);
    }

    @NotNull
    @VisibleForTesting
    ImmutableList<IssueView> getIssueViews() {
        ImmutableList.Builder builder2 = ImmutableList.builder();
        for (Component component : this.myErrorListPanel.getComponents()) {
            if (!(component instanceof IssueView)) continue;
            builder2.add((Object)((IssueView)component));
        }
        return builder2.build();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("lookAndFeel".equals(evt.getPropertyName())) {
            this.myErrorListPanel.removeAll();
            this.myDisplayedError.clear();
            this.updateErrorList();
        }
    }

    private static class ColumnHeaderPanel
    extends JPanel {
        private static final int HEIGHT = 15;
        private static final GradientPaint backgroundPaint = new GradientPaint(0.0f, 0.0f, (Color)new JBColor(0xFBFBFB, 5461850), 0.0f, 15.0f, (Color)new JBColor(0xE2E2E2, 3750717));
        public static final int COLUMN_COUNT = 2;
        private final JLabel myMessageLabel = ColumnHeaderPanel.createLabel("Message");
        private final JLabel mySourceLabel = ColumnHeaderPanel.createLabel("Source");
        private int[] myColumnsX;
        private boolean myInitialized;

        private ColumnHeaderPanel() {
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, JBColor.border()));
            this.mySourceLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, JBColor.border()), BorderFactory.createEmptyBorder(0, JBUI.scale((int)6), 0, 0)));
            this.add(this.myMessageLabel);
            this.add(this.mySourceLabel);
            this.myInitialized = true;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.myInitialized) {
                this.myMessageLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
                this.mySourceLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
                this.mySourceLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, JBColor.border()), BorderFactory.createEmptyBorder(0, JBUI.scale((int)6), 0, 0)));
            }
        }

        @NotNull
        private static JLabel createLabel(@Nullable String message2) {
            JLabel label = new JLabel(message2);
            label.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            return label;
        }

        @Override
        public void doLayout() {
            boolean isColumnsXValid;
            super.doLayout();
            boolean bl = isColumnsXValid = this.myColumnsX != null && this.myColumnsX.length == 2 && (this.myColumnsX[0] != 0 || this.myColumnsX[1] != 0);
            if (isColumnsXValid) {
                this.myMessageLabel.setLocation(this.myColumnsX[0], 0);
                int sourceLabelX = (int)Math.min((double)this.getWidth() * 0.9, (double)(this.myColumnsX[1] - this.mySourceLabel.getInsets().left));
                this.mySourceLabel.setLocation(sourceLabelX, 0);
            } else {
                this.myMessageLabel.setLocation(5, 0);
                this.mySourceLabel.setLocation((int)((double)this.getWidth() * 0.8), 0);
            }
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Paint paint = g2d.getPaint();
            g2d.setPaint(backgroundPaint);
            g2d.fill(this.getBounds());
            g2d.setPaint(paint);
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)-1, (int)15);
        }

        private void setColumnsX(@NotNull int[] columnsX) {
            this.myColumnsX = columnsX;
            this.revalidate();
            this.repaint();
        }
    }

    private class MinimizeAction
    extends AnAction {
        private static final String DESCRIPTION = "Hide the render errors panel";

        private MinimizeAction() {
            super(DESCRIPTION, DESCRIPTION, StudioIcons.Common.CLOSE);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            IssuePanel.this.setMinimized(true);
        }
    }

    public static interface ExpandListener {
        public void onExpanded(Issue var1, boolean var2);
    }

    public static interface MinimizeListener {
        public void onMinimizeChanged(boolean var1);
    }
}

