/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.actions.DesignerActionUtils;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.util.IconUtil;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class IssueNotificationAction
extends ToggleAction {
    public static final String NO_ISSUE = "No Issue";
    public static final String SHOW_ISSUE = "Show Warnings and Errors";
    private static final Icon DISABLED_ICON = IconUtil.desaturate((Icon)StudioIcons.Common.ERROR);

    private IssueNotificationAction() {
    }

    @NotNull
    public static IssueNotificationAction getInstance() {
        return (IssueNotificationAction)ActionManager.getInstance().getAction("Android.Designer.IssueNotificationAction");
    }

    public void update(@NotNull AnActionEvent event) {
        if (DesignerActionUtils.isActionEventFromJTextField(event)) {
            event.getPresentation().setEnabled(false);
            return;
        }
        super.update(event);
        DesignSurface surface2 = (DesignSurface)((Object)event.getData(DesignerDataKeys.DESIGN_SURFACE));
        Presentation presentation = event.getPresentation();
        if (surface2 == null) {
            event.getPresentation().setEnabled(false);
            presentation.setDescription("Toggle visibility of issue panel");
            presentation.setIcon(DISABLED_ICON);
        } else {
            event.getPresentation().setEnabled(true);
            IssueModel issueModel = surface2.getIssueModel();
            int markerCount = issueModel.getIssueCount();
            presentation.setDescription(markerCount == 0 ? NO_ISSUE : SHOW_ISSUE);
            presentation.setIcon(IssueNotificationAction.getIssueTypeIcon(issueModel));
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        DesignSurface surface2 = (DesignSurface)((Object)e.getData(DesignerDataKeys.DESIGN_SURFACE));
        return surface2 != null && !surface2.getIssuePanel().isMinimized();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        DesignSurface surface2 = (DesignSurface)((Object)e.getData(DesignerDataKeys.DESIGN_SURFACE));
        if (surface2 != null) {
            surface2.getAnalyticsManager().trackShowIssuePanel();
            surface2.setShowIssuePanel(state, true);
        }
    }

    @NotNull
    private static Icon getIssueTypeIcon(@NotNull IssueModel issueModel) {
        Icon icon2 = issueModel.getErrorCount() > 0 ? StudioIcons.Common.ERROR : (issueModel.getWarningCount() > 0 ? StudioIcons.Common.WARNING : (issueModel.getIssueCount() > 0 ? StudioIcons.Common.INFO : DISABLED_ICON));
        return icon2;
    }
}

