/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public class WipeAvdDataAction
extends AvdUiAction {
    public WipeAvdDataAction(AvdUiAction.AvdInfoProvider avdInfoProvider) {
        super(avdInfoProvider, "Wipe Data", "Wipe the user data of this AVD", AllIcons.Actions.Edit);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AvdManagerConnection connection = AvdManagerConnection.getDefaultAvdManagerConnection();
        AvdInfo avdInfo = this.getAvdInfo();
        if (avdInfo == null) {
            return;
        }
        if (connection.isAvdRunning(avdInfo)) {
            Messages.showErrorDialog((Component)this.myAvdInfoProvider.getAvdProviderComponent(), (String)"The selected AVD is currently running in the Emulator. Please exit the emulator instance and try wiping again.", (String)"Cannot Wipe A Running AVD");
            return;
        }
        int result2 = Messages.showYesNoDialog((Component)this.myAvdInfoProvider.getAvdProviderComponent(), (String)("Do you really want to wipe user files from AVD " + avdInfo.getName() + "?"), (String)"Confirm Data Wipe", (Icon)AllIcons.General.QuestionDialog);
        if (result2 == 0) {
            connection.wipeUserData(avdInfo);
            this.refreshAvds();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getAvdInfo() != null;
    }
}

