/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdCamera;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdNetworkLatency;
import com.android.sdklib.internal.avd.AvdNetworkSpeed;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.EmulatorAdvFeatures;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableObject;
import com.android.tools.idea.observable.core.ObservableString;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.wizard.model.WizardModel;
import com.android.utils.ILogger;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AvdOptionsModel
extends WizardModel {
    private static final Storage minGeneralInternalMemSize = new Storage(200L, Storage.Unit.MiB);
    private static final Storage minPlayStoreInternalMemSize = new Storage(2L, Storage.Unit.GiB);
    private static final Storage minGeneralSdSize = new Storage(10L, Storage.Unit.MiB);
    private static final Storage minPlayStoreSdSize = new Storage(100L, Storage.Unit.MiB);
    private static final Storage defaultSdSize = new Storage(512L, Storage.Unit.MiB);
    private static final Storage zeroSdSize = new Storage(0L, Storage.Unit.MiB);
    private final AvdInfo myAvdInfo;
    private BoolProperty myUseQemu2 = new BoolValueProperty(true);
    private StringProperty myAvdId = new StringValueProperty();
    private StringProperty myAvdDisplayName = new StringValueProperty();
    private ObjectProperty<Storage> myInternalStorage = new ObjectValueProperty<Storage>(EmulatedProperties.DEFAULT_INTERNAL_STORAGE);
    private ObjectProperty<ScreenOrientation> mySelectedAvdOrientation = new ObjectValueProperty<ScreenOrientation>(ScreenOrientation.PORTRAIT);
    private ObjectProperty<AvdCamera> mySelectedAvdFrontCamera;
    private ObjectProperty<AvdCamera> mySelectedAvdBackCamera;
    private BoolProperty myHasDeviceFrame = new BoolValueProperty(true);
    private BoolProperty myUseExternalSdCard = new BoolValueProperty(false);
    private BoolProperty myUseBuiltInSdCard = new BoolValueProperty(true);
    private ObjectProperty<AvdNetworkSpeed> mySelectedNetworkSpeed = new ObjectValueProperty<AvdNetworkSpeed>(EmulatedProperties.DEFAULT_NETWORK_SPEED);
    private ObjectProperty<AvdNetworkLatency> mySelectedNetworkLatency = new ObjectValueProperty<AvdNetworkLatency>(EmulatedProperties.DEFAULT_NETWORK_LATENCY);
    private StringProperty mySystemImageName = new StringValueProperty();
    private StringProperty mySystemImageDetails = new StringValueProperty();
    private OptionalProperty<Integer> myCpuCoreCount = new OptionalValueProperty<Integer>(EmulatedProperties.RECOMMENDED_NUMBER_OF_CORES);
    private ObjectProperty<Storage> myVmHeapStorage = new ObjectValueProperty<Storage>(EmulatedProperties.DEFAULT_HEAP);
    private StringProperty myExternalSdCardLocation = new StringValueProperty();
    private OptionalProperty<Storage> mySdCardStorage = new OptionalValueProperty<Storage>(defaultSdSize);
    private BoolProperty myUseHostGpu = new BoolValueProperty(true);
    private BoolProperty myColdBoot = new BoolValueProperty(false);
    private BoolProperty myFastBoot = new BoolValueProperty(true);
    private BoolProperty myChosenSnapshotBoot = new BoolValueProperty(false);
    private StringProperty myChosenSnapshotFile = new StringValueProperty();
    private OptionalProperty<GpuMode> myHostGpuMode = new OptionalValueProperty<GpuMode>(GpuMode.AUTO);
    private BoolProperty myEnableHardwareKeyboard = new BoolValueProperty(true);
    private BoolProperty myIsInEditMode = new BoolValueProperty();
    private BoolProperty myRemovePreviousAvd = new BoolValueProperty(true);
    private OptionalProperty<File> myBackupSkinFile = new OptionalValueProperty<File>();
    private OptionalProperty<SystemImageDescription> mySystemImage = new OptionalValueProperty<SystemImageDescription>();
    private OptionalProperty<Device> myDevice = new OptionalValueProperty<Device>();
    private ObservableString existingSdLocation = new StringValueProperty();
    private ObservableObject<Storage> myOriginalSdCard;
    private AvdDeviceData myAvdDeviceData;
    private AvdInfo myCreatedAvd;

    public void setAsCopy() {
        String originalName = (String)this.myAvdDisplayName.get();
        String newName2 = "Copy_of_" + originalName;
        int copyNum = 2;
        while (AvdManagerConnection.getDefaultAvdManagerConnection().findAvdWithDisplayName(newName2)) {
            newName2 = "Copy_" + copyNum + "_of_" + originalName;
            ++copyNum;
        }
        this.myAvdDisplayName.set(newName2);
        this.myRemovePreviousAvd.set(false);
    }

    public AvdOptionsModel(@Nullable AvdInfo avdInfo) {
        this.myAvdInfo = avdInfo;
        this.myAvdDeviceData = new AvdDeviceData();
        boolean supportsVirtualCamera = EmulatorAdvFeatures.emulatorSupportsVirtualScene(AndroidSdks.getInstance().tryToChooseSdkHandler(), (ProgressIndicator)new StudioLoggerProgressIndicator(AvdOptionsModel.class), (ILogger)new LogWrapper(Logger.getInstance(AvdOptionsModel.class)));
        this.mySelectedAvdFrontCamera = new ObjectValueProperty<AvdCamera>(AvdCamera.EMULATED);
        this.mySelectedAvdBackCamera = new ObjectValueProperty<AvdCamera>(supportsVirtualCamera ? AvdCamera.VIRTUAL_SCENE : AvdCamera.EMULATED);
        if (this.myAvdInfo != null) {
            this.updateValuesWithAvdInfo(this.myAvdInfo);
        } else {
            this.updateValuesFromHardwareProperties();
        }
        this.myDevice.addListener(() -> {
            if (((Optional)this.myDevice.get()).isPresent()) {
                this.myAvdDeviceData.updateValuesFromDevice(this.myDevice.getValue(), this.mySystemImage.getValueOrNull());
                ScreenSize size = ScreenSize.getScreenSize((Double)((Double)this.myAvdDeviceData.diagonalScreenSize().get()));
                Density density = AvdScreenData.getScreenDensity((String)this.myAvdDeviceData.deviceId().get(), (Boolean)this.myAvdDeviceData.isTv().get(), (Double)this.myAvdDeviceData.screenDpi().get(), (Integer)this.myAvdDeviceData.screenResolutionHeight().get());
                Storage vmHeapSize = EmulatedProperties.calculateDefaultVmHeapSize((ScreenSize)size, (Density)density, (boolean)((Boolean)this.myAvdDeviceData.isTv().get()));
                this.myVmHeapStorage.set(vmHeapSize);
                if (((Boolean)this.myAvdDeviceData.getHasSdCard().get()).booleanValue()) {
                    this.myUseBuiltInSdCard.set(true);
                } else {
                    this.myUseBuiltInSdCard.set(false);
                }
                this.myUseExternalSdCard.set(false);
            }
        });
        this.mySystemImage.addListener(() -> {
            if (((Optional)this.myDevice.get()).isPresent()) {
                this.myAvdDeviceData.updateSkinFromDeviceAndSystemImage(this.myDevice.getValue(), this.mySystemImage.getValueOrNull());
            }
        });
    }

    public boolean isPlayStoreCompatible() {
        return this.myDevice != null && (Boolean)this.myDevice.isPresent().get() != false && this.myDevice.getValue().hasPlayStore() && (Boolean)this.mySystemImage.isPresent().get() != false && this.mySystemImage.getValue().getSystemImage().hasPlayStore();
    }

    public Storage minSdCardSize() {
        if (!((Boolean)this.myUseBuiltInSdCard.get()).booleanValue() && !((Boolean)this.myUseExternalSdCard.get()).booleanValue()) {
            return zeroSdSize;
        }
        return this.isPlayStoreCompatible() ? minPlayStoreSdSize : minGeneralSdSize;
    }

    public Storage minInternalMemSize() {
        return this.isPlayStoreCompatible() ? minPlayStoreInternalMemSize : minGeneralInternalMemSize;
    }

    public void ensureMinimumMemory() {
        if (this.mySdCardStorage.getValue().lessThan((Object)this.minSdCardSize())) {
            this.mySdCardStorage.setValue(this.minSdCardSize());
        }
        if (((Storage)this.myInternalStorage.get()).lessThan((Object)this.minInternalMemSize())) {
            this.myInternalStorage.set(this.minInternalMemSize());
        }
    }

    @Nullable
    private static Storage getStorageFromIni(@Nullable String iniString, boolean isInternalStorage) {
        if (iniString == null) {
            return null;
        }
        String numString = iniString.substring(0, iniString.length() - 1);
        char unitChar = iniString.charAt(iniString.length() - 1);
        Storage.Unit selectedUnit = null;
        for (Storage.Unit u : Storage.Unit.values()) {
            if (u.toString().charAt(0) != unitChar) continue;
            selectedUnit = u;
            break;
        }
        if (selectedUnit == null) {
            selectedUnit = isInternalStorage ? Storage.Unit.B : Storage.Unit.MiB;
            numString = iniString;
        }
        try {
            long numLong = Long.parseLong(numString);
            return new Storage(numLong, selectedUnit);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    private static String toIniString(@NotNull Double value2) {
        return String.format(Locale.US, "%f", value2);
    }

    @NotNull
    private static String toIniString(@NotNull File value2) {
        return value2.getPath();
    }

    @NotNull
    public static String toIniString(@NotNull Storage storage, boolean convertToMb) {
        Storage.Unit unit = convertToMb ? Storage.Unit.MiB : storage.getAppropriateUnits();
        String unitString = convertToMb ? "" : unit.toString().substring(0, 1);
        return String.format(Locale.US, "%1$d%2$s", storage.getSizeAsUnit(unit), unitString);
    }

    @NotNull
    private static String toIniString(@NotNull Boolean b) {
        return b != false ? "yes" : "no";
    }

    private static boolean fromIniString(@Nullable String s) {
        return "yes".equals(s);
    }

    @NotNull
    private static String calculateAvdName(@Nullable AvdInfo avdInfo, @NotNull Map<String, String> hardwareProperties, @NotNull Device device) {
        if (avdInfo != null) {
            return avdInfo.getName();
        }
        String candidateBase = hardwareProperties.get("avd.ini.displayname");
        if (candidateBase == null || candidateBase.isEmpty()) {
            String deviceName = device.getDisplayName().replace(' ', '_');
            String manufacturer = device.getManufacturer().replace(' ', '_');
            candidateBase = String.format("AVD_for_%1$s_by_%2$s", deviceName, manufacturer);
        }
        return AvdWizardUtils.cleanAvdName(AvdManagerConnection.getDefaultAvdManagerConnection(), candidateBase, true);
    }

    @NotNull
    public BoolProperty useQemu2() {
        return this.myUseQemu2;
    }

    @NotNull
    public StringProperty avdId() {
        return this.myAvdId;
    }

    @NotNull
    public StringProperty avdDisplayName() {
        return this.myAvdDisplayName;
    }

    @NotNull
    public ObjectProperty<ScreenOrientation> selectedAvdOrientation() {
        return this.mySelectedAvdOrientation;
    }

    @NotNull
    public ObjectProperty<AvdCamera> selectedFrontCamera() {
        return this.mySelectedAvdFrontCamera;
    }

    @NotNull
    public ObjectProperty<AvdCamera> selectedBackCamera() {
        return this.mySelectedAvdBackCamera;
    }

    @NotNull
    public BoolProperty hasDeviceFrame() {
        return this.myHasDeviceFrame;
    }

    @NotNull
    public ObjectProperty<AvdNetworkSpeed> selectedNetworkSpeed() {
        return this.mySelectedNetworkSpeed;
    }

    @NotNull
    public ObjectProperty<AvdNetworkLatency> selectedNetworkLatency() {
        return this.mySelectedNetworkLatency;
    }

    @NotNull
    public ObjectProperty<Storage> internalStorage() {
        return this.myInternalStorage;
    }

    @NotNull
    public BoolProperty useExternalSdCard() {
        return this.myUseExternalSdCard;
    }

    @NotNull
    public BoolProperty useBuiltInSdCard() {
        return this.myUseBuiltInSdCard;
    }

    @NotNull
    public StringProperty systemImageName() {
        return this.mySystemImageName;
    }

    @NotNull
    public StringProperty systemImageDetails() {
        return this.mySystemImageDetails;
    }

    @NotNull
    public ObjectProperty<Storage> vmHeapStorage() {
        return this.myVmHeapStorage;
    }

    @NotNull
    public OptionalProperty<Integer> cpuCoreCount() {
        return this.myCpuCoreCount;
    }

    @NotNull
    public OptionalProperty<Storage> sdCardStorage() {
        return this.mySdCardStorage;
    }

    @NotNull
    public StringProperty externalSdCardLocation() {
        return this.myExternalSdCardLocation;
    }

    @NotNull
    public BoolProperty useHostGpu() {
        return this.myUseHostGpu;
    }

    @NotNull
    public BoolProperty useColdBoot() {
        return this.myColdBoot;
    }

    @NotNull
    public BoolProperty useFastBoot() {
        return this.myFastBoot;
    }

    @NotNull
    public BoolProperty useChosenSnapshotBoot() {
        return this.myChosenSnapshotBoot;
    }

    @NotNull
    public StringProperty chosenSnapshotFile() {
        return this.myChosenSnapshotFile;
    }

    @NotNull
    public OptionalProperty<GpuMode> hostGpuMode() {
        return this.myHostGpuMode;
    }

    @NotNull
    public BoolProperty enableHardwareKeyboard() {
        return this.myEnableHardwareKeyboard;
    }

    @NotNull
    public OptionalProperty<File> backupSkinFile() {
        return this.myBackupSkinFile;
    }

    @NotNull
    public OptionalProperty<Device> device() {
        return this.myDevice;
    }

    @NotNull
    public BoolProperty isInEditMode() {
        return this.myIsInEditMode;
    }

    @NotNull
    public OptionalProperty<SystemImageDescription> systemImage() {
        return this.mySystemImage;
    }

    @NotNull
    public AvdDeviceData getAvdDeviceData() {
        return this.myAvdDeviceData;
    }

    private void updateValuesWithAvdInfo(@NotNull AvdInfo avdInfo) {
        File skinFile;
        String backupSkinPath;
        List<Device> devices2 = DeviceManagerConnection.getDefaultDeviceManagerConnection().getDevices();
        Device selectedDevice = null;
        String manufacturer = avdInfo.getDeviceManufacturer();
        String deviceId = avdInfo.getDeviceName();
        for (Device device : devices2) {
            if (!manufacturer.equals(device.getManufacturer()) || !deviceId.equals(device.getId())) continue;
            selectedDevice = device;
            break;
        }
        this.myDevice.setNullableValue(selectedDevice);
        SystemImageDescription systemImageDescription = null;
        ISystemImage selectedImage = avdInfo.getSystemImage();
        if (selectedImage != null) {
            systemImageDescription = new SystemImageDescription(selectedImage);
            this.mySystemImage.setValue(systemImageDescription);
        }
        this.myAvdDeviceData = new AvdDeviceData(selectedDevice, systemImageDescription);
        Map properties2 = avdInfo.getProperties();
        this.myUseQemu2.set(properties2.containsKey("hw.cpu.ncore"));
        String cpuCoreCount = (String)properties2.get("hw.cpu.ncore");
        this.myCpuCoreCount.setValue(cpuCoreCount == null ? 1 : Integer.parseInt(cpuCoreCount));
        Storage storage = AvdOptionsModel.getStorageFromIni((String)properties2.get("hw.ramSize"), false);
        if (storage != null) {
            this.myAvdDeviceData.ramStorage().set(storage);
        }
        if ((storage = AvdOptionsModel.getStorageFromIni((String)properties2.get("vm.heapSize"), false)) != null) {
            this.myVmHeapStorage.set(storage);
        }
        if ((storage = AvdOptionsModel.getStorageFromIni((String)properties2.get("disk.dataPartition.size"), true)) != null) {
            this.myInternalStorage.set(storage);
        }
        if (properties2.getOrDefault("hw.sdCard", AvdOptionsModel.toIniString(true)).equals(AvdOptionsModel.toIniString(true))) {
            String sdCardLocation = null;
            if (properties2.get("sdcard.path") != null) {
                sdCardLocation = (String)properties2.get("sdcard.path");
            } else if (properties2.get("sdcard.size") != null) {
                sdCardLocation = FileUtil.join((String[])new String[]{avdInfo.getDataFolderPath(), "sdcard.img"});
            }
            this.existingSdLocation = new StringValueProperty(Strings.nullToEmpty((String)sdCardLocation));
            String dataFolderPath = avdInfo.getDataFolderPath();
            File sdLocationFile = null;
            if (sdCardLocation != null) {
                sdLocationFile = new File(sdCardLocation);
            }
            if (sdLocationFile != null) {
                if (Objects.equal((Object)sdLocationFile.getParent(), (Object)dataFolderPath)) {
                    File sdFile = new File(sdCardLocation);
                    Storage sdCardSize = new Storage(sdFile.length());
                    this.myUseExternalSdCard.set(false);
                    this.myUseBuiltInSdCard.set(true);
                    this.myOriginalSdCard = new ObjectValueProperty<Storage>(sdCardSize);
                    this.mySdCardStorage.setValue(sdCardSize);
                } else {
                    this.myUseExternalSdCard.set(true);
                    this.myUseBuiltInSdCard.set(false);
                    this.externalSdCardLocation().set(sdCardLocation);
                }
            }
        } else {
            this.myUseExternalSdCard.set(false);
            this.myUseBuiltInSdCard.set(false);
        }
        this.myUseHostGpu.set(AvdOptionsModel.fromIniString((String)properties2.get("hw.gpu.enabled")));
        this.mySelectedAvdFrontCamera.set(AvdCamera.fromName((String)((String)properties2.get("hw.camera.front"))));
        this.mySelectedAvdBackCamera.set(AvdCamera.fromName((String)((String)properties2.get("hw.camera.back"))));
        this.mySelectedNetworkLatency.set(AvdNetworkLatency.fromName((String)((String)properties2.get("runtime.network.latency"))));
        this.mySelectedNetworkSpeed.set(AvdNetworkSpeed.fromName((String)((String)properties2.get("runtime.network.speed"))));
        this.myEnableHardwareKeyboard.set(AvdOptionsModel.fromIniString((String)properties2.get("hw.keyboard")));
        this.myAvdDisplayName.set(avdInfo.getDisplayName());
        this.myHasDeviceFrame.set(AvdOptionsModel.fromIniString((String)properties2.get("showDeviceFrame")));
        this.myColdBoot.set(AvdOptionsModel.fromIniString((String)properties2.get("fastboot.forceColdBoot")));
        this.myFastBoot.set(AvdOptionsModel.fromIniString((String)properties2.get("fastboot.forceFastBoot")));
        this.myChosenSnapshotBoot.set(AvdOptionsModel.fromIniString((String)properties2.get("fastboot.forceChosenSnapshotBoot")));
        String chosenFile = (String)properties2.get("fastboot.chosenSnapshotFile");
        this.myChosenSnapshotFile.set(StringUtil.notNullize((String)chosenFile));
        ScreenOrientation screenOrientation = null;
        String orientation = (String)properties2.get("hw.initialOrientation");
        if (!Strings.isNullOrEmpty((String)orientation)) {
            screenOrientation = ScreenOrientation.getByShortDisplayName((String)orientation);
        }
        this.mySelectedAvdOrientation.set(screenOrientation == null ? ScreenOrientation.PORTRAIT : screenOrientation);
        String skinPath = (String)properties2.get("skin.path");
        if (skinPath != null) {
            File skinFile2;
            File file2 = skinFile2 = skinPath.equals(AvdWizardUtils.NO_SKIN.getPath()) ? AvdWizardUtils.NO_SKIN : new File(skinPath);
            if (skinFile2.isDirectory()) {
                this.myAvdDeviceData.customSkinFile().setValue(skinFile2);
            }
        }
        if ((backupSkinPath = (String)properties2.get("skin.path.backup")) != null && ((skinFile = new File(backupSkinPath)).isDirectory() || FileUtil.filesEqual((File)skinFile, (File)AvdWizardUtils.NO_SKIN))) {
            this.backupSkinFile().setValue(skinFile);
        }
        String modeString = (String)properties2.get("hw.gpu.mode");
        this.myHostGpuMode.setValue(GpuMode.fromGpuSetting((String)modeString));
        this.myIsInEditMode.set(true);
    }

    private void updateValuesFromHardwareProperties() {
        AvdManagerConnection conn = AvdManagerConnection.getDefaultAvdManagerConnection();
        Storage storage = AvdOptionsModel.getStorageFromIni(conn.getSdCardSizeFromHardwareProperties(), false);
        if (storage != null) {
            this.mySdCardStorage.setValue(storage);
        }
        if ((storage = AvdOptionsModel.getStorageFromIni(conn.getInternalStorageSizeFromHardwareProperties(), true)) != null && storage.getSize() != 0L) {
            this.myInternalStorage.set(storage);
        }
    }

    private Map<String, Object> generateUserEditedPropertiesMap() {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("AvdManager.WizardOnly.DeviceDefinition", this.myDevice);
        map2.put("AvdManager.WizardOnly.SystemImage", this.mySystemImage);
        map2.put("AvdId", this.myAvdId.get());
        map2.put("vm.heapSize", this.myVmHeapStorage.get());
        map2.put("avd.ini.displayname", this.myAvdDisplayName.get());
        map2.put("AvdManager.WizardOnly.DefaultOrientation", this.mySelectedAvdOrientation.get());
        map2.put("hw.ramSize", this.myAvdDeviceData.ramStorage().get());
        map2.put("AvdManager.WizardOnly.isInEditMode", this.myIsInEditMode.get());
        map2.put("hw.keyboard", this.myEnableHardwareKeyboard.get());
        map2.put("hw.initialOrientation", ((ScreenOrientation)this.mySelectedAvdOrientation.get()).getShortDisplayValue());
        map2.put("hw.gpu.enabled", this.myUseHostGpu.get());
        map2.put("showDeviceFrame", this.myHasDeviceFrame.get());
        map2.put("hw.gpu.mode", this.myHostGpuMode.getValue());
        map2.put("fastboot.forceColdBoot", this.myColdBoot.get());
        map2.put("fastboot.forceFastBoot", this.myFastBoot.get());
        map2.put("fastboot.forceChosenSnapshotBoot", this.myChosenSnapshotBoot.get());
        map2.put("fastboot.chosenSnapshotFile", this.myChosenSnapshotFile.get());
        if (((Boolean)this.myUseQemu2.get()).booleanValue()) {
            if (((Optional)this.myCpuCoreCount.get()).isPresent()) {
                map2.put("hw.cpu.ncore", this.myCpuCoreCount.getValue());
            } else {
                map2.put("hw.cpu.ncore", 1);
            }
        } else {
            map2.remove("hw.cpu.ncore");
        }
        if (this.myOriginalSdCard != null) {
            map2.put("sdcard.size", this.myOriginalSdCard);
        }
        if (!Strings.isNullOrEmpty((String)((String)this.existingSdLocation.get()))) {
            map2.put("sdcard.path", this.existingSdLocation.get());
        }
        if (!Strings.isNullOrEmpty((String)((String)this.myExternalSdCardLocation.get()))) {
            map2.put("sdcard.path", this.myExternalSdCardLocation.get());
            map2.put("AvdManager.WizardOnly.displaySdLocation", this.myExternalSdCardLocation.get());
        }
        map2.put("AvdManager.WizardOnly.displayUseExistingSd", this.myUseExternalSdCard.get());
        map2.put("disk.dataPartition.size", this.myInternalStorage.get());
        map2.put("runtime.network.speed", ((AvdNetworkSpeed)this.mySelectedNetworkSpeed.get()).getAsParameter());
        map2.put("runtime.network.latency", ((AvdNetworkLatency)this.mySelectedNetworkLatency.get()).getAsParameter());
        map2.put("hw.camera.front", (Boolean)this.myAvdDeviceData.hasFrontCamera().get() != false ? ((AvdCamera)this.mySelectedAvdFrontCamera.get()).getAsParameter() : AvdCamera.NONE);
        map2.put("hw.camera.back", (Boolean)this.myAvdDeviceData.hasBackCamera().get() != false ? ((AvdCamera)this.mySelectedAvdBackCamera.get()).getAsParameter() : AvdCamera.NONE);
        if (((Optional)this.myAvdDeviceData.customSkinFile().get()).isPresent()) {
            map2.put("skin.path", this.myAvdDeviceData.customSkinFile().getValue());
        }
        if (((Optional)this.myBackupSkinFile.get()).isPresent()) {
            map2.put("skin.path.backup", this.myBackupSkinFile.getValue());
        }
        if (((Optional)this.mySdCardStorage.get()).isPresent()) {
            map2.put("AvdManager.WizardOnly.displaySdCardSize", this.mySdCardStorage.getValue());
        }
        return map2;
    }

    @Override
    protected void handleFinished() {
        ISystemImage image;
        String avdName;
        File skinFile;
        Device device = this.myDevice.getValue();
        SystemImageDescription systemImage = this.mySystemImage.getValue();
        Map hardwareProperties = DeviceManager.getHardwareProperties((Device)device);
        Map userEditedProperties = this.generateUserEditedPropertiesMap();
        String sdCard = null;
        boolean hasSdCard = false;
        if (((Boolean)this.myUseExternalSdCard.get()).booleanValue()) {
            sdCard = (String)this.myExternalSdCardLocation.get();
            userEditedProperties.remove("sdcard.size");
            hasSdCard = true;
        } else if (((Boolean)this.myUseBuiltInSdCard.get()).booleanValue()) {
            if (((Optional)this.sdCardStorage().get()).isPresent() && this.myOriginalSdCard != null && this.sdCardStorage().getValue().equals(this.myOriginalSdCard.get())) {
                sdCard = (String)this.existingSdLocation.get();
                hasSdCard = true;
            } else {
                userEditedProperties.remove("sdcard.path");
                Storage storage = null;
                this.myOriginalSdCard = new ObjectValueProperty<Storage>(this.mySdCardStorage.getValue());
                if (((Optional)this.mySdCardStorage.get()).isPresent()) {
                    storage = this.mySdCardStorage.getValue();
                    sdCard = AvdOptionsModel.toIniString(storage, false);
                }
                hasSdCard = storage != null && storage.getSize() > 0L;
            }
        } else {
            hasSdCard = false;
            userEditedProperties.remove("sdcard.path");
        }
        hardwareProperties.put("hw.sdCard", AvdOptionsModel.toIniString(hasSdCard));
        userEditedProperties = Maps.filterEntries(userEditedProperties, input -> !((String)input.getKey()).startsWith("AvdManager.WizardOnly.") && input.getValue() != null);
        hardwareProperties.putAll(Maps.transformEntries((Map)userEditedProperties, (key, value2) -> {
            if (value2 instanceof Storage) {
                if (key.equals("hw.ramSize") || key.equals("vm.heapSize")) {
                    return AvdOptionsModel.toIniString((Storage)value2, true);
                }
                return AvdOptionsModel.toIniString((Storage)value2, false);
            }
            if (value2 instanceof Boolean) {
                return AvdOptionsModel.toIniString((Boolean)value2);
            }
            if (value2 instanceof File) {
                return AvdOptionsModel.toIniString((File)value2);
            }
            if (value2 instanceof Double) {
                return AvdOptionsModel.toIniString((Double)value2);
            }
            if (value2 instanceof GpuMode) {
                GpuMode gpuMode = (GpuMode)value2;
                if (gpuMode == GpuMode.SWIFT && !AvdManagerConnection.getDefaultAvdManagerConnection().emulatorVersionIsAtLeast(new Revision(27, 1, 6))) {
                    return "guest";
                }
                return gpuMode.getGpuSetting();
            }
            return value2.toString();
        }));
        File file2 = skinFile = ((Optional)this.myAvdDeviceData.customSkinFile().get()).isPresent() ? this.myAvdDeviceData.customSkinFile().getValue() : AvdWizardUtils.pathToUpdatedSkins(device.getDefaultHardware().getSkinFile(), systemImage, FileOpUtils.create());
        if (((Optional)this.myBackupSkinFile.get()).isPresent()) {
            hardwareProperties.put("skin.path.backup", this.myBackupSkinFile.getValue().getPath());
        }
        if (!hardwareProperties.containsKey("skin.dynamic")) {
            hardwareProperties.put("skin.dynamic", AvdOptionsModel.toIniString(true));
        }
        if (!hardwareProperties.containsKey("hw.keyboard")) {
            hardwareProperties.put("hw.keyboard", AvdOptionsModel.toIniString(false));
        }
        boolean isCircular = (Boolean)this.myAvdDeviceData.isScreenRound().get();
        String tempAvdName = (String)this.myAvdId.get();
        String string = avdName = tempAvdName.isEmpty() ? AvdOptionsModel.calculateAvdName(this.myAvdInfo, hardwareProperties, device) : tempAvdName;
        if (this.myAvdInfo != null && (image = this.myAvdInfo.getSystemImage()) != null) {
            int oldApiLevel = image.getAndroidVersion().getFeatureLevel();
            int newApiLevel = systemImage.getVersion().getFeatureLevel();
            String oldApiName = image.getAndroidVersion().getApiString();
            String newApiName = systemImage.getVersion().getApiString();
            if (oldApiLevel > newApiLevel || oldApiLevel == newApiLevel && image.getAndroidVersion().isPreview() && !systemImage.getVersion().isPreview()) {
                AtomicReference shouldContinue = new AtomicReference();
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    String message2 = String.format(Locale.getDefault(), "You are about to downgrade %1$s from API level %2$s to API level %3$s.\nThis requires a wipe of the userdata partition of the AVD.\nDo you wish to continue with the data wipe?", avdName, oldApiName, newApiName);
                    int result2 = Messages.showYesNoDialog((Project)null, (String)message2, (String)"Confirm Data Wipe", (Icon)AllIcons.General.QuestionDialog);
                    shouldContinue.set(result2 == 0);
                }, ModalityState.any());
                if (((Boolean)shouldContinue.get()).booleanValue()) {
                    AvdManagerConnection.getDefaultAvdManagerConnection().wipeUserData(this.myAvdInfo);
                } else {
                    return;
                }
            }
        }
        String sdCardFinal = sdCard;
        AvdManagerConnection connection = AvdManagerConnection.getDefaultAvdManagerConnection();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            this.myCreatedAvd = connection.createOrUpdateAvd(this.myAvdInfo, avdName, device, systemImage, (ScreenOrientation)this.mySelectedAvdOrientation.get(), isCircular, sdCardFinal, skinFile, hardwareProperties, (Boolean)this.myRemovePreviousAvd.get());
        }, "Creating Android Virtual Device", false, null);
        if (this.myCreatedAvd == null) {
            ApplicationManager.getApplication().invokeAndWait(() -> Messages.showErrorDialog((Project)null, (String)"An error occurred while creating the AVD. See idea.log for details.", (String)"Error Creating AVD"), ModalityState.any());
        }
    }

    @NotNull
    public AvdInfo getCreatedAvd() {
        return this.myCreatedAvd;
    }

    @Nullable
    public String getAvdLocation() {
        return this.myAvdInfo == null ? null : this.myAvdInfo.getDataFolderPath();
    }
}

