/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.StatefulButtonNotifier;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonPainter;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.FontUIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatefulButton
extends JPanel {
    @VisibleForTesting
    @NotNull
    final ActionButton myButton;
    @Nullable
    private final String mySuccessMessage;
    @Nullable
    private final AssistActionStateManager myStateManager;
    @NotNull
    private final ActionData myAction;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Collection<MessageBusConnection> myMessageBusConnections = new ArrayList<MessageBusConnection>();
    @VisibleForTesting
    @Nullable
    StatefulButtonMessage myMessage;

    public StatefulButton(@NotNull ActionData action2, @NotNull ActionListener listener2, @Nullable AssistActionStateManager stateManager, @NotNull Project project) {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.myAction = action2;
        this.myStateManager = stateManager;
        this.myProject = project;
        this.mySuccessMessage = action2.getSuccessMessage();
        this.myButton = new ActionButton(action2, listener2, this);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 18;
        c.insets = JBUI.insets((int)7, (int)0, (int)10, (int)5);
        this.add((Component)this.myButton, c);
        this.myButton.setVisible(false);
        if (this.myStateManager != null) {
            this.myStateManager.init(project, action2);
            this.myMessage = this.myStateManager.getStateDisplay(project, action2, this.mySuccessMessage);
            if (this.myMessage != null) {
                ++c.gridy;
                c.fill = 2;
                this.add((Component)this.myMessage, c);
                this.myMessage.setVisible(false);
            }
        }
        this.updateButtonState();
    }

    @Override
    public void addNotify() {
        assert (SwingUtilities.isEventDispatchThread());
        this.updateButtonState();
        if (this.myStateManager != null) {
            for (Module module2 : AssistActionStateManager.getAndroidModules(this.myProject)) {
                MessageBusConnection connection = module2.getMessageBus().connect((Disposable)module2);
                this.myMessageBusConnections.add(connection);
                connection.subscribe(StatefulButtonNotifier.BUTTON_STATE_TOPIC, this::updateButtonState);
            }
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        assert (SwingUtilities.isEventDispatchThread());
        this.myMessageBusConnections.forEach(SimpleMessageBusConnection::disconnect);
        this.myMessageBusConnections.clear();
        super.removeNotify();
    }

    @NotNull
    public ActionData getActionData() {
        return this.myAction;
    }

    public void updateButtonState() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myStateManager == null) {
                this.myButton.setVisible(true);
                return;
            }
            AssistActionState state = this.myStateManager.getState(this.myProject, this.myAction);
            this.revalidate();
            this.repaint();
            if (this.myMessage != null) {
                this.updateUIForState(state);
            }
        });
    }

    private void updateUIForState(AssistActionState state) {
        this.myButton.setVisible(state.isButtonVisible());
        this.myButton.setEnabled(state.isButtonEnabled());
        if (this.myMessage != null) {
            this.myMessage.setVisible(state.isMessageVisible());
        }
        if (state.isMessageVisible() && this.myStateManager != null) {
            this.remove(this.myMessage);
            this.myMessage = this.myStateManager.getStateDisplay(this.myProject, this.myAction, this.mySuccessMessage);
            if (this.myMessage == null) {
                return;
            }
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1.0;
            c.anchor = 18;
            c.fill = 2;
            c.insets = JBUI.insets((int)7, (int)0, (int)10, (int)5);
            this.add((Component)this.myMessage, c);
        }
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    private static class HighlightedDarculaButtonUI
    extends DarculaButtonUI {
        private HighlightedDarculaButtonUI() {
        }

        @NotNull
        protected Color getButtonColorStart() {
            return this.getDefaultButtonColorStart();
        }

        @NotNull
        protected Color getButtonColorEnd() {
            return this.getDefaultButtonColorEnd();
        }

        protected void setupDefaultButton(@NotNull JComponent button2, @NotNull Graphics graphics) {
            Font font = button2.getFont();
            if (!SystemInfo.isMac && font instanceof FontUIResource) {
                graphics.setFont(font.deriveFont(1));
            }
        }
    }

    public static class ActionButton
    extends JButton {
        private final String myKey;
        private final StatefulButton myButtonWrapper;

        public ActionButton(@NotNull ActionData action2, @NotNull ActionListener listener2, @NotNull StatefulButton wrapper) {
            super(action2.getLabel());
            this.myKey = action2.getKey();
            this.myButtonWrapper = wrapper;
            this.addActionListener(listener2);
            this.setOpaque(false);
            if (action2.isHighlighted()) {
                this.highlight();
            }
        }

        @NotNull
        public String getKey() {
            return this.myKey;
        }

        public void updateState() {
            this.myButtonWrapper.updateButtonState();
        }

        @NotNull
        public ActionData getActionData() {
            return this.myButtonWrapper.getActionData();
        }

        @NotNull
        public Project getProject() {
            return this.myButtonWrapper.getProject();
        }

        private void highlight() {
            if (this.getUI() instanceof DarculaButtonUI) {
                this.setUI((ButtonUI)((Object)new HighlightedDarculaButtonUI()));
                this.setBorder((Border)new DarculaButtonPainter(){

                    @NotNull
                    public Paint getBorderPaint(@NotNull Component button2) {
                        return JBColor.namedColor((String)"Button.default.focusedBorderColor", (Color)JBColor.namedColor((String)"Button.darcula.defaultFocusedOutlineColor", (int)8892378));
                    }
                });
                Color foreground = UIManager.getColor("Button.default.foreground");
                if (foreground == null) {
                    foreground = UIManager.getColor("Button.darcula.selectedButtonForeground");
                }
                if (foreground != null) {
                    this.setForeground(foreground);
                }
            }
        }
    }
}

