/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.tools.idea.adb.wireless.EditorPaneUtils;
import com.android.tools.idea.adb.wireless.MdnsService;
import com.android.tools.idea.adb.wireless.PinCodeDevicePanel;
import com.android.tools.idea.adb.wireless.UIColors;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class PinCodeContentPanel {
    @NotNull
    private JPanel myRootComponent;
    @NotNull
    private JPanel myEmptyPanel;
    @NotNull
    private JPanel myDevicesPanel;
    @NotNull
    private JPanel myDevicesHeaderPanel;
    @NotNull
    private JPanel myDeviceList;
    @NotNull
    private JBScrollPane myDeviceListScrollPane;
    @NotNull
    List<PinCodeDevicePanel> myPanels;

    public PinCodeContentPanel() {
        this.$$$setupUI$$$();
        this.myPanels = new ArrayList<PinCodeDevicePanel>();
        this.myDeviceList.setLayout((LayoutManager)new VerticalFlowLayout());
        this.myEmptyPanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myDevicesHeaderPanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myDeviceListScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myDeviceList.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        EditorPaneUtils.setTitlePanelBorder(this.myDevicesHeaderPanel);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myRootComponent;
    }

    public void showDevices(@NotNull @NotNull List<@NotNull MdnsService> services, @NotNull Consumer<MdnsService> pinCodePairInvoked2) {
        if (services.isEmpty()) {
            this.myEmptyPanel.setVisible(true);
            this.myDevicesPanel.setVisible(false);
            this.myDeviceList.removeAll();
            this.myDeviceList.revalidate();
            this.myDeviceList.repaint();
            this.myPanels.clear();
        } else {
            int i2;
            this.myEmptyPanel.setVisible(false);
            this.myDevicesPanel.setVisible(true);
            boolean needRepaint = false;
            for (MdnsService service : services) {
                if (PinCodeContentPanel.isPanelPresent(this.myPanels, service)) continue;
                PinCodeDevicePanel devicePanel = new PinCodeDevicePanel(service, () -> pinCodePairInvoked2.accept(service));
                this.myDeviceList.add(devicePanel.getComponent());
                this.myPanels.add(devicePanel);
                needRepaint = true;
            }
            ArrayList<Integer> indicesToRemove = new ArrayList<Integer>();
            int index2 = 0;
            for (PinCodeDevicePanel panel2 : this.myPanels) {
                if (PinCodeContentPanel.isPanelDeleted(services, panel2)) {
                    indicesToRemove.add(index2);
                }
                ++index2;
            }
            for (i2 = indicesToRemove.size() - 1; i2 >= 0; --i2) {
                int indexToRemove = (Integer)indicesToRemove.get(i2);
                this.myPanels.remove(indexToRemove);
                this.myDeviceList.remove(indexToRemove);
                needRepaint = true;
            }
            if (needRepaint) {
                this.myDeviceList.revalidate();
                this.myDeviceList.repaint();
            }
            assert (this.myPanels.size() == this.myDeviceList.getComponentCount());
            assert (services.size() == this.myDeviceList.getComponentCount());
            for (i2 = 0; i2 < this.myPanels.size(); ++i2) {
                assert (this.myPanels.get(i2).getComponent() == this.myDeviceList.getComponent(i2));
                assert (this.myPanels.get(i2).getMdnsService().equals(services.get(i2)));
            }
        }
    }

    private static boolean isPanelDeleted(@NotNull List<MdnsService> services, @NotNull PinCodeDevicePanel panel2) {
        return services.stream().noneMatch(service -> service.equals(panel2.getMdnsService()));
    }

    private static boolean isPanelPresent(@NotNull List<PinCodeDevicePanel> panels, @NotNull MdnsService device) {
        return panels.stream().anyMatch(panel2 -> panel2.getMdnsService().equals(device));
    }

    private void createUIComponents() {
        this.myDeviceListScrollPane = new JBScrollPane(0);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.myRootComponent = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        this.myDevicesPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDevicesHeaderPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Available devices");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = this.myDeviceListScrollPane;
        jPanel4.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeviceList = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel2);
        this.myEmptyPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootComponent;
    }
}

