/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.panels;

import com.android.build.attribution.ui.BuildAnalyzerBrowserLinks;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.DescriptionWithHelpLinkLabel;
import com.android.build.attribution.ui.data.PluginSourceType;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.panels.BuildAttributionPanelsKt;
import com.android.tools.adtui.TabularLayout;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0002\u001a$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a\b\u0010\u000b\u001a\u00020\fH\u0002\u001a6\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u001a8\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a,\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"createReasonsText", "", "reasons", "", "generateReportLinkLabel", "Ljavax/swing/JComponent;", "taskData", "Lcom/android/build/attribution/ui/data/TaskUiData;", "generateReportClicked", "Lkotlin/Function1;", "", "horizontalRuler", "Ljavax/swing/JPanel;", "taskDetailsPage", "helpLinkListener", "Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "generateReportClickedListener", "taskDetailsPanel", "taskWarningDescriptionPanel", "issue", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "helpLinkClickCallback", "needSeparatorInFront", "", "intellij.android.build-attribution"})
public final class BuildAttributionPanelsKt {
    @NotNull
    public static final JPanel taskDetailsPage(@NotNull TaskUiData taskData, @NotNull Function1<? super BuildAnalyzerBrowserLinks, Unit> helpLinkListener, @NotNull Function1<? super TaskUiData, Unit> generateReportClickedListener) {
        JPanel jPanel = new JPanel();
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply = jPanel;
        boolean bl3 = false;
        $this$apply.setLayout(new BorderLayout());
        $this$apply.add((Component)BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines("<b>" + taskData.getTaskPath() + "</b>"), "North");
        $this$apply.add((Component)BuildAttributionPanelsKt.taskDetailsPanel(taskData, helpLinkListener, generateReportClickedListener), "Center");
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    private static final JPanel taskDetailsPanel(TaskUiData taskData, Function1<? super BuildAnalyzerBrowserLinks, Unit> helpLinkListener, Function1<? super TaskUiData, Unit> generateReportClickedListener) {
        String determinesBuildDurationLine = taskData.getOnLogicalCriticalPath() ? "This task frequently determines build duration because of dependencies between its inputs/outputs and other tasks." : "This task occasionally determines build duration because of parallelism constraints introduced by number of cores or other tasks in the same module.";
        JEditorPane taskInfo = BuildAttributionUIUtilKt.htmlTextLabelWithLinesWrap(StringsKt.trimIndent((String)("\n      " + determinesBuildDurationLine + "<br/>\n      <br/>\n      <b>Duration:</b>  " + BuildAttributionUIUtilKt.durationStringHtml(taskData.getExecutionTime()) + " / " + BuildAttributionUIUtilKt.percentageStringHtml(taskData.getExecutionTime()) + "<br/>\n      Sub-project: " + taskData.getModule() + "<br/>\n      Plugin: " + taskData.getPluginName() + "<br/>\n      Type: " + taskData.getTaskType() + "<br/>\n      <br/>\n      <b>Warnings</b><br/>\n    ")));
        JEditorPane reasonsList = BuildAttributionUIUtilKt.htmlTextLabelWithLinesWrap(StringsKt.trimIndent((String)("\n    <b>Reason task ran</b><br/>\n    " + BuildAttributionPanelsKt.createReasonsText(taskData.getReasonsToRun()) + "\n  ")));
        JBPanel infoPanel = new JBPanel((LayoutManager)new TabularLayout("*"));
        int row = 0;
        infoPanel.add((Component)taskInfo, (Object)new TabularLayout.Constraint(row++, 0, 0, 4, null));
        if (taskData.getIssues().isEmpty()) {
            infoPanel.add((Component)new JLabel("No warnings found"), (Object)new TabularLayout.Constraint(row++, 0, 0, 4, null));
        } else {
            if (taskData.getSourceType() != PluginSourceType.BUILD_SRC) {
                infoPanel.add((Component)BuildAttributionPanelsKt.generateReportLinkLabel(taskData, generateReportClickedListener), (Object)new TabularLayout.Constraint(row++, 0, 0, 4, null));
            }
            boolean bl = false;
            for (TaskIssueUiData issue2 : (Iterable)taskData.getIssues()) {
                void index2;
                infoPanel.add((Component)BuildAttributionPanelsKt.taskWarningDescriptionPanel(issue2, helpLinkListener, index2 > 0), (Object)new TabularLayout.Constraint(row++, 0, 0, 4, null));
                ++index2;
            }
        }
        reasonsList.setBorder((Border)JBUI.Borders.emptyTop((int)22));
        infoPanel.add((Component)reasonsList, (Object)new TabularLayout.Constraint(row, 0, 0, 4, null));
        return (JPanel)infoPanel;
    }

    private static final JComponent taskWarningDescriptionPanel(TaskIssueUiData issue2, Function1<? super BuildAnalyzerBrowserLinks, Unit> helpLinkClickCallback, boolean needSeparatorInFront) {
        JPanel jPanel = new JPanel();
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply = jPanel;
        boolean bl3 = false;
        $this$apply.setName("warning-" + issue2.getType().name());
        $this$apply.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        $this$apply.setLayout((LayoutManager)new TabularLayout("Fit,*").setVGap(8));
        if (needSeparatorInFront) {
            $this$apply.add((Component)BuildAttributionPanelsKt.horizontalRuler(), new TabularLayout.Constraint(0, 1, 0, 4, null));
        }
        $this$apply.add((Component)new JBLabel(BuildAttributionUIUtilKt.warningIcon()).withBorder((Border)JBUI.Borders.emptyRight((int)5)), new TabularLayout.Constraint(1, 0, 0, 4, null));
        $this$apply.add((Component)BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines("<b>" + issue2.getType().getUiName() + "</b>"), new TabularLayout.Constraint(1, 1, 0, 4, null));
        $this$apply.add((Component)((Object)new DescriptionWithHelpLinkLabel(issue2.getExplanation(), issue2.getHelpLink(), helpLinkClickCallback)), new TabularLayout.Constraint(2, 1, 0, 4, null));
        $this$apply.add((Component)BuildAttributionUIUtilKt.htmlTextLabelWithLinesWrap("<b>Recommendation:</b> " + issue2.getBuildSrcRecommendation()), new TabularLayout.Constraint(3, 1, 0, 4, null));
        return jPanel;
    }

    private static final JComponent generateReportLinkLabel(TaskUiData taskData, Function1<? super TaskUiData, Unit> generateReportClicked) {
        JPanel jPanel = new JPanel();
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply = jPanel;
        boolean bl3 = false;
        $this$apply.setLayout(new FlowLayout(0, 0, 0));
        $this$apply.add(new JLabel("Consider filing a bug to report this issue to the plugin developer. "));
        HyperlinkLabel link = new HyperlinkLabel("Generate report");
        link.addHyperlinkListener(new HyperlinkListener(generateReportClicked, taskData){
            final /* synthetic */ Function1 $generateReportClicked$inlined;
            final /* synthetic */ TaskUiData $taskData$inlined;
            {
                this.$generateReportClicked$inlined = function1;
                this.$taskData$inlined = taskUiData;
            }

            public final void hyperlinkUpdate(HyperlinkEvent it) {
                this.$generateReportClicked$inlined.invoke((Object)this.$taskData$inlined);
            }
        });
        $this$apply.add((Component)link);
        return jPanel;
    }

    private static final String createReasonsText(List<String> reasons) {
        return reasons.isEmpty() ? "No info" : CollectionsKt.joinToString$default((Iterable)reasons, (CharSequence)"<br/>", null, null, (int)0, null, (Function1)createReasonsText.1.INSTANCE, (int)30, null);
    }

    private static final JPanel horizontalRuler() {
        return (JPanel)new JBPanel().withBackground(OnePixelDivider.BACKGROUND).withPreferredHeight(1).withMaximumHeight(1).withMinimumHeight(1);
    }
}

