/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.projectRoots.impl.MockSdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.JavaVersion;
import com.sun.tools.javac.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.tools.FileSystemCompiler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;

public final class IdeaTestUtil {
    private static final String MOCK_JDK_DIR_NAME_PREFIX = "mockJDK-";
    public static final String WEB_JARS_MODULE_LIBRARY_NAME = "webjars";

    public static void printDetectedPerformanceTimings() {
        System.out.println(Timings.getStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withLevel(@NotNull Module module, @NotNull LanguageLevel level, @NotNull Runnable r) {
        LanguageLevelProjectExtension projectExt = LanguageLevelProjectExtension.getInstance((Project)module.getProject());
        LanguageLevel projectLevel = projectExt.getLanguageLevel();
        LanguageLevel moduleLevel = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        try {
            projectExt.setLanguageLevel(level);
            IdeaTestUtil.setModuleLanguageLevel(module, level);
            r.run();
        }
        finally {
            IdeaTestUtil.setModuleLanguageLevel(module, moduleLevel);
            projectExt.setLanguageLevel(projectLevel);
        }
    }

    public static void setModuleLanguageLevel(@NotNull Module module, @Nullable LanguageLevel level) {
        ModuleRootModificationUtil.updateModel((Module)module, model -> ((LanguageLevelModuleExtension)model.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level));
    }

    public static void setModuleLanguageLevel(@NotNull Module module, @NotNull LanguageLevel level, @NotNull Disposable parentDisposable) {
        LanguageLevel prev = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        IdeaTestUtil.setModuleLanguageLevel(module, level);
        Disposer.register((Disposable)parentDisposable, () -> IdeaTestUtil.setModuleLanguageLevel(module, prev));
    }

    @NotNull
    public static Sdk getMockJdk(@NotNull JavaVersion version) {
        int mockJdk = version.feature >= 11 ? 11 : (version.feature >= 9 ? 9 : (version.feature >= 7 ? version.feature : (version.feature >= 5 ? 7 : 4)));
        String path = IdeaTestUtil.getPathForJdkNamed(MOCK_JDK_DIR_NAME_PREFIX + (mockJdk < 11 ? "1." : "") + mockJdk).getPath();
        return IdeaTestUtil.createMockJdk("java " + version, path);
    }

    @NotNull
    public static Sdk createMockJdk(@NotNull String name, @NotNull String path) {
        return IdeaTestUtil.createMockJdk(name, path, false);
    }

    @NotNull
    public static Sdk createMockJdk(@NotNull String name, @NotNull String path, boolean isJre) {
        JavaSdk javaSdk = JavaSdk.getInstance();
        if (javaSdk == null) {
            throw new AssertionError((Object)"The test uses classes from Java plugin but Java plugin wasn't loaded; make sure that Java plugin classes are included into classpath and that the plugin isn't disabled by using 'idea.load.plugins', 'idea.load.plugins.id', 'idea.load.plugins.category' system properties");
        }
        String homePath = PathUtil.toSystemIndependentName((String)path);
        File jdkHomeFile = new File(homePath);
        final MultiMap roots = MultiMap.create();
        SdkModificator sdkModificator = new SdkModificator(){

            @NotNull
            public String getName() {
                throw new UnsupportedOperationException();
            }

            public void setName(@NotNull String name1) {
                throw new UnsupportedOperationException();
            }

            public String getHomePath() {
                throw new UnsupportedOperationException();
            }

            public void setHomePath(String path1) {
                throw new UnsupportedOperationException();
            }

            public String getVersionString() {
                throw new UnsupportedOperationException();
            }

            public void setVersionString(String versionString) {
                throw new UnsupportedOperationException();
            }

            public SdkAdditionalData getSdkAdditionalData() {
                throw new UnsupportedOperationException();
            }

            public void setSdkAdditionalData(SdkAdditionalData data) {
                throw new UnsupportedOperationException();
            }

            public VirtualFile @NotNull [] getRoots(@NotNull OrderRootType rootType) {
                return roots.get((Object)rootType).toArray(VirtualFile.EMPTY_ARRAY);
            }

            public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
                throw new UnsupportedOperationException();
            }

            public void removeRoots(@NotNull OrderRootType rootType) {
                throw new UnsupportedOperationException();
            }

            public void removeAllRoots() {
                throw new UnsupportedOperationException();
            }

            public void commitChanges() {
                throw new UnsupportedOperationException();
            }

            public boolean isWritable() {
                throw new UnsupportedOperationException();
            }

            public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
                roots.putValue((Object)rootType, (Object)root);
            }
        };
        JavaSdkImpl.addClasses((File)jdkHomeFile, (SdkModificator)sdkModificator, (boolean)isJre);
        JavaSdkImpl.addSources((File)jdkHomeFile, (SdkModificator)sdkModificator);
        JavaSdkImpl.attachJdkAnnotations((SdkModificator)sdkModificator);
        return new MockSdk(name, homePath, name, roots, () -> JavaSdk.getInstance());
    }

    @NotNull
    public static Sdk getMockJdk14() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)4));
    }

    @NotNull
    public static Sdk getMockJdk17() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)7));
    }

    @NotNull
    public static Sdk getMockJdk17(@NotNull String name) {
        return IdeaTestUtil.createMockJdk(name, IdeaTestUtil.getMockJdk17Path().getPath());
    }

    @NotNull
    public static Sdk getMockJdk18() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)8));
    }

    @NotNull
    public static Sdk getMockJdk9() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)9));
    }

    @NotNull
    public static File getMockJdk14Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.4");
    }

    @NotNull
    public static File getMockJdk17Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.7");
    }

    @NotNull
    public static File getMockJdk18Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.8");
    }

    @NotNull
    public static File getMockJdk9Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.9");
    }

    public static String getMockJdkVersion(@NotNull String path) {
        String name = PathUtil.getFileName((String)path);
        if (name.startsWith(MOCK_JDK_DIR_NAME_PREFIX)) {
            return "java " + StringUtil.trimStart((String)name, (String)MOCK_JDK_DIR_NAME_PREFIX);
        }
        return null;
    }

    @NotNull
    private static File getPathForJdkNamed(@NotNull String name) {
        return new File(PathManager.getCommunityHomePath(), "java/" + name);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static Sdk getWebMockJdk17() {
        Sdk jdk = IdeaTestUtil.getMockJdk17();
        jdk = IdeaTestUtil.addWebJarsTo(jdk);
        return jdk;
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    @NotNull
    public static Sdk addWebJarsTo(@NotNull Sdk jdk) {
        try {
            jdk = (Sdk)jdk.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/jsp-api.jar"), OrderRootType.CLASSES);
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/servlet-api.jar"), OrderRootType.CLASSES);
        sdkModificator.commitChanges();
        return jdk;
    }

    public static void addWebJarsToModule(@NotNull Module module) {
        ModuleRootModificationUtil.updateModel((Module)module, IdeaTestUtil::addWebJarsToModule);
    }

    public static void removeWebJarsFromModule(@NotNull Module module) {
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            boolean removed = false;
            for (OrderEntry entry : model.getOrderEntries()) {
                LibraryOrderEntry libraryOrderEntry;
                if (!(entry instanceof LibraryOrderEntry) || !(libraryOrderEntry = (LibraryOrderEntry)entry).isModuleLevel() || !WEB_JARS_MODULE_LIBRARY_NAME.equals(libraryOrderEntry.getLibraryName())) continue;
                model.removeOrderEntry(entry);
                removed = true;
            }
            Assert.assertTrue((String)("Module library webjars was not found in module " + module), (boolean)removed);
        });
    }

    public static void addWebJarsToModule(@NotNull ModifiableRootModel model) {
        LibraryEx library = (LibraryEx)model.getModuleLibraryTable().createLibrary(WEB_JARS_MODULE_LIBRARY_NAME);
        LibraryEx.ModifiableModelEx libraryModel = library.getModifiableModel();
        libraryModel.addRoot(IdeaTestUtil.findJar("lib/jsp-api.jar"), OrderRootType.CLASSES);
        libraryModel.addRoot(IdeaTestUtil.findJar("lib/servlet-api.jar"), OrderRootType.CLASSES);
        WriteAction.runAndWait(() -> ((LibraryEx.ModifiableModelEx)libraryModel).commit());
    }

    @NotNull
    private static VirtualFile findJar(@NotNull String name) {
        String path = PathManager.getHomePath() + '/' + name;
        VirtualFile file = VfsTestUtil.findFileByCaseSensitivePath((String)path);
        VirtualFile jar = JarFileSystem.getInstance().getJarRootForLocalFile(file);
        assert (jar != null) : "no .jar for: " + path;
        return jar;
    }

    public static void setTestVersion(@NotNull JavaSdkVersion testVersion, @NotNull Module module, @NotNull Disposable parentDisposable) {
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        Assert.assertNotNull((Object)sdk);
        String oldVersionString = sdk.getVersionString();
        ((SdkModificator)sdk).setVersionString(testVersion.getDescription());
        Assert.assertSame((Object)testVersion, (Object)JavaSdk.getInstance().getVersion(sdk));
        Disposer.register((Disposable)parentDisposable, () -> ((SdkModificator)sdk).setVersionString(oldVersionString));
    }

    @NotNull
    public static String requireRealJdkHome() {
        String javaHome = SystemProperties.getJavaHome();
        List paths = ContainerUtil.packNullables((Object[])new String[]{javaHome, new File(javaHome).getParent(), System.getenv("JDK_16_x64"), System.getenv("JDK_16")});
        for (String path : paths) {
            if (!JdkUtil.checkForJdk((String)path)) continue;
            return path;
        }
        Assume.assumeTrue((String)("Cannot find JDK, checked paths: " + paths), (boolean)false);
        return null;
    }

    @NotNull
    public static File findSourceFile(@NotNull String basePath) {
        File testFile = new File(basePath + ".java");
        if (!testFile.exists()) {
            testFile = new File(basePath + ".groovy");
        }
        if (!testFile.exists()) {
            throw new IllegalArgumentException("No test source for " + basePath);
        }
        return testFile;
    }

    public static void compileFile(@NotNull File source, @NotNull File out, String ... options) {
        Assert.assertTrue((String)("source does not exist: " + source.getPath()), (boolean)source.isFile());
        ArrayList<String> args = new ArrayList<String>();
        args.add("-d");
        args.add(out.getAbsolutePath());
        ContainerUtil.addAll(args, (Object[])options);
        args.add(source.getAbsolutePath());
        if (source.getName().endsWith(".groovy")) {
            try {
                FileSystemCompiler.commandLineCompile((String[])ArrayUtilRt.toStringArray(args));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            int result = Main.compile(ArrayUtilRt.toStringArray(args));
            if (result != 0) {
                throw new IllegalStateException("javac failed with exit code " + result);
            }
        }
    }
}

