/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.dimension;

import com.google.api.services.testing.model.AndroidDeviceCatalog;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gct.testing.CloudConfigurationImpl;
import com.google.gct.testing.dimension.CloudConfigurationDimension;
import com.google.gct.testing.dimension.CloudTestingType;
import com.google.gct.testing.launcher.CloudAuthenticator;
import icons.StudioIcons;
import java.util.List;
import javax.swing.Icon;

public class OrientationDimension
extends CloudConfigurationDimension {
    public static final String DISPLAY_NAME = "Orientation";
    private static ImmutableList<Orientation> FULL_DOMAIN;
    private static Orientation defaultOrientation;

    public OrientationDimension(CloudConfigurationImpl googleCloudTestingConfiguration) {
        super(googleCloudTestingConfiguration);
    }

    @Override
    public List<? extends CloudTestingType> getAppSupportedDomain() {
        return OrientationDimension.getFullDomain();
    }

    public static List<? extends CloudTestingType> getFullDomain() {
        if (OrientationDimension.isFullDomainMissing() || OrientationDimension.shouldPollDiscoveryTestApi(DISPLAY_NAME)) {
            ImmutableList.Builder fullDomainBuilder = new ImmutableList.Builder();
            AndroidDeviceCatalog androidDeviceCatalog = CloudAuthenticator.getInstance().getAndroidDeviceCatalog();
            if (androidDeviceCatalog != null) {
                List modelOrientations = androidDeviceCatalog.getRuntimeConfiguration().getOrientations();
                for (com.google.api.services.testing.model.Orientation modelOrientation : modelOrientations) {
                    String orientationName = modelOrientation.getName();
                    if ("default".equalsIgnoreCase(orientationName)) continue;
                    Orientation orientation = new Orientation(modelOrientation.getId(), orientationName);
                    fullDomainBuilder.add((Object)orientation);
                    List tags = modelOrientation.getTags();
                    if (tags == null || !tags.contains("default")) continue;
                    defaultOrientation = orientation;
                }
            }
            if (OrientationDimension.isFullDomainMissing() || !fullDomainBuilder.build().isEmpty()) {
                FULL_DOMAIN = fullDomainBuilder.build();
            }
            OrientationDimension.resetDiscoveryTestApiUpdateTimestamp(DISPLAY_NAME);
        }
        return FULL_DOMAIN;
    }

    private static boolean isFullDomainMissing() {
        return FULL_DOMAIN == null || FULL_DOMAIN.isEmpty();
    }

    public static Orientation getDefaultOrientation() {
        if (defaultOrientation == null) {
            OrientationDimension.getFullDomain();
        }
        return defaultOrientation;
    }

    public void enableDefault() {
        if (OrientationDimension.getDefaultOrientation() != null) {
            this.enable(defaultOrientation);
        }
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public String getId() {
        return "ORIENTATION";
    }

    @Override
    public Icon getIcon() {
        return StudioIcons.DeviceConfiguration.ORIENTATION;
    }

    public static class Orientation
    extends CloudTestingType {
        private final String id;
        private final String name;

        public Orientation(String id, String name) {
            this.id = id;
            this.name = name;
            this.details = ImmutableMap.of();
        }

        @Override
        public String getConfigurationDialogDisplayName() {
            return this.name;
        }

        @Override
        public String getId() {
            return this.id;
        }
    }
}

