/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.tracer.agent;

import com.android.tools.tracer.agent.TraceProfile;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Tracer {
    private static final int SAVE_BATCH_SIZE = 40;
    public static TraceProfile profile;
    private static ArrayList<Event> events;
    private static final ExecutorService writer;
    public static final int pid;

    private static synchronized void add(Event event) {
        events.add(event);
        if (events.size() == 1) {
            writer.submit(Tracer::drain);
        }
    }

    private static synchronized ArrayList<Event> consumeEvents() {
        ArrayList<Event> old = events;
        events = new ArrayList(events.size());
        return old;
    }

    public static void add(Type type, String text) {
        Tracer.add(type, pid, Thread.currentThread().getId(), System.nanoTime(), text);
    }

    public static void add(Type type, long pid, long tid, long ns, String text) {
        Event event = new Event();
        event.pid = pid;
        event.tid = tid;
        event.text = text;
        event.timestamp_ns = ns;
        event.type = type;
        Tracer.add(event);
    }

    private static void drain() {
        ArrayList<Event> events = Tracer.consumeEvents();
        writer.submit(() -> Tracer.save(events));
    }

    private static void save(ArrayList<Event> events) {
        try (FileChannel fd = FileChannel.open(Paths.get(profile.getOutputFile(), new String[0]), StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
            fd.lock();
            long size = fd.size();
            if (size == 0L) {
                fd.write(ByteBuffer.wrap(new byte[]{91, 10}));
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < events.size(); ++i) {
                Event event = events.get(i);
                String s = String.format("{\"ts\" : \"%d\", \"ph\" : \"%s\" , \"pid\" : \"%s\" , \"tid\" : \"%d\", \"name\" : \"%s\"},\n", event.timestamp_ns / 1000L, event.type == Type.BEGIN ? "B" : "E", event.pid, event.tid, event.text);
                builder.append(s);
                if ((i + 1) % 40 != 0 && i != events.size() - 1) continue;
                byte[] bytes = builder.toString().getBytes(StandardCharsets.UTF_8);
                fd.write(ByteBuffer.wrap(bytes));
                builder = new StringBuilder();
            }
            fd.force(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void truncate() {
        try (FileChannel fd = FileChannel.open(Paths.get(profile.getOutputFile(), new String[0]), StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            fd.lock();
            fd.position(0L);
            fd.truncate(0L);
            fd.force(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void begin(String text) {
        Tracer.add(Type.BEGIN, text);
    }

    public static void end() {
        Tracer.add(Type.END, "");
    }

    public static void flush() {
        CountDownLatch latch = new CountDownLatch(1);
        Tracer.drain();
        writer.submit(latch::countDown);
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void begin(long pid, long tid, long ns, String text) {
        Tracer.add(Type.BEGIN, pid, tid, ns, text);
    }

    public static void end(long pid, long tid, long ns) {
        Tracer.add(Type.END, pid, tid, ns, "");
    }

    public static void start() {
        Tracer.drain();
        writer.submit(Tracer::truncate);
    }

    public static void addVmArgs(List<String> args) {
        String jvmArgs = profile.getJvmArgs();
        if (!jvmArgs.isEmpty()) {
            args.add(jvmArgs);
        }
    }

    static {
        events = new ArrayList();
        writer = Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        });
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int ix = name.indexOf(64);
        int candidatePid = 0;
        if (ix != -1) {
            try {
                candidatePid = Integer.valueOf(name.substring(0, ix));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        pid = candidatePid;
    }

    static class Event {
        public Type type;
        public long pid;
        public long tid;
        public long timestamp_ns;
        public String text;

        Event() {
        }
    }

    static enum Type {
        BEGIN,
        END;

    }
}

