/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.gradle.model.impl.GradleResourcesTargetType;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.groovy.GroovyBuilderExtension;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;

public class GroovyResourcesTargetExtension
implements GroovyBuilderExtension {
    @NotNull
    public Collection<String> getCompilationClassPath(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        return GroovyResourcesTargetExtension.getModuleDependencies(chunk).stream().flatMap(module -> GradleResourcesTargetType.buildModuleTargets(module, chunk.containsTests()).stream()).flatMap(target -> target.getOutputRoots(context).stream()).map(file -> FileUtil.toCanonicalPath((String)file.getPath())).collect(Collectors.toSet());
    }

    private static Collection<JpsModule> getModuleDependencies(@NotNull ModuleChunk chunk) {
        return chunk.getModules().stream().flatMap(module -> module.getDependenciesList().getDependencies().stream()).map(dep -> {
            if (dep instanceof JpsModuleDependency) {
                return ((JpsModuleDependency)dep).getModule();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @NotNull
    public Collection<String> getCompilationUnitPatchers(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        return Collections.emptyList();
    }
}

