/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.BundleBase;
import com.intellij.diagnostic.LoadingState;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.FontUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.AppleBoldDottedPainter;
import com.intellij.util.ui.CenteredIcon;
import com.intellij.util.ui.DetectRetinaKit;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.WavePainter;
import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.awt.print.PrinterGraphics;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import javax.swing.text.StyleContext;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.UndoManager;
import org.intellij.lang.annotations.JdkConstants;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UIUtil {
    public static final String BORDER_LINE = "<hr size=1 noshade>";
    @NonNls
    public static final String BR = "<br/>";
    public static final Key<Boolean> LAF_WITH_THEME_KEY;
    public static final Key<String> PLUGGABLE_LAF_KEY;
    private static final AtomicNotNullLazyValue<Boolean> X_RENDER_ACTIVE;
    private static final String[] STANDARD_FONT_SIZES;
    public static final char MNEMONIC = '\u001b';
    @NonNls
    public static final String HTML_MIME = "text/html";
    @NonNls
    public static final String JSLIDER_ISFILLED = "JSlider.isFilled";
    @NonNls
    public static final String TABLE_FOCUS_CELL_BACKGROUND_PROPERTY = "Table.focusCellBackground";
    @NonNls
    public static final String HIDE_EDITOR_FROM_DATA_CONTEXT_PROPERTY = "AuxEditorComponent";
    @NonNls
    public static final String CENTER_TOOLTIP_DEFAULT = "ToCenterTooltip";
    @NonNls
    public static final String CENTER_TOOLTIP_STRICT = "ToCenterTooltip.default";
    private static final Pattern CLOSE_TAG_PATTERN;
    @NonNls
    private static final String FOCUS_PROXY_KEY = "isFocusProxy";
    public static final Key<Integer> KEEP_BORDER_SIDES;
    private static final Key<UndoManager> UNDO_MANAGER;
    public static final Key<Boolean> TEXT_COPY_ROOT;
    private static final AbstractAction REDO_ACTION;
    private static final AbstractAction UNDO_ACTION;
    private static final Color ACTIVE_HEADER_COLOR;
    private static final Color INACTIVE_HEADER_COLOR;
    public static final Color CONTRAST_BORDER_COLOR;
    public static final Color SIDE_PANEL_BACKGROUND;
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR;
    public static final Color TRANSPARENT_COLOR;
    public static final int DEFAULT_HGAP = 10;
    public static final int DEFAULT_VGAP = 4;
    public static final int LARGE_VGAP = 12;
    private static final int REGULAR_PANEL_TOP_BOTTOM_INSET = 8;
    private static final int REGULAR_PANEL_LEFT_RIGHT_INSET = 12;
    public static final Insets PANEL_REGULAR_INSETS;
    public static final Insets PANEL_SMALL_INSETS;
    @NonNls
    private static final String ROOT_PANE = "JRootPane.future";
    private static final Ref<Boolean> ourRetina;
    public static final int LIST_FIXED_CELL_HEIGHT = 20;
    public static final Key<Iterable<? extends Component>> NOT_IN_HIERARCHY_COMPONENTS;
    private static final JBTreeTraverser<Component> UI_TRAVERSER;
    private static final Color DECORATED_ROW_BG_COLOR;
    private static final DocumentAdapter SET_TEXT_CHECKER;
    public static final String CHECKBOX_ROLLOVER_PROPERTY = "JCheckBox.rollOver.rectangle";
    public static final String CHECKBOX_PRESSED_PROPERTY = "JCheckBox.pressed.rectangle";
    private static final Color BACKGROUND;
    private static final Color LIST_BACKGROUND;
    private static final Color TREE_BACKGROUND;
    private static final Color TABLE_BACKGROUND;
    private static final JBValue SELECTED_ITEM_ALPHA;

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(UIUtil.class);
    }

    public static void decorateWindowHeader(JRootPane pane) {
        if (pane != null && SystemInfo.isMacOSMojave) {
            pane.putClientProperty("jetbrains.awt.windowDarkAppearance", StartupUiUtil.isUnderDarcula());
        }
    }

    public static void setCustomTitleBar(final @NotNull Window window, final @NotNull JRootPane rootPane, java.util.function.Consumer<Runnable> onDispose) {
        if (!SystemInfo.isMac || !Registry.is((String)"ide.mac.transparentTitleBarAppearance", (boolean)false)) {
            return;
        }
        final JBInsets topWindowInset = JBUI.insetsTop(24);
        rootPane.putClientProperty("jetbrains.awt.transparentTitleBarAppearance", true);
        AbstractBorder customDecorationBorder = new AbstractBorder(){

            @Override
            public Insets getBorderInsets(Component c) {
                return topWindowInset;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D graphics = (Graphics2D)g.create();
                try {
                    Rectangle headerRectangle = new Rectangle(0, 0, c.getWidth(), topWindowInset.top);
                    graphics.setColor(UIUtil.getPanelBackground());
                    graphics.fill(headerRectangle);
                    JBColor color = window.isActive() ? JBColor.black : JBColor.gray;
                    graphics.setColor(color);
                    int controlButtonsWidth = 70;
                    String windowTitle = UIUtil.getWindowTitle(window);
                    double widthToFit = controlButtonsWidth * 2 + GraphicsUtil.stringWidth(windowTitle, g.getFont()) - c.getWidth();
                    if (widthToFit <= 0.0) {
                        UIUtil.drawCenteredString(graphics, headerRectangle, windowTitle);
                    } else {
                        FontMetrics fm = graphics.getFontMetrics();
                        Rectangle2D stringBounds = fm.getStringBounds(windowTitle, graphics);
                        Rectangle bounds = AffineTransform.getTranslateInstance(controlButtonsWidth, (double)fm.getAscent() + ((double)headerRectangle.height - stringBounds.getHeight()) / 2.0).createTransformedShape(stringBounds).getBounds();
                        UIUtil.drawCenteredString(graphics, bounds, windowTitle, false, true);
                    }
                }
                finally {
                    graphics.dispose();
                }
            }
        };
        rootPane.setBorder(customDecorationBorder);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                rootPane.repaint();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                rootPane.repaint();
            }
        };
        PropertyChangeListener propertyChangeListener = e -> rootPane.repaint();
        window.addPropertyChangeListener("title", propertyChangeListener);
        onDispose.accept(() -> {
            window.removeWindowListener(windowAdapter);
            window.removePropertyChangeListener("title", propertyChangeListener);
        });
    }

    private static String getWindowTitle(Window window) {
        return window instanceof JDialog ? ((JDialog)window).getTitle() : ((JFrame)window).getTitle();
    }

    public static void markAsTypeAheadAware(Window window) {
        UIUtil.putWindowClientProperty(window, "TypeAheadAwareWindow", Boolean.TRUE);
    }

    public static boolean isTypeAheadAware(Window window) {
        return UIUtil.isWindowClientPropertyTrue(window, "TypeAheadAwareWindow");
    }

    public static void markAsPossibleOwner(Dialog dialog) {
        UIUtil.putWindowClientProperty(dialog, "PossibleOwner", Boolean.TRUE);
    }

    public static boolean isPossibleOwner(@NotNull Dialog dialog) {
        return UIUtil.isWindowClientPropertyTrue(dialog, "PossibleOwner");
    }

    public static int getMultiClickInterval() {
        Object property = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        if (property instanceof Integer) {
            return (Integer)property;
        }
        return 500;
    }

    public static void applyStyle(@NotNull ComponentStyle componentStyle, @NotNull Component comp) {
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent c = (JComponent)comp;
        if (UIUtil.isUnderAquaBasedLookAndFeel()) {
            c.putClientProperty("JComponent.sizeVariant", StringUtil.toLowerCase((String)componentStyle.name()));
        }
        FontSize fontSize = componentStyle == ComponentStyle.MINI ? FontSize.MINI : (componentStyle == ComponentStyle.SMALL ? FontSize.SMALL : FontSize.NORMAL);
        c.setFont(UIUtil.getFont(fontSize, c.getFont()));
        Container p = c.getParent();
        if (p != null) {
            SwingUtilities.updateComponentTreeUI(p);
        }
    }

    public static void setMonospaced(@NotNull Component component) {
        Font font = component.getFont();
        component.setFont(new FontUIResource("Monospaced", font.getStyle(), font.getSize()));
    }

    @NotNull
    public static Cursor getTextCursor(@NotNull Color backgroundColor) {
        return SystemInfo.isMac && ColorUtil.isDark(backgroundColor) ? MacUIUtil.getInvertedTextCursor() : Cursor.getPredefinedCursor(2);
    }

    @Nullable
    public static Cursor cursorIfNotDefault(@Nullable Cursor cursorToSet) {
        return cursorToSet != null && cursorToSet.getType() != 0 ? cursorToSet : null;
    }

    @NotNull
    public static RGBImageFilter getGrayFilter() {
        return GrayFilter.namedFilter("grayFilter", new GrayFilter(33, -35, 100));
    }

    @NotNull
    public static RGBImageFilter getTextGrayFilter() {
        return GrayFilter.namedFilter("text.grayFilter", new GrayFilter(20, 0, 100));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isAppleRetina() {
        return false;
    }

    @NotNull
    public static Couple<Color> getCellColors(@NotNull JTable table, boolean isSel, int row, int column) {
        return Couple.of((Object)(isSel ? table.getSelectionForeground() : table.getForeground()), (Object)(isSel ? table.getSelectionBackground() : table.getBackground()));
    }

    public static void fixOSXEditorBackground(@NotNull JTable table) {
        if (!SystemInfo.isMac) {
            return;
        }
        if (table.isEditing()) {
            int column = table.getEditingColumn();
            int row = table.getEditingRow();
            Component renderer = column >= 0 && row >= 0 ? table.getCellRenderer(row, column).getTableCellRendererComponent(table, table.getValueAt(row, column), true, table.hasFocus(), row, column) : null;
            Component component = table.getEditorComponent();
            if (component != null && renderer != null) {
                UIUtil.changeBackGround(component, renderer.getBackground());
            }
        }
    }

    private UIUtil() {
    }

    public static boolean isRetina(@NotNull Graphics2D graphics) {
        return SystemInfo.isMac ? DetectRetinaKit.isMacRetina(graphics) : UIUtil.isRetina();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRetina() {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        if ("true".equalsIgnoreCase(System.getProperty("is.hidpi"))) {
            return true;
        }
        if (Registry.is((String)"new.retina.detection", (boolean)false)) {
            return DetectRetinaKit.isRetina();
        }
        Ref<Boolean> ref = ourRetina;
        synchronized (ref) {
            if (ourRetina.isNull()) {
                ourRetina.set((Object)false);
                try {
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice device = env.getDefaultScreenDevice();
                    Integer scale = (Integer)ReflectionUtil.getField(device.getClass(), (Object)device, Integer.TYPE, (String)"scale");
                    if (scale != null && scale == 2) {
                        ourRetina.set((Object)true);
                        return true;
                    }
                }
                catch (AWTError | Exception throwable) {
                    // empty catch block
                }
                ourRetina.set((Object)false);
            }
            return (Boolean)ourRetina.get();
        }
    }

    public static boolean isWindowClientPropertyTrue(Window window, @NotNull Object key) {
        return Boolean.TRUE.equals(UIUtil.getWindowClientProperty(window, key));
    }

    public static Object getWindowClientProperty(Window window, @NotNull Object key) {
        JRootPane pane;
        if (window instanceof RootPaneContainer && (pane = ((RootPaneContainer)((Object)window)).getRootPane()) != null) {
            return pane.getClientProperty(key);
        }
        return null;
    }

    public static void putWindowClientProperty(Window window, @NotNull Object key, Object value) {
        JRootPane pane;
        if (window instanceof RootPaneContainer && (pane = ((RootPaneContainer)((Object)window)).getRootPane()) != null) {
            pane.putClientProperty(key, value);
        }
    }

    public static boolean isClientPropertyTrue(Object component, @NotNull Object key) {
        return Boolean.TRUE.equals(UIUtil.getClientProperty(component, key));
    }

    public static Object getClientProperty(Object component, @NotNull Object key) {
        return component instanceof JComponent ? ((JComponent)component).getClientProperty(key) : null;
    }

    public static <T> T getClientProperty(Object component, @NotNull Class<T> type) {
        return (T)ObjectUtils.tryCast((Object)UIUtil.getClientProperty(component, type), type);
    }

    public static <T> T getClientProperty(Object component, @NotNull Key<T> key) {
        return (T)UIUtil.getClientProperty(component, key);
    }

    public static <T> void putClientProperty(@NotNull JComponent component, @NotNull Key<T> key, T value) {
        ComponentUtil.putClientProperty(component, key, value);
    }

    @NotNull
    public static String getHtmlBody(@NotNull String text) {
        int bodyIndex;
        int htmlIndex = 6 + text.indexOf("<html>");
        if (htmlIndex < 6) {
            return text.replaceAll("\n", "<br>");
        }
        int htmlCloseIndex = text.indexOf("</html>", htmlIndex);
        if (htmlCloseIndex < 0) {
            htmlCloseIndex = text.length();
        }
        if ((bodyIndex = 6 + text.indexOf("<body>", htmlIndex)) < 6) {
            return text.substring(htmlIndex, htmlCloseIndex);
        }
        int bodyCloseIndex = text.indexOf("</body>", bodyIndex);
        if (bodyCloseIndex < 0) {
            bodyCloseIndex = text.length();
        }
        return text.substring(bodyIndex, Math.min(bodyCloseIndex, htmlCloseIndex));
    }

    @NotNull
    public static String getHtmlBody(@NotNull Html html) {
        String result = UIUtil.getHtmlBody(html.getText());
        return html.isKeepFont() ? result : result.replaceAll("<font(.*?)>", "").replaceAll("</font>", "");
    }

    public static void drawLinePickedOut(@NotNull Graphics graphics, int x, int y, int x1, int y1) {
        if (x == x1) {
            int minY = Math.min(y, y1);
            int maxY = Math.max(y, y1);
            LinePainter2D.paint((Graphics2D)graphics, x, minY + 1, (double)x1, maxY - 1);
        } else if (y == y1) {
            int minX = Math.min(x, x1);
            int maxX = Math.max(x, x1);
            LinePainter2D.paint((Graphics2D)graphics, minX + 1, y, (double)(maxX - 1), y1);
        } else {
            LinePainter2D.paint((Graphics2D)graphics, x, y, (double)x1, y1);
        }
    }

    public static boolean isReallyTypedEvent(@NotNull KeyEvent e) {
        char c = e.getKeyChar();
        if (c == '\uffff') {
            return false;
        }
        if (c < ' ' || c == '\u007f') {
            return false;
        }
        if (SystemInfo.isWindows && c >= '\u200c' && c <= '\u200f') {
            return true;
        }
        if (SystemInfo.isMac) {
            return !e.isMetaDown() && !e.isControlDown();
        }
        return !e.isAltDown() && !e.isControlDown();
    }

    public static int getStringY(@NotNull String string, @NotNull Rectangle bounds, @NotNull Graphics2D g) {
        int centerY = bounds.height / 2;
        Font font = g.getFont();
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle stringBounds = font.getStringBounds(string.isEmpty() ? " " : string, frc).getBounds();
        return (int)((double)centerY - (double)stringBounds.height / 2.0 - (double)stringBounds.y);
    }

    public static void drawLabelDottedRectangle(@NotNull JLabel label, @NotNull Graphics g) {
        UIUtil.drawLabelDottedRectangle(label, g, null);
    }

    public static void drawLabelDottedRectangle(@NotNull JLabel label, @NotNull Graphics g, @Nullable Rectangle bounds) {
        if (bounds == null) {
            bounds = UIUtil.getLabelTextBounds(label);
        }
        FontMetrics fm = label.getFontMetrics(label.getFont());
        int baseLine = label.getUI().getBaseline(label, label.getWidth(), label.getHeight());
        int textY = baseLine - fm.getLeading() - fm.getAscent();
        int textHeight = fm.getHeight();
        UIUtil.drawDottedRectangle(g, bounds.x, textY, bounds.x + bounds.width - 1, textY + textHeight - 1);
    }

    @NotNull
    public static Rectangle getLabelTextBounds(@NotNull JLabel label) {
        Dimension size = label.getPreferredSize();
        Icon icon = label.getIcon();
        Point point = new Point(0, 0);
        Insets insets = label.getInsets();
        if (icon != null) {
            if (label.getHorizontalTextPosition() == 11) {
                point.x += label.getIconTextGap();
                point.x += icon.getIconWidth();
            } else if (label.getHorizontalTextPosition() == 10) {
                size.width -= icon.getIconWidth();
            }
        }
        point.x += insets.left;
        point.y += insets.top;
        size.width -= point.x;
        size.width -= insets.right;
        size.height -= insets.bottom;
        return new Rectangle(point, size);
    }

    public static int getHighestGlyphHeight(@NotNull String string, @NotNull Font font, @NotNull Graphics graphics) {
        FontRenderContext frc = ((Graphics2D)graphics).getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, string);
        int maxHeight = 0;
        for (int i = 0; i < string.length(); ++i) {
            maxHeight = Math.max(maxHeight, (int)gv.getGlyphMetrics(i).getBounds2D().getHeight());
        }
        return maxHeight;
    }

    public static void setEnabled(@NotNull Component component, boolean enabled, boolean recursively) {
        UIUtil.setEnabled(component, enabled, recursively, false);
    }

    public static void setEnabled(@NotNull Component component, boolean enabled, boolean recursively, boolean visibleOnly) {
        JBIterable all = recursively ? ((JBTreeTraverser)UIUtil.uiTraverser(component).expandAndFilter(visibleOnly ? Component::isVisible : Conditions.alwaysTrue())).traverse() : JBIterable.of((Object)component);
        Color fg = enabled ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground();
        for (Component c : all) {
            c.setEnabled(enabled);
            if (!(c instanceof JLabel)) continue;
            c.setForeground(fg);
        }
    }

    @Deprecated
    public static void drawLine(@NotNull Graphics g, int x1, int y1, int x2, int y2) {
        LinePainter2D.paint((Graphics2D)g, x1, y1, (double)x2, y2);
    }

    public static void drawLine(@NotNull Graphics2D g, int x1, int y1, int x2, int y2, @Nullable Color bgColor, @Nullable Color fgColor) {
        Color oldFg = g.getColor();
        Color oldBg = g.getBackground();
        if (fgColor != null) {
            g.setColor(fgColor);
        }
        if (bgColor != null) {
            g.setBackground(bgColor);
        }
        LinePainter2D.paint(g, x1, y1, (double)x2, y2);
        if (fgColor != null) {
            g.setColor(oldFg);
        }
        if (bgColor != null) {
            g.setBackground(oldBg);
        }
    }

    public static void drawWave(@NotNull Graphics2D g, @NotNull Rectangle rectangle) {
        WavePainter.forColor(g.getColor()).paint(g, (int)rectangle.getMinX(), (int)rectangle.getMaxX(), (int)rectangle.getMaxY());
    }

    public static String @NotNull [] splitText(@NotNull String text, @NotNull FontMetrics fontMetrics, int widthLimit, char separator) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        StringBuilder currentAtom = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String s;
            int width;
            char ch = text.charAt(i);
            currentAtom.append(ch);
            if (ch == separator) {
                currentLine.append((CharSequence)currentAtom);
                currentAtom.setLength(0);
            }
            if ((width = fontMetrics.stringWidth(s = currentLine.toString() + currentAtom)) < widthLimit - fontMetrics.charWidth('w')) continue;
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder();
                continue;
            }
            lines.add(currentAtom.toString());
            currentAtom.setLength(0);
        }
        String s = currentLine.toString() + currentAtom;
        if (!s.isEmpty()) {
            lines.add(s);
        }
        return ArrayUtilRt.toStringArray(lines);
    }

    public static void setActionNameAndMnemonic(@NotNull String text, @NotNull Action action) {
        UIUtil.assignMnemonic(text, action);
        text = text.replaceAll("&", "");
        action.putValue("Name", text);
    }

    public static void assignMnemonic(@NotNull String text, @NotNull Action action) {
        String mnemoChar;
        int mnemoPos = text.indexOf(38);
        if (mnemoPos >= 0 && mnemoPos < text.length() - 2 && (mnemoChar = text.substring(mnemoPos + 1, mnemoPos + 2).trim()).length() == 1) {
            action.putValue("MnemonicKey", mnemoChar.charAt(0));
        }
    }

    @NotNull
    public static Font getLabelFont(@NotNull FontSize size) {
        return UIUtil.getFont(size, null);
    }

    @NotNull
    public static Font getFont(@NotNull FontSize size, @Nullable Font base) {
        if (base == null) {
            base = StartupUiUtil.getLabelFont();
        }
        return base.deriveFont(UIUtil.getFontSize(size));
    }

    public static float getFontSize(@NotNull FontSize size) {
        int defSize = StartupUiUtil.getLabelFont().getSize();
        switch (size) {
            case SMALL: {
                return Math.max((float)defSize - JBUIScale.scale(2.0f), JBUIScale.scale(11.0f));
            }
            case MINI: {
                return Math.max((float)defSize - JBUIScale.scale(4.0f), JBUIScale.scale(9.0f));
            }
        }
        return defSize;
    }

    @NotNull
    public static Color getLabelFontColor(@NotNull FontColor fontColor) {
        Color defColor = UIUtil.getLabelForeground();
        if (fontColor == FontColor.BRIGHTER) {
            return new JBColor(new Color(Math.min(defColor.getRed() + 50, 255), Math.min(defColor.getGreen() + 50, 255), Math.min(defColor.getBlue() + 50, 255)), defColor.darker());
        }
        return defColor;
    }

    public static int getCheckBoxTextHorizontalOffset(@NotNull JCheckBox cb) {
        ButtonUI ui = cb.getUI();
        String text = cb.getText();
        Icon buttonIcon = cb.getIcon();
        if (buttonIcon == null && ui != null && ui instanceof BasicRadioButtonUI) {
            buttonIcon = ((BasicRadioButtonUI)ui).getDefaultIcon();
        }
        Dimension size = new Dimension();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = cb.getInsets();
        size = cb.getSize(size);
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = size.width - (i.right + viewRect.x);
        viewRect.height = size.height - (i.bottom + viewRect.y);
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        SwingUtilities.layoutCompoundLabel(cb, cb.getFontMetrics(cb.getFont()), text, buttonIcon, cb.getVerticalAlignment(), cb.getHorizontalAlignment(), cb.getVerticalTextPosition(), cb.getHorizontalTextPosition(), viewRect, iconRect, textRect, text == null ? 0 : cb.getIconTextGap());
        return textRect.x;
    }

    public static int getScrollBarWidth() {
        return UIManager.getInt("ScrollBar.width");
    }

    public static Color getLabelBackground() {
        return UIManager.getColor("Label.background");
    }

    @NotNull
    public static Color getLabelForeground() {
        return JBColor.namedColor("Label.foreground", new JBColor(Gray._0, Gray.xBB));
    }

    public static Color getErrorForeground() {
        return JBColor.namedColor("Label.errorForeground", new JBColor(new Color(13050413), JBColor.RED));
    }

    @NotNull
    public static Color getLabelDisabledForeground() {
        return JBColor.namedColor("Label.disabledForeground", JBColor.GRAY);
    }

    @NotNull
    public static Color getContextHelpForeground() {
        return JBColor.namedColor("Label.infoForeground", new JBColor(Gray.x78, Gray.x8C));
    }

    @NotNull
    public static String removeMnemonic(@NotNull String s) {
        if (s.indexOf(38) != -1) {
            s = StringUtil.replace((String)s, (String)"&", (String)"");
        }
        if (s.indexOf(95) != -1) {
            s = StringUtil.replace((String)s, (String)"_", (String)"");
        }
        if (s.indexOf(27) != -1) {
            s = StringUtil.replace((String)s, (String)String.valueOf('\u001b'), (String)"");
        }
        return s;
    }

    public static int getDisplayMnemonicIndex(@NotNull String s) {
        int idx = s.indexOf(38);
        if (idx >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(38)) {
            return idx;
        }
        idx = s.indexOf(27);
        if (idx >= 0 && idx != s.length() - 1 && idx == s.lastIndexOf(27)) {
            return idx;
        }
        return -1;
    }

    public static String replaceMnemonicAmpersand(String value) {
        return BundleBase.replaceMnemonicAmpersand((String)value);
    }

    @Deprecated
    @NotNull
    public static Color getTreeTextForeground() {
        return UIUtil.getTreeForeground();
    }

    @Deprecated
    @NotNull
    public static Color getTreeTextBackground() {
        return UIUtil.getTreeBackground();
    }

    public static Color getFieldForegroundColor() {
        return UIManager.getColor("field.foreground");
    }

    public static Color getActiveTextColor() {
        return UIManager.getColor("textActiveText");
    }

    @NotNull
    public static Color getInactiveTextColor() {
        return JBColor.namedColor("Component.infoForeground", new JBColor(Gray.x99, Gray.x78));
    }

    @Deprecated
    public static Color getActiveTextFieldBackgroundColor() {
        return UIUtil.getTextFieldBackground();
    }

    public static Color getInactiveTextFieldBackgroundColor() {
        return UIManager.getColor("TextField.inactiveBackground");
    }

    @Deprecated
    @NotNull
    public static Color getTextInactiveTextColor() {
        return UIUtil.getInactiveTextColor();
    }

    public static Color getTreeSelectionBorderColor() {
        return UIManager.getColor("Tree.selectionBorderColor");
    }

    public static int getTreeRightChildIndent() {
        return UIManager.getInt("Tree.rightChildIndent");
    }

    public static int getTreeLeftChildIndent() {
        return UIManager.getInt("Tree.leftChildIndent");
    }

    @NotNull
    public static Color getToolTipBackground() {
        return JBColor.namedColor("ToolTip.background", new JBColor(Gray.xF2, new Color(3948353)));
    }

    @NotNull
    public static Color getToolTipActionBackground() {
        return JBColor.namedColor("ToolTip.Actions.background", new JBColor(Gray.xEB, new Color(4409162)));
    }

    @NotNull
    public static Color getToolTipForeground() {
        return JBColor.namedColor("ToolTip.foreground", new JBColor(Gray.x00, Gray.xBF));
    }

    public static Color getComboBoxDisabledForeground() {
        return UIManager.getColor("ComboBox.disabledForeground");
    }

    public static Color getComboBoxDisabledBackground() {
        return UIManager.getColor("ComboBox.disabledBackground");
    }

    public static Color getButtonSelectColor() {
        return UIManager.getColor("Button.select");
    }

    public static Integer getPropertyMaxGutterIconWidth(@NotNull String propertyPrefix) {
        return (Integer)UIManager.get(propertyPrefix + ".maxGutterIconWidth");
    }

    public static Color getMenuItemDisabledForeground() {
        return UIManager.getColor("MenuItem.disabledForeground");
    }

    public static Object getMenuItemDisabledForegroundObject() {
        return UIManager.get("MenuItem.disabledForeground");
    }

    public static Object getTabbedPanePaintContentBorder(@NotNull JComponent c) {
        return c.getClientProperty("TabbedPane.paintContentBorder");
    }

    public static Color getTableGridColor() {
        return UIManager.getColor("Table.gridColor");
    }

    @NotNull
    public static Color getPanelBackground() {
        return JBColor.PanelBackground;
    }

    public static Color getEditorPaneBackground() {
        return UIManager.getColor("EditorPane.background");
    }

    public static Color getTableFocusCellBackground() {
        return UIManager.getColor(TABLE_FOCUS_CELL_BACKGROUND_PROPERTY);
    }

    public static Color getTextFieldForeground() {
        return UIManager.getColor("TextField.foreground");
    }

    public static Color getTextFieldBackground() {
        return UIManager.getColor("TextField.background");
    }

    public static Font getButtonFont() {
        return UIManager.getFont("Button.font");
    }

    public static Font getToolTipFont() {
        return UIManager.getFont("ToolTip.font");
    }

    public static void setSliderIsFilled(@NotNull JSlider slider, boolean value) {
        slider.putClientProperty(JSLIDER_ISFILLED, value);
    }

    public static Color getLabelTextForeground() {
        return UIManager.getColor("Label.textForeground");
    }

    public static Color getControlColor() {
        return UIManager.getColor("control");
    }

    public static Font getOptionPaneMessageFont() {
        return UIManager.getFont("OptionPane.messageFont");
    }

    public static Font getMenuFont() {
        return UIManager.getFont("Menu.font");
    }

    @Deprecated
    @NotNull
    public static Color getSeparatorForeground() {
        return JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
    }

    public static Color getSeparatorShadow() {
        return UIManager.getColor("Separator.shadow");
    }

    @Deprecated
    public static Color getSeparatorHighlight() {
        return UIManager.getColor("Separator.highlight");
    }

    @Deprecated
    @NotNull
    public static Color getSeparatorColor() {
        return JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
    }

    public static Border getTableFocusCellHighlightBorder() {
        return UIManager.getBorder("Table.focusCellHighlightBorder");
    }

    @Deprecated
    public static void setLineStyleAngled(@NotNull JTree component) {
    }

    public static Color getTableFocusCellForeground() {
        return UIManager.getColor("Table.focusCellForeground");
    }

    public static Border getTextFieldBorder() {
        return UIManager.getBorder("TextField.border");
    }

    @NotNull
    public static Icon getErrorIcon() {
        return (Icon)ObjectUtils.notNull((Object)UIManager.getIcon("OptionPane.errorIcon"), (Object)AllIcons.General.ErrorDialog);
    }

    @NotNull
    public static Icon getInformationIcon() {
        return (Icon)ObjectUtils.notNull((Object)UIManager.getIcon("OptionPane.informationIcon"), (Object)AllIcons.General.InformationDialog);
    }

    @NotNull
    public static Icon getQuestionIcon() {
        return (Icon)ObjectUtils.notNull((Object)UIManager.getIcon("OptionPane.questionIcon"), (Object)AllIcons.General.QuestionDialog);
    }

    @NotNull
    public static Icon getWarningIcon() {
        return (Icon)ObjectUtils.notNull((Object)UIManager.getIcon("OptionPane.warningIcon"), (Object)AllIcons.General.WarningDialog);
    }

    @NotNull
    public static Icon getBalloonInformationIcon() {
        return AllIcons.General.BalloonInformation;
    }

    @NotNull
    public static Icon getBalloonWarningIcon() {
        return AllIcons.General.BalloonWarning;
    }

    @NotNull
    public static Icon getBalloonErrorIcon() {
        return AllIcons.General.BalloonError;
    }

    @Deprecated
    public static Icon getRadioButtonIcon() {
        return UIManager.getIcon("RadioButton.icon");
    }

    @NotNull
    public static Icon getTreeNodeIcon(boolean expanded, boolean selected, boolean focused) {
        boolean white = selected && focused || StartupUiUtil.isUnderDarcula();
        Icon expandedDefault = UIUtil.getTreeExpandedIcon();
        Icon collapsedDefault = UIUtil.getTreeCollapsedIcon();
        Icon expandedSelected = UIUtil.getTreeSelectedExpandedIcon();
        Icon collapsedSelected = UIUtil.getTreeSelectedCollapsedIcon();
        int width = Math.max(Math.max(expandedDefault.getIconWidth(), collapsedDefault.getIconWidth()), Math.max(expandedSelected.getIconWidth(), collapsedSelected.getIconWidth()));
        int height = Math.max(Math.max(expandedDefault.getIconHeight(), collapsedDefault.getIconHeight()), Math.max(expandedSelected.getIconHeight(), collapsedSelected.getIconHeight()));
        return new CenteredIcon(!white ? (expanded ? expandedDefault : collapsedDefault) : (expanded ? expandedSelected : collapsedSelected), width, height, false);
    }

    @NotNull
    public static Icon getTreeCollapsedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    @NotNull
    public static Icon getTreeExpandedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    @Deprecated
    public static Icon getTreeIcon(boolean expanded) {
        return expanded ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon();
    }

    @NotNull
    public static Icon getTreeSelectedCollapsedIcon() {
        Icon icon = UIManager.getIcon("Tree.collapsedSelectedIcon");
        return icon != null ? icon : UIUtil.getTreeCollapsedIcon();
    }

    @NotNull
    public static Icon getTreeSelectedExpandedIcon() {
        Icon icon = UIManager.getIcon("Tree.expandedSelectedIcon");
        return icon != null ? icon : UIUtil.getTreeExpandedIcon();
    }

    @Deprecated
    public static Border getTableHeaderCellBorder() {
        return UIManager.getBorder("TableHeader.cellBorder");
    }

    public static Color getWindowColor() {
        return UIManager.getColor("window");
    }

    public static Color getTextAreaForeground() {
        return UIManager.getColor("TextArea.foreground");
    }

    public static Color getOptionPaneBackground() {
        return UIManager.getColor("OptionPane.background");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isUnderAquaLookAndFeel() {
        return SystemInfo.isMac && UIManager.getLookAndFeel().getName().contains("Mac OS X");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isUnderNimbusLookAndFeel() {
        return false;
    }

    public static boolean isUnderAquaBasedLookAndFeel() {
        return SystemInfo.isMac && (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF());
    }

    public static boolean isUnderDefaultMacTheme() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (SystemInfo.isMac && lookAndFeel instanceof UserDataHolder) {
            UserDataHolder dh = (UserDataHolder)lookAndFeel;
            return Boolean.TRUE != dh.getUserData(LAF_WITH_THEME_KEY) && StringUtil.equals((CharSequence)((CharSequence)dh.getUserData(PLUGGABLE_LAF_KEY)), (CharSequence)"macOS Light");
        }
        return false;
    }

    public static boolean isUnderWin10LookAndFeel() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (SystemInfo.isWindows && lookAndFeel instanceof UserDataHolder) {
            UserDataHolder dh = (UserDataHolder)lookAndFeel;
            return Boolean.TRUE != dh.getUserData(LAF_WITH_THEME_KEY) && StringUtil.equals((CharSequence)((CharSequence)dh.getUserData(PLUGGABLE_LAF_KEY)), (CharSequence)"Windows 10 Light");
        }
        return false;
    }

    public static boolean isUnderDarcula() {
        return StartupUiUtil.isUnderDarcula();
    }

    public static boolean isUnderIntelliJLaF() {
        return UIManager.getLookAndFeel().getName().contains("IntelliJ") || UIUtil.isUnderDefaultMacTheme() || UIUtil.isUnderWin10LookAndFeel();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isUnderGTKLookAndFeel() {
        return SystemInfo.isXWindow && UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static boolean isGraphite() {
        if (!SystemInfo.isMac) {
            return false;
        }
        try {
            return Foundation.invoke("NSColor", "currentControlTint", new Object[0]).intValue() == 6;
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public static Font getToolbarFont() {
        return SystemInfo.isMac ? UIUtil.getLabelFont(FontSize.SMALL) : StartupUiUtil.getLabelFont();
    }

    @NotNull
    public static Color shade(@NotNull Color c, double factor, double alphaFactor) {
        assert (factor >= 0.0) : factor;
        return new Color(Math.min((int)Math.round((double)c.getRed() * factor), 255), Math.min((int)Math.round((double)c.getGreen() * factor), 255), Math.min((int)Math.round((double)c.getBlue() * factor), 255), Math.min((int)Math.round((double)c.getAlpha() * alphaFactor), 255));
    }

    @NotNull
    public static Color mix(@NotNull Color c1, Color c2, double factor) {
        assert (0.0 <= factor && factor <= 1.0) : factor;
        double backFactor = 1.0 - factor;
        return new Color(Math.min((int)Math.round((double)c1.getRed() * backFactor + (double)c2.getRed() * factor), 255), Math.min((int)Math.round((double)c1.getGreen() * backFactor + (double)c2.getGreen() * factor), 255), Math.min((int)Math.round((double)c1.getBlue() * backFactor + (double)c2.getBlue() * factor), 255));
    }

    public static boolean isFullRowSelectionLAF() {
        return false;
    }

    public static boolean isUnderNativeMacLookAndFeel() {
        return StartupUiUtil.isUnderDarcula();
    }

    public static int getListCellHPadding() {
        return UIUtil.isUnderDefaultMacTheme() ? 8 : (UIUtil.isUnderWin10LookAndFeel() ? 2 : 7);
    }

    public static int getListCellVPadding() {
        return 1;
    }

    @NotNull
    public static JBInsets getRegularPanelInsets() {
        return JBInsets.create(8, 12);
    }

    @NotNull
    public static Insets getListCellPadding() {
        return JBInsets.create(UIUtil.getListCellVPadding(), UIUtil.getListCellHPadding());
    }

    @NotNull
    public static Insets getListViewportPadding() {
        return UIUtil.isUnderNativeMacLookAndFeel() ? JBInsets.create(1, 0) : JBUI.emptyInsets();
    }

    public static boolean isToUseDottedCellBorder() {
        return !UIUtil.isUnderNativeMacLookAndFeel();
    }

    public static boolean isControlKeyDown(@NotNull MouseEvent mouseEvent) {
        return SystemInfo.isMac ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
    }

    public static String @NotNull [] getValidFontNames(boolean familyName) {
        TreeSet<String> result = new TreeSet<String>();
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            try {
                if (!FontUtil.isValidFont(font)) continue;
                result.add(familyName ? font.getFamily() : font.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Font labelFont = StartupUiUtil.getLabelFont();
        if (labelFont != null && FontUtil.isValidFont(labelFont)) {
            result.add(familyName ? labelFont.getFamily() : labelFont.getName());
        }
        return ArrayUtilRt.toStringArray(result);
    }

    public static String @NotNull [] getStandardFontSizes() {
        return STANDARD_FONT_SIZES;
    }

    public static void setupEnclosingDialogBounds(@NotNull JComponent component) {
        component.revalidate();
        component.repaint();
        Window window = SwingUtilities.windowForComponent(component);
        if (window != null && (window.getSize().height < window.getMinimumSize().height || window.getSize().width < window.getMinimumSize().width)) {
            window.pack();
        }
    }

    @NotNull
    public static String displayPropertiesToCSS(Font font, Color fg) {
        StringBuilder rule = new StringBuilder("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule.append(" color: #");
            UIUtil.appendColor(fg, rule);
            rule.append(" ; ");
        }
        rule.append(" }");
        return rule.toString();
    }

    public static void appendColor(@NotNull Color color, @NotNull StringBuilder sb) {
        if (color.getRed() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getRed()));
        if (color.getGreen() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getGreen()));
        if (color.getBlue() < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color.getBlue()));
    }

    public static void drawDottedRectangle(@NotNull Graphics g, @NotNull Rectangle r) {
        UIUtil.drawDottedRectangle(g, r.x, r.y, r.x + r.width, r.y + r.height);
    }

    public static void drawDottedRectangle(@NotNull Graphics g, int x, int y, int x1, int y1) {
        int i1;
        for (i1 = x; i1 <= x1; i1 += 2) {
            LinePainter2D.paint((Graphics2D)g, i1, y, (double)i1, y);
        }
        for (i1 = y + (i1 != x1 + 1 ? 2 : 1); i1 <= y1; i1 += 2) {
            LinePainter2D.paint((Graphics2D)g, x1, i1, (double)x1, i1);
        }
        for (i1 = x1 - (i1 != y1 + 1 ? 2 : 1); i1 >= x; i1 -= 2) {
            LinePainter2D.paint((Graphics2D)g, i1, y1, (double)i1, y1);
        }
        for (i1 = y1 - (i1 != x - 1 ? 2 : 1); i1 >= y; i1 -= 2) {
            LinePainter2D.paint((Graphics2D)g, x, i1, (double)x, i1);
        }
    }

    public static void drawBoldDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        if (SystemInfo.isMac && !UIUtil.isRetina() || SystemInfo.isLinux) {
            UIUtil.drawAppleDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        } else {
            UIUtil.drawBoringDottedLine(g, startX, endX, lineY, bgColor, fgColor, opaque);
        }
    }

    public static void drawSearchMatch(@NotNull Graphics2D g, float startX, float endX, int height) {
        JBColor c1 = JBColor.namedColor("SearchMatch.startBackground", JBColor.namedColor("SearchMatch.startColor", 16771746));
        JBColor c2 = JBColor.namedColor("SearchMatch.endBackground", JBColor.namedColor("SearchMatch.endColor", 16764994));
        UIUtil.drawSearchMatch(g, startX, endX, height, c1, c2);
    }

    public static void drawSearchMatch(@NotNull Graphics2D g, float startXf, float endXf, int height, Color c1, Color c2) {
        boolean drawRound;
        GraphicsConfig config = new GraphicsConfig(g);
        float alpha = (float)JBUI.getInt("SearchMatch.transparency", 70) / 100.0f;
        alpha = alpha < 0.0f || alpha > 1.0f ? 0.7f : alpha;
        g.setComposite(AlphaComposite.getInstance(3, alpha));
        g.setPaint(UIUtil.getGradientPaint(startXf, 2.0f, c1, startXf, height - 5, c2));
        if (JreHiDpiUtil.isJreHiDPI(g)) {
            GraphicsConfig c = GraphicsUtil.setupRoundedBorderAntialiasing(g);
            g.fill(new RoundRectangle2D.Float(startXf, 2.0f, endXf - startXf, height - 4, 5.0f, 5.0f));
            c.restore();
            config.restore();
            return;
        }
        int startX = (int)startXf;
        int endX = (int)endXf;
        g.fillRect(startX, 3, endX - startX, height - 5);
        boolean bl = drawRound = endXf - startXf > 4.0f;
        if (drawRound) {
            LinePainter2D.paint(g, startX - 1, 4.0, (double)(startX - 1), height - 4);
            LinePainter2D.paint(g, endX, 4.0, (double)endX, height - 4);
            g.setColor(new Color(100, 100, 100, 50));
            LinePainter2D.paint(g, startX - 1, 4.0, (double)(startX - 1), height - 4);
            LinePainter2D.paint(g, endX, 4.0, (double)endX, height - 4);
            LinePainter2D.paint(g, startX, 3.0, (double)(endX - 1), 3.0);
            LinePainter2D.paint(g, startX, height - 3, (double)(endX - 1), height - 3);
        }
        config.restore();
    }

    private static void drawBoringDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, startX, lineY, (double)endX, lineY);
            LinePainter2D.paint(g, startX, lineY + 1, (double)endX, lineY + 1);
        }
        int step = 4;
        int startPosCorrection = startX % 4 < 3 ? 0 : 1;
        g.setColor(fgColor != null ? fgColor : oldColor);
        for (int dotXi = (startX / 4 + startPosCorrection) * 4; dotXi < endX; dotXi += 4) {
            LinePainter2D.paint(g, dotXi, lineY, (double)(dotXi + 1), lineY);
            LinePainter2D.paint(g, dotXi, lineY + 1, (double)(dotXi + 1), lineY + 1);
        }
        g.setColor(oldColor);
    }

    public static void drawGradientHToolbarBackground(@NotNull Graphics g, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(UIUtil.getGradientPaint(0.0f, 0.0f, Gray._215, 0.0f, height, Gray._200));
        g2d.fillRect(0, 0, width, height);
    }

    public static void drawHeader(@NotNull Graphics g, int x, int width, int height, boolean active, boolean drawTopLine) {
        UIUtil.drawHeader(g, x, width, height, active, false, drawTopLine, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawHeader(@NotNull Graphics g, int x, int width, int height, boolean active, boolean toolWindow, boolean drawTopLine, boolean drawBottomLine) {
        GraphicsConfig config = GraphicsUtil.disableAAPainting(g);
        try {
            g.setColor(JBUI.CurrentTheme.ToolWindow.headerBackground(active));
            g.fillRect(x, 0, width, height);
            g.setColor(JBUI.CurrentTheme.ToolWindow.headerBorderBackground());
            if (drawTopLine) {
                LinePainter2D.paint((Graphics2D)g, x, 0.0, (double)width, 0.0);
            }
            if (drawBottomLine) {
                LinePainter2D.paint((Graphics2D)g, x, height - 1, (double)width, height - 1);
            }
        }
        finally {
            config.restore();
        }
    }

    public static void drawDoubleSpaceDottedLine(@NotNull Graphics2D g, int start, int end, int xOrY, Color fgColor, boolean horizontal) {
        g.setColor(fgColor);
        for (int dot = start; dot < end; dot += 3) {
            if (horizontal) {
                LinePainter2D.paint(g, dot, xOrY, (double)dot, xOrY);
                continue;
            }
            LinePainter2D.paint(g, xOrY, dot, (double)xOrY, dot);
        }
    }

    private static void drawAppleDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, Color bgColor, Color fgColor, boolean opaque) {
        Color oldColor = g.getColor();
        if (opaque && bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, startX, lineY, (double)endX, lineY);
            LinePainter2D.paint(g, startX, lineY + 1, (double)endX, lineY + 1);
            LinePainter2D.paint(g, startX, lineY + 2, (double)endX, lineY + 2);
        }
        AppleBoldDottedPainter painter = AppleBoldDottedPainter.forColor((Color)ObjectUtils.notNull((Object)fgColor, (Object)oldColor));
        painter.paint(g, startX, endX, lineY);
    }

    @Deprecated
    public static void applyRenderingHints(@NotNull Graphics g) {
        GraphicsUtil.applyRenderingHints((Graphics2D)g);
    }

    @Deprecated
    @NotNull
    public static BufferedImage createImage(int width, int height, int type) {
        return ImageUtil.createImage(width, height, type);
    }

    @Deprecated
    @NotNull
    public static BufferedImage createImage(@Nullable GraphicsConfiguration gc, int width, int height, int type) {
        return ImageUtil.createImage(gc, width, height, type);
    }

    @NotNull
    public static BufferedImage createImage(GraphicsConfiguration gc, double width, double height, int type, @NotNull PaintUtil.RoundingMode rm) {
        if (JreHiDpiUtil.isJreHiDPI(gc)) {
            return RetinaImage.create(gc, width, height, type, rm);
        }
        return new BufferedImage(rm.round(width), rm.round(height), type);
    }

    @NotNull
    public static BufferedImage createImage(ScaleContext ctx, double width, double height, int type, @NotNull PaintUtil.RoundingMode rm) {
        if (StartupUiUtil.isJreHiDPI(ctx)) {
            return RetinaImage.create(ctx, width, height, type, rm);
        }
        return new BufferedImage(rm.round(width), rm.round(height), type);
    }

    @Deprecated
    @NotNull
    public static BufferedImage createImage(Graphics g, int width, int height, int type) {
        return ImageUtil.createImage(g, width, height, type);
    }

    @Deprecated
    @NotNull
    public static BufferedImage createImage(Graphics g, double width, double height, int type, @NotNull PaintUtil.RoundingMode rm) {
        return ImageUtil.createImage(g, width, height, type, rm);
    }

    @NotNull
    public static BufferedImage createImage(Component comp, int width, int height, int type) {
        return comp != null ? ImageUtil.createImage(comp.getGraphicsConfiguration(), width, height, type) : ImageUtil.createImage(width, height, type);
    }

    @Deprecated
    @NotNull
    public static BufferedImage createImageForGraphics(Graphics2D g, int width, int height, int type) {
        return ImageUtil.createImage(g, width, height, type);
    }

    public static void setupComposite(@NotNull Graphics2D g) {
        g.setComposite((Boolean)X_RENDER_ACTIVE.getValue() != false ? AlphaComposite.SrcOver : AlphaComposite.Src);
    }

    public static void dispatchAllInvocationEvents() {
        AWTEvent event;
        assert (EdtInvocationManager.getInstance().isEventDispatchThread()) : Thread.currentThread() + "; EDT: " + UIUtil.getEventQueueThread();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Method dispatchEventMethod = Objects.requireNonNull(ReflectionUtil.getDeclaredMethod(eventQueue.getClass(), (String)"dispatchEvent", (Class[])new Class[]{AWTEvent.class}));
        int i = 1;
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                event = eventQueue.getNextEvent();
                if (event instanceof InvocationEvent) {
                    dispatchEventMethod.invoke((Object)eventQueue, event);
                }
            }
            catch (InvocationTargetException e) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)e.getCause());
            }
            catch (Exception e) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            if (i % 10000 == 0) {
                System.out.println("Suspiciously many (" + i + ") AWT events, last dispatched " + event);
            }
            ++i;
        }
    }

    @NotNull
    private static Thread getEventQueueThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            Method method = ReflectionUtil.getDeclaredMethod(EventQueue.class, (String)"getDispatchThread", (Class[])new Class[0]);
            return (Thread)method.invoke((Object)eventQueue, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addAwtListener(@NotNull AWTEventListener listener, long mask, @NotNull Disposable parent) {
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, mask);
        Disposer.register((Disposable)parent, () -> Toolkit.getDefaultToolkit().removeAWTEventListener(listener));
    }

    public static void addParentChangeListener(@NotNull Component component, @NotNull PropertyChangeListener listener) {
        component.addPropertyChangeListener("ancestor", listener);
    }

    public static void removeParentChangeListener(@NotNull Component component, @NotNull PropertyChangeListener listener) {
        component.removePropertyChangeListener("ancestor", listener);
    }

    public static void drawVDottedLine(@NotNull Graphics2D g, int lineX, int startY, int endY, @Nullable Color bgColor, Color fgColor) {
        if (bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, lineX, startY, (double)lineX, endY);
        }
        g.setColor(fgColor);
        for (int i = startY / 2 * 2; i < endY; i += 2) {
            g.drawRect(lineX, i, 0, 0);
        }
    }

    public static void drawHDottedLine(@NotNull Graphics2D g, int startX, int endX, int lineY, @Nullable Color bgColor, Color fgColor) {
        if (bgColor != null) {
            g.setColor(bgColor);
            LinePainter2D.paint(g, startX, lineY, (double)endX, lineY);
        }
        g.setColor(fgColor);
        for (int i = startX / 2 * 2; i < endX; i += 2) {
            g.drawRect(i, lineY, 0, 0);
        }
    }

    public static void drawDottedLine(@NotNull Graphics2D g, int x1, int y1, int x2, int y2, @Nullable Color bgColor, Color fgColor) {
        if (x1 == x2) {
            UIUtil.drawVDottedLine(g, x1, y1, y2, bgColor, fgColor);
        } else if (y1 == y2) {
            UIUtil.drawHDottedLine(g, x1, x2, y1, bgColor, fgColor);
        } else {
            throw new IllegalArgumentException("Only vertical or horizontal lines are supported");
        }
    }

    public static void drawStringWithHighlighting(@NotNull Graphics g, @NotNull String s, int x, int y, Color foreground, Color highlighting) {
        g.setColor(highlighting);
        boolean isRetina = JreHiDpiUtil.isJreHiDPI((Graphics2D)g);
        float scale = 1.0f / JBUIScale.sysScale((Graphics2D)g);
        for (float i = (float)(x - 1); i <= (float)(x + 1); i += isRetina ? scale : 1.0f) {
            for (float j = (float)(y - 1); j <= (float)(y + 1); j += isRetina ? scale : 1.0f) {
                ((Graphics2D)g).drawString(s, i, j);
            }
        }
        g.setColor(foreground);
        g.drawString(s, x, y);
    }

    public static void drawCenteredString(@NotNull Graphics2D g, @NotNull Rectangle rect, @NotNull String str, boolean horzCentered, boolean vertCentered) {
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int textWidth = fm.stringWidth(str) - 1;
        int x = horzCentered ? Math.max(rect.x, rect.x + (rect.width - textWidth) / 2) : rect.x;
        int y = vertCentered ? Math.max(rect.y, rect.y + rect.height / 2 + fm.getAscent() * 2 / 5) : rect.y;
        Shape oldClip = g.getClip();
        g.clip(rect);
        g.drawString(str, x, y);
        g.setClip(oldClip);
    }

    public static void drawCenteredString(@NotNull Graphics2D g, @NotNull Rectangle rect, @NotNull String str) {
        UIUtil.drawCenteredString(g, rect, str, true, true);
    }

    public static boolean isFocusAncestor(@NotNull Component component) {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return false;
        }
        if (owner == component) {
            return true;
        }
        return SwingUtilities.isDescendingFrom(owner, component);
    }

    public static boolean isCloseClick(@NotNull MouseEvent e) {
        return UIUtil.isCloseClick(e, 501);
    }

    public static boolean isCloseClick(@NotNull MouseEvent e, int effectiveType) {
        if (e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 2 || e.getButton() == 1 && e.isShiftDown();
    }

    public static boolean isActionClick(@NotNull MouseEvent e) {
        return UIUtil.isActionClick(e, 501);
    }

    public static boolean isActionClick(@NotNull MouseEvent e, int effectiveType) {
        return UIUtil.isActionClick(e, effectiveType, false);
    }

    public static boolean isActionClick(@NotNull MouseEvent e, int effectiveType, boolean allowShift) {
        if (!allowShift && UIUtil.isCloseClick(e) || e.isPopupTrigger() || e.getID() != effectiveType) {
            return false;
        }
        return e.getButton() == 1;
    }

    @NotNull
    public static Color getBgFillColor(@NotNull Component c) {
        Component parent = UIUtil.findNearestOpaque(c);
        return parent == null ? c.getBackground() : parent.getBackground();
    }

    @Nullable
    public static Component findNearestOpaque(Component c) {
        return ComponentUtil.findParentByCondition(c, Component::isOpaque);
    }

    @Deprecated
    public static Component findParentByCondition(@Nullable Component c, @NotNull Condition<? super Component> condition) {
        return ComponentUtil.findParentByCondition(c, (? super Component it) -> condition.value(it));
    }

    @Nullable
    public static Component getDeepestComponentAt(@NotNull Component parent, int x, int y) {
        Object[] components;
        JRootPane rootPane;
        Component component = SwingUtilities.getDeepestComponentAt(parent, x, y);
        if (component != null && component.getParent() instanceof JRootPane && (component = UIUtil.getDeepestComponentAtForComponent(parent, x, y, (rootPane = (JRootPane)component.getParent()).getLayeredPane())) == null) {
            component = UIUtil.getDeepestComponentAtForComponent(parent, x, y, rootPane.getContentPane());
        }
        if (component != null && component.getParent() instanceof JLayeredPane && (components = ((JLayeredPane)component.getParent()).getComponentsInLayer(JLayeredPane.DEFAULT_LAYER)).length == 1 && ArrayUtilRt.indexOf((Object[])components, (Object)component, (int)0, (int)components.length) == -1) {
            component = UIUtil.getDeepestComponentAtForComponent(parent, x, y, (Component)components[0]);
        }
        return component;
    }

    private static Component getDeepestComponentAtForComponent(@NotNull Component parent, int x, int y, @NotNull Component component) {
        Point point = SwingUtilities.convertPoint(parent, new Point(x, y), component);
        return SwingUtilities.getDeepestComponentAt(component, point.x, point.y);
    }

    public static void layoutRecursively(@NotNull Component component) {
        if (!(component instanceof JComponent)) {
            return;
        }
        UIUtil.forEachComponentInHierarchy(component, (Consumer<? super Component>)((Consumer)Component::doLayout));
    }

    @Language(value="HTML")
    @NotNull
    public static String getCssFontDeclaration(@NotNull Font font) {
        return UIUtil.getCssFontDeclaration(font, UIUtil.getLabelForeground(), JBUI.CurrentTheme.Link.linkColor(), null);
    }

    @Language(value="HTML")
    @NotNull
    public static String getCssFontDeclaration(@NotNull Font font, @Nullable Color fgColor, @Nullable Color linkColor, @Nullable String liImg) {
        String familyAndSize = "font-family:'" + font.getFamily() + "'; font-size:" + font.getSize() + "pt;";
        return "<style>\nbody, div, td, p {" + familyAndSize + (fgColor != null ? " color:#" + ColorUtil.toHex(fgColor) + ';' : "") + "}\na {" + familyAndSize + (linkColor != null ? " color:#" + ColorUtil.toHex(linkColor) + ';' : "") + "}\ncode {font-size:" + font.getSize() + "pt;}\nul {list-style:disc; margin-left:15px;}\n</style>";
    }

    @NotNull
    public static Color getFocusedFillColor() {
        return UIUtil.toAlpha(UIUtil.getListSelectionBackground(true), 100);
    }

    @NotNull
    public static Color getFocusedBoundsColor() {
        return UIUtil.getBoundsColor();
    }

    @NotNull
    public static Color getBoundsColor() {
        return JBColor.border();
    }

    @NotNull
    public static Color getBoundsColor(boolean focused) {
        return focused ? UIUtil.getFocusedBoundsColor() : UIUtil.getBoundsColor();
    }

    @NotNull
    public static Color toAlpha(Color color, int alpha) {
        Color actual = color != null ? color : Color.black;
        return new Color(actual.getRed(), actual.getGreen(), actual.getBlue(), alpha);
    }

    public static boolean isFocusable(@Nullable Component component) {
        return component != null && component.isFocusable() && component.isEnabled() && component.isShowing();
    }

    @Deprecated
    public static void requestFocus(@NotNull JComponent c) {
        if (c.isShowing()) {
            c.requestFocus();
        } else {
            SwingUtilities.invokeLater(c::requestFocus);
        }
    }

    public static boolean canDisplayFocusedState(@NotNull Component component) {
        return component instanceof JTextComponent || component instanceof AbstractButton || component instanceof JComboBox;
    }

    public static void dispose(Component c) {
        MouseWheelListener[] mouseWheelListeners;
        MouseMotionListener[] motionListeners;
        MouseListener[] mouseListeners;
        if (c == null) {
            return;
        }
        for (MouseListener each : mouseListeners = c.getMouseListeners()) {
            c.removeMouseListener(each);
        }
        for (MouseMotionListener each : motionListeners = c.getMouseMotionListeners()) {
            c.removeMouseMotionListener(each);
        }
        for (MouseWheelListener each : mouseWheelListeners = c.getMouseWheelListeners()) {
            c.removeMouseWheelListener(each);
        }
        if (c instanceof AbstractButton) {
            ActionListener[] listeners;
            for (ActionListener listener : listeners = ((AbstractButton)c).getActionListeners()) {
                ((AbstractButton)c).removeActionListener(listener);
            }
        }
    }

    public static void disposeProgress(@NotNull JProgressBar progress) {
        if (!UIUtil.isUnderNativeMacLookAndFeel()) {
            return;
        }
        SwingUtilities.invokeLater(() -> progress.setUI(null));
    }

    @Nullable
    public static Component findUltimateParent(@Nullable Component c) {
        return c == null ? null : ComponentUtil.findUltimateParent(c);
    }

    @NotNull
    public static Color getHeaderActiveColor() {
        return ACTIVE_HEADER_COLOR;
    }

    @NotNull
    public static Color getFocusedBorderColor() {
        return JBUI.CurrentTheme.Focus.focusColor();
    }

    @NotNull
    public static Color getHeaderInactiveColor() {
        return INACTIVE_HEADER_COLOR;
    }

    @NotNull
    public static Font getTitledBorderFont() {
        return StartupUiUtil.getLabelFont();
    }

    @Deprecated
    @NotNull
    public static Color getBorderInactiveColor() {
        return JBColor.border();
    }

    @Deprecated
    @NotNull
    public static Color getBorderActiveColor() {
        return JBColor.border();
    }

    @Deprecated
    @NotNull
    public static Color getBorderSeparatorColor() {
        return JBColor.border();
    }

    @Nullable
    public static StyleSheet loadStyleSheet(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        try {
            StyleSheet styleSheet = new StyleSheet();
            styleSheet.loadRules(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8), url);
            return styleSheet;
        }
        catch (IOException e) {
            UIUtil.getLogger().warn(url + " loading failed", (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static HTMLEditorKit getHTMLEditorKit() {
        return UIUtil.getHTMLEditorKit(true);
    }

    @NotNull
    public static HTMLEditorKit getHTMLEditorKit(boolean noGapsBetweenParagraphs) {
        return new JBHtmlEditorKit(noGapsBetweenParagraphs);
    }

    @NotNull
    public static Font getFontWithFallbackIfNeeded(@NotNull Font font, @NotNull String text) {
        if (font.canDisplayUpTo(text) != -1) {
            return UIUtil.getFontWithFallback(font);
        }
        return font;
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@NotNull Font font) {
        return UIUtil.getFontWithFallback(font.getFamily(), font.getStyle(), font.getSize());
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@Nullable String familyName, @JdkConstants.FontStyle int style, int size) {
        Font fontWithFallback = SystemInfo.isMac ? new Font(familyName, style, size) : new StyleContext().getFont(familyName, style, size);
        return fontWithFallback instanceof FontUIResource ? (FontUIResource)fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public static <T> T htmlInjectionGuard(T toRender) {
        if (toRender instanceof String && StringUtil.toLowerCase((String)((String)toRender)).startsWith("<html>")) {
            return (T)("<html>" + StringUtil.escapeXmlEntities((String)((String)toRender)));
        }
        return toRender;
    }

    @Deprecated
    public static void removeScrollBorder(Component c) {
        JBIterable scrollPanes = ((JBTreeTraverser)UIUtil.uiTraverser(c).expand(o -> o == c || o instanceof JPanel || o instanceof JLayeredPane)).filter(JScrollPane.class);
        for (JScrollPane scrollPane : scrollPanes) {
            Integer keepBorderSides = ComponentUtil.getClientProperty(scrollPane, KEEP_BORDER_SIDES);
            if (keepBorderSides != null) {
                if (scrollPane.getBorder() instanceof LineBorder) {
                    Color color = ((LineBorder)scrollPane.getBorder()).getLineColor();
                    scrollPane.setBorder(new SideBorder(color, keepBorderSides));
                    continue;
                }
                scrollPane.setBorder(new SideBorder(UIUtil.getBoundsColor(), keepBorderSides));
                continue;
            }
            scrollPane.setBorder(new SideBorder(UIUtil.getBoundsColor(), 0));
        }
    }

    @NotNull
    public static String toHtml(@NotNull String html) {
        return UIUtil.toHtml(html, 0);
    }

    @NonNls
    @NotNull
    public static String toHtml(@NotNull String html, int hPadding) {
        html = CLOSE_TAG_PATTERN.matcher(html).replaceAll("<$1$2></$1>");
        Font font = StartupUiUtil.getLabelFont();
        String family = font != null ? font.getFamily() : "Tahoma";
        int size = font != null ? font.getSize() : JBUIScale.scale(11);
        return "<html><style>body { font-family: " + family + "; font-size: " + size + ";} ul li {list-style-type:circle;}</style>" + UIUtil.addPadding(html, hPadding) + "</html>";
    }

    @NotNull
    public static String addPadding(@NotNull String html, int hPadding) {
        return String.format("<p style=\"margin: 0 %dpx 0 %dpx;\">%s</p>", hPadding, hPadding, html);
    }

    @NotNull
    public static String convertSpace2Nbsp(@NotNull String html) {
        StringBuilder result = new StringBuilder();
        int braces = 0;
        for (int currentPos = 0; currentPos < html.length(); ++currentPos) {
            String each = html.substring(currentPos, currentPos + 1);
            if ("<".equals(each)) {
                ++braces;
            } else if (">".equals(each)) {
                --braces;
            }
            if (" ".equals(each) && braces == 0) {
                result.append("&nbsp;");
                continue;
            }
            result.append(each);
        }
        return result.toString();
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        EdtInvocationManager edtInvocationManager = EdtInvocationManager.getInstance();
        if (edtInvocationManager.isEventDispatchThread()) {
            runnable.run();
        } else {
            edtInvocationManager.invokeLater(runnable);
        }
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        EdtInvocationManager.getInstance().invokeAndWaitIfNeeded(runnable);
    }

    public static <T> T invokeAndWaitIfNeeded(@NotNull Computable<T> computable) {
        Ref result = Ref.create();
        UIUtil.invokeAndWaitIfNeeded(() -> result.set(computable.compute()));
        return (T)result.get();
    }

    public static void invokeAndWaitIfNeeded(@NotNull ThrowableRunnable<?> runnable) throws Throwable {
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            runnable.run();
        } else {
            Ref ref = Ref.create();
            EdtInvocationManager.getInstance().invokeAndWait(() -> {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    ref.set((Object)throwable);
                }
            });
            if (!ref.isNull()) {
                throw (Throwable)ref.get();
            }
        }
    }

    public static boolean isFocusProxy(@Nullable Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty(FOCUS_PROXY_KEY));
    }

    public static void maybeInstall(@NotNull InputMap map, String action, KeyStroke stroke) {
        if (map.get(stroke) == null) {
            map.put(stroke, action);
        }
    }

    public static void changeBackGround(@NotNull Component component, Color background) {
        Color oldBackGround = component.getBackground();
        if (background == null || !background.equals(oldBackGround)) {
            component.setBackground(background);
        }
    }

    @Nullable
    public static ComboPopup getComboBoxPopup(@NotNull JComboBox<?> comboBox) {
        ComboBoxUI ui = comboBox.getUI();
        if (ui instanceof BasicComboBoxUI) {
            return (ComboPopup)ReflectionUtil.getField(BasicComboBoxUI.class, (Object)ui, ComboPopup.class, (String)"popup");
        }
        return null;
    }

    public static void fixFormattedField(@NotNull JFormattedTextField field) {
        if (SystemInfo.isMac) {
            int commandKeyMask;
            try {
                commandKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            }
            catch (HeadlessException e) {
                return;
            }
            InputMap inputMap = field.getInputMap();
            KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, commandKeyMask);
            inputMap.put(copyKeyStroke, "copy-to-clipboard");
            KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, commandKeyMask);
            inputMap.put(pasteKeyStroke, "paste-from-clipboard");
            KeyStroke cutKeyStroke = KeyStroke.getKeyStroke(88, commandKeyMask);
            inputMap.put(cutKeyStroke, "cut-to-clipboard");
        }
    }

    public static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics || g instanceof PrinterGraphics;
    }

    public static int getSelectedButton(@NotNull ButtonGroup group) {
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (group.isSelected(button.getModel())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void setSelectedButton(@NotNull ButtonGroup group, int index) {
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            group.setSelected(button.getModel(), index == i);
            ++i;
        }
    }

    public static boolean isSelectionButtonDown(@NotNull MouseEvent e) {
        return e.isShiftDown() || e.isControlDown() || e.isMetaDown();
    }

    public static boolean isToggleListSelectionEvent(@NotNull MouseEvent e) {
        return SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown()) && !e.isPopupTrigger();
    }

    public static void setComboBoxEditorBounds(int x, int y, int width, int height, @NotNull JComponent editor) {
        editor.reshape(x, y, width, height);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static int fixComboBoxHeight(int height) {
        return height;
    }

    public static boolean isDescendingFrom(@Nullable Component child, @NotNull Component parent) {
        while (child != null && child != parent) {
            child = child instanceof JPopupMenu ? ((JPopupMenu)child).getInvoker() : child.getParent();
        }
        return child == parent;
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T getParentOfType(@NotNull Class<? extends T> type, Component component) {
        return ComponentUtil.getParentOfType(type, component);
    }

    @NotNull
    public static JBIterable<Component> uiParents(@Nullable Component c, boolean strict) {
        return strict ? JBIterable.generate((Object)c, c1 -> c1.getParent()).skip(1) : JBIterable.generate((Object)c, c1 -> c1.getParent());
    }

    @NotNull
    public static JBIterable<Component> uiChildren(@Nullable Component component) {
        if (!(component instanceof Container)) {
            return JBIterable.empty();
        }
        Container container = (Container)component;
        return JBIterable.of((Object[])container.getComponents());
    }

    @NotNull
    public static JBTreeTraverser<Component> uiTraverser(@Nullable Component component) {
        return (JBTreeTraverser)((JBTreeTraverser)UI_TRAVERSER.withRoot((Object)component)).expandAndFilter(o -> !(o instanceof CellRendererPane));
    }

    public static void scrollListToVisibleIfNeeded(@NotNull JList<?> list) {
        SwingUtilities.invokeLater(() -> {
            Rectangle cellBounds;
            Rectangle visibleRect;
            int selectedIndex = list.getSelectedIndex();
            if (selectedIndex >= 0 && !(visibleRect = list.getVisibleRect()).contains(cellBounds = list.getCellBounds(selectedIndex, selectedIndex))) {
                list.scrollRectToVisible(cellBounds);
            }
        });
    }

    @Nullable
    public static <T extends JComponent> T findComponentOfType(JComponent parent, Class<T> cls) {
        if (parent == null || cls.isInstance(parent)) {
            return (T)((JComponent)cls.cast(parent));
        }
        for (Component component : parent.getComponents()) {
            T comp;
            if (!(component instanceof JComponent) || (comp = UIUtil.findComponentOfType((JComponent)component, cls)) == null) continue;
            return comp;
        }
        return null;
    }

    @NotNull
    public static <T extends JComponent> List<T> findComponentsOfType(JComponent parent, @NotNull Class<? extends T> cls) {
        ArrayList result = new ArrayList();
        UIUtil.findComponentsOfType(parent, cls, result);
        return result;
    }

    private static <T extends JComponent> void findComponentsOfType(JComponent parent, @NotNull Class<T> cls, @NotNull List<? super T> result) {
        if (parent == null) {
            return;
        }
        if (cls.isAssignableFrom(parent.getClass())) {
            JComponent t = parent;
            result.add(t);
        }
        for (Component c : parent.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            UIUtil.findComponentsOfType((JComponent)c, cls, result);
        }
    }

    @Nullable
    public static JRootPane getRootPane(Component c) {
        JRootPane root = ComponentUtil.getParentOfType(JRootPane.class, c);
        if (root != null) {
            return root;
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            WeakReference pane;
            if (!(eachParent instanceof JComponent) || (pane = (WeakReference)((JComponent)eachParent).getClientProperty(ROOT_PANE)) == null) continue;
            return (JRootPane)pane.get();
        }
        return null;
    }

    public static void setFutureRootPane(@NotNull JComponent c, @NotNull JRootPane pane) {
        c.putClientProperty(ROOT_PANE, new WeakReference<JRootPane>(pane));
    }

    public static boolean isMeaninglessFocusOwner(@Nullable Component c) {
        if (c == null || !c.isShowing()) {
            return true;
        }
        return c instanceof JFrame || c instanceof JDialog || c instanceof JWindow || c instanceof JRootPane || UIUtil.isFocusProxy(c);
    }

    @Deprecated
    @NotNull
    public static Timer createNamedTimer(@NonNls @NotNull String name, int delay, @NotNull ActionListener listener) {
        return TimerUtil.createNamedTimer(name, delay, listener);
    }

    @Deprecated
    @NotNull
    public static Timer createNamedTimer(@NonNls @NotNull String name, int delay) {
        return TimerUtil.createNamedTimer(name, delay);
    }

    public static boolean isDialogRootPane(JRootPane rootPane) {
        if (rootPane != null) {
            Object isDialog = rootPane.getClientProperty("DIALOG_ROOT_PANE");
            return isDialog instanceof Boolean && (Boolean)isDialog != false;
        }
        return false;
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(PanelWithAnchor ... panels) {
        return UIUtil.mergeComponentsWithAnchor(Arrays.asList(panels));
    }

    @Nullable
    public static JComponent mergeComponentsWithAnchor(@NotNull Collection<? extends PanelWithAnchor> panels) {
        JComponent maxWidthAnchor = null;
        int maxWidth = 0;
        for (PanelWithAnchor panelWithAnchor : panels) {
            int anchorWidth;
            JComponent anchor = panelWithAnchor != null ? panelWithAnchor.getAnchor() : null;
            if (anchor == null || maxWidth >= (anchorWidth = anchor.getPreferredSize().width)) continue;
            maxWidth = anchorWidth;
            maxWidthAnchor = anchor;
        }
        for (PanelWithAnchor panelWithAnchor : panels) {
            if (panelWithAnchor == null) continue;
            panelWithAnchor.setAnchor(maxWidthAnchor);
        }
        return maxWidthAnchor;
    }

    public static void setNotOpaqueRecursively(@NotNull Component component) {
        UIUtil.setOpaqueRecursively(component, false);
    }

    public static void setOpaqueRecursively(@NotNull Component component, boolean opaque) {
        if (!(component instanceof JComponent)) {
            return;
        }
        UIUtil.forEachComponentInHierarchy(component, (Consumer<? super Component>)((Consumer)c -> {
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(opaque);
            }
        }));
    }

    public static void setBackgroundRecursively(@NotNull Component component, @NotNull Color bg) {
        UIUtil.forEachComponentInHierarchy(component, (Consumer<? super Component>)((Consumer)c -> c.setBackground(bg)));
    }

    public static void setForegroundRecursively(@NotNull Component component, @NotNull Color bg) {
        UIUtil.forEachComponentInHierarchy(component, (Consumer<? super Component>)((Consumer)c -> c.setForeground(bg)));
    }

    private static void forEachComponentInHierarchy(@NotNull Component component, @NotNull Consumer<? super Component> action) {
        action.consume((Object)component);
        if (component instanceof Container) {
            for (Component c : ((Container)component).getComponents()) {
                UIUtil.forEachComponentInHierarchy(c, action);
            }
        }
    }

    public static void addInsets(@NotNull JComponent component, int top, int left, int bottom, int right) {
        UIUtil.addBorder(component, BorderFactory.createEmptyBorder(top, left, bottom, right));
    }

    public static void addInsets(@NotNull JComponent component, @NotNull Insets insets) {
        UIUtil.addInsets(component, insets.top, insets.left, insets.bottom, insets.right);
    }

    public static void adjustWindowToMinimumSize(Window window) {
        if (window == null) {
            return;
        }
        Dimension minSize = window.getMinimumSize();
        Dimension size = window.getSize();
        Dimension newSize = new Dimension(Math.max(size.width, minSize.width), Math.max(size.height, minSize.height));
        if (!newSize.equals(size)) {
            SwingUtilities.invokeLater(() -> {
                if (window.isShowing()) {
                    window.setSize(newSize);
                }
            });
        }
    }

    public static int getLcdContrastValue() {
        int lcdContrastValue = Registry.intValue((String)"lcd.contrast.value", (int)0);
        if (lcdContrastValue == 0) {
            return StartupUiUtil.doGetLcdContrastValueForSplash(StartupUiUtil.isUnderDarcula());
        }
        return StartupUiUtil.normalizeLcdContrastValue(lcdContrastValue);
    }

    public static void addBorder(JComponent component, Border border) {
        if (component != null && border != null) {
            Border old = component.getBorder();
            if (old != null) {
                border = BorderFactory.createCompoundBorder(border, old);
            }
            component.setBorder(border);
        }
    }

    @NotNull
    public static Color getDecoratedRowColor() {
        return JBColor.namedColor("Table.stripeColor", DECORATED_ROW_BG_COLOR);
    }

    @NotNull
    public static Paint getGradientPaint(float x1, float y1, @NotNull Color c1, float x2, float y2, @NotNull Color c2) {
        return Registry.is((String)"ui.no.bangs.and.whistles", (boolean)false) ? ColorUtil.mix(c1, c2, 0.5) : new GradientPaint(x1, y1, c1, x2, y2, c2);
    }

    @Nullable
    public static Point getLocationOnScreen(@NotNull JComponent component) {
        int dx = 0;
        int dy = 0;
        for (Container c = component; c != null; c = c.getParent()) {
            if (c.isShowing()) {
                Point locationOnScreen = c.getLocationOnScreen();
                locationOnScreen.translate(dx, dy);
                return locationOnScreen;
            }
            Point location = c.getLocation();
            dx += location.x;
            dy += location.y;
        }
        return null;
    }

    public static void setAutoRequestFocus(@NotNull Window window, boolean value) {
        if (!SystemInfo.isMac) {
            window.setAutoRequestFocus(value);
        }
    }

    public static void runWhenWindowOpened(@NotNull Window window, final @NotNull Runnable runnable) {
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                runnable.run();
            }
        });
    }

    public static void runWhenWindowClosed(@NotNull Window window, final @NotNull Runnable runnable) {
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                runnable.run();
            }
        });
    }

    @NotNull
    public static String getDebugText(@NotNull Component c) {
        StringBuilder builder = new StringBuilder();
        UIUtil.getAllTextsRecursively(c, builder);
        return builder.toString();
    }

    private static void getAllTextsRecursively(@NotNull Component component, @NotNull StringBuilder builder) {
        String candidate = "";
        if (component instanceof JLabel) {
            candidate = ((JLabel)component).getText();
        }
        if (component instanceof JTextComponent) {
            candidate = ((JTextComponent)component).getText();
        }
        if (component instanceof AbstractButton) {
            candidate = ((AbstractButton)component).getText();
        }
        if (StringUtil.isNotEmpty((String)candidate)) {
            candidate = candidate.replaceAll("<a href=\"#inspection/[^)]+\\)", "");
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(StringUtil.removeHtmlTags((String)candidate).trim());
        }
        if (component instanceof Container) {
            Component[] components;
            for (Component child : components = ((Container)component).getComponents()) {
                UIUtil.getAllTextsRecursively(child, builder);
            }
        }
    }

    public static boolean isAncestor(@NotNull Component ancestor, @Nullable Component descendant) {
        while (descendant != null) {
            if (descendant == ancestor) {
                return true;
            }
            descendant = descendant.getParent();
        }
        return false;
    }

    public static void resetUndoRedoActions(@NotNull JTextComponent textComponent) {
        UndoManager undoManager = ComponentUtil.getClientProperty(textComponent, UNDO_MANAGER);
        if (undoManager != null) {
            undoManager.discardAllEdits();
        }
    }

    public static void addUndoRedoActions(@NotNull JTextComponent textComponent) {
        if (textComponent.getClientProperty(UNDO_MANAGER) instanceof UndoManager) {
            return;
        }
        UndoManager undoManager = new UndoManager();
        textComponent.putClientProperty(UNDO_MANAGER, undoManager);
        textComponent.getDocument().addUndoableEditListener(undoManager);
        textComponent.getDocument().addDocumentListener(SET_TEXT_CHECKER);
        textComponent.getInputMap().put(KeyStroke.getKeyStroke(90, SystemInfo.isMac ? 4 : 2), "undoKeystroke");
        textComponent.getActionMap().put("undoKeystroke", UNDO_ACTION);
        textComponent.getInputMap().put(KeyStroke.getKeyStroke(90, (SystemInfo.isMac ? 4 : 2) | 1), "redoKeystroke");
        textComponent.getActionMap().put("redoKeystroke", REDO_ACTION);
    }

    @Nullable
    public static UndoManager getUndoManager(Component component) {
        Object o;
        if (component instanceof JTextComponent && (o = ((JTextComponent)component).getClientProperty(UNDO_MANAGER)) instanceof UndoManager) {
            return (UndoManager)o;
        }
        return null;
    }

    public static void playSoundFromResource(@NotNull String resourceName) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return;
        }
        UIUtil.playSoundFromStream((Factory<? extends InputStream>)((Factory)() -> callerClass.getResourceAsStream(resourceName)));
    }

    public static void playSoundFromStream(@NotNull Factory<? extends InputStream> streamProducer) {
        new Thread(() -> {
            try {
                Clip clip = AudioSystem.getClip();
                InputStream stream = (InputStream)streamProducer.create();
                if (!stream.markSupported()) {
                    stream = new BufferedInputStream(stream);
                }
                AudioInputStream inputStream = AudioSystem.getAudioInputStream(stream);
                clip.open(inputStream);
                clip.start();
            }
            catch (Exception e) {
                UIUtil.getLogger().info((Throwable)e);
            }
        }, "play sound").start();
    }

    @NotNull
    public static String leftArrow() {
        return FontUtil.leftArrow(StartupUiUtil.getLabelFont());
    }

    @NotNull
    public static String rightArrow() {
        return FontUtil.rightArrow(StartupUiUtil.getLabelFont());
    }

    @NotNull
    public static String upArrow(@NotNull String defaultValue) {
        return FontUtil.upArrow(StartupUiUtil.getLabelFont(), defaultValue);
    }

    public static void configureNumericFormattedTextField(@NotNull JFormattedTextField textField) {
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setParseIntegerOnly(true);
        format.setGroupingUsed(false);
        NumberFormatter numberFormatter = new NumberFormatter(format);
        numberFormatter.setMinimum(Integer.valueOf(0));
        textField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        textField.setHorizontalAlignment(11);
        textField.setColumns(4);
    }

    @Nullable
    public static Window getWindow(@Nullable Component component) {
        return ComponentUtil.getWindow(component);
    }

    public static void toFront(@Nullable Window window) {
        if (window instanceof Frame) {
            ((Frame)window).setState(0);
        }
        if (window != null) {
            window.toFront();
        }
    }

    public static boolean hasScrollPane(@NotNull Component component) {
        return UIUtil.hasComponentOfType(component, JScrollPane.class);
    }

    public static boolean hasComponentOfType(@NotNull Component component, Class<?> ... types) {
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(component.getClass())) continue;
            return true;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (!UIUtil.hasComponentOfType(container.getComponent(i), types)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setColumns(JTextComponent textComponent, int columns) {
        if (textComponent instanceof JTextField) {
            ((JTextField)textComponent).setColumns(columns);
        }
        if (textComponent instanceof JTextArea) {
            ((JTextArea)textComponent).setColumns(columns);
        }
    }

    public static int getLineHeight(@NotNull JTextComponent textComponent) {
        return textComponent.getFontMetrics(textComponent.getFont()).getHeight();
    }

    public static JComponent getPreferredFocusedComponent(Container container) {
        Container parent = container;
        if (parent == null) {
            return null;
        }
        FocusTraversalPolicy policy = parent.getFocusTraversalPolicy();
        while (policy == null) {
            if ((parent = parent.getParent()) == null) {
                return null;
            }
            policy = parent.getFocusTraversalPolicy();
        }
        Component component = policy.getFirstComponent(container);
        return component instanceof JComponent ? (JComponent)component : null;
    }

    @NotNull
    public static ComponentStyle getComponentStyle(Component component) {
        if (component instanceof JComponent) {
            Object property = ((JComponent)component).getClientProperty("JComponent.sizeVariant");
            if ("large".equals(property)) {
                return ComponentStyle.LARGE;
            }
            if ("small".equals(property)) {
                return ComponentStyle.SMALL;
            }
            if ("mini".equals(property)) {
                return ComponentStyle.MINI;
            }
        }
        return ComponentStyle.REGULAR;
    }

    public static void repaintViewport(@NotNull JComponent c) {
        if (!c.isDisplayable() || !c.isVisible()) {
            return;
        }
        Container p = c.getParent();
        if (p instanceof JViewport) {
            p.repaint();
        }
    }

    public static void setCursor(@NotNull Component component, Cursor cursor) {
        if (component.isCursorSet() && component.getCursor() == cursor) {
            return;
        }
        component.setCursor(cursor);
    }

    public static boolean haveCommonOwner(Component c1, Component c2) {
        Window owner;
        if (c1 == null || c2 == null) {
            return false;
        }
        Window c1Ancestor = UIUtil.findWindowAncestor(c1);
        Window c2Ancestor = UIUtil.findWindowAncestor(c2);
        HashSet<Window> ownerSet = new HashSet<Window>();
        for (owner = c1Ancestor; owner != null && !(owner instanceof JDialog) && !(owner instanceof JFrame); owner = owner.getOwner()) {
            ownerSet.add(owner);
        }
        for (owner = c2Ancestor; owner != null && !(owner instanceof JDialog) && !(owner instanceof JFrame); owner = owner.getOwner()) {
            if (!ownerSet.contains(owner)) continue;
            return true;
        }
        return false;
    }

    private static Window findWindowAncestor(@NotNull Component c) {
        return c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
    }

    public static boolean isHelpButton(Component button) {
        return button instanceof JButton && "help".equals(((JComponent)button).getClientProperty("JButton.buttonType"));
    }

    public static boolean isRetina(@NotNull GraphicsDevice device) {
        return DetectRetinaKit.isOracleMacRetinaDevice(device);
    }

    public static void useSafely(@NotNull Graphics originGraphics, @NotNull Consumer<? super Graphics2D> drawingConsumer) {
        Graphics2D graphics = (Graphics2D)originGraphics.create();
        try {
            drawingConsumer.consume((Object)graphics);
        }
        finally {
            graphics.dispose();
        }
    }

    @NotNull
    public static Font getListFont() {
        Font font = UIManager.getFont("List.font");
        return font != null ? font : StartupUiUtil.getLabelFont();
    }

    @NotNull
    public static Color getListBackground() {
        return LIST_BACKGROUND;
    }

    @NotNull
    public static Color getListSelectionBackground(boolean focused) {
        if (!focused) {
            return UnfocusedSelection.LIST_BACKGROUND;
        }
        Color color = UIManager.getColor("List.selectionBackground");
        double alpha = (double)SELECTED_ITEM_ALPHA.getFloat() / 100.0;
        return UIUtil.isUnderDefaultMacTheme() && alpha >= 0.0 && alpha <= 1.0 ? ColorUtil.mix(Color.WHITE, color, alpha) : color;
    }

    @NotNull
    public static Dimension updateListRowHeight(@NotNull Dimension size) {
        size.height = Math.max(size.height, UIManager.getInt("List.rowHeight"));
        return size;
    }

    @NotNull
    public static Color getListBackground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getListBackground() : UIUtil.getListSelectionBackground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getListBackground(boolean selected) {
        return UIUtil.getListBackground(selected, true);
    }

    @Deprecated
    @NotNull
    public static Color getListSelectionBackground() {
        return UIUtil.getListSelectionBackground(true);
    }

    @Deprecated
    @NotNull
    public static Color getListUnfocusedSelectionBackground() {
        return UIUtil.getListSelectionBackground(false);
    }

    @NotNull
    public static Color getListForeground() {
        return UIManager.getColor("List.foreground");
    }

    @NotNull
    public static Color getListSelectionForeground(boolean focused) {
        Color foreground = UIManager.getColor(focused ? "List.selectionForeground" : "List.selectionInactiveForeground");
        if (focused && foreground == null) {
            foreground = UIManager.getColor("List[Selected].textForeground");
        }
        return foreground != null ? foreground : UIUtil.getListForeground();
    }

    @NotNull
    public static Color getListForeground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getListForeground() : UIUtil.getListSelectionForeground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getListForeground(boolean selected) {
        return UIUtil.getListForeground(selected, true);
    }

    @Deprecated
    @NotNull
    public static Color getListSelectionForeground() {
        return UIUtil.getListSelectionForeground(true);
    }

    @NotNull
    public static Font getTreeFont() {
        Font font = UIManager.getFont("Tree.font");
        return font != null ? font : StartupUiUtil.getLabelFont();
    }

    @NotNull
    public static Color getTreeBackground() {
        return TREE_BACKGROUND;
    }

    @NotNull
    public static Color getTreeSelectionBackground(boolean focused) {
        return focused ? FocusedSelection.TREE_BACKGROUND : UnfocusedSelection.TREE_BACKGROUND;
    }

    @NotNull
    public static Color getTreeBackground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getTreeBackground() : UIUtil.getTreeSelectionBackground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTreeSelectionBackground() {
        return UIUtil.getTreeSelectionBackground(true);
    }

    @Deprecated
    @NotNull
    public static Color getTreeUnfocusedSelectionBackground() {
        return UIUtil.getTreeSelectionBackground(false);
    }

    @NotNull
    public static Color getTreeForeground() {
        return UIManager.getColor("Tree.foreground");
    }

    @NotNull
    public static Color getTreeSelectionForeground(boolean focused) {
        Color foreground = UIManager.getColor(focused ? "Tree.selectionForeground" : "Tree.selectionInactiveForeground");
        return foreground != null ? foreground : UIUtil.getTreeForeground();
    }

    @NotNull
    public static Color getTreeForeground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getTreeForeground() : UIUtil.getTreeSelectionForeground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTreeSelectionForeground() {
        return UIUtil.getTreeSelectionForeground(true);
    }

    @NotNull
    public static Color getTableBackground() {
        return TABLE_BACKGROUND;
    }

    @NotNull
    public static Color getTableSelectionBackground(boolean focused) {
        return focused ? FocusedSelection.TABLE_BACKGROUND : UnfocusedSelection.TABLE_BACKGROUND;
    }

    @NotNull
    public static Color getTableBackground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getTableBackground() : UIUtil.getTableSelectionBackground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTableBackground(boolean selected) {
        return UIUtil.getTableBackground(selected, true);
    }

    @Deprecated
    @NotNull
    public static Color getTableSelectionBackground() {
        return UIUtil.getTableSelectionBackground(true);
    }

    @Deprecated
    @NotNull
    public static Color getTableUnfocusedSelectionBackground() {
        return UIUtil.getTableSelectionBackground(false);
    }

    @NotNull
    public static Color getTableForeground() {
        return UIManager.getColor("Table.foreground");
    }

    @NotNull
    public static Color getTableSelectionForeground(boolean focused) {
        Color foreground = UIManager.getColor(focused ? "Table.selectionForeground" : "Table.selectionInactiveForeground");
        return foreground != null ? foreground : UIUtil.getTreeForeground();
    }

    @NotNull
    public static Color getTableForeground(boolean selected, boolean focused) {
        return !selected ? UIUtil.getTableForeground() : UIUtil.getTableSelectionForeground(focused);
    }

    @Deprecated
    @NotNull
    public static Color getTableForeground(boolean selected) {
        return UIUtil.getTableForeground(selected, true);
    }

    @Deprecated
    @NotNull
    public static Color getTableSelectionForeground() {
        return UIManager.getColor("Table.selectionForeground");
    }

    @Deprecated
    public static Pair<String, Integer> getSystemFontData() {
        return JBUIScale.getSystemFontData();
    }

    @Deprecated
    public static boolean isJreHiDPIEnabled() {
        return JreHiDpiUtil.isJreHiDPIEnabled();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isJreHiDPI(@Nullable Graphics2D g) {
        return JreHiDpiUtil.isJreHiDPI(g);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static Color getPanelBackgound() {
        return UIUtil.getPanelBackground();
    }

    public static void doNotScrollToCaret(@NotNull JTextComponent textComponent) {
        textComponent.setCaret(new DefaultCaret(){

            @Override
            protected void adjustVisibility(Rectangle nloc) {
            }
        });
    }

    public static void enableEagerSoftWrapping(@NotNull JTextComponent textComponent) {
        textComponent.getDocument().putProperty("multiByte", Boolean.TRUE);
    }

    @NotNull
    public static Color getTooltipSeparatorColor() {
        return JBColor.namedColor("Tooltip.separatorColor", 0xD1D1D1, 5527128);
    }

    public static void scrollToReference(@NotNull JEditorPane editor, @NotNull String reference) {
        Element elementById;
        Document document = editor.getDocument();
        if (document instanceof HTMLDocument && (elementById = ((HTMLDocument)document).getElement(reference)) != null) {
            try {
                int pos = elementById.getStartOffset();
                Rectangle r = editor.modelToView(pos);
                if (r != null) {
                    r.height = editor.getVisibleRect().height;
                    editor.scrollRectToVisible(r);
                    editor.setCaretPosition(pos);
                }
            }
            catch (BadLocationException e) {
                UIUtil.getLogger().error((Throwable)e);
            }
            return;
        }
        editor.scrollToReference(reference);
    }

    public static void runWhenFocused(@NotNull Component component, final @NotNull Runnable runnable) {
        assert (component.isShowing());
        if (component.isFocusOwner()) {
            runnable.run();
        } else {
            final Disposable disposable = Disposer.newDisposable();
            FocusAdapter focusListener = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    Disposer.dispose((Disposable)disposable);
                    runnable.run();
                }
            };
            HierarchyListener hierarchyListener = e -> {
                if ((e.getChangeFlags() & 4L) != 0L && !component.isShowing()) {
                    Disposer.dispose((Disposable)disposable);
                }
            };
            component.addFocusListener(focusListener);
            component.addHierarchyListener(hierarchyListener);
            Disposer.register((Disposable)disposable, () -> {
                component.removeFocusListener(focusListener);
                component.removeHierarchyListener(hierarchyListener);
            });
        }
    }

    public static Font getLabelFont() {
        return StartupUiUtil.getLabelFont();
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, @Nullable ImageObserver observer) {
        StartupUiUtil.drawImage(g, image, x, y, null);
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Dimension container, @NotNull Dimension child) {
        return StartupUiUtil.getCenterPoint(container, child);
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Rectangle container, @NotNull Dimension child) {
        return StartupUiUtil.getCenterPoint(container, child);
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable ImageObserver observer) {
        StartupUiUtil.drawImage(g, image, dstBounds, srcBounds, null, observer);
    }

    public static void drawImage(@NotNull Graphics g, @NotNull BufferedImage image, @Nullable BufferedImageOp op, int x, int y) {
        StartupUiUtil.drawImage(g, image, x, y, -1, -1, op, null);
    }

    public static void pump() {
        assert (!SwingUtilities.isEventDispatchThread());
        Semaphore lock = new Semaphore(1);
        SwingUtilities.invokeLater(() -> lock.up());
        lock.waitFor();
    }

    public static boolean isJreHiDPI() {
        return StartupUiUtil.isJreHiDPI();
    }

    public static Color makeTransparent(@NotNull Color color, @NotNull Color backgroundColor, double transparency) {
        int r = UIUtil.makeTransparent(transparency, color.getRed(), backgroundColor.getRed());
        int g = UIUtil.makeTransparent(transparency, color.getGreen(), backgroundColor.getGreen());
        int b = UIUtil.makeTransparent(transparency, color.getBlue(), backgroundColor.getBlue());
        return new Color(r, g, b);
    }

    private static int makeTransparent(double transparency, int channel, int backgroundChannel) {
        int result = (int)((double)backgroundChannel * (1.0 - transparency) + (double)channel * transparency);
        if (result < 0) {
            return 0;
        }
        return Math.min(result, 255);
    }

    static {
        LoadingState.LAF_INITIALIZED.checkOccurred();
        LAF_WITH_THEME_KEY = Key.create((String)"Laf.with.ui.theme");
        PLUGGABLE_LAF_KEY = Key.create((String)"Pluggable.laf.name");
        X_RENDER_ACTIVE = new AtomicNotNullLazyValue<Boolean>(){

            @NotNull
            protected Boolean compute() {
                if (!SystemInfo.isXWindow) {
                    return false;
                }
                try {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                    Method method = clazz.getMethod("isXRenderAvailable", new Class[0]);
                    return (Boolean)method.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    return false;
                }
            }
        };
        STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
        KEEP_BORDER_SIDES = Key.create((String)"keepBorderSides");
        UNDO_MANAGER = Key.create((String)"undoManager");
        TEXT_COPY_ROOT = Key.create((String)"TEXT_COPY_ROOT");
        REDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                UndoManager manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER);
                if (manager != null && manager.canRedo()) {
                    manager.redo();
                }
            }
        };
        UNDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                UndoManager manager = (UndoManager)UIUtil.getClientProperty(e.getSource(), UNDO_MANAGER);
                if (manager != null && manager.canUndo()) {
                    manager.undo();
                }
            }
        };
        ACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.active", 10533589);
        INACTIVE_HEADER_COLOR = JBColor.namedColor("HeaderColor.inactive", Gray._128);
        CONTRAST_BORDER_COLOR = JBColor.namedColor("Borders.ContrastBorderColor", new JBColor(0xC9C9C9, 0x323232));
        SIDE_PANEL_BACKGROUND = JBColor.namedColor("SidePanel.background", new JBColor(15133680, 4080460));
        AQUA_SEPARATOR_BACKGROUND_COLOR = new JBColor(Gray._240, Gray.x51);
        TRANSPARENT_COLOR = Gray.TRANSPARENT;
        PANEL_REGULAR_INSETS = UIUtil.getRegularPanelInsets();
        PANEL_SMALL_INSETS = JBInsets.create(5, 8);
        ourRetina = Ref.create((Object)(SystemInfo.isMac ? null : Boolean.valueOf(false)));
        NOT_IN_HIERARCHY_COMPONENTS = Key.create((String)"NOT_IN_HIERARCHY_COMPONENTS");
        UI_TRAVERSER = JBTreeTraverser.from(c -> {
            JBIterable result = c instanceof JMenu ? JBIterable.of((Object[])((JMenu)c).getMenuComponents()) : UIUtil.uiChildren(c);
            if (c instanceof JComponent) {
                JPopupMenu jpm;
                JComponent jc = (JComponent)c;
                Iterable<? extends Component> orphans = ComponentUtil.getClientProperty(jc, NOT_IN_HIERARCHY_COMPONENTS);
                if (orphans != null) {
                    result = result.append(orphans);
                }
                if ((jpm = jc.getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                    result = result.append(Collections.singletonList(jpm));
                }
            }
            return result;
        });
        DECORATED_ROW_BG_COLOR = new JBColor(new Color(242, 245, 249), new Color(65, 69, 71));
        SET_TEXT_CHECKER = new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                Document document = e.getDocument();
                if (document instanceof AbstractDocument) {
                    StackTraceElement[] stackTrace;
                    for (StackTraceElement element : stackTrace = new Throwable().getStackTrace()) {
                        UndoableEditListener[] undoableEditListeners;
                        if (!element.getClassName().equals(JTextComponent.class.getName()) || !element.getMethodName().equals("setText")) continue;
                        for (UndoableEditListener listener : undoableEditListeners = ((AbstractDocument)document).getUndoableEditListeners()) {
                            if (!(listener instanceof UndoManager)) continue;
                            Runnable runnable = ((UndoManager)listener)::discardAllEdits;
                            SwingUtilities.invokeLater(runnable);
                            return;
                        }
                    }
                }
            }
        };
        BACKGROUND = new JBColor(0xFFFFFF, 3948353);
        LIST_BACKGROUND = JBColor.namedColor("List.background", BACKGROUND);
        TREE_BACKGROUND = JBColor.namedColor("Tree.background", BACKGROUND);
        TABLE_BACKGROUND = JBColor.namedColor("Table.background", BACKGROUND);
        SELECTED_ITEM_ALPHA = new JBValue.UIInteger("List.selectedItemAlpha", 75);
    }

    private static final class UnfocusedSelection {
        private static final Color BACKGROUND = new JBColor(0xD4D4D4, 862526);
        private static final Color LIST_BACKGROUND = JBColor.namedColor("List.selectionInactiveBackground", BACKGROUND);
        private static final Color TREE_BACKGROUND = JBColor.namedColor("Tree.selectionInactiveBackground", BACKGROUND);
        private static final Color TABLE_BACKGROUND = JBColor.namedColor("Table.selectionInactiveBackground", BACKGROUND);

        private UnfocusedSelection() {
        }
    }

    private static final class FocusedSelection {
        private static final Color BACKGROUND = new JBColor(3700182, 3106250);
        private static final Color TREE_BACKGROUND = JBColor.namedColor("Tree.selectionBackground", BACKGROUND);
        private static final Color TABLE_BACKGROUND = JBColor.namedColor("Table.selectionBackground", BACKGROUND);

        private FocusedSelection() {
        }
    }

    public static class TextPainter {
        private final List<String> myLines = new ArrayList<String>();
        private boolean myDrawShadow = StartupUiUtil.isUnderDarcula();
        private Color myShadowColor = StartupUiUtil.isUnderDarcula() ? Gray._0.withAlpha(100) : Gray._220;
        private float myLineSpacing = 1.0f;
        private Font myFont;
        private Color myColor;

        @NotNull
        public TextPainter withShadow(boolean drawShadow, Color shadowColor) {
            this.myDrawShadow = drawShadow;
            this.myShadowColor = shadowColor;
            return this;
        }

        @NotNull
        public TextPainter withLineSpacing(float lineSpacing) {
            this.myLineSpacing = lineSpacing;
            return this;
        }

        @NotNull
        public TextPainter withColor(Color color) {
            this.myColor = color;
            return this;
        }

        @NotNull
        public TextPainter withFont(Font font) {
            this.myFont = font;
            return this;
        }

        @NotNull
        public TextPainter appendLine(String text) {
            if (text == null || text.isEmpty()) {
                return this;
            }
            this.myLines.add(text);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(@NotNull Graphics g, @NotNull PairFunction<? super Integer, ? super Integer, ? extends Couple<Integer>> _position) {
            Font oldFont = null;
            if (this.myFont != null) {
                oldFont = g.getFont();
                g.setFont(this.myFont);
            }
            Color oldColor = null;
            if (this.myColor != null) {
                oldColor = g.getColor();
                g.setColor(this.myColor);
            }
            try {
                int[] maxWidth = new int[]{0};
                int[] height = new int[]{0};
                ContainerUtil.process(this.myLines, text -> {
                    FontMetrics fm = g.getFontMetrics();
                    maxWidth[0] = Math.max(fm.stringWidth(text.replace("<shortcut>", "").replace("</shortcut>", "")), maxWidth[0]);
                    height[0] = (int)((float)height[0] + (float)(fm.getHeight() + fm.getLeading()) * this.myLineSpacing);
                    return true;
                });
                Couple position = (Couple)_position.fun((Object)(maxWidth[0] + 20), (Object)height[0]);
                assert (position != null);
                int[] yOffset = new int[]{(Integer)position.getSecond()};
                ContainerUtil.process(this.myLines, text -> {
                    String shortcut = "";
                    if (text.contains("<shortcut>")) {
                        shortcut = text.substring(text.indexOf("<shortcut>") + "<shortcut>".length(), text.indexOf("</shortcut>"));
                        text = text.substring(0, text.indexOf("<shortcut>"));
                    }
                    int x = (Integer)position.getFirst() + 10;
                    FontMetrics fm = g.getFontMetrics();
                    if (this.myDrawShadow) {
                        int xOff = StartupUiUtil.isUnderDarcula() ? 1 : 0;
                        Color oldColor1 = g.getColor();
                        g.setColor(this.myShadowColor);
                        int yOff = 1;
                        g.drawString((String)text, x + xOff, yOffset[0] + yOff);
                        g.setColor(oldColor1);
                    }
                    g.drawString((String)text, x, yOffset[0]);
                    if (!StringUtil.isEmpty((String)shortcut)) {
                        Color oldColor1 = g.getColor();
                        g.setColor(JBColor.namedColor("Editor.shortcutForeground", new JBColor(new Color(82, 99, 155), new Color(88, 157, 246))));
                        g.drawString(shortcut, x + fm.stringWidth(text + (StartupUiUtil.isUnderDarcula() ? " " : "")), yOffset[0]);
                        g.setColor(oldColor1);
                    }
                    yOffset[0] = (int)((float)yOffset[0] + (float)(fm.getHeight() + fm.getLeading()) * this.myLineSpacing);
                    return true;
                });
            }
            finally {
                if (oldFont != null) {
                    g.setFont(oldFont);
                }
                if (oldColor != null) {
                    g.setColor(oldColor);
                }
            }
        }
    }

    public static final class JBWordWrapHtmlEditorKit
    extends JBHtmlEditorKit {
        private final HTMLEditorKit.HTMLFactory myFactory = new HTMLEditorKit.HTMLFactory(){

            @Override
            public View create(Element e) {
                View view = super.create(e);
                if (view instanceof ParagraphView) {
                    return new ParagraphView(e){

                        @Override
                        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
                            if (r == null) {
                                r = new SizeRequirements();
                            }
                            r.minimum = (int)this.layoutPool.getMinimumSpan(axis);
                            r.preferred = Math.max(r.minimum, (int)this.layoutPool.getPreferredSpan(axis));
                            r.maximum = Integer.MAX_VALUE;
                            r.alignment = 0.5f;
                            return r;
                        }
                    };
                }
                return view;
            }
        };

        @Override
        public ViewFactory getViewFactory() {
            return this.myFactory;
        }
    }

    public static enum FontColor {
        NORMAL,
        BRIGHTER;

    }

    public static enum ComponentStyle {
        LARGE,
        REGULAR,
        SMALL,
        MINI;

    }

    public static enum FontSize {
        NORMAL,
        SMALL,
        MINI;

    }

    @ApiStatus.Experimental
    public static class GrayFilter
    extends RGBImageFilter {
        private float brightness;
        private float contrast;
        private int alpha;
        private int origContrast;
        private int origBrightness;

        public GrayFilter(int brightness, int contrast, int alpha) {
            this.setBrightness(brightness);
            this.setContrast(contrast);
            this.setAlpha(alpha);
        }

        public GrayFilter() {
            this(0, 0, 100);
        }

        private void setBrightness(int brightness) {
            this.origBrightness = Math.max(-100, Math.min(100, brightness));
            this.brightness = (float)(Math.pow(this.origBrightness, 3.0) / 10000.0);
        }

        public int getBrightness() {
            return this.origBrightness;
        }

        private void setContrast(int contrast) {
            this.origContrast = Math.max(-100, Math.min(100, contrast));
            this.contrast = (float)this.origContrast / 100.0f;
        }

        public int getContrast() {
            return this.origContrast;
        }

        private void setAlpha(int alpha) {
            this.alpha = Math.max(0, Math.min(100, alpha));
        }

        public int getAlpha() {
            return this.alpha;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int gray = (int)(0.3 * (double)(rgb >> 16 & 0xFF) + 0.59 * (double)(rgb >> 8 & 0xFF) + 0.11 * (double)(rgb & 0xFF));
            gray = this.brightness >= 0.0f ? (int)(((float)gray + this.brightness * 255.0f) / (1.0f + this.brightness)) : (int)((float)gray / (1.0f - this.brightness));
            gray = this.contrast >= 0.0f ? (gray >= 127 ? (int)((float)gray + (float)(255 - gray) * this.contrast) : (int)((float)gray - (float)gray * this.contrast)) : (int)(127.0f + (float)(gray - 127) * (this.contrast + 1.0f));
            int a = (rgb >> 24 & 0xFF) * this.alpha / 100;
            return a << 24 | gray << 16 | gray << 8 | gray;
        }

        @NotNull
        public GrayFilterUIResource asUIResource() {
            return new GrayFilterUIResource(this);
        }

        @NotNull
        public static GrayFilter namedFilter(@NotNull String resourceName, @NotNull GrayFilter defaultFilter) {
            return (GrayFilter)ObjectUtils.notNull((Object)((GrayFilter)UIManager.get(resourceName)), (Object)defaultFilter);
        }

        public static class GrayFilterUIResource
        extends GrayFilter
        implements UIResource {
            public GrayFilterUIResource(@NotNull GrayFilter filter) {
                super(filter.origBrightness, filter.origContrast, filter.alpha);
            }
        }
    }
}

