/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.Scale;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBUI {
    private static final JBEmptyBorder SHARED_EMPTY_INSTANCE = new JBEmptyBorder(0);

    @Deprecated
    public static float sysScale() {
        return JBUIScale.sysScale();
    }

    @Deprecated
    public static float sysScale(@Nullable Graphics2D g) {
        return JBUIScale.sysScale(g);
    }

    @Deprecated
    public static float sysScale(@Nullable Component comp) {
        return JBUIScale.sysScale(comp);
    }

    public static float pixScale() {
        return JreHiDpiUtil.isJreHiDPIEnabled() ? JBUIScale.sysScale() * JBUIScale.scale(1.0f) : JBUIScale.scale(1.0f);
    }

    public static float pixScale(float f) {
        return JBUI.pixScale() * f;
    }

    public static float pixScale(@Nullable GraphicsConfiguration gc) {
        return JreHiDpiUtil.isJreHiDPIEnabled() ? JBUIScale.sysScale(gc) * JBUIScale.scale(1.0f) : JBUIScale.scale(1.0f);
    }

    public static float pixScale(@Nullable Component comp) {
        return JBUI.pixScale(comp != null ? comp.getGraphicsConfiguration() : null);
    }

    @Deprecated
    public static float setUserScaleFactor(float scale) {
        return JBUIScale.setUserScaleFactor(scale);
    }

    @Deprecated
    public static float scale(float f) {
        return JBUIScale.scale(f);
    }

    public static int scale(int i) {
        return JBUIScale.scale(i);
    }

    public static int scaleFontSize(float fontSize) {
        return JBUIScale.scaleFontSize(fontSize);
    }

    @NotNull
    public static JBValue value(float value) {
        return new JBValue.Float(value);
    }

    @NotNull
    public static JBValue uiIntValue(@NotNull String key, int defValue) {
        return new JBValue.UIInteger(key, defValue);
    }

    @NotNull
    public static JBDimension size(int width, int height) {
        return new JBDimension(width, height);
    }

    @NotNull
    public static JBDimension size(int widthAndHeight) {
        return new JBDimension(widthAndHeight, widthAndHeight);
    }

    @NotNull
    public static JBDimension size(Dimension size) {
        if (size instanceof JBDimension) {
            JBDimension newSize = ((JBDimension)size).newSize();
            return size instanceof UIResource ? newSize.asUIResource() : newSize;
        }
        return new JBDimension(size.width, size.height);
    }

    @NotNull
    public static JBInsets insets(int top, int left, int bottom, int right) {
        return new JBInsets(top, left, bottom, right);
    }

    @NotNull
    public static JBInsets insets(int all) {
        return new JBInsets(all, all, all, all);
    }

    @NotNull
    public static JBInsets insets(@NonNls @NotNull String propName, @NotNull JBInsets defaultValue) {
        Insets i = UIManager.getInsets(propName);
        return i != null ? JBInsets.create(i) : defaultValue;
    }

    @NotNull
    public static JBInsets insets(int topBottom, int leftRight) {
        return JBInsets.create(topBottom, leftRight);
    }

    @NotNull
    public static JBInsets emptyInsets() {
        return new JBInsets(0, 0, 0, 0);
    }

    @NotNull
    public static JBInsets insetsTop(int t) {
        return new JBInsets(t, 0, 0, 0);
    }

    @NotNull
    public static JBInsets insetsLeft(int l) {
        return new JBInsets(0, l, 0, 0);
    }

    @NotNull
    public static JBInsets insetsBottom(int b) {
        return new JBInsets(0, 0, b, 0);
    }

    @NotNull
    public static JBInsets insetsRight(int r) {
        return new JBInsets(0, 0, 0, r);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static <T extends JBScalableIcon> T scale(@NotNull T icon) {
        return JBUIScale.scaleIcon(icon);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static <T extends JBIcon> T scale(@NotNull T icon) {
        return (T)((JBIcon)icon.withIconPreScaled(false));
    }

    @NotNull
    public static JBDimension emptySize() {
        return new JBDimension(0, 0);
    }

    @NotNull
    public static JBInsets insets(@NotNull Insets insets) {
        return JBInsets.create(insets);
    }

    @Deprecated
    public static boolean isHiDPI() {
        return JBUIScale.isUsrHiDPI();
    }

    @Deprecated
    public static boolean isUsrHiDPI() {
        return JBUIScale.isUsrHiDPI();
    }

    public static boolean isPixHiDPI(@Nullable GraphicsConfiguration gc) {
        return JBUIScale.isHiDPI(JBUI.pixScale(gc));
    }

    public static boolean isPixHiDPI(@Nullable Component comp) {
        return JBUIScale.isHiDPI(JBUI.pixScale(comp));
    }

    public static Border asUIResource(@NotNull Border border) {
        if (border instanceof UIResource) {
            return border;
        }
        return new BorderUIResource(border);
    }

    public static int getInt(@NonNls @NotNull String propertyName, int defaultValue) {
        Object value = UIManager.get(propertyName);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    @NotNull
    private static Icon getIcon(@NonNls @NotNull String propertyName, @NotNull Icon defaultIcon) {
        Icon icon = UIManager.getIcon(propertyName);
        return icon == null ? defaultIcon : icon;
    }

    @NotNull
    private static Border getBorder(@NonNls @NotNull String propertyName, @NotNull Border defaultBorder) {
        Border border = UIManager.getBorder(propertyName);
        return border == null ? defaultBorder : border;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static abstract class JBIcon<T extends JBScalableIcon>
    extends JBScalableIcon {
        public JBIcon() {
        }

        public JBIcon(T icon) {
            super((JBScalableIcon)icon);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final class ScaleContext
    extends com.intellij.ui.scale.ScaleContext {
        private ScaleContext() {
        }

        @NotNull
        public static ScaleContext create() {
            return new ScaleContext();
        }

        @NotNull
        public static ScaleContext create(@Nullable Component comp) {
            ScaleContext ctx = new ScaleContext(com.intellij.ui.scale.ScaleType.SYS_SCALE.of(JBUIScale.sysScale(comp)));
            if (comp != null) {
                ctx.compRef = new WeakReference<Component>(comp);
            }
            return ctx;
        }

        @NotNull
        public static ScaleContext create(@NotNull Scale scale) {
            return new ScaleContext(scale);
        }

        private ScaleContext(@NotNull Scale scale) {
            this.setScale(scale);
        }

        @Override
        public double getScale(@NotNull ScaleType type) {
            switch (type) {
                case USR_SCALE: {
                    return this.usrScale.value();
                }
                case SYS_SCALE: {
                    return this.sysScale.value();
                }
                case OBJ_SCALE: {
                    return this.objScale.value();
                }
                case PIX_SCALE: {
                    return this.pixScale;
                }
            }
            return 1.0;
        }

        @Override
        public boolean update(@Nullable BaseScaleContext context) {
            return super.update(context);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static class BaseScaleContext
    extends UserScaleContext {
        public boolean update(@Nullable BaseScaleContext ctx) {
            return super.update(ctx);
        }

        public boolean update(@NotNull Scale scale) {
            return this.setScale(scale);
        }

        @Deprecated
        public double getScale(@NotNull ScaleType type) {
            switch (type) {
                case USR_SCALE: {
                    return this.usrScale.value();
                }
                case SYS_SCALE: {
                    return 1.0;
                }
                case OBJ_SCALE: {
                    return this.objScale.value();
                }
                case PIX_SCALE: {
                    return this.pixScale;
                }
            }
            return 1.0;
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static enum ScaleType {
        USR_SCALE,
        SYS_SCALE,
        OBJ_SCALE,
        PIX_SCALE;

    }

    public static final class CurrentTheme {

        public static final class NewClassDialog {
            @NotNull
            public static Color searchFieldBackground() {
                return JBColor.namedColor("NewClass.SearchField.background", 0xFFFFFF);
            }

            @NotNull
            public static Color panelBackground() {
                return JBColor.namedColor("NewClass.Panel.background", 0xF2F2F2);
            }

            @NotNull
            public static Color bordersColor() {
                return JBColor.namedColor("TextField.borderColor", JBColor.namedColor("Component.borderColor", new JBColor(0xBDBDBD, 0x646464)));
            }

            public static int fieldsSeparatorWidth() {
                return JBUI.getInt("NewClass.separatorWidth", JBUIScale.scale(10));
            }
        }

        public static final class Arrow {
            @NotNull
            public static Color foregroundColor(boolean enabled) {
                return enabled ? JBColor.namedColor("ComboBox.ArrowButton.iconColor", JBColor.namedColor("ComboBox.darcula.arrowButtonForeground", Gray.x66)) : JBColor.namedColor("ComboBox.ArrowButton.disabledIconColor", JBColor.namedColor("ComboBox.darcula.arrowButtonDisabledForeground", Gray.xAB));
            }

            @NotNull
            public static Color backgroundColor(boolean enabled, boolean editable) {
                return enabled ? (editable ? JBColor.namedColor("ComboBox.ArrowButton.background", JBColor.namedColor("ComboBox.darcula.editable.arrowButtonBackground", Gray.xFC)) : JBColor.namedColor("ComboBox.ArrowButton.nonEditableBackground", JBColor.namedColor("ComboBox.darcula.arrowButtonBackground", Gray.xFC))) : UIUtil.getPanelBackground();
            }
        }

        public static final class Link {
            @NotNull
            public static Color linkColor() {
                return JBColor.namedColor("Link.activeForeground", JBColor.namedColor("link.foreground", 5807606));
            }

            @NotNull
            public static Color linkHoverColor() {
                return JBColor.namedColor("Link.hoverForeground", JBColor.namedColor("link.hover.foreground", Link.linkColor()));
            }

            @NotNull
            public static Color linkPressedColor() {
                return JBColor.namedColor("Link.pressedForeground", JBColor.namedColor("link.pressed.foreground", new JBColor(0xF00000, 12218149)));
            }

            @NotNull
            public static Color linkVisitedColor() {
                return JBColor.namedColor("Link.visitedForeground", JBColor.namedColor("link.visited.foreground", new JBColor(0x800080, 9926313)));
            }

            @NotNull
            public static Color linkSecondaryColor() {
                return JBColor.namedColor("Link.secondaryForeground", new JBColor(7839165, 5666464));
            }
        }

        public static final class Validator {
            @NotNull
            public static Color errorBorderColor() {
                return JBColor.namedColor("ValidationTooltip.errorBorderColor", 14723241);
            }

            @NotNull
            public static Color errorBackgroundColor() {
                return JBColor.namedColor("ValidationTooltip.errorBackground", JBColor.namedColor("ValidationTooltip.errorBackgroundColor", 16115431));
            }

            @NotNull
            public static Color warningBorderColor() {
                return JBColor.namedColor("ValidationTooltip.warningBorderColor", 14732968);
            }

            @NotNull
            public static Color warningBackgroundColor() {
                return JBColor.namedColor("ValidationTooltip.warningBackground", JBColor.namedColor("ValidationTooltip.warningBackgroundColor", 16117990));
            }
        }

        public static final class Advertiser {
            private static final JBInsets DEFAULT_AD_INSETS = JBInsets.create(1, 5);

            @NotNull
            public static Color foreground() {
                Color foreground = BigPopup.advertiserForeground();
                return JBColor.namedColor("Popup.Advertiser.foreground", foreground);
            }

            @NotNull
            public static Color background() {
                Color background = BigPopup.advertiserBackground();
                return JBColor.namedColor("Popup.Advertiser.background", background);
            }

            @NotNull
            public static Border border() {
                return new JBEmptyBorder(JBUI.insets("Popup.Advertiser.borderInsets", DEFAULT_AD_INSETS));
            }

            @NotNull
            public static Color borderColor() {
                return JBColor.namedColor("Popup.Advertiser.borderColor", Gray._135);
            }
        }

        public static final class BigPopup {
            @NotNull
            public static Color headerBackground() {
                return JBColor.namedColor("SearchEverywhere.Header.background", 0xF2F2F2);
            }

            @NotNull
            public static Insets tabInsets() {
                return JBInsets.create(0, 12);
            }

            @NotNull
            public static Color selectedTabColor() {
                return JBColor.namedColor("SearchEverywhere.Tab.selectedBackground", 0xDEDEDE);
            }

            @NotNull
            public static Color selectedTabTextColor() {
                return JBColor.namedColor("SearchEverywhere.Tab.selectedForeground", 0);
            }

            @NotNull
            public static Color searchFieldBackground() {
                return JBColor.namedColor("SearchEverywhere.SearchField.background", 0xFFFFFF);
            }

            @NotNull
            public static Color searchFieldBorderColor() {
                return JBColor.namedColor("SearchEverywhere.SearchField.borderColor", 0xBDBDBD);
            }

            @NotNull
            public static Insets searchFieldInsets() {
                return JBUI.insets(0, 6, 0, 5);
            }

            public static int maxListHeight() {
                return JBUIScale.scale(600);
            }

            @NotNull
            public static Color listSeparatorColor() {
                return JBColor.namedColor("SearchEverywhere.List.separatorColor", Gray.xDC);
            }

            @NotNull
            public static Color listTitleLabelForeground() {
                return JBColor.namedColor("SearchEverywhere.List.separatorForeground", UIUtil.getLabelDisabledForeground());
            }

            @NotNull
            public static Color searchFieldGrayForeground() {
                return JBColor.namedColor("SearchEverywhere.SearchField.infoForeground", JBColor.GRAY);
            }

            @NotNull
            public static Color advertiserForeground() {
                return JBColor.namedColor("SearchEverywhere.Advertiser.foreground", JBColor.GRAY);
            }

            @NotNull
            public static Border advertiserBorder() {
                return new JBEmptyBorder(JBUI.insets("SearchEverywhere.Advertiser.foreground", JBUI.insetsLeft(8)));
            }

            @NotNull
            public static Color advertiserBackground() {
                return JBColor.namedColor("SearchEverywhere.Advertiser.background", 0xF2F2F2);
            }
        }

        public static final class TabbedPane {
            public static final Color ENABLED_SELECTED_COLOR = JBColor.namedColor("TabbedPane.underlineColor", JBColor.namedColor("TabbedPane.selectedColor", 4228041));
            public static final Color DISABLED_SELECTED_COLOR = JBColor.namedColor("TabbedPane.disabledUnderlineColor", JBColor.namedColor("TabbedPane.selectedDisabledColor", Gray.xAB));
            public static final Color DISABLED_TEXT_COLOR = JBColor.namedColor("TabbedPane.disabledForeground", JBColor.namedColor("TabbedPane.disabledText", Gray.x99));
            public static final Color HOVER_COLOR = JBColor.namedColor("TabbedPane.hoverColor", Gray.xD9);
            public static final Color FOCUS_COLOR = JBColor.namedColor("TabbedPane.focusColor", 14345453);
            public static final JBValue TAB_HEIGHT = new JBValue.UIInteger("TabbedPane.tabHeight", 32);
            public static final JBValue SELECTION_HEIGHT = new JBValue.UIInteger("TabbedPane.tabSelectionHeight", 3);
        }

        public static final class Focus {
            private static final Color GRAPHITE_COLOR = new JBColor(new Color(-2137417827, true), new Color(6776937));

            @NotNull
            public static Color focusColor() {
                return UIUtil.isGraphite() ? GRAPHITE_COLOR : JBColor.namedColor("Component.focusColor", JBColor.namedColor("Focus.borderColor", 9089771));
            }

            @NotNull
            public static Color defaultButtonColor() {
                return StartupUiUtil.isUnderDarcula() ? JBColor.namedColor("Button.default.focusColor", JBColor.namedColor("Focus.defaultButtonBorderColor", 9946099)) : Focus.focusColor();
            }

            @NotNull
            public static Color errorColor(boolean active) {
                return active ? JBColor.namedColor("Component.errorFocusColor", JBColor.namedColor("Focus.activeErrorBorderColor", 15023693)) : JBColor.namedColor("Component.inactiveErrorFocusColor", JBColor.namedColor("Focus.inactiveErrorBorderColor", 0xEBBCBC));
            }

            @NotNull
            public static Color warningColor(boolean active) {
                return active ? JBColor.namedColor("Component.warningFocusColor", JBColor.namedColor("Focus.activeWarningBorderColor", 14853434)) : JBColor.namedColor("Component.inactiveWarningFocusColor", JBColor.namedColor("Focus.inactiveWarningBorderColor", 16765829));
            }
        }

        public static final class Popup {
            public static Color headerBackground(boolean active) {
                return active ? JBColor.namedColor("Popup.Header.activeBackground", 0xE6E6E6) : JBColor.namedColor("Popup.Header.inactiveBackground", 0xEDEDED);
            }

            public static int headerHeight(boolean hasControls) {
                return hasControls ? JBUIScale.scale(28) : JBUIScale.scale(24);
            }

            public static Color borderColor(boolean active) {
                return active ? JBColor.namedColor("Popup.borderColor", JBColor.namedColor("Popup.Border.color", 0x808080)) : JBColor.namedColor("Popup.inactiveBorderColor", JBColor.namedColor("Popup.inactiveBorderColor", 0xAAAAAA));
            }

            public static Color toolbarPanelColor() {
                return JBColor.namedColor("Popup.Toolbar.background", 0xF7F7F7);
            }

            public static Color toolbarBorderColor() {
                return JBColor.namedColor("Popup.Toolbar.borderColor", JBColor.namedColor("Popup.Toolbar.Border.color", 0xF7F7F7));
            }

            public static int toolbarHeight() {
                return JBUIScale.scale(28);
            }

            public static Color separatorColor() {
                return JBColor.namedColor("Popup.separatorColor", new JBColor(Color.gray.brighter(), Gray.x51));
            }

            public static Color separatorTextColor() {
                return JBColor.namedColor("Popup.separatorForeground", Color.gray);
            }
        }

        public static final class Label {
            @NotNull
            public static Color foreground(boolean selected) {
                return selected ? JBColor.namedColor("Label.selectedForeground", 0xFFFFFF) : JBColor.namedColor("Label.foreground", 0);
            }

            @NotNull
            public static Color foreground() {
                return Label.foreground(false);
            }

            @NotNull
            public static Color disabledForeground(boolean selected) {
                return selected ? JBColor.namedColor("Label.selectedDisabledForeground", 0x999999) : JBColor.namedColor("Label.disabledForeground", JBColor.namedColor("Label.disabledText", 0x999999));
            }

            @NotNull
            public static Color disabledForeground() {
                return Label.disabledForeground(false);
            }
        }

        public static final class ToolWindow {
            @NotNull
            public static Color borderColor() {
                return JBColor.namedColor("ToolWindow.HeaderTab.borderColor", DefaultTabs.borderColor());
            }

            @NotNull
            public static Color underlinedTabForeground() {
                return JBColor.namedColor("ToolWindow.HeaderTab.underlinedTabForeground", DefaultTabs.underlinedTabForeground());
            }

            @NotNull
            public static Color hoverBackground() {
                return JBColor.namedColor("ToolWindow.HeaderTab.hoverBackground", DefaultTabs.hoverBackground());
            }

            @NotNull
            public static Color inactiveUnderlineColor() {
                return JBColor.namedColor("ToolWindow.HeaderTab.inactiveUnderlineColor", DefaultTabs.inactiveUnderlineColor());
            }

            @NotNull
            public static Color underlineColor() {
                return JBColor.namedColor("ToolWindow.HeaderTab.underlineColor", DefaultTabs.underlineColor());
            }

            public static Color underlinedTabBackground() {
                return UIManager.getColor("ToolWindow.HeaderTab.underlinedTabBackground");
            }

            public static Color hoverInactiveBackground() {
                return JBColor.namedColor("ToolWindow.HeaderTab.hoverInactiveBackground", ToolWindow.hoverBackground());
            }

            public static Color underlinedTabInactiveBackground() {
                return UIManager.getColor("ToolWindow.HeaderTab.underlinedTabInactiveBackground");
            }

            @NotNull
            public static Color underlinedTabInactiveForeground() {
                return JBColor.namedColor("ToolWindow.HeaderTab.underlinedTabInactiveForeground", ToolWindow.underlinedTabForeground());
            }

            @Deprecated
            @NotNull
            public static Color tabSelectedBackground() {
                return Registry.is((String)"toolwindow.active.tab.use.contrast.background") ? Registry.getColor((String)"toolwindow.active.tab.contrast.background.color", (Color)JBColor.GRAY) : JBColor.namedColor("ToolWindow.HeaderTab.selectedInactiveBackground", JBColor.namedColor("ToolWindow.header.tab.selected.background", 0xDEDEDE));
            }

            @Deprecated
            @NotNull
            public static Color tabHoveredBackground() {
                return ToolWindow.hoverInactiveBackground();
            }

            @Deprecated
            @NotNull
            public static Color tabHoveredBackground(boolean active) {
                return active ? ToolWindow.hoverBackground() : ToolWindow.hoverInactiveBackground();
            }

            @NotNull
            public static Color headerBackground(boolean active) {
                return active ? ToolWindow.headerActiveBackground() : ToolWindow.headerBackground();
            }

            @NotNull
            public static Color headerBackground() {
                return JBColor.namedColor("ToolWindow.Header.inactiveBackground", JBColor.namedColor("ToolWindow.header.background", 0xECECEC));
            }

            @NotNull
            public static Color headerBorderBackground() {
                return JBColor.namedColor("ToolWindow.Header.borderColor", DefaultTabs.borderColor());
            }

            @NotNull
            public static Color headerActiveBackground() {
                return JBColor.namedColor("ToolWindow.Header.background", JBColor.namedColor("ToolWindow.header.active.background", 14870252));
            }

            @Deprecated
            public static int tabVerticalPadding() {
                return JBUI.getInt("ToolWindow.HeaderTab.verticalPadding", JBUIScale.scale(6));
            }

            @Deprecated
            @NotNull
            public static Border tabBorder() {
                return JBUI.getBorder("ToolWindow.tabBorder", Borders.empty(1));
            }

            public static int underlineHeight() {
                return JBUI.getInt("ToolWindow.HeaderTab.underlineHeight", DefaultTabs.underlineHeight());
            }

            @NotNull
            public static Font headerFont() {
                return JBFont.label();
            }

            public static float overrideHeaderFontSizeOffset() {
                Object offset = UIManager.get("ToolWindow.Header.font.size.offset");
                if (offset instanceof Integer) {
                    return ((Integer)offset).floatValue();
                }
                return 0.0f;
            }

            @NotNull
            public static Color hoveredIconBackground() {
                return JBColor.namedColor("ToolWindow.HeaderCloseButton.background", JBColor.namedColor("ToolWindow.header.closeButton.background", 0xB9B9B9));
            }

            @NotNull
            public static Icon closeTabIcon(boolean hovered) {
                return hovered ? JBUI.getIcon("ToolWindow.header.closeButton.hovered.icon", AllIcons.Actions.CloseHovered) : JBUI.getIcon("ToolWindow.header.closeButton.icon", AllIcons.Actions.Close);
            }

            @NotNull
            public static Icon comboTabIcon(boolean hovered) {
                return hovered ? JBUI.getIcon("ToolWindow.header.comboButton.hovered.icon", AllIcons.General.ArrowDown) : JBUI.getIcon("ToolWindow.header.comboButton.icon", AllIcons.General.ArrowDown);
            }
        }

        public static final class StatusBar {
            @NotNull
            public static Color hoverBackground() {
                return JBColor.namedColor("StatusBar.hoverBackground", ActionButton.hoverBackground());
            }
        }

        public static final class EditorTabs {
            @NotNull
            public static Color underlineColor() {
                return JBColor.namedColor("EditorTabs.underlineColor", DefaultTabs.underlineColor());
            }

            public static int underlineHeight() {
                return JBUI.getInt("EditorTabs.underlineHeight", DefaultTabs.underlineHeight());
            }

            @NotNull
            public static Color inactiveUnderlineColor() {
                return JBColor.namedColor("EditorTabs.inactiveUnderlineColor", DefaultTabs.inactiveUnderlineColor());
            }

            public static Color underlinedTabBackground() {
                return UIManager.getColor("EditorTabs.underlinedTabBackground");
            }

            @NotNull
            public static Color borderColor() {
                return JBColor.namedColor("EditorTabs.borderColor", DefaultTabs.borderColor());
            }

            @NotNull
            public static Color background() {
                return JBColor.namedColor("EditorTabs.background", DefaultTabs.background());
            }

            @NotNull
            public static Color hoverBackground() {
                return JBColor.namedColor("EditorTabs.hoverBackground", DefaultTabs.hoverBackground());
            }

            @NotNull
            public static Color inactiveColoredFileBackground() {
                return JBColor.namedColor("EditorTabs.inactiveColoredFileBackground", new JBColor(ColorUtil.withAlpha(Color.BLACK, 0.07), ColorUtil.withAlpha(new Color(3948353), 0.6)));
            }

            @NotNull
            public static Color underlinedTabForeground() {
                return JBColor.namedColor("EditorTabs.underlinedTabForeground", DefaultTabs.underlinedTabForeground());
            }
        }

        public static final class DebuggerTabs {
            public static int underlineHeight() {
                return JBUI.getInt("DebuggerTabs.underlineHeight", JBUIScale.scale(2));
            }

            public static Color underlinedTabBackground() {
                return UIManager.getColor("DebuggerTabs.underlinedTabBackground");
            }
        }

        public static final class DefaultTabs {
            @NotNull
            public static Color underlineColor() {
                return JBColor.namedColor("DefaultTabs.underlineColor", new JBColor(4228041, 4884679));
            }

            public static int underlineHeight() {
                return JBUI.getInt("DefaultTabs.underlineHeight", JBUIScale.scale(3));
            }

            @NotNull
            public static Color inactiveUnderlineColor() {
                return JBColor.namedColor("DefaultTabs.inactiveUnderlineColor", new JBColor(10266552, 7633536));
            }

            @NotNull
            public static Color borderColor() {
                return JBColor.namedColor("DefaultTabs.borderColor", UIUtil.CONTRAST_BORDER_COLOR);
            }

            @NotNull
            public static Color background() {
                return JBColor.namedColor("DefaultTabs.background", new JBColor(0xECECEC, 3948353));
            }

            @NotNull
            public static Color hoverBackground() {
                return JBColor.namedColor("DefaultTabs.hoverBackground", new JBColor(ColorUtil.withAlpha(Color.BLACK, 0.1), ColorUtil.withAlpha(Color.BLACK, 0.35)));
            }

            public static Color underlinedTabBackground() {
                return UIManager.getColor("DefaultTabs.underlinedTabBackground");
            }

            @NotNull
            public static Color underlinedTabForeground() {
                return JBColor.namedColor("DefaultTabs.underlinedTabForeground", UIUtil.getLabelForeground());
            }
        }

        public static final class CustomFrameDecorations {
            @NotNull
            public static Color separatorForeground() {
                return JBColor.namedColor("Separator.separatorColor", new JBColor(0xCDCDCD, 0x515151));
            }

            @NotNull
            public static Color titlePaneButtonHoverBackground() {
                return JBColor.namedColor("TitlePane.Button.hoverBackground", new JBColor(ColorUtil.withAlpha(Color.BLACK, 0.1), ColorUtil.withAlpha(Color.WHITE, 0.1)));
            }

            @NotNull
            public static Color titlePaneButtonPressBackground() {
                return CustomFrameDecorations.titlePaneButtonHoverBackground();
            }

            @NotNull
            public static Color titlePaneInactiveBackground() {
                return JBColor.namedColor("TitlePane.inactiveBackground", CustomFrameDecorations.titlePaneBackground());
            }

            @NotNull
            public static Color titlePaneBackground(boolean active) {
                return active ? CustomFrameDecorations.titlePaneBackground() : CustomFrameDecorations.titlePaneInactiveBackground();
            }

            @NotNull
            public static Color titlePaneBackground() {
                return JBColor.namedColor("TitlePane.background", CustomFrameDecorations.paneBackground());
            }

            @NotNull
            public static Color titlePaneInfoForeground() {
                return JBColor.namedColor("TitlePane.infoForeground", new JBColor(0x616161, 0x919191));
            }

            @NotNull
            public static Color titlePaneInactiveInfoForeground() {
                return JBColor.namedColor("TitlePane.inactiveInfoForeground", new JBColor(0xA6A6A6, 0x737373));
            }

            @NotNull
            public static Color paneBackground() {
                return JBColor.namedColor("Panel.background", Gray.xCD);
            }
        }

        public static final class ActionButton {
            @NotNull
            public static Color pressedBackground() {
                return JBColor.namedColor("ActionButton.pressedBackground", Gray.xCF);
            }

            @NotNull
            public static Color pressedBorder() {
                return JBColor.namedColor("ActionButton.pressedBorderColor", Gray.xCF);
            }

            @NotNull
            public static Color focusedBorder() {
                return JBColor.namedColor("ActionButton.focusedBorderColor", new JBColor(6469854, 6204624));
            }

            @NotNull
            public static Color hoverBackground() {
                return JBColor.namedColor("ActionButton.hoverBackground", Gray.xDF);
            }

            @NotNull
            public static Color hoverBorder() {
                return JBColor.namedColor("ActionButton.hoverBorderColor", Gray.xDF);
            }

            @NotNull
            public static Color hoverSeparatorColor() {
                return JBColor.namedColor("ActionButton.hoverSeparatorColor", new JBColor(Gray.xB3, Gray.x6B));
            }
        }
    }

    public static final class Panels {
        @NotNull
        public static BorderLayoutPanel simplePanel() {
            return new BorderLayoutPanel();
        }

        @NotNull
        public static BorderLayoutPanel simplePanel(Component comp) {
            return Panels.simplePanel().addToCenter(comp);
        }

        @NotNull
        public static BorderLayoutPanel simplePanel(int hgap, int vgap) {
            return new BorderLayoutPanel(hgap, vgap);
        }
    }

    public static final class Borders {
        @NotNull
        public static JBEmptyBorder empty(int top, int left, int bottom, int right) {
            if (top == 0 && left == 0 && bottom == 0 && right == 0) {
                return SHARED_EMPTY_INSTANCE;
            }
            return new JBEmptyBorder(top, left, bottom, right);
        }

        @NotNull
        public static JBEmptyBorder empty(int topAndBottom, int leftAndRight) {
            return Borders.empty(topAndBottom, leftAndRight, topAndBottom, leftAndRight);
        }

        @NotNull
        public static JBEmptyBorder emptyTop(int offset) {
            return Borders.empty(offset, 0, 0, 0);
        }

        @NotNull
        public static JBEmptyBorder emptyLeft(int offset) {
            return Borders.empty(0, offset, 0, 0);
        }

        @NotNull
        public static JBEmptyBorder emptyBottom(int offset) {
            return Borders.empty(0, 0, offset, 0);
        }

        @NotNull
        public static JBEmptyBorder emptyRight(int offset) {
            return Borders.empty(0, 0, 0, offset);
        }

        @NotNull
        public static JBEmptyBorder empty() {
            return Borders.empty(0, 0, 0, 0);
        }

        @NotNull
        public static Border empty(int offsets) {
            return Borders.empty(offsets, offsets, offsets, offsets);
        }

        @NotNull
        public static Border customLine(Color color, int top, int left, int bottom, int right) {
            return new CustomLineBorder(color, JBUI.insets(top, left, bottom, right));
        }

        @NotNull
        public static Border customLine(Color color, int thickness) {
            return Borders.customLine(color, thickness, thickness, thickness, thickness);
        }

        @NotNull
        public static Border customLine(Color color) {
            return Borders.customLine(color, 1);
        }

        @NotNull
        public static Border merge(@Nullable Border source, @NotNull Border extra, boolean extraIsOutside) {
            if (source == null) {
                return extra;
            }
            return new CompoundBorder(extraIsOutside ? extra : source, extraIsOutside ? source : extra);
        }
    }

    public static final class Fonts {
        @NotNull
        public static JBFont label() {
            return JBFont.label();
        }

        @NotNull
        public static JBFont label(float size) {
            return JBFont.label().deriveFont(JBUIScale.scale(size));
        }

        @NotNull
        public static JBFont smallFont() {
            return JBFont.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.SMALL));
        }

        @NotNull
        public static JBFont miniFont() {
            return JBFont.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.MINI));
        }

        @NotNull
        public static JBFont create(String fontFamily, int size) {
            return JBFont.create(new Font(fontFamily, 0, size));
        }

        @NotNull
        public static JBFont toolbarFont() {
            return SystemInfo.isMac ? Fonts.smallFont() : JBFont.label();
        }

        @NotNull
        public static JBFont toolbarSmallComboBoxFont() {
            return Fonts.label(11.0f);
        }
    }
}

