/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class JBSwingUtilities {
    private static final List<BiFunction<? super JComponent, ? super Graphics2D, ? extends Graphics2D>> ourGlobalTransform = new CopyOnWriteArrayList(Collections.emptyList());

    @Deprecated
    public static boolean isLeftMouseButton(MouseEvent anEvent) {
        return SwingUtilities.isLeftMouseButton(anEvent);
    }

    @Deprecated
    public static boolean isRightMouseButton(MouseEvent anEvent) {
        return SwingUtilities.isRightMouseButton(anEvent);
    }

    public static Disposable addGlobalCGTransform(final @NotNull BiFunction<? super JComponent, ? super Graphics2D, ? extends Graphics2D> fun) {
        ourGlobalTransform.add(fun);
        return new Disposable(){

            public void dispose() {
                ourGlobalTransform.remove(fun);
            }
        };
    }

    @NotNull
    public static Graphics2D runGlobalCGTransform(@NotNull JComponent c, @NotNull Graphics g) {
        Graphics2D gg = (Graphics2D)g;
        for (BiFunction<? super JComponent, ? super Graphics2D, ? extends Graphics2D> transform : ourGlobalTransform) {
            gg = Objects.requireNonNull(transform.apply(c, gg));
        }
        return gg;
    }
}

