/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.scale.JBUIScale;
import java.awt.Font;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;

public class JBFont
extends Font {
    JBFont(@NotNull Font font) {
        super(font);
    }

    @NotNull
    public static JBFont label() {
        return JBFont.create(UIManager.getFont("Label.font"), false);
    }

    public static JBFont create(Font font) {
        return JBFont.create(font, true);
    }

    @NotNull
    public static JBFont create(@NotNull Font font, boolean tryToScale) {
        if (font instanceof JBFont) {
            return (JBFont)font;
        }
        Font scaled = font;
        if (tryToScale) {
            scaled = font.deriveFont((float)font.getSize() * JBUIScale.scale(1.0f));
        }
        if (font instanceof UIResource) {
            return new JBFontUIResource(scaled);
        }
        return new JBFont(scaled);
    }

    public JBFont asBold() {
        return this.deriveFont(1, this.getSize());
    }

    public JBFont asItalic() {
        return this.deriveFont(2, this.getSize());
    }

    public JBFont asPlain() {
        return this.deriveFont(0, this.getSize());
    }

    @Override
    public JBFont deriveFont(int style, float size) {
        Font font = super.deriveFont(style, size);
        return this instanceof JBFontUIResource ? new JBFontUIResource(font) : new JBFont(font);
    }

    @Override
    public JBFont deriveFont(float size) {
        return this.deriveFont(this.getStyle(), size);
    }

    public JBFont biggerOn(float size) {
        return this.deriveFont((float)this.getSize() + JBUIScale.scale(size));
    }

    public JBFont lessOn(float size) {
        return this.deriveFont((float)this.getSize() - JBUIScale.scale(size));
    }

    static final class JBFontUIResource
    extends JBFont
    implements UIResource {
        JBFontUIResource(Font font) {
            super(font);
        }
    }
}

