/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.EventQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class EDT {
    private static Thread myEventDispatchThread = null;

    private EDT() {
    }

    @ApiStatus.Internal
    public static void updateEdt() {
        myEventDispatchThread = Thread.currentThread();
    }

    @ApiStatus.Internal
    public static boolean isEdt(@NotNull Thread thread) {
        return thread == myEventDispatchThread;
    }

    public static boolean isCurrentThreadEdt() {
        if (myEventDispatchThread == null) {
            return EventQueue.isDispatchThread();
        }
        return EDT.isEdt(Thread.currentThread());
    }

    public static void assertIsEdt() {
        if (!EDT.isCurrentThreadEdt()) {
            Logger.getInstance(EDT.class).error("Assert: must be called on EDT");
        }
    }
}

