/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ImageLoader;
import com.intellij.util.containers.ContainerUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SVGLoaderCacheIO {
    private static final Set<OpenOption> OPEN_OPTION_SET = ContainerUtil.set((Object[])new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE});

    @Nullable
    @ApiStatus.Internal
    public static BufferedImage readImageFile(byte @NotNull [] bytes, @NotNull ImageLoader.Dimension2DDouble docSize) {
        ByteBuffer buff = ByteBuffer.wrap(bytes);
        double width = buff.getDouble();
        double height = buff.getDouble();
        int actualWidth = buff.getInt();
        int actualHeight = buff.getInt();
        if (actualWidth <= 0 || actualHeight <= 0 || actualWidth * actualHeight <= 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(actualWidth, actualHeight, 2);
        for (int y = 0; y < actualHeight; ++y) {
            for (int x = 0; x < actualWidth; ++x) {
                image.setRGB(x, y, buff.getInt());
            }
        }
        docSize.setSize(width, height);
        return image;
    }

    @ApiStatus.Internal
    public static void writeImageFile(@NotNull Path file, @NotNull BufferedImage image, @NotNull ImageLoader.Dimension2DDouble size) throws IOException {
        int actualWidth = image.getWidth();
        int actualHeight = image.getHeight();
        ByteBuffer buff = ByteBuffer.allocate(actualHeight * actualWidth * 4 + 16 + 8);
        buff.putDouble(size.getWidth());
        buff.putDouble(size.getHeight());
        buff.putInt(actualWidth);
        buff.putInt(actualHeight);
        for (int y = 0; y < actualHeight; ++y) {
            for (int x = 0; x < actualWidth; ++x) {
                buff.putInt(image.getRGB(x, y));
            }
        }
        buff.flip();
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Path tmpFile = file.resolve(file + ".tmp" + System.currentTimeMillis());
        try {
            try (SeekableByteChannel channel = Files.newByteChannel(tmpFile, OPEN_OPTION_SET, new FileAttribute[0]);){
                channel.write(buff);
            }
            try {
                Files.move(tmpFile, file, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(tmpFile, file, new CopyOption[0]);
            }
        }
        catch (FileAlreadyExistsException e) {
        }
        catch (Exception e) {
            SVGLoaderCacheIO.deleteQuietly(file);
            throw e;
        }
        finally {
            SVGLoaderCacheIO.deleteQuietly(tmpFile);
        }
    }

    private static void deleteQuietly(@NotNull Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

