/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.ImageType;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.BitUtil;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageLoader
implements Serializable {
    public static final int ALLOW_FLOAT_SCALING = 1;
    public static final byte USE_CACHE = 2;
    public static final int DARK = 4;
    public static final int FIND_SVG = 8;
    public static final long CACHED_IMAGE_MAX_SIZE = (long)(SystemProperties.getFloatProperty((String)"ide.cached.image.max.size", (float)1.5f) * 1024.0f * 1024.0f);
    private static LoadFunction measureLoad;
    public static final Component ourComponent;

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance((String)"#com.intellij.util.ImageLoader");
    }

    public static void clearCache() {
        ImageDescriptorList.IO_MISS_CACHE.clear();
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url) {
        return ImageLoader.loadFromUrl(url, true);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling) {
        return ImageLoader.loadFromUrl(url, allowFloatScaling, true, new ImageFilter[]{null}, ScaleContext.create());
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling, boolean useCache, ImageFilter[] filters, ScaleContext ctx) {
        int flags = 8;
        if (allowFloatScaling) {
            flags |= 1;
        }
        if (useCache) {
            flags |= 2;
        }
        if (StartupUiUtil.isUnderDarcula()) {
            flags |= 4;
        }
        return ImageLoader.loadFromUrl(url, null, flags, filters, ctx);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, @Nullable Class aClass, int flags, ImageFilter @Nullable [] filters, ScaleContext scaleContext) {
        return ImageLoader.loadFromUrl(url.toString(), aClass, flags, filters, scaleContext);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull String path, @Nullable Class aClass, final int flags, ImageFilter @Nullable [] filters, final ScaleContext scaleContext) {
        return ImageDescriptorList.create(path, flags, scaleContext).load(ImageConverterChain.create().withFilter(filters).with(new ImageConverter(){

            @Override
            public Image convert(Image source, ImageDescriptor desc) {
                if (source != null && desc.type != ImageType.SVG) {
                    double scale = ImageLoader.adjustScaleFactor(BitUtil.isSet((int)flags, (int)1), scaleContext.getScale(DerivedScaleType.PIX_SCALE));
                    if (desc.scale > 1.0) {
                        scale /= desc.scale;
                    }
                    source = ImageLoader.scaleImage(source, scale);
                }
                return source;
            }
        }).withHiDPI(scaleContext), BitUtil.isSet((int)flags, (int)2), aClass);
    }

    private static double adjustScaleFactor(boolean allowFloatScaling, double scale) {
        return allowFloatScaling ? scale : (JBUIScale.isHiDPI(scale) ? 2.0 : 1.0);
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, double scale) {
        if (scale == 1.0) {
            return image;
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).scale(scale);
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            return image;
        }
        int width = (int)Math.round(scale * (double)w);
        int height = (int)Math.round(scale * (double)h);
        return Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])null);
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, int targetSize) {
        return ImageLoader.scaleImage(image, targetSize, targetSize);
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, int targetWidth, int targetHeight) {
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).scale(targetWidth, targetHeight);
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0 || w == targetWidth && h == targetHeight) {
            return image;
        }
        return Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])null);
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String s) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return null;
        }
        return ImageLoader.loadFromResource(s, callerClass);
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String path, @NotNull Class aClass) {
        ScaleContext scaleContext = ScaleContext.create();
        int flags = 9;
        if (StartupUiUtil.isUnderDarcula()) {
            flags |= 4;
        }
        return ImageDescriptorList.create(path, flags, scaleContext).load(ImageConverterChain.create().withHiDPI(scaleContext), true, aClass);
    }

    public static Image loadFromBytes(byte @NotNull [] bytes) {
        return ImageLoader.loadFromStream(new ByteArrayInputStream(bytes));
    }

    public static Image loadFromStream(@NotNull InputStream inputStream) {
        return ImageLoader.loadFromStream(inputStream, ScaleContext.create(), null);
    }

    @Deprecated
    public static Image loadFromStream(@NotNull InputStream inputStream, int scale) {
        return ImageLoader.loadFromStream(inputStream, ScaleContext.create(ScaleType.OBJ_SCALE.of(scale)), null);
    }

    @Deprecated
    public static Image loadFromStream(@NotNull InputStream inputStream, int scale, ImageFilter filter) {
        return ImageLoader.loadFromStream(inputStream, ScaleContext.create(ScaleType.OBJ_SCALE.of(scale)), filter);
    }

    public static Image loadFromStream(@NotNull InputStream inputStream, @NotNull ScaleContext ctx, ImageFilter filter) {
        try {
            ImageDescriptor desc = new ImageDescriptor(ctx.getScale(DerivedScaleType.PIX_SCALE));
            Image image = desc.loadFromStream(inputStream, null, null);
            return ImageConverterChain.create().withFilter(filter).withHiDPI(ctx).convert(image, desc);
        }
        catch (IOException ex) {
            ImageLoader.getLogger().error((Throwable)ex);
            return null;
        }
    }

    @Nullable
    public static Image loadCustomIcon(@NotNull File f) throws IOException {
        Image icon = ImageLoader._loadImageFromFile(f);
        if (icon == null) {
            return null;
        }
        int w = icon.getWidth(null);
        int h = icon.getHeight(null);
        if (w <= 0 || h <= 0) {
            ImageLoader.getLogger().error("negative image size: w=" + w + ", h=" + h + ", path=" + f.getPath());
            return null;
        }
        if (w > EmptyIcon.ICON_18.getIconWidth() || h > EmptyIcon.ICON_18.getIconHeight()) {
            double s = (double)EmptyIcon.ICON_18.getIconWidth() / (double)Math.max(w, h);
            return ImageLoader.scaleImage(icon, s);
        }
        return icon;
    }

    @Nullable
    private static Image _loadImageFromFile(@NotNull File f) throws IOException {
        ScaleContext ctx = ScaleContext.create();
        double scale = ctx.getScale(DerivedScaleType.PIX_SCALE);
        ImageDescriptor desc = new ImageDescriptor(f.toURI().toURL().toString(), scale, StringUtilRt.endsWithIgnoreCase((CharSequence)f.getPath(), (CharSequence)".svg") ? ImageType.SVG : ImageType.IMG);
        return ImageUtil.ensureHiDPI(desc.load(true), ctx);
    }

    static {
        ourComponent = new Component(){};
    }

    private static final class ImageConverterChain
    extends ArrayList<ImageConverter> {
        private ImageConverterChain() {
        }

        public static ImageConverterChain create() {
            return new ImageConverterChain();
        }

        ImageConverterChain withFilter(ImageFilter @Nullable [] filters) {
            if (filters == null) {
                return this;
            }
            ImageConverterChain chain = this;
            for (ImageFilter filter : filters) {
                chain = chain.withFilter(filter);
            }
            return chain;
        }

        ImageConverterChain withFilter(final ImageFilter filter) {
            if (filter == null) {
                return this;
            }
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDescriptor desc) {
                    return ImageUtil.filter(source, filter);
                }
            });
        }

        ImageConverterChain withHiDPI(final ScaleContext ctx) {
            if (ctx == null) {
                return this;
            }
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDescriptor desc) {
                    double usrScale = ctx.getScale(DerivedScaleType.EFF_USR_SCALE);
                    return ImageUtil.ensureHiDPI(source, ctx, desc.origUsrSize.getWidth() * usrScale, desc.origUsrSize.getHeight() * usrScale);
                }
            });
        }

        public ImageConverterChain with(ImageConverter f) {
            this.add(f);
            return this;
        }

        public Image convert(Image image, ImageDescriptor desc) {
            for (ImageConverter f : this) {
                image = f.convert(image, desc);
            }
            return image;
        }
    }

    private static interface ImageConverter {
        public Image convert(@Nullable Image var1, ImageDescriptor var2);
    }

    public static final class ImageDescriptorList {
        private static final Set<String> IO_MISS_CACHE = ContainerUtil.newConcurrentSet();
        private final List<ImageDescriptor> list;
        private final String name;
        private final ImageType type;

        private ImageDescriptorList(@NotNull List<ImageDescriptor> list, @NotNull String name, @NotNull ImageType type) {
            this.list = list;
            this.name = name;
            this.type = type;
        }

        @NotNull
        public @NotNull List<@NotNull ImageDescriptor> getDescriptors() {
            return this.list;
        }

        @Nullable
        public Image load() {
            return this.load(ImageConverterChain.create());
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters) {
            return this.load(converters, true, null);
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters, boolean useCache, @Nullable Class<?> resourceClass) {
            String cacheKey = this.name + "." + this.type.name();
            if (IO_MISS_CACHE.contains(cacheKey)) {
                return null;
            }
            long start = StartUpMeasurer.isEnabled() ? StartUpMeasurer.getCurrentTime() : -1L;
            boolean ioExceptionThrown = false;
            Image result = null;
            for (ImageDescriptor descriptor : this.list) {
                try {
                    Image image = descriptor.load(useCache, resourceClass);
                    if (image == null) continue;
                    ImageLoader.getLogger().debug("Loaded image: " + descriptor);
                    result = converters.convert(image, descriptor);
                    if (start == -1L) break;
                    IconLoadMeasurer.addLoading(descriptor.type, (int)(StartUpMeasurer.getCurrentTime() - start));
                    break;
                }
                catch (IOException e) {
                    ioExceptionThrown = true;
                }
            }
            if (result == null && ioExceptionThrown) {
                IO_MISS_CACHE.add(cacheKey);
            }
            return result;
        }

        @NotNull
        public static ImageDescriptorList create(@NotNull String path, int flags, @NotNull ScaleContext scaleContext) {
            double pixScale = scaleContext.getScale(DerivedScaleType.PIX_SCALE);
            boolean retina = JBUIScale.isHiDPI(pixScale);
            ImageDescriptorListBuilder builder = new ImageDescriptorListBuilder(FileUtilRt.getNameWithoutExtension((String)path), FileUtilRt.getExtension((String)path), BitUtil.isSet((int)flags, (int)8), ImageLoader.adjustScaleFactor(BitUtil.isSet((int)flags, (int)1), pixScale));
            boolean isDark = BitUtil.isSet((int)flags, (int)4);
            if (!path.startsWith("file:") && path.contains("://")) {
                builder.add(StringUtilRt.endsWithIgnoreCase((CharSequence)StringUtil.substringBeforeLast((String)path, (String)"?"), (CharSequence)".svg") ? ImageType.SVG : ImageType.IMG);
            } else if (retina && isDark) {
                builder.add(true, true);
                builder.add(true, false);
            } else if (isDark) {
                builder.add(false, true);
                builder.add(false, false);
            } else if (retina) {
                builder.add(true, false);
            } else {
                builder.add(false, false);
            }
            return builder.build();
        }
    }

    @ApiStatus.Internal
    public static final class ImageDescriptorListBuilder {
        private final List<ImageDescriptor> list = new SmartList();
        final String name;
        final String ext;
        final boolean svg;
        final double scale;

        ImageDescriptorListBuilder(String name, String ext, boolean svg, double scale) {
            this.name = name;
            this.ext = ext;
            this.svg = svg;
            this.scale = scale;
        }

        void add(boolean retina, boolean dark) {
            if (this.svg) {
                this.add(retina, dark, ImageType.SVG);
            }
            this.add(retina, dark, ImageType.IMG);
        }

        void add(boolean retina, boolean dark, ImageType type) {
            String _ext;
            String string = _ext = ImageType.SVG == type ? "svg" : this.ext;
            double _scale = ImageType.SVG == type ? this.scale : (retina ? 2.0 : 1.0);
            this.list.add(new ImageDescriptor(this.name + (dark ? "_dark" : "") + (retina ? "@2x" : "") + "." + _ext, _scale, type));
            if (retina && dark) {
                this.list.add(new ImageDescriptor(this.name + "@2x_dark." + _ext, _scale, type));
            }
            if (retina) {
                this.list.add(new ImageDescriptor(this.name + (dark ? "_dark" : "") + "." + _ext, ImageType.SVG == type ? this.scale : 1.0, type));
            }
        }

        void add(ImageType type) {
            this.list.add(new ImageDescriptor(this.name + "." + this.ext, 1.0, type, true));
        }

        @NotNull
        ImageDescriptorList build() {
            return new ImageDescriptorList(this.list, this.name, this.svg ? ImageType.SVG : ImageType.IMG);
        }
    }

    public static final class Dimension2DDouble {
        private double myWidth;
        private double myHeight;

        public Dimension2DDouble(double width, double height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public void setSize(Dimension2DDouble size) {
            this.myWidth = size.myWidth;
            this.myHeight = size.myHeight;
        }

        public void setSize(double width, double height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public double getWidth() {
            return this.myWidth;
        }

        public double getHeight() {
            return this.myHeight;
        }
    }

    @ApiStatus.Internal
    public static interface LoadFunction {
        public Image load(@Nullable LoadFunction var1, @NotNull ImageType var2) throws IOException;
    }
}

