/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.render;

import com.intellij.openapi.util.Key;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class RenderingUtil {
    public static final Key<Boolean> ALWAYS_PAINT_SELECTION_AS_FOCUSED = Key.create((String)"ALWAYS_PAINT_SELECTION_AS_FOCUSED");
    @ApiStatus.Internal
    public static final Key<JComponent> FOCUSABLE_SIBLING = Key.create((String)"FOCUSABLE_SIBLING");
    @ApiStatus.Internal
    public static final Key<Supplier<Color>> CUSTOM_SELECTION_BACKGROUND = Key.create((String)"CUSTOM_SELECTION_BACKGROUND");

    @NotNull
    public static Color getBackground(@NotNull JList<?> list, boolean selected) {
        return selected ? RenderingUtil.getSelectionBackground(list) : RenderingUtil.getBackground(list);
    }

    @NotNull
    public static Color getBackground(@NotNull JTable table, boolean selected) {
        return selected ? RenderingUtil.getSelectionBackground(table) : RenderingUtil.getBackground(table);
    }

    @NotNull
    public static Color getBackground(@NotNull JTree tree, boolean selected) {
        return selected ? RenderingUtil.getSelectionBackground(tree) : RenderingUtil.getBackground(tree);
    }

    @NotNull
    public static Color getBackground(@NotNull JList<?> list) {
        Color background = list.getBackground();
        return background != null ? background : UIUtil.getListBackground();
    }

    @NotNull
    public static Color getBackground(@NotNull JTable table) {
        Color background = table.getBackground();
        return background != null ? background : UIUtil.getTableBackground();
    }

    @NotNull
    public static Color getBackground(@NotNull JTree tree) {
        JTable table = RenderingUtil.getTableFor(tree);
        if (table != null) {
            return RenderingUtil.getBackground(table);
        }
        Color background = tree.getBackground();
        return background != null ? background : UIUtil.getTreeBackground();
    }

    @NotNull
    public static Color getSelectionBackground(@NotNull JList<?> list) {
        Color background = RenderingUtil.getCustomSelectionBackground(list);
        return background != null ? background : UIUtil.getListSelectionBackground(RenderingUtil.isFocused(list));
    }

    @NotNull
    public static Color getSelectionBackground(@NotNull JTable table) {
        Color background = RenderingUtil.getCustomSelectionBackground(table);
        return background != null ? background : UIUtil.getTableSelectionBackground(RenderingUtil.isFocused(table));
    }

    @NotNull
    public static Color getSelectionBackground(@NotNull JTree tree) {
        JTable table = RenderingUtil.getTableFor(tree);
        if (table != null) {
            return RenderingUtil.getSelectionBackground(table);
        }
        Color background = RenderingUtil.getCustomSelectionBackground(tree);
        return background != null ? background : UIUtil.getTreeSelectionBackground(RenderingUtil.isFocused(tree));
    }

    @NotNull
    public static Color getForeground(@NotNull JList<?> list, boolean selected) {
        return selected ? RenderingUtil.getSelectionForeground(list) : RenderingUtil.getForeground(list);
    }

    @NotNull
    public static Color getForeground(@NotNull JTable table, boolean selected) {
        return selected ? RenderingUtil.getSelectionForeground(table) : RenderingUtil.getForeground(table);
    }

    @NotNull
    public static Color getForeground(@NotNull JTree tree, boolean selected) {
        return selected ? RenderingUtil.getSelectionForeground(tree) : RenderingUtil.getForeground(tree);
    }

    @NotNull
    public static Color getForeground(@NotNull JList<?> list) {
        Color foreground = list.getForeground();
        return foreground != null ? foreground : UIUtil.getListForeground();
    }

    @NotNull
    public static Color getForeground(@NotNull JTable table) {
        Color foreground = table.getForeground();
        return foreground != null ? foreground : UIUtil.getTableForeground();
    }

    @NotNull
    public static Color getForeground(@NotNull JTree tree) {
        JTable table = RenderingUtil.getTableFor(tree);
        if (table != null) {
            return RenderingUtil.getForeground(table);
        }
        Color foreground = tree.getForeground();
        return foreground != null ? foreground : UIUtil.getTreeForeground();
    }

    @NotNull
    public static Color getSelectionForeground(@NotNull JList<?> list) {
        return UIUtil.getListSelectionForeground(RenderingUtil.isFocused(list));
    }

    @NotNull
    public static Color getSelectionForeground(@NotNull JTable table) {
        return UIUtil.getTableSelectionForeground(RenderingUtil.isFocused(table));
    }

    @NotNull
    public static Color getSelectionForeground(@NotNull JTree tree) {
        JTable table = RenderingUtil.getTableFor(tree);
        if (table != null) {
            return RenderingUtil.getSelectionForeground(table);
        }
        return UIUtil.getTreeSelectionForeground(RenderingUtil.isFocused(tree));
    }

    public static boolean isFocused(@NotNull JComponent component) {
        if (RenderingUtil.isFocusedImpl(component)) {
            return true;
        }
        JComponent sibling = UIUtil.getClientProperty((Object)component, FOCUSABLE_SIBLING);
        return sibling != null && RenderingUtil.isFocusedImpl(sibling);
    }

    private static boolean isFocusedImpl(@NotNull JComponent component) {
        return component.hasFocus() || UIUtil.isClientPropertyTrue(component, ALWAYS_PAINT_SELECTION_AS_FOCUSED);
    }

    private static JTable getTableFor(@NotNull JTree tree) {
        Object property = tree.getClientProperty("TreeTableTree");
        if (property instanceof JTable) {
            return (JTable)property;
        }
        JComponent sibling = UIUtil.getClientProperty((Object)tree, FOCUSABLE_SIBLING);
        return sibling instanceof JTable ? (JTable)sibling : null;
    }

    private static Color getCustomSelectionBackground(@NotNull JComponent component) {
        Supplier<Color> supplier = UIUtil.getClientProperty((Object)component, CUSTOM_SELECTION_BACKGROUND);
        return supplier == null ? null : supplier.get();
    }
}

