/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class ClickListener {
    private static final int EPS = 4;
    private MouseAdapter myListener;

    public abstract boolean onClick(@NotNull MouseEvent var1, int var2);

    public void installOn(@NotNull Component c) {
        this.installOn(c, false);
    }

    public void installOn(@NotNull Component c, final boolean allowDragWhileClicking) {
        this.myListener = new MouseAdapter(){
            private Point pressPoint;
            private Point lastClickPoint;
            private long lastTimeClicked = -1L;
            private int clickCount = 0;

            @Override
            public void mousePressed(MouseEvent e) {
                Point point = e.getPoint();
                SwingUtilities.convertPointToScreen(point, e.getComponent());
                if (Math.abs(this.lastTimeClicked - e.getWhen()) > (long)UIUtil.getMultiClickInterval() || this.lastClickPoint != null && !ClickListener.isWithinEps(this.lastClickPoint, point)) {
                    this.clickCount = 0;
                    this.lastClickPoint = null;
                }
                ++this.clickCount;
                this.lastTimeClicked = e.getWhen();
                if (!e.isPopupTrigger()) {
                    this.pressPoint = point;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Point clickedAt;
                Point releasedAt = e.getPoint();
                SwingUtilities.convertPointToScreen(releasedAt, e.getComponent());
                this.lastClickPoint = clickedAt = this.pressPoint;
                this.pressPoint = null;
                if (e.isConsumed() || clickedAt == null || e.isPopupTrigger() || !e.getComponent().contains(e.getPoint())) {
                    return;
                }
                if ((allowDragWhileClicking || ClickListener.isWithinEps(releasedAt, clickedAt)) && ClickListener.this.onClick(e, this.clickCount)) {
                    e.consume();
                }
            }
        };
        c.addMouseListener(this.myListener);
    }

    private static boolean isWithinEps(Point releasedAt, Point clickedAt) {
        return Math.abs(clickedAt.x - releasedAt.x) < 4 && Math.abs(clickedAt.y - releasedAt.y) < 4;
    }

    public void uninstall(Component c) {
        c.removeMouseListener(this.myListener);
    }
}

