/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.DeprecatedDuplicatesIconPathPatcher;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.icons.DarkIconProvider;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.LazyImageIcon;
import com.intellij.ui.icons.MenuBarIconProvider;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextSupport;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.MultiResolutionImageProvider;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance(IconLoader.class);
    private static final String ICON_CACHE_URL_KEY = "ICON_CACHE_URL_KEY";
    private static final ConcurrentMap<Pair<String, Object>, CachedImageIcon> ourIconsCache = ContainerUtil.newConcurrentMap((int)100, (float)0.9f, (int)2);
    private static final ConcurrentMap<Icon, Icon> ourIcon2DisabledIcon = CollectionFactory.createConcurrentWeakMap((int)200, (float)0.75f, (int)Math.min(Runtime.getRuntime().availableProcessors(), 4));
    private static volatile boolean STRICT_GLOBAL;
    private static final ThreadLocal<Boolean> STRICT_LOCAL;
    private static final AtomicReference<IconTransform> ourTransform;
    private static final AtomicInteger ourTransformModCount;
    private static final ImageIcon EMPTY_ICON;
    private static boolean ourIsActivated;

    private IconLoader() {
    }

    public static <T, E extends Throwable> T performStrictly(ThrowableComputable<T, E> computable) throws E {
        STRICT_LOCAL.set(true);
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            STRICT_LOCAL.set(false);
        }
    }

    public static void setStrictGlobally(boolean strict) {
        STRICT_GLOBAL = strict;
    }

    private static void updateTransform(@NotNull Function<? super IconTransform, IconTransform> updater) {
        IconTransform next;
        IconTransform prev;
        while (!ourTransform.compareAndSet(prev = ourTransform.get(), next = updater.apply(prev))) {
        }
        ourTransformModCount.incrementAndGet();
        if (prev != next) {
            ourIcon2DisabledIcon.clear();
            ImageDescriptor.clearCache();
        }
    }

    public static void installPathPatcher(@NotNull IconPathPatcher patcher) {
        IconLoader.updateTransform(transform -> transform.withPathPatcher(patcher));
    }

    public static void removePathPatcher(@NotNull IconPathPatcher patcher) {
        IconLoader.updateTransform(transform -> transform.withoutPathPatcher(patcher));
    }

    @Deprecated
    @NotNull
    public static Icon getIcon(@NotNull Image image) {
        return new JBImageIcon(image);
    }

    public static void setUseDarkIcons(boolean useDarkIcons) {
        IconLoader.updateTransform(transform -> transform.withDark(useDarkIcons));
    }

    public static void setFilter(ImageFilter filter) {
        IconLoader.updateTransform(transform -> transform.withFilter(filter));
    }

    public static void clearCache() {
        IconLoader.updateTransform(IconTransform::copy);
    }

    @NotNull
    public static Icon getIcon(@NonNls @NotNull String path) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        assert (callerClass != null) : path;
        return IconLoader.getIcon(path, callerClass);
    }

    @Nullable
    public static Icon getReflectiveIcon(@NotNull String path, ClassLoader classLoader) {
        try {
            String packageName = path.startsWith("AllIcons.") ? "com.intellij.icons." : "icons.";
            Class<?> aClass = Class.forName(packageName + path.substring(0, path.lastIndexOf(46)).replace('.', '$'), true, classLoader);
            Field field = aClass.getField(path.substring(path.lastIndexOf(46) + 1));
            field.setAccessible(true);
            return (Icon)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Icon findIcon(@NonNls @NotNull String path) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return null;
        }
        return IconLoader.findIcon(path, callerClass);
    }

    @Nullable
    public static Icon findIcon(@NonNls @NotNull String path, boolean strict) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return null;
        }
        return IconLoader.findIcon(path, callerClass, false, strict);
    }

    @NotNull
    public static Icon getIcon(@NotNull String path, @NotNull Class<?> aClass) {
        Icon icon = IconLoader.findIcon(path, aClass, aClass.getClassLoader(), CachedImageIcon.HandleNotFound.strict(STRICT_LOCAL.get()), true);
        if (icon == null) {
            LOG.error("Icon cannot be found in '" + path + "', aClass='" + aClass + "'");
        }
        return icon;
    }

    public static void activate() {
        ourIsActivated = true;
    }

    public static void deactivate() {
        ourIsActivated = false;
    }

    private static boolean isLoaderDisabled() {
        return !ourIsActivated;
    }

    @Nullable
    public static Icon findLafIcon(@NotNull String key, @NotNull Class<?> aClass, boolean strict) {
        return IconLoader.findIcon(key + ".png", aClass, true, strict);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class<?> aClass) {
        return IconLoader.findIcon(path, aClass, aClass.getClassLoader(), CachedImageIcon.HandleNotFound.strict(STRICT_LOCAL.get()), false);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class<?> aClass, boolean computeNow) {
        return IconLoader.findIcon(path, aClass, computeNow, STRICT_LOCAL.get());
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class<?> aClass, boolean computeNow, boolean strict) {
        return IconLoader.findIcon(path, aClass, aClass.getClassLoader(), CachedImageIcon.HandleNotFound.strict(strict), false);
    }

    private static boolean isReflectivePath(@NotNull String path) {
        if (path.isEmpty() || path.charAt(0) == '/') {
            return false;
        }
        int dotIndex = path.indexOf(46);
        if (dotIndex < 0) {
            return false;
        }
        int suffixLength = "Icons".length();
        return path.regionMatches(dotIndex - suffixLength, "Icons", 0, suffixLength);
    }

    @Nullable
    public static Icon findIcon(URL url) {
        return IconLoader.findIcon(url, true);
    }

    @Nullable
    public static Icon findIcon(URL url, boolean useCache) {
        if (url == null) {
            return null;
        }
        Pair key = Pair.create((Object)ICON_CACHE_URL_KEY, (Object)url);
        CachedImageIcon icon = (CachedImageIcon)ourIconsCache.get(key);
        if (icon == null) {
            icon = new CachedImageIcon(url, useCache);
            if (useCache) {
                icon = (CachedImageIcon)ConcurrencyUtil.cacheOrGet(ourIconsCache, (Object)key, (Object)icon);
            }
        }
        return icon;
    }

    @Nullable
    private static Icon findIcon(@NotNull String originalPath, @Nullable Class<?> clazz, @NotNull ClassLoader classLoader, @NotNull CachedImageIcon.HandleNotFound handleNotFound, boolean deferUrlResolve) {
        long start = StartUpMeasurer.isEnabled() ? StartUpMeasurer.getCurrentTime() : -1L;
        Icon icon = IconLoader.findIconImpl(originalPath, clazz, classLoader, handleNotFound, deferUrlResolve);
        if (start != -1L) {
            IconLoadMeasurer.addFindIcon(StartUpMeasurer.getCurrentTime() - start);
        }
        return icon;
    }

    @Nullable
    private static Icon findIconImpl(@NotNull String originalPath, @Nullable Class<?> clazz, @NotNull ClassLoader classLoader, @NotNull CachedImageIcon.HandleNotFound handleNotFound, boolean deferUrlResolve) {
        Pair<String, ClassLoader> patchedPath = ourTransform.get().patchPath(originalPath, classLoader);
        String path = (String)patchedPath.first;
        if (patchedPath.second != null) {
            classLoader = (ClassLoader)patchedPath.second;
        }
        if (IconLoader.isReflectivePath(path)) {
            return IconLoader.getReflectiveIcon(path, classLoader);
        }
        Pair key = Pair.create((Object)originalPath, (Object)classLoader);
        CachedImageIcon cachedIcon = (CachedImageIcon)ourIconsCache.get(key);
        if (cachedIcon == null) {
            cachedIcon = CachedImageIcon.create(originalPath, path, classLoader, clazz, handleNotFound, deferUrlResolve);
            if (cachedIcon == null) {
                return null;
            }
            cachedIcon = (CachedImageIcon)ConcurrencyUtil.cacheOrGet(ourIconsCache, (Object)key, (Object)cachedIcon);
        } else {
            ScaleContext scaleContext = ScaleContext.create();
            if (!((ScaleContext)cachedIcon.getScaleContext()).equals(scaleContext)) {
                cachedIcon = cachedIcon.copy();
                cachedIcon.updateScaleContext(scaleContext);
            }
        }
        return cachedIcon;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        return IconLoader.findIcon(path, null, classLoader, CachedImageIcon.HandleNotFound.strict(false), false);
    }

    @Nullable
    public static Image toImage(@NotNull Icon icon) {
        return IconLoader.toImage(icon, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Image toImage(@NotNull Icon icon, @Nullable ScaleContext ctx) {
        BufferedImage image;
        if (icon instanceof RetrievableIcon) {
            icon = IconLoader.getOrigin((RetrievableIcon)icon);
        }
        if (icon instanceof CachedImageIcon) {
            icon = ((CachedImageIcon)icon).getRealIcon(ctx);
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        if (icon.getIconWidth() <= 0 || icon.getIconHeight() <= 0) {
            return null;
        }
        if (GraphicsEnvironment.isHeadless()) {
            image = UIUtil.createImage(ctx, (double)icon.getIconWidth(), (double)icon.getIconHeight(), 2, PaintUtil.RoundingMode.ROUND);
        } else {
            if (ctx == null) {
                ctx = ScaleContext.create();
            }
            image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(PaintUtil.RoundingMode.ROUND.round(ctx.apply((double)icon.getIconWidth(), DerivedScaleType.DEV_SCALE)), PaintUtil.RoundingMode.ROUND.round(ctx.apply((double)icon.getIconHeight(), DerivedScaleType.DEV_SCALE)), 3);
            if (StartupUiUtil.isJreHiDPI(ctx)) {
                image = (BufferedImage)ImageUtil.ensureHiDPI(image, ctx, icon.getIconWidth(), icon.getIconHeight());
            }
        }
        Graphics2D g = image.createGraphics();
        try {
            icon.paintIcon(null, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="null, _, _->null; !null, _, _->!null")
    public static Icon copy(final @Nullable Icon icon, @Nullable Component ancestor, boolean deepCopy) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof CopyableIcon) {
            return deepCopy ? ((CopyableIcon)icon).deepCopy() : ((CopyableIcon)icon).copy();
        }
        BufferedImage image = UIUtil.createImage(ancestor, icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        try {
            icon.paintIcon(ancestor, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return new JBImageIcon((Image)image){
            final int originalWidth;
            final int originalHeight;
            {
                super(image);
                this.originalWidth = icon.getIconWidth();
                this.originalHeight = icon.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return this.originalWidth;
            }

            @Override
            public int getIconHeight() {
                return this.originalHeight;
            }
        };
    }

    @Nullable
    private static ImageIcon checkIcon(@Nullable Image image, @NotNull CachedImageIcon cii) {
        if (image == null || image.getHeight(null) < 1) {
            return null;
        }
        JBImageIcon icon = new JBImageIcon(image);
        if (!IconLoader.isGoodSize(icon)) {
            LOG.error("Invalid icon: " + cii);
            return EMPTY_ICON;
        }
        return icon;
    }

    public static boolean isGoodSize(@NotNull Icon icon) {
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    @NotNull
    public static Icon getDisabledIcon(@NotNull Icon icon) {
        return IconLoader.getDisabledIcon(icon, null);
    }

    @NotNull
    public static Icon getDisabledIcon(@NotNull Icon icon, @Nullable Component ancestor) {
        Icon disabledIcon;
        if (!ourIsActivated) {
            return icon;
        }
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (icon instanceof RetrievableIcon) {
            icon = IconLoader.getOrigin((RetrievableIcon)icon);
        }
        if ((disabledIcon = (Icon)ourIcon2DisabledIcon.get(icon)) == null) {
            disabledIcon = (Icon)ConcurrencyUtil.cacheOrGet(ourIcon2DisabledIcon, (Object)icon, (Object)IconLoader.filterIcon(icon, UIUtil::getGrayFilter, ancestor));
        }
        return disabledIcon;
    }

    @NotNull
    public static Icon filterIcon(@NotNull Icon icon, @NotNull Supplier<? extends RGBImageFilter> filterSupplier, @Nullable Component ancestor) {
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (!IconLoader.isGoodSize(icon)) {
            LOG.error((Object)icon);
            return EMPTY_ICON;
        }
        if (icon instanceof CachedImageIcon) {
            icon = ((CachedImageIcon)icon).createWithFilter(filterSupplier);
        } else {
            ScaleContextSupport ctxSupport = IconLoader.getScaleContextSupport(icon);
            double scale = ctxSupport != null ? (StartupUiUtil.isJreHiDPI() ? ctxSupport.getScale(ScaleType.SYS_SCALE) : 1.0) : (StartupUiUtil.isJreHiDPI() ? (double)JBUIScale.sysScale(ancestor) : 1.0);
            BufferedImage image = new BufferedImage((int)(scale * (double)icon.getIconWidth()), (int)(scale * (double)icon.getIconHeight()), 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setColor(UIUtil.TRANSPARENT_COLOR);
            graphics.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
            graphics.scale(scale, scale);
            icon.paintIcon(LabelHolder.ourFakeComponent, graphics, 0, 0);
            graphics.dispose();
            Image img = ImageUtil.filter(image, filterSupplier.get());
            if (StartupUiUtil.isJreHiDPI(ancestor)) {
                img = RetinaImage.createFrom(img, scale, null);
            }
            icon = new JBImageIcon(img);
        }
        return icon;
    }

    @NotNull
    public static Icon getTransparentIcon(@NotNull Icon icon) {
        return IconLoader.getTransparentIcon(icon, 0.5f);
    }

    @NotNull
    public static Icon getTransparentIcon(final @NotNull Icon icon, final float alpha) {
        return new RetrievableIcon(){

            @Override
            @NotNull
            public Icon retrieveIcon() {
                return icon;
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Composite saveComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(10, alpha));
                icon.paintIcon(c, g2, x, y);
                g2.setComposite(saveComposite);
            }
        };
    }

    @NotNull
    public static Icon getIconSnapshot(@NotNull Icon icon) {
        if (icon instanceof CachedImageIcon) {
            return ((CachedImageIcon)icon).getRealIcon();
        }
        return icon;
    }

    @ApiStatus.Internal
    @NotNull
    public static Icon getMenuBarIcon(@NotNull Icon icon, boolean dark) {
        if (icon instanceof RetrievableIcon) {
            icon = IconLoader.getOrigin((RetrievableIcon)icon);
        }
        if (icon instanceof MenuBarIconProvider) {
            return ((MenuBarIconProvider)((Object)icon)).getMenuBarIcon(dark);
        }
        return icon;
    }

    @NotNull
    public static Icon getDarkIcon(@NotNull Icon icon, boolean dark) {
        if (icon instanceof RetrievableIcon) {
            icon = IconLoader.getOrigin((RetrievableIcon)icon);
        }
        if (icon instanceof DarkIconProvider) {
            return ((DarkIconProvider)icon).getDarkIcon(dark);
        }
        return icon;
    }

    public static void detachClassLoader(@NotNull ClassLoader classLoader) {
        for (Map.Entry entry : new ArrayList(ourIconsCache.entrySet())) {
            Icon disabledIcon;
            CachedImageIcon icon;
            ((CachedImageIcon)entry.getValue()).detachClassLoader(classLoader);
            if (((Pair)entry.getKey()).second != classLoader || (icon = (CachedImageIcon)ourIconsCache.remove(entry.getKey())) == null || !((disabledIcon = (Icon)ourIcon2DisabledIcon.remove(icon)) instanceof CachedImageIcon)) continue;
            ((CachedImageIcon)disabledIcon).detachClassLoader(classLoader);
        }
    }

    @NotNull
    public static Icon createLazy(final @NotNull @NotNull Supplier<? extends @NotNull Icon> producer) {
        return new LazyIcon(){

            @Override
            @NotNull
            protected Icon compute() {
                return (Icon)producer.get();
            }
        };
    }

    @NotNull
    private static Icon getOrigin(@NotNull RetrievableIcon icon) {
        int maxDeep = 10;
        Icon origin = icon.retrieveIcon();
        for (int level = 0; origin instanceof RetrievableIcon && level < 10; ++level) {
            origin = ((RetrievableIcon)origin).retrieveIcon();
        }
        if (origin instanceof RetrievableIcon) {
            LOG.error("can't calculate origin icon (too deep in hierarchy), src: " + icon);
        }
        return origin;
    }

    @Nullable
    private static ScaleContextSupport getScaleContextSupport(@NotNull Icon icon) {
        if (icon instanceof ScaleContextSupport) {
            return (ScaleContextSupport)((Object)icon);
        }
        if (icon instanceof RetrievableIcon) {
            return IconLoader.getScaleContextSupport(((RetrievableIcon)icon).retrieveIcon());
        }
        if (icon instanceof CompositeIcon) {
            return IconLoader.getScaleContextSupport(((CompositeIcon)icon).getIcon(0));
        }
        return null;
    }

    static {
        STRICT_LOCAL = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }

            @Override
            public Boolean get() {
                if (STRICT_GLOBAL) {
                    return true;
                }
                return (Boolean)super.get();
            }
        };
        ourTransform = new AtomicReference<IconTransform>(IconTransform.getDefault());
        ourTransformModCount = new AtomicInteger(0);
        IconLoader.installPathPatcher((IconPathPatcher)new DeprecatedDuplicatesIconPathPatcher());
        EMPTY_ICON = new ImageIcon(ImageUtil.createImage(1, 1, 5)){

            @Override
            @NonNls
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
    }

    private static final class IconTransform {
        private final boolean myDark;
        private final IconPathPatcher @NotNull [] myPatchers;
        @Nullable
        private final ImageFilter myFilter;

        private IconTransform(boolean dark, IconPathPatcher @NotNull [] patchers, @Nullable ImageFilter filter) {
            this.myDark = dark;
            this.myPatchers = patchers;
            this.myFilter = filter;
        }

        boolean isDark() {
            return this.myDark;
        }

        @Nullable
        ImageFilter getFilter() {
            return this.myFilter;
        }

        @NotNull
        IconTransform withPathPatcher(@NotNull IconPathPatcher patcher) {
            return new IconTransform(this.myDark, (IconPathPatcher[])ArrayUtil.append((Object[])this.myPatchers, (Object)patcher), this.myFilter);
        }

        @NotNull
        IconTransform withoutPathPatcher(@NotNull IconPathPatcher patcher) {
            IconPathPatcher[] newPatchers = (IconPathPatcher[])ArrayUtil.remove((Object[])this.myPatchers, (Object)patcher);
            return newPatchers == this.myPatchers ? this : new IconTransform(this.myDark, newPatchers, this.myFilter);
        }

        @NotNull
        public IconTransform withFilter(ImageFilter filter) {
            return filter == this.myFilter ? this : new IconTransform(this.myDark, this.myPatchers, filter);
        }

        @NotNull
        IconTransform withDark(boolean dark) {
            return dark == this.myDark ? this : new IconTransform(dark, this.myPatchers, this.myFilter);
        }

        @NotNull
        public Pair<String, ClassLoader> patchPath(@NotNull String path, ClassLoader classLoader) {
            for (IconPathPatcher patcher : this.myPatchers) {
                Class contextClass;
                String newPath = patcher.patchPath(path, classLoader);
                if (newPath == null) {
                    newPath = patcher.patchPath(path, null);
                }
                if (newPath == null) continue;
                LOG.debug("replace '" + path + "' with '" + newPath + "'");
                ClassLoader contextClassLoader = patcher.getContextClassLoader(path, classLoader);
                if (contextClassLoader == null && (contextClass = patcher.getContextClass(path)) != null) {
                    contextClassLoader = contextClass.getClassLoader();
                }
                return Pair.create((Object)newPath, (Object)contextClassLoader);
            }
            return Pair.create((Object)path, null);
        }

        @NotNull
        public IconTransform copy() {
            return new IconTransform(this.myDark, this.myPatchers, this.myFilter);
        }

        @NotNull
        public static IconTransform getDefault() {
            return new IconTransform(StartupUiUtil.isUnderDarcula(), new IconPathPatcher[0], null);
        }
    }

    private static class LabelHolder {
        private static final JComponent ourFakeComponent = new JComponent(){};

        private LabelHolder() {
        }
    }

    public static abstract class LazyIcon
    extends ScaleContextSupport
    implements CopyableIcon,
    RetrievableIcon {
        private boolean myWasComputed;
        private volatile Icon myIcon;
        private int myTransformModCount = IconLoader.access$400().get();

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.updateScaleContext(ScaleContext.create((Graphics2D)g))) {
                this.myIcon = null;
            }
            Icon icon = this.getOrComputeIcon();
            icon.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            Icon icon = this.getOrComputeIcon();
            return icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            Icon icon = this.getOrComputeIcon();
            return icon.getIconHeight();
        }

        @NotNull
        final synchronized Icon getOrComputeIcon() {
            Icon icon = this.myIcon;
            int newTransformModCount = ourTransformModCount.get();
            if (icon == null || !this.myWasComputed || this.myTransformModCount != newTransformModCount) {
                this.myTransformModCount = newTransformModCount;
                this.myWasComputed = true;
                try {
                    icon = this.compute();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Cannot compute icon", e);
                    icon = AllIcons.Actions.Stub;
                }
                this.myIcon = icon;
            }
            return icon;
        }

        public final void load() {
            this.getIconWidth();
        }

        @NotNull
        protected abstract Icon compute();

        @Override
        @NotNull
        public Icon retrieveIcon() {
            return this.getOrComputeIcon();
        }

        @Override
        @NotNull
        public Icon copy() {
            return IconLoader.copy(this.getOrComputeIcon(), null, false);
        }
    }

    public static final class CachedImageIcon
    extends LazyImageIcon {
        @Nullable
        private final String myOriginalPath;
        @NotNull
        private volatile IconUrlResolver myResolver;
        @Nullable(value="when not overridden")
        private final @Nullable(value="when not overridden") Boolean myDarkOverridden;
        private int myTransformModCount;
        private final boolean myUseCacheOnLoad;
        @Nullable
        private final Supplier<? extends RGBImageFilter> myLocalFilterSupplier;
        private final MyScaledIconsCache myScaledIconsCache = new MyScaledIconsCache();

        public CachedImageIcon(@NotNull URL url) {
            this(url, true);
        }

        CachedImageIcon(@Nullable URL url, boolean useCacheOnLoad) {
            this(new MyUrlResolver(url, null), null, useCacheOnLoad);
        }

        private CachedImageIcon(@NotNull MyUrlResolver urlResolver, @Nullable String originalPath, boolean useCacheOnLoad) {
            this(originalPath, urlResolver, null, useCacheOnLoad, null);
        }

        private CachedImageIcon(@Nullable String originalPath, @NotNull IconUrlResolver resolver, @Nullable Boolean darkOverridden, boolean useCacheOnLoad, @Nullable Supplier<? extends RGBImageFilter> localFilterSupplier) {
            this.myOriginalPath = originalPath;
            this.myResolver = resolver;
            this.myDarkOverridden = darkOverridden;
            this.myUseCacheOnLoad = useCacheOnLoad;
            this.myTransformModCount = ourTransformModCount.get();
            this.myLocalFilterSupplier = localFilterSupplier;
        }

        @Contract(value="_, _, _, _, _, true -> !null")
        static CachedImageIcon create(@NotNull String originalPath, @Nullable String pathToResolve, @NotNull ClassLoader classLoader, @Nullable Class<?> clazz, @NotNull HandleNotFound handleNotFound, boolean deferUrlResolve) {
            MyUrlResolver resolver = new MyUrlResolver(pathToResolve == null ? originalPath : pathToResolve, clazz, classLoader, handleNotFound);
            CachedImageIcon icon = new CachedImageIcon(resolver, originalPath, true);
            if (!deferUrlResolve && icon.getURL() == null) {
                return null;
            }
            return icon;
        }

        @Nullable
        public String getOriginalPath() {
            return this.myOriginalPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected ImageIcon getRealIcon(@Nullable ScaleContext ctx) {
            if (!this.isValid()) {
                if (IconLoader.isLoaderDisabled()) {
                    return EMPTY_ICON;
                }
                Object object = this.myLock;
                synchronized (object) {
                    if (!this.isValid()) {
                        this.myTransformModCount = ourTransformModCount.get();
                        this.myResolver.resolve();
                        this.myRealIcon = null;
                        this.myScaledIconsCache.clear();
                        if (this.myOriginalPath != null) {
                            this.myResolver = this.myResolver.patch(this.myOriginalPath, (IconTransform)ourTransform.get());
                        }
                    }
                }
            }
            Object realIcon = this.myRealIcon;
            Object object = this.myLock;
            synchronized (object) {
                ImageIcon icon;
                if (!this.updateScaleContext(ctx) && realIcon != null && (icon = CachedImageIcon.unwrapIcon(realIcon)) != null) {
                    return icon;
                }
                icon = this.myScaledIconsCache.getOrScaleIcon(1.0f);
                if (icon != null) {
                    this.myRealIcon = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference((Object)icon);
                    return icon;
                }
            }
            return EMPTY_ICON;
        }

        private boolean isValid() {
            return ourTransformModCount.get() == this.myTransformModCount && this.myResolver.isResolved();
        }

        public String toString() {
            URL url;
            if (this.myResolver.isResolved() && (url = this.myResolver.getURL()) != null) {
                return url.toString();
            }
            return this.myOriginalPath != null ? this.myOriginalPath : "unknown path";
        }

        @NotNull
        public Icon scale(float scale) {
            if (scale == 1.0f) {
                return this;
            }
            this.getRealIcon();
            ImageIcon icon = this.myScaledIconsCache.getOrScaleIcon(scale);
            if (icon != null) {
                return icon;
            }
            return this;
        }

        @NotNull
        public Icon getDarkIcon(boolean isDark) {
            return new CachedImageIcon(this.myOriginalPath, this.myResolver, isDark, this.myUseCacheOnLoad, this.myLocalFilterSupplier);
        }

        @Override
        @NotNull
        public Icon getMenuBarIcon(boolean isDark) {
            boolean useMRI = MultiResolutionImageProvider.isMultiResolutionImageAvailable() && SystemInfo.isMac;
            ScaleContext ctx = useMRI ? ScaleContext.create() : ScaleContext.createIdentity();
            ctx.setScale(ScaleType.USR_SCALE.of(1.0));
            Image img = this.loadFromUrl(ctx, isDark);
            if (useMRI) {
                img = MultiResolutionImageProvider.convertFromJBImage(img);
            }
            if (img != null) {
                return new ImageIcon(img);
            }
            return this;
        }

        @Override
        @NotNull
        public CachedImageIcon copy() {
            return new CachedImageIcon(this.myOriginalPath, this.myResolver, this.myDarkOverridden, this.myUseCacheOnLoad, this.myLocalFilterSupplier);
        }

        @NotNull
        private Icon createWithFilter(@NotNull Supplier<? extends RGBImageFilter> filterSupplier) {
            return new CachedImageIcon(this.myOriginalPath, this.myResolver, this.myDarkOverridden, this.myUseCacheOnLoad, filterSupplier);
        }

        private boolean isDark() {
            return this.myDarkOverridden == null ? ((IconTransform)ourTransform.get()).isDark() : this.myDarkOverridden.booleanValue();
        }

        private ImageFilter @Nullable [] getFilters() {
            ImageFilter local;
            ImageFilter global = ((IconTransform)ourTransform.get()).getFilter();
            ImageFilter imageFilter = local = this.myLocalFilterSupplier != null ? (ImageFilter)this.myLocalFilterSupplier.get() : null;
            if (global != null && local != null) {
                return new ImageFilter[]{global, local};
            }
            if (global != null) {
                return new ImageFilter[]{global};
            }
            if (local != null) {
                return new ImageFilter[]{local};
            }
            return null;
        }

        @Nullable
        public URL getURL() {
            return this.myResolver.getURL();
        }

        @Nullable
        private Image loadFromUrl(@NotNull ScaleContext ctx, boolean dark) {
            long start = StartUpMeasurer.isEnabled() ? StartUpMeasurer.getCurrentTime() : -1L;
            Image image = this.loadFromUrlImpl(ctx, dark);
            if (start != -1L) {
                IconLoadMeasurer.addFindIconLoad(StartUpMeasurer.getCurrentTime() - start);
            }
            return image;
        }

        private Image loadFromUrlImpl(@NotNull ScaleContext ctx, boolean dark) {
            int flags = 9;
            if (this.myUseCacheOnLoad) {
                flags |= 2;
            }
            if (dark) {
                flags |= 4;
            }
            String path = this.myResolver.getOverriddenPath();
            Class<?> aClass = this.myResolver.getOwnerClass();
            if (aClass != null && path != null) {
                return ImageLoader.loadFromUrl(path, aClass, flags, this.getFilters(), ctx);
            }
            URL url = this.getURL();
            if (url == null) {
                return null;
            }
            return ImageLoader.loadFromUrl(url, null, flags, this.getFilters(), ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void detachClassLoader(ClassLoader loader) {
            Object object = this.myLock;
            synchronized (object) {
                this.myResolver = this.myResolver.detachClassLoader(loader);
            }
        }

        private static class DummyUrlResolver
        implements IconUrlResolver {
            private DummyUrlResolver() {
            }

            @Override
            @Nullable
            public Class<?> getOwnerClass() {
                return null;
            }

            @Override
            @Nullable
            public String getOverriddenPath() {
                return null;
            }

            @Override
            public boolean isResolved() {
                return false;
            }

            @Override
            public IconUrlResolver resolve() throws RuntimeException {
                return this;
            }

            @Override
            @Nullable
            public URL getURL() {
                return null;
            }

            @Override
            public IconUrlResolver patch(@NotNull String originalPath, @NotNull IconTransform transform) {
                return this;
            }

            @Override
            public IconUrlResolver detachClassLoader(ClassLoader loader) {
                return this;
            }
        }

        private static final class MyUrlResolver
        implements IconUrlResolver {
            @Nullable
            private final Class<?> myOwnerClass;
            @Nullable
            private final ClassLoader myClassLoader;
            @Nullable
            private final String myOverriddenPath;
            @NotNull
            private final HandleNotFound myHandleNotFound;
            @Nullable
            private URL myUrl;
            private volatile boolean isResolved;

            MyUrlResolver(@Nullable URL url, @Nullable ClassLoader classLoader) {
                this.myOwnerClass = null;
                this.myOverriddenPath = null;
                this.myClassLoader = classLoader;
                this.myUrl = url;
                this.myHandleNotFound = HandleNotFound.IGNORE;
                this.isResolved = true;
            }

            MyUrlResolver(@Nullable URL url, @NotNull String path, @Nullable ClassLoader classLoader) {
                this.myOwnerClass = null;
                this.myOverriddenPath = path;
                this.myClassLoader = classLoader;
                this.myUrl = url;
                this.myHandleNotFound = HandleNotFound.IGNORE;
                this.isResolved = true;
            }

            MyUrlResolver(@NotNull String path, @Nullable Class<?> clazz, @Nullable ClassLoader classLoader, @NotNull HandleNotFound handleNotFound) {
                this.myOverriddenPath = path;
                this.myOwnerClass = clazz;
                this.myClassLoader = classLoader;
                this.myHandleNotFound = handleNotFound;
                if (!SystemProperties.getBooleanProperty((String)"ide.icons.deferUrlResolve", (boolean)true)) {
                    this.resolve();
                }
            }

            @Override
            @Nullable
            public Class<?> getOwnerClass() {
                return this.myOwnerClass;
            }

            @Override
            @Nullable
            public String getOverriddenPath() {
                return this.myOverriddenPath;
            }

            @Override
            public boolean isResolved() {
                return this.isResolved;
            }

            @Override
            public MyUrlResolver resolve() throws RuntimeException {
                if (this.isResolved) {
                    return this;
                }
                try {
                    URL url = null;
                    String path = this.myOverriddenPath;
                    if (path != null) {
                        if (this.myClassLoader != null) {
                            path = StringUtil.trimStart((String)path, (String)"/");
                            url = MyUrlResolver.findURL(path, this.myClassLoader::getResource);
                        }
                        if (url == null && this.myOwnerClass != null) {
                            url = MyUrlResolver.findURL(path, this.myOwnerClass::getResource);
                        }
                    }
                    if (url == null) {
                        this.myHandleNotFound.handle("Can't find icon in '" + path + "' near " + this.myClassLoader);
                    }
                    this.myUrl = url;
                }
                finally {
                    this.isResolved = true;
                }
                return this;
            }

            @Override
            @Nullable
            public URL getURL() {
                if (!this.isResolved()) {
                    return this.resolve().myUrl;
                }
                return this.myUrl;
            }

            @Override
            public IconUrlResolver patch(@NotNull String originalPath, @NotNull IconTransform transform) {
                Pair<String, ClassLoader> patchedPath = transform.patchPath(originalPath, this.myClassLoader);
                ClassLoader classLoader = patchedPath.second != null ? (ClassLoader)patchedPath.second : this.myClassLoader;
                String path = (String)patchedPath.first;
                if (classLoader != null && path != null && path.startsWith("/")) {
                    return new MyUrlResolver(path.substring(1), null, classLoader, this.myHandleNotFound).resolve();
                }
                if (path != null && path.startsWith("file:/")) {
                    try {
                        return new MyUrlResolver(new URL(path), path.substring(1), classLoader).resolve();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                return this;
            }

            @Nullable
            private static URL findURL(@NotNull String path, @NotNull Function<? super String, URL> urlProvider) {
                URL url = urlProvider.apply(path);
                if (url != null) {
                    return url;
                }
                if (path.endsWith(".png")) {
                    path = path.substring(0, path.length() - 4) + ".svg";
                } else if (path.endsWith(".svg")) {
                    path = path.substring(0, path.length() - 4) + ".png";
                } else {
                    LOG.debug("unexpected path: ", new Object[]{path});
                }
                return urlProvider.apply(path);
            }

            @Override
            public IconUrlResolver detachClassLoader(ClassLoader loader) {
                if (this.myClassLoader == loader) {
                    return new DummyUrlResolver();
                }
                return this;
            }
        }

        private static interface IconUrlResolver {
            @Nullable
            public Class<?> getOwnerClass();

            @Nullable
            public String getOverriddenPath();

            public boolean isResolved();

            public IconUrlResolver resolve() throws RuntimeException;

            @Nullable
            public URL getURL();

            public IconUrlResolver patch(@NotNull String var1, @NotNull IconTransform var2);

            public IconUrlResolver detachClassLoader(ClassLoader var1);
        }

        static enum HandleNotFound {
            THROW_EXCEPTION{

                @Override
                void handle(@NotNull String msg) {
                    throw new RuntimeException(msg);
                }
            }
            ,
            LOG_ERROR{

                @Override
                void handle(@NotNull String msg) {
                    LOG.error(msg);
                }
            }
            ,
            IGNORE;


            void handle(@NotNull String msg) throws RuntimeException {
            }

            @NotNull
            static HandleNotFound strict(boolean strict) {
                return strict ? THROW_EXCEPTION : IGNORE;
            }
        }

        private final class MyScaledIconsCache {
            private static final int SCALED_ICONS_CACHE_LIMIT = 5;
            private final Map<Couple<Double>, SoftReference<ImageIcon>> scaledIconsCache = Collections.synchronizedMap(new FixedHashMap(5));

            private MyScaledIconsCache() {
            }

            private Couple<Double> key(@NotNull ScaleContext ctx) {
                return new Couple((Object)ctx.getScale(DerivedScaleType.EFF_USR_SCALE), (Object)ctx.getScale(ScaleType.SYS_SCALE));
            }

            ImageIcon getOrScaleIcon(float scale) {
                ImageIcon icon;
                ScaleContext ctx = (ScaleContext)CachedImageIcon.this.getScaleContext();
                if (scale != 1.0f) {
                    ctx = (ScaleContext)ctx.copy();
                    ctx.setScale(ScaleType.OBJ_SCALE.of(scale));
                }
                if ((icon = (ImageIcon)SoftReference.dereference((Reference)((Reference)this.scaledIconsCache.get(this.key(ctx))))) != null) {
                    return icon;
                }
                Image image = CachedImageIcon.this.loadFromUrl(ctx, CachedImageIcon.this.isDark());
                icon = IconLoader.checkIcon(image, CachedImageIcon.this);
                if (icon != null && 4L * (long)icon.getIconWidth() * (long)icon.getIconHeight() < ImageLoader.CACHED_IMAGE_MAX_SIZE) {
                    this.scaledIconsCache.put(this.key(ctx), (SoftReference<ImageIcon>)new SoftReference((Object)icon));
                }
                return icon;
            }

            public void clear() {
                this.scaledIconsCache.clear();
            }
        }
    }
}

