/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.run;

import com.google.gct.studio.appengine.run.AppEngineRunConfiguration;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemBeforeRunTask;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemBeforeRunTaskProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import icons.GoogleCloudToolsIcons;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class AppEngineGradleBeforeRunTaskProvider
extends ExternalSystemBeforeRunTaskProvider {
    static final Key<ExternalSystemBeforeRunTask> ID = Key.create((String)"AppEngine.Gradle.BeforeRunTask");
    static final String TASK_NAME = GctStudioBundle.message("appengine.gradle.before.run.name", new Object[0]);
    private static final Logger LOG = Logger.getInstance(AppEngineGradleBeforeRunTaskProvider.class);
    private final Project myProject;

    public AppEngineGradleBeforeRunTaskProvider(@NotNull Project project) {
        super(GradleConstants.SYSTEM_ID, project, ID);
        this.myProject = project;
    }

    public boolean canExecuteTask(RunConfiguration configuration, ExternalSystemBeforeRunTask beforeRunTask) {
        if (configuration instanceof AppEngineRunConfiguration) {
            return super.canExecuteTask(configuration, beforeRunTask);
        }
        return false;
    }

    @NotNull
    public Key<ExternalSystemBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return TASK_NAME;
    }

    public String getDescription(ExternalSystemBeforeRunTask task) {
        return GctStudioBundle.message("appengine.gradle.before.run.description", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return GoogleCloudToolsIcons.APP_ENGINE;
    }

    public Icon getTaskIcon(ExternalSystemBeforeRunTask task) {
        return GoogleCloudToolsIcons.APP_ENGINE;
    }

    public boolean isConfigurable() {
        return false;
    }

    public boolean configureTask(RunConfiguration runConfiguration, ExternalSystemBeforeRunTask task) {
        return true;
    }

    @Nullable
    public ExternalSystemBeforeRunTask createTask(RunConfiguration runConfiguration) {
        if (runConfiguration instanceof AppEngineRunConfiguration) {
            ExternalSystemBeforeRunTask task = new ExternalSystemBeforeRunTask(ID, GradleConstants.SYSTEM_ID);
            task.setEnabled(true);
            return task;
        }
        return null;
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, ExternalSystemBeforeRunTask task) {
        assert (configuration instanceof AppEngineRunConfiguration);
        AppEngineRunConfiguration runConfig = (AppEngineRunConfiguration)configuration;
        Module[] modules = runConfig.getModules();
        String gradlePath = ExternalSystemApiUtil.getExternalProjectId((Module)modules[0]);
        if (gradlePath == null || gradlePath.equals(":")) {
            gradlePath = "";
        }
        task.getTaskExecutionSettings().setTaskNames(Collections.singletonList(gradlePath + ":assemble"));
        task.getTaskExecutionSettings().setExternalProjectPath(ExternalSystemApiUtil.getExternalProjectPath((Module)modules[0]));
        return super.executeTask(context, configuration, env, task);
    }
}

