/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.gradle.service;

import com.google.gct.studio.appengine.gradle.facet.AppEngineConfigurationProperties;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacet;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacetConfiguration;
import com.google.gct.studio.appengine.gradle.project.IdeaAppEngineProject;
import com.google.gct.studio.appengine.run.AppEngineRunConfiguration;
import com.google.gct.studio.appengine.run.AppEngineRunConfigurationType;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import org.jetbrains.annotations.NotNull;

public class AppEngineGradleProjectSetup {
    @NotNull
    public static AppEngineGradleFacet addAppEngineGradleFacet(@NotNull IdeaAppEngineProject ideaAppEngineProject, @NotNull Module appEngineModule, @NotNull IdeModifiableModelsProvider modelsProvider) {
        AppEngineConfigurationProperties state;
        ModifiableFacetModel model = modelsProvider.getModifiableFacetModel(appEngineModule);
        FacetManager facetManager = FacetManager.getInstance((Module)appEngineModule);
        AppEngineGradleFacet facet = AppEngineGradleFacet.getInstance(appEngineModule);
        if (facet == null) {
            facet = (AppEngineGradleFacet)facetManager.createFacet(AppEngineGradleFacet.getFacetType(), "App Engine Gradle", null);
            model.addFacet((Facet)facet, ExternalProjectSystemRegistry.getInstance().getExternalSource(appEngineModule));
        }
        if ((state = ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState()) != null) {
            state.APPENGINE_SDKROOT = ideaAppEngineProject.getDelegate().getAppEngineSdkRoot();
            state.HTTP_ADDRESS = ideaAppEngineProject.getDelegate().getHttpAddress();
            state.HTTP_PORT = ideaAppEngineProject.getDelegate().getHttpPort();
            state.JVM_FLAGS.clear();
            for (String flag : ideaAppEngineProject.getDelegate().getJvmFlags()) {
                state.JVM_FLAGS.add(flag);
            }
            state.WAR_DIR = ideaAppEngineProject.getDelegate().getWarDir().getAbsolutePath();
            state.WEB_APP_DIR = ideaAppEngineProject.getDelegate().getWebAppDir().getAbsolutePath();
            state.DISABLE_UPDATE_CHECK = ideaAppEngineProject.getDelegate().isDisableUpdateCheck();
        }
        return facet;
    }

    public static void addAppEngineRunConfiguration(@NotNull Module appEngineModule) {
        Object configuration2;
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)appEngineModule.getProject());
        for (Object configuration2 : runManager.getAllConfigurationsList()) {
            if (!configuration2.getName().equals(appEngineModule.getName())) continue;
            return;
        }
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(appEngineModule.getName(), AppEngineRunConfigurationType.getInstance().getFactory());
        settings.setSingleton(true);
        configuration2 = (AppEngineRunConfiguration)settings.getConfiguration();
        configuration2.setModule(appEngineModule);
        ((AppEngineRunConfiguration)((Object)configuration2)).setSyncWithGradle(true);
        runManager.addConfiguration(settings, false);
    }
}

