/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.io.netty.handler.codec.http.websocketx.extensions.compression;

import com.android.tools.idea.io.netty.channel.ChannelHandlerContext;
import com.android.tools.idea.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import com.android.tools.idea.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import com.android.tools.idea.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.android.tools.idea.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.android.tools.idea.io.netty.handler.codec.http.websocketx.extensions.compression.DeflateDecoder;
import java.util.List;

class PerMessageDeflateDecoder
extends DeflateDecoder {
    private boolean compressing;

    PerMessageDeflateDecoder(boolean noContext) {
        super(noContext);
    }

    @Override
    public boolean acceptInboundMessage(Object msg) throws Exception {
        return (msg instanceof TextWebSocketFrame || msg instanceof BinaryWebSocketFrame) && (((WebSocketFrame)msg).rsv() & 4) > 0 || msg instanceof ContinuationWebSocketFrame && this.compressing;
    }

    @Override
    protected int newRsv(WebSocketFrame msg) {
        return (msg.rsv() & 4) > 0 ? msg.rsv() ^ 4 : msg.rsv();
    }

    @Override
    protected boolean appendFrameTail(WebSocketFrame msg) {
        return msg.isFinalFragment();
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        super.decode(ctx, msg, out);
        if (msg.isFinalFragment()) {
            this.compressing = false;
        } else if (msg instanceof TextWebSocketFrame || msg instanceof BinaryWebSocketFrame) {
            this.compressing = true;
        }
    }
}

