/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.util;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import trebuchet.io.DataSlice;
import trebuchet.io.GenericByteBuffer;
import trebuchet.io.StreamingReader;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u0006J\"\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00152\b\b\u0002\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u0006J\"\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0006J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0014\u001a\u00020\u0006J \u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006 "}, d2={"Ltrebuchet/util/StringSearch;", "", "lookFor", "", "(Ljava/lang/String;)V", "length", "", "getLength", "()I", "getLookFor", "()Ljava/lang/String;", "skipLut", "", "getSkipLut", "()[B", "suffixSkip", "getSuffixSkip", "find", "buffer", "startIndex", "endIndex", "Ltrebuchet/io/GenericByteBuffer;", "reader", "Ltrebuchet/io/StreamingReader;", "inEndIndex", "findInLoadedRegion", "findInWindow", "window", "Ltrebuchet/io/StreamingReader$Window;", "globalStartIndex", "globalEndIndex", "Companion", "intellij.android.profilers.atrace"})
public final class StringSearch {
    @NotNull
    private final byte[] skipLut;
    @NotNull
    private final byte[] suffixSkip;
    @NotNull
    private final String lookFor;
    private static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] getSkipLut() {
        return this.skipLut;
    }

    @NotNull
    public final byte[] getSuffixSkip() {
        return this.suffixSkip;
    }

    public final int getLength() {
        return this.lookFor.length();
    }

    public final int find(@NotNull StreamingReader reader, int startIndex, int inEndIndex) {
        int index = startIndex + this.lookFor.length() - 1;
        int endIndex = inEndIndex;
        while (index <= endIndex) {
            if (index > reader.getEndIndex()) {
                if (!reader.loadIndex(index)) {
                    return -1;
                }
                if (reader.getReachedEof()) {
                    endIndex = reader.getEndIndex();
                }
            }
            while (reader.windowFor(index) != reader.windowFor(index - this.lookFor.length() + 1)) {
                int lookForIndex;
                for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0 && reader.get(index) == (byte)this.lookFor.charAt(lookForIndex); --lookForIndex) {
                    --index;
                }
                if (lookForIndex < 0) {
                    return index + 1;
                }
                byte by = this.skipLut[reader.get(index) & 0xFF];
                byte by2 = this.suffixSkip[lookForIndex];
                boolean bl = false;
                if ((index += (byte)Math.max(by, by2)) <= reader.getEndIndex()) continue;
                if (!reader.loadIndex(index)) {
                    return -1;
                }
                if (!reader.getReachedEof()) continue;
                endIndex = reader.getEndIndex();
            }
            StreamingReader.Window window = reader.windowFor(index);
            if ((index = this.findInWindow(window, index, endIndex)) > window.getGlobalEndIndex()) continue;
            return index;
        }
        return -1;
    }

    public static /* synthetic */ int find$default(StringSearch stringSearch, StreamingReader streamingReader, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        return stringSearch.find(streamingReader, n, n2);
    }

    public final int findInLoadedRegion(@NotNull StreamingReader reader, int endIndex) {
        int index = reader.getStartIndex() + this.lookFor.length() - 1;
        while (index <= endIndex) {
            while (reader.windowFor(index) != reader.windowFor(index - this.lookFor.length() + 1)) {
                int lookForIndex;
                for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0 && reader.get(index) == (byte)this.lookFor.charAt(lookForIndex); --lookForIndex) {
                    --index;
                }
                if (lookForIndex < 0) {
                    return index + 1;
                }
                byte by = this.skipLut[reader.get(index) & 0xFF];
                byte by2 = this.suffixSkip[lookForIndex];
                boolean bl = false;
                index += (byte)Math.max(by, by2);
            }
            StreamingReader.Window window = reader.windowFor(index);
            if ((index = this.findInWindow(window, index, endIndex)) >= window.getGlobalEndIndex() || index >= endIndex) continue;
            return index;
        }
        return -1;
    }

    public static /* synthetic */ int findInLoadedRegion$default(StringSearch stringSearch, StreamingReader streamingReader, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = streamingReader.getEndIndex();
        }
        return stringSearch.findInLoadedRegion(streamingReader, n);
    }

    public final int find(@NotNull GenericByteBuffer buffer, int startIndex, int endIndex) {
        int index;
        byte by;
        byte by2;
        for (index = startIndex + this.lookFor.length() - 1; index < endIndex; index += (byte)Math.max(by2, by)) {
            int lookForIndex;
            for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0 && buffer.get(index) == (byte)this.lookFor.charAt(lookForIndex); --lookForIndex) {
                --index;
            }
            if (lookForIndex < 0) {
                ++index;
                break;
            }
            by2 = this.skipLut[buffer.get(index) & 0xFF];
            by = this.suffixSkip[lookForIndex];
            boolean bl = false;
        }
        return index;
    }

    public static /* synthetic */ int find$default(StringSearch stringSearch, GenericByteBuffer genericByteBuffer, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = genericByteBuffer.getLength();
        }
        return stringSearch.find(genericByteBuffer, n, n2);
    }

    public final int find(@NotNull byte[] buffer, int startIndex, int endIndex) {
        int index;
        byte by;
        byte by2;
        for (index = startIndex + this.lookFor.length() - 1; index < endIndex; index += (byte)Math.max(by2, by)) {
            int lookForIndex;
            for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0 && buffer[index] == (byte)this.lookFor.charAt(lookForIndex); --lookForIndex) {
                --index;
            }
            if (lookForIndex < 0) {
                ++index;
                break;
            }
            by2 = this.skipLut[buffer[index] & 0xFF];
            by = this.suffixSkip[lookForIndex];
            boolean bl = false;
        }
        return index;
    }

    public static /* synthetic */ int find$default(StringSearch stringSearch, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return stringSearch.find(byArray, n, n2);
    }

    private final int findInWindow(StreamingReader.Window window, int globalStartIndex, int globalEndIndex) {
        int index;
        byte by;
        DataSlice buffer = window.getSlice();
        int n = window.getGlobalEndIndex();
        byte by2 = 0;
        int endIndex = Math.min(n, globalEndIndex) - window.getGlobalStartIndex();
        for (index = globalStartIndex - window.getGlobalStartIndex(); index <= endIndex; index += (byte)Math.max(by2, by)) {
            boolean $i$f$get;
            int lookForIndex;
            for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0; --lookForIndex) {
                DataSlice this_$iv = buffer;
                $i$f$get = false;
                if (this_$iv.getBuffer()[this_$iv.getStartIndex() + index] != (byte)this.lookFor.charAt(lookForIndex)) break;
                --index;
            }
            if (lookForIndex < 0) {
                ++index;
                break;
            }
            DataSlice this_$iv = buffer;
            $i$f$get = false;
            by2 = this.skipLut[this_$iv.getBuffer()[this_$iv.getStartIndex() + index] & 0xFF];
            by = this.suffixSkip[lookForIndex];
            boolean bl = false;
        }
        return index + window.getGlobalStartIndex();
    }

    @NotNull
    public final String getLookFor() {
        return this.lookFor;
    }

    /*
     * WARNING - void declaration
     */
    public StringSearch(@NotNull String lookFor) {
        int i2;
        byte[] byArray;
        int n;
        this.lookFor = lookFor;
        int n2 = 256;
        StringSearch stringSearch = this;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byte by;
            n = n3;
            int n4 = n3++;
            byArray = byArray2;
            boolean bl = false;
            byArray[n4] = by = (byte)this.lookFor.length();
        }
        byArray = byArray2;
        stringSearch.skipLut = byArray;
        this.suffixSkip = new byte[this.lookFor.length()];
        int n5 = 0;
        int last = this.lookFor.length() - 1;
        n3 = last - 1;
        if (n5 <= n3) {
            while (true) {
                void i3;
                this.skipLut[this.lookFor.charAt((int)i3) & 0xFF] = (byte)(last - i3);
                if (i3 == n3) break;
                ++i3;
            }
        }
        int lastPrefix = last;
        n3 = last;
        n = 0;
        while (n3 >= 0) {
            if (Companion.isPrefix(this.lookFor, i2 + 1)) {
                lastPrefix = i2 + 1;
            }
            this.suffixSkip[i2] = (byte)(lastPrefix + last - i2);
            --i2;
        }
        n = last;
        for (i2 = 0; i2 < n; ++i2) {
            int suffixLength = Companion.longestCommonSuffix(this.lookFor, i2);
            if (this.lookFor.charAt(i2 - suffixLength) == this.lookFor.charAt(last - suffixLength)) continue;
            this.suffixSkip[last - suffixLength] = (byte)(suffixLength + last - i2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Ltrebuchet/util/StringSearch$Companion;", "", "()V", "isPrefix", "", "str", "", "pos", "", "longestCommonSuffix", "word", "intellij.android.profilers.atrace"})
    private static final class Companion {
        public final boolean isPrefix(@NotNull CharSequence str, int pos) {
            boolean bl;
            block3: {
                Iterable $this$none$iv = (Iterable)RangesKt.until((int)0, (int)(str.length() - pos));
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $this$none$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl2 = false;
                        if (!(str.charAt(it) != str.charAt(pos + it))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final int longestCommonSuffix(@NotNull CharSequence word, int pos) {
            int i2;
            for (i2 = 0; word.charAt(pos - i2) == word.charAt(word.length() - 1 - i2) && i2 < pos; ++i2) {
            }
            return i2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

