/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.perfetto.traceprocessor;

import com.android.tools.profiler.perfetto.proto.TraceProcessor;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.systemtrace.CounterModel;
import com.android.tools.profilers.cpu.systemtrace.CpuCoreModel;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SchedulingEventModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.cpu.systemtrace.ThreadModel;
import com.android.tools.profilers.cpu.systemtrace.TraceEventModel;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorModel$Builder$WhenMappings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0002\u001f B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel;", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceModelAdapter;", "Ljava/io/Serializable;", "builder", "Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel$Builder;", "(Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel$Builder;)V", "cpuCores", "", "Lcom/android/tools/profilers/cpu/systemtrace/CpuCoreModel;", "danglingThreads", "", "", "Lcom/android/tools/profilers/cpu/systemtrace/ThreadModel;", "endCaptureTimestamp", "", "processMap", "", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "startCaptureTimestamp", "getCaptureEndTimestampUs", "getCaptureStartTimestampUs", "getCpuCores", "getDanglingThread", "tid", "getProcessById", "id", "getProcesses", "getSystemTraceTechnology", "Lcom/android/tools/profiler/proto/Cpu$CpuTraceType;", "isCapturePossibleCorrupted", "", "Builder", "Companion", "intellij.android.profilers"})
public final class TraceProcessorModel
implements SystemTraceModelAdapter,
Serializable {
    private final Map<Integer, ProcessModel> processMap;
    private final List<CpuCoreModel> cpuCores;
    private final Map<Integer, ThreadModel> danglingThreads;
    private final long startCaptureTimestamp;
    private final long endCaptureTimestamp;
    private static final long serialVersionUID;
    public static final Companion Companion;

    @Override
    public long getCaptureStartTimestampUs() {
        return this.startCaptureTimestamp;
    }

    @Override
    public long getCaptureEndTimestampUs() {
        return this.endCaptureTimestamp;
    }

    @Override
    @Nullable
    public ProcessModel getProcessById(int id) {
        return this.processMap.get(id);
    }

    @Override
    @NotNull
    public List<ProcessModel> getProcesses() {
        return CollectionsKt.toList((Iterable)this.processMap.values());
    }

    @Override
    @Nullable
    public ThreadModel getDanglingThread(int tid) {
        return this.danglingThreads.get(tid);
    }

    @Override
    @NotNull
    public List<CpuCoreModel> getCpuCores() {
        return this.cpuCores;
    }

    @Override
    @NotNull
    public Cpu.CpuTraceType getSystemTraceTechnology() {
        return Cpu.CpuTraceType.PERFETTO;
    }

    @Override
    public boolean isCapturePossibleCorrupted() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public TraceProcessorModel(@NotNull Builder builder) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable it;
        SortedMap updatedThreadMap;
        Serializable serializable;
        CounterModel entry;
        Object object;
        Collection<Object> collection;
        this.danglingThreads = builder.getDanglingThreads$intellij_android_profilers();
        this.startCaptureTimestamp = builder.getStartCaptureTimestamp$intellij_android_profilers();
        this.endCaptureTimestamp = builder.getEndCaptureTimestamp$intellij_android_profilers();
        boolean bl = false;
        Map processMapBuilder = new LinkedHashMap();
        for (ProcessModel process : builder.getProcessById$intellij_android_profilers().values()) {
            void $this$mapTo$iv$iv2;
            void $this$mapValuesTo$iv$iv;
            Map<Integer, ThreadModel> $this$mapValues$iv = process.getThreadById();
            boolean $i$f$mapValues = false;
            Map<Integer, ThreadModel> map = $this$mapValues$iv;
            Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl2 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                collection = k;
                object = map2;
                boolean bl3 = false;
                boolean bl4 = false;
                bl4 = false;
                serializable = ThreadModel.copy$default((ThreadModel)entry.getValue(), 0, 0, null, builder.getThreadToEventsMap$intellij_android_profilers().getOrDefault(entry.getKey(), CollectionsKt.emptyList()), builder.getThreadToScheduling$intellij_android_profilers().getOrDefault(entry.getKey(), CollectionsKt.emptyList()), 7, null);
                object.put(collection, serializable);
            }
            updatedThreadMap = MapsKt.toSortedMap((Map)destination$iv$iv);
            $i$f$mapValues = false;
            Iterable $this$map$iv2 = builder.getProcessToCounters$intellij_android_profilers().getOrDefault(process.getId(), CollectionsKt.emptyList());
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Object element$iv$iv$iv;
                element$iv$iv$iv = (CounterModel)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl5 = false;
                collection = TuplesKt.to((Object)((CounterModel)((Object)it)).getName(), (Object)it);
                object.add(collection);
            }
            Map counterMap = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            processMapBuilder.put(process.getId(), ProcessModel.copy$default(process, 0, null, updatedThreadMap, counterMap, 3, null));
        }
        this.processMap = MapsKt.toSortedMap((Map)processMapBuilder);
        Iterable process = (Iterable)RangesKt.until((int)0, (int)builder.getCpuCoresCount$intellij_android_profilers());
        object = this;
        boolean $i$f$map = false;
        updatedThreadMap = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv3;
            void it2;
            int item$iv$iv;
            int destination$iv$iv2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl6 = false;
            boolean $i$f$associateByTo = false;
            Iterable $this$map$iv3 = builder.getCoreToCpuCounters$intellij_android_profilers().getOrDefault((int)it2, CollectionsKt.emptyList());
            boolean $i$f$map2 = false;
            it = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void counterModel;
                entry = (CounterModel)item$iv$iv2;
                Collection collection2 = destination$iv$iv3;
                boolean bl7 = false;
                Pair pair = TuplesKt.to((Object)counterModel.getName(), (Object)counterModel);
                collection2.add(pair);
            }
            Map cpuCountersMap = MapsKt.toMap((Iterable)((List)destination$iv$iv3));
            boolean bl8 = false;
            serializable = new CpuCoreModel((int)it2, builder.getCoreToScheduling$intellij_android_profilers().getOrDefault((int)it2, CollectionsKt.emptyList()), cpuCountersMap);
            collection.add(serializable);
        }
        collection = (List)destination$iv$iv;
        ((TraceProcessorModel)object).cpuCores = collection;
    }

    static {
        Companion = new Companion(null);
        serialVersionUID = -2228053132990163476L;
    }

    public static final long getSerialVersionUID() {
        Companion companion = Companion;
        return serialVersionUID;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020)2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020)2\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020)2\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u000209J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020\u00162\u0006\u0010?\u001a\u00020\u0016H\u0002JP\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020$0A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00160C2\u0018\u0010D\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00060A2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020$0AH\u0002R&\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\tR\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001c0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\tR&\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\tR\u001a\u0010 \u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0018\"\u0004\b\"\u0010\u001aR&\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\tR&\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\t\u00a8\u0006F"}, d2={"Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel$Builder;", "", "()V", "coreToCpuCounters", "", "", "", "Lcom/android/tools/profilers/cpu/systemtrace/CounterModel;", "getCoreToCpuCounters$intellij_android_profilers", "()Ljava/util/Map;", "coreToScheduling", "Lcom/android/tools/profilers/cpu/systemtrace/SchedulingEventModel;", "getCoreToScheduling$intellij_android_profilers", "cpuCoresCount", "getCpuCoresCount$intellij_android_profilers", "()I", "setCpuCoresCount$intellij_android_profilers", "(I)V", "danglingThreads", "Lcom/android/tools/profilers/cpu/systemtrace/ThreadModel;", "getDanglingThreads$intellij_android_profilers", "endCaptureTimestamp", "", "getEndCaptureTimestamp$intellij_android_profilers", "()J", "setEndCaptureTimestamp$intellij_android_profilers", "(J)V", "processById", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "getProcessById$intellij_android_profilers", "processToCounters", "getProcessToCounters$intellij_android_profilers", "startCaptureTimestamp", "getStartCaptureTimestamp$intellij_android_profilers", "setStartCaptureTimestamp$intellij_android_profilers", "threadToEventsMap", "Lcom/android/tools/profilers/cpu/systemtrace/TraceEventModel;", "getThreadToEventsMap$intellij_android_profilers", "threadToScheduling", "getThreadToScheduling$intellij_android_profilers", "addCpuCounters", "", "result", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$CpuCoreCountersResult;", "addProcessCounters", "counters", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$ProcessCountersResult;", "addProcessMetadata", "processMetadataResult", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$ProcessMetadataResult;", "addSchedulingEvents", "schedEvents", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$SchedulingEventsResult;", "addTraceEvents", "traceEventsResult", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$TraceEventsResult;", "build", "Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel;", "convertSchedulingState", "Lcom/android/tools/profilers/cpu/ThreadState;", "state", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$SchedulingEventsResult$SchedulingEvent$SchedulingState;", "convertToUs", "tsNanos", "reconstructTraceTree", "", "rootIds", "", "eventToChildrenIds", "eventPerId", "intellij.android.profilers"})
    public static final class Builder {
        private long startCaptureTimestamp = Long.MAX_VALUE;
        private long endCaptureTimestamp = Long.MIN_VALUE;
        private int cpuCoresCount;
        @NotNull
        private final Map<Integer, ProcessModel> processById;
        @NotNull
        private final Map<Integer, ThreadModel> danglingThreads;
        @NotNull
        private final Map<Integer, List<TraceEventModel>> threadToEventsMap;
        @NotNull
        private final Map<Integer, List<SchedulingEventModel>> threadToScheduling;
        @NotNull
        private final Map<Integer, List<SchedulingEventModel>> coreToScheduling;
        @NotNull
        private final Map<Integer, List<CounterModel>> coreToCpuCounters;
        @NotNull
        private final Map<Integer, List<CounterModel>> processToCounters;

        public final long getStartCaptureTimestamp$intellij_android_profilers() {
            return this.startCaptureTimestamp;
        }

        public final void setStartCaptureTimestamp$intellij_android_profilers(long l) {
            this.startCaptureTimestamp = l;
        }

        public final long getEndCaptureTimestamp$intellij_android_profilers() {
            return this.endCaptureTimestamp;
        }

        public final void setEndCaptureTimestamp$intellij_android_profilers(long l) {
            this.endCaptureTimestamp = l;
        }

        public final int getCpuCoresCount$intellij_android_profilers() {
            return this.cpuCoresCount;
        }

        public final void setCpuCoresCount$intellij_android_profilers(int n) {
            this.cpuCoresCount = n;
        }

        @NotNull
        public final Map<Integer, ProcessModel> getProcessById$intellij_android_profilers() {
            return this.processById;
        }

        @NotNull
        public final Map<Integer, ThreadModel> getDanglingThreads$intellij_android_profilers() {
            return this.danglingThreads;
        }

        @NotNull
        public final Map<Integer, List<TraceEventModel>> getThreadToEventsMap$intellij_android_profilers() {
            return this.threadToEventsMap;
        }

        @NotNull
        public final Map<Integer, List<SchedulingEventModel>> getThreadToScheduling$intellij_android_profilers() {
            return this.threadToScheduling;
        }

        @NotNull
        public final Map<Integer, List<SchedulingEventModel>> getCoreToScheduling$intellij_android_profilers() {
            return this.coreToScheduling;
        }

        @NotNull
        public final Map<Integer, List<CounterModel>> getCoreToCpuCounters$intellij_android_profilers() {
            return this.coreToCpuCounters;
        }

        @NotNull
        public final Map<Integer, List<CounterModel>> getProcessToCounters$intellij_android_profilers() {
            return this.processToCounters;
        }

        /*
         * WARNING - void declaration
         */
        public final void addProcessMetadata(@NotNull TraceProcessor.ProcessMetadataResult processMetadataResult) {
            for (TraceProcessor.ProcessMetadataResult.ProcessMetadata process : processMetadataResult.getProcessList()) {
                Collection<Pair> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = process.getThreadList();
                String string = process.getName();
                int n = (int)process.getId();
                Integer n2 = (int)process.getId();
                Map<Integer, ProcessModel> map = this.processById;
                boolean $i$f$map = false;
                void var6_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void t;
                    TraceProcessor.ProcessMetadataResult.ThreadMetadata threadMetadata = (TraceProcessor.ProcessMetadataResult.ThreadMetadata)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    bl2 = false;
                    Pair pair = TuplesKt.to((Object)((int)t.getId()), (Object)new ThreadModel((int)t.getId(), (int)process.getId(), t.getName(), CollectionsKt.emptyList(), CollectionsKt.emptyList()));
                    collection.add(pair);
                }
                collection = (List)destination$iv$iv;
                boolean bl = false;
                Map map2 = MapsKt.emptyMap();
                Map map3 = MapsKt.toSortedMap((Map)MapsKt.toMap((Iterable)collection));
                String string2 = string;
                int n3 = n;
                map.put(n2, new ProcessModel(n3, string2, map3, map2));
            }
            for (TraceProcessor.ProcessMetadataResult.ThreadMetadata thread2 : processMetadataResult.getDanglingThreadList()) {
                this.danglingThreads.put((int)thread2.getId(), new ThreadModel((int)thread2.getId(), 0, thread2.getName(), CollectionsKt.emptyList(), CollectionsKt.emptyList()));
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addTraceEvents(@NotNull TraceProcessor.TraceEventsResult traceEventsResult) {
            for (TraceProcessor.TraceEventsResult.ThreadTraceEvents thread2 : traceEventsResult.getThreadList()) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Long key$iv;
                boolean bl = false;
                Set rootIds = new LinkedHashSet();
                boolean bl2 = false;
                Map eventToChildrenIds = new LinkedHashMap();
                boolean bl3 = false;
                Map eventPerId = new LinkedHashMap();
                for (TraceProcessor.TraceEventsResult.TraceEvent event : thread2.getTraceEventList()) {
                    if (event.getDepth() > 0) {
                        Object object;
                        void $this$getOrPut$iv;
                        Map map = eventToChildrenIds;
                        key$iv = event.getParentId();
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl4 = false;
                            boolean bl5 = false;
                            List answer$iv = new ArrayList();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        ((List)object).add(event.getId());
                    } else {
                        rootIds.add(event.getId());
                    }
                    long startTimestampUs = this.convertToUs(event.getTimestampNanoseconds());
                    long durationTimestampUs = this.convertToUs(event.getDurationNanoseconds());
                    long endTimestampUs = startTimestampUs + durationTimestampUs;
                    boolean bl6 = false;
                    eventPerId.put(event.getId(), new TraceEventModel(event.getName(), startTimestampUs, endTimestampUs, durationTimestampUs, CollectionsKt.emptyList()));
                }
                Map<Long, TraceEventModel> reconstructedTree = this.reconstructTraceTree(rootIds, eventToChildrenIds, eventPerId);
                Iterable iterable = rootIds;
                Integer n = (int)thread2.getThreadId();
                Map<Integer, List<TraceEventModel>> map = this.threadToEventsMap;
                boolean $i$f$mapNotNull = false;
                key$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    TraceEventModel traceEventModel;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl7 = false;
                    long it = ((Number)element$iv$iv).longValue();
                    boolean bl8 = false;
                    if (reconstructedTree.get(it) == null) continue;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    TraceEventModel it$iv$iv = traceEventModel;
                    boolean bl11 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                map.put(n, list);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Map<Long, TraceEventModel> reconstructTraceTree(Set<Long> rootIds, Map<Long, ? extends List<Long>> eventToChildrenIds, Map<Long, TraceEventModel> eventPerId) {
            boolean bl = false;
            Map reconstructedEventsPerId = new LinkedHashMap();
            boolean bl2 = false;
            Set visitedAllChildren = new LinkedHashSet();
            Deque eventIdStack = new LinkedList(rootIds);
            while (true) {
                TraceEventModel event;
                void $this$mapTo$iv$iv;
                boolean $i$f$forEach;
                Collection collection = eventIdStack;
                boolean bl3 = false;
                if (!(!collection.isEmpty())) break;
                Long eventId = (Long)eventIdStack.getFirst();
                if (!visitedAllChildren.contains(eventId)) {
                    bl3 = false;
                    Iterable $this$forEach$iv = eventToChildrenIds.getOrDefault(eventId, (List)new ArrayList());
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        long it = ((Number)element$iv).longValue();
                        boolean bl4 = false;
                        eventIdStack.addFirst(it);
                    }
                    visitedAllChildren.add(eventId);
                    continue;
                }
                eventIdStack.removeFirst();
                $i$f$forEach = false;
                Iterable $this$map$iv = eventToChildrenIds.getOrDefault(eventId, (List)new ArrayList());
                boolean $i$f$map = false;
                Iterable element$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    TraceEventModel traceEventModel;
                    void it;
                    long l = ((Number)item$iv$iv).longValue();
                    Collection collection2 = destination$iv$iv;
                    boolean bl5 = false;
                    if ((TraceEventModel)reconstructedEventsPerId.get((long)it) == null) {
                        String string = "Children should have been computed already";
                        boolean bl6 = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    collection2.add(traceEventModel);
                }
                Iterable $this$sortedBy$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy2 = false;
                boolean bl7 = false;
                List children2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        TraceEventModel it = (TraceEventModel)a;
                        boolean bl2 = false;
                        Comparable comparable = Long.valueOf(it.getStartTimestampUs());
                        it = (TraceEventModel)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Long l = it.getStartTimestampUs();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                });
                if (eventPerId.get(eventId) == null) {
                    String $i$f$sortedBy2 = "Trace Event should be present in the map";
                    bl7 = false;
                    throw (Throwable)new IllegalStateException($i$f$sortedBy2.toString());
                }
                long myStart = event.getStartTimestampUs();
                TraceEventModel traceEventModel = (TraceEventModel)CollectionsKt.lastOrNull((List)children2);
                long maxEndTs = traceEventModel != null ? traceEventModel.getEndTimestampUs() : 0L;
                long myCpuTime = event.getCpuTimeUs();
                long l = myStart + myCpuTime;
                boolean bl8 = false;
                TraceEventModel updatedEvent = TraceEventModel.copy$default(event, null, 0L, Math.max(l, maxEndTs), 0L, children2, 11, null);
                reconstructedEventsPerId.put(eventId, updatedEvent);
                l = this.startCaptureTimestamp;
                long l2 = updatedEvent.getStartTimestampUs();
                boolean bl9 = false;
                this.startCaptureTimestamp = Math.min(l, l2);
                l = this.endCaptureTimestamp;
                l2 = updatedEvent.getEndTimestampUs();
                bl9 = false;
                this.endCaptureTimestamp = Math.max(l, l2);
            }
            return reconstructedEventsPerId;
        }

        public final void addSchedulingEvents(@NotNull TraceProcessor.SchedulingEventsResult schedEvents) {
            boolean bl;
            Iterable $this$sortedBy$iv2;
            List previousList;
            Map.Entry element$iv;
            int n = this.cpuCoresCount;
            int n2 = schedEvents.getNumCores();
            boolean bl2 = false;
            this.cpuCoresCount = Math.max(n, n2);
            n2 = 0;
            Map perThreadScheduling = new LinkedHashMap();
            bl2 = false;
            Map perCoreScheduling = new LinkedHashMap();
            for (TraceProcessor.SchedulingEventsResult.SchedulingEvent event : schedEvents.getSchedEventList()) {
                Object object;
                Object object2;
                List answer$iv;
                boolean bl3;
                Map $this$getOrPut$iv;
                long startTimestampUs = this.convertToUs(event.getTimestampNanoseconds());
                long durationTimestampUs = this.convertToUs(event.getDurationNanoseconds());
                long endTimestampUs = startTimestampUs + durationTimestampUs;
                long l = this.startCaptureTimestamp;
                boolean bl4 = false;
                this.startCaptureTimestamp = Math.min(l, startTimestampUs);
                l = this.endCaptureTimestamp;
                bl4 = false;
                this.endCaptureTimestamp = Math.max(l, endTimestampUs);
                SchedulingEventModel schedEvent = new SchedulingEventModel(this.convertSchedulingState(event.getState()), startTimestampUs, endTimestampUs, durationTimestampUs, durationTimestampUs, (int)event.getProcessId(), (int)event.getThreadId(), event.getCpu());
                Map map = perThreadScheduling;
                Integer key$iv = (int)event.getThreadId();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl5 = false;
                    bl3 = false;
                    answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((List)object2).add(schedEvent);
                $this$getOrPut$iv = perCoreScheduling;
                key$iv = event.getCpu();
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl6 = false;
                    bl3 = false;
                    answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(schedEvent);
            }
            Map $this$forEach$iv = perThreadScheduling;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl7 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry it = element$iv = iterator.next();
                boolean bl8 = false;
                List list = this.threadToScheduling.get(it.getKey());
                if (list == null) {
                    boolean schedEvent = false;
                    list = CollectionsKt.emptyList();
                }
                previousList = list;
                $this$sortedBy$iv2 = CollectionsKt.plus((Collection)previousList, (Iterable)((Iterable)it.getValue()));
                boolean $i$f$sortedBy = false;
                bl = false;
                this.threadToScheduling.put((Integer)it.getKey(), CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        SchedulingEventModel s = (SchedulingEventModel)a;
                        boolean bl2 = false;
                        Comparable comparable = Long.valueOf(s.getStartTimestampUs());
                        s = (SchedulingEventModel)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Long l = s.getStartTimestampUs();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                }));
            }
            $this$forEach$iv = perCoreScheduling;
            $i$f$forEach = false;
            map = $this$forEach$iv;
            bl7 = false;
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry it = element$iv = iterator.next();
                boolean bl9 = false;
                List list = this.coreToScheduling.get(it.getKey());
                if (list == null) {
                    boolean $this$sortedBy$iv2 = false;
                    list = CollectionsKt.emptyList();
                }
                previousList = list;
                $this$sortedBy$iv2 = CollectionsKt.plus((Collection)previousList, (Iterable)((Iterable)it.getValue()));
                boolean $i$f$sortedBy = false;
                bl = false;
                this.coreToScheduling.put((Integer)it.getKey(), CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        SchedulingEventModel s = (SchedulingEventModel)a;
                        boolean bl2 = false;
                        Comparable comparable = Long.valueOf(s.getStartTimestampUs());
                        s = (SchedulingEventModel)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Long l = s.getStartTimestampUs();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                }));
            }
        }

        private final ThreadState convertSchedulingState(TraceProcessor.SchedulingEventsResult.SchedulingEvent.SchedulingState state) {
            ThreadState threadState;
            switch (TraceProcessorModel$Builder$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    threadState = ThreadState.RUNNING_CAPTURED;
                    break;
                }
                case 2: {
                    threadState = ThreadState.RUNNING_CAPTURED;
                    break;
                }
                case 3: {
                    threadState = ThreadState.DEAD_CAPTURED;
                    break;
                }
                case 4: {
                    threadState = ThreadState.SLEEPING_CAPTURED;
                    break;
                }
                case 5: {
                    threadState = ThreadState.WAITING_CAPTURED;
                    break;
                }
                default: {
                    threadState = ThreadState.UNKNOWN;
                }
            }
            return threadState;
        }

        /*
         * WARNING - void declaration
         */
        public final void addCpuCounters(@NotNull TraceProcessor.CpuCoreCountersResult result) {
            int n = this.cpuCoresCount;
            int n2 = result.getNumCores();
            boolean bl = false;
            this.cpuCoresCount = Math.max(n, n2);
            Iterable $this$forEach$iv = result.getCountersPerCoreList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Collection<CounterModel> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                TraceProcessor.CpuCoreCountersResult.CountersPerCore countersPerCore = (TraceProcessor.CpuCoreCountersResult.CountersPerCore)element$iv;
                boolean bl2 = false;
                Iterable iterable = countersPerCore.getCounterList();
                Integer n3 = countersPerCore.getCpu();
                Map<Integer, List<CounterModel>> map = this.coreToCpuCounters;
                boolean $i$f$map = false;
                void var12_14 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Collection<Pair> collection2;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    void counter;
                    TraceProcessor.Counter counter2 = (TraceProcessor.Counter)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    Iterable iterable2 = counter.getValueList();
                    String string = counter.getName();
                    boolean $i$f$map2 = false;
                    void var25_25 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        TraceProcessor.CounterValue counterValue = (TraceProcessor.CounterValue)item$iv$iv2;
                        collection2 = destination$iv$iv2;
                        boolean bl4 = false;
                        Pair pair = TuplesKt.to((Object)this.convertToUs(it.getTimestampNanoseconds()), (Object)it.getValue());
                        collection2.add(pair);
                    }
                    collection2 = (List)destination$iv$iv2;
                    SortedMap sortedMap = MapsKt.toSortedMap((Map)MapsKt.toMap((Iterable)collection2));
                    String string2 = string;
                    CounterModel counterModel = new CounterModel(string2, sortedMap);
                    collection.add(counterModel);
                }
                collection = (List)destination$iv$iv;
                map.put(n3, (List<CounterModel>)collection);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addProcessCounters(@NotNull TraceProcessor.ProcessCountersResult counters) {
            Collection<CounterModel> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = counters.getCounterList();
            Integer n = (int)counters.getProcessId();
            Map<Integer, List<CounterModel>> map = this.processToCounters;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Collection<Pair> collection2;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void counter;
                TraceProcessor.Counter counter2 = (TraceProcessor.Counter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable iterable2 = counter.getValueList();
                String string = counter.getName();
                boolean $i$f$map2 = false;
                void var16_16 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    TraceProcessor.CounterValue counterValue = (TraceProcessor.CounterValue)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    Pair pair = TuplesKt.to((Object)this.convertToUs(it.getTimestampNanoseconds()), (Object)it.getValue());
                    collection2.add(pair);
                }
                collection2 = (List)destination$iv$iv2;
                SortedMap sortedMap = MapsKt.toSortedMap((Map)MapsKt.toMap((Iterable)collection2));
                String string2 = string;
                CounterModel counterModel = new CounterModel(string2, sortedMap);
                collection.add(counterModel);
            }
            collection = (List)destination$iv$iv;
            map.put(n, (List<CounterModel>)collection);
        }

        @NotNull
        public final TraceProcessorModel build() {
            return new TraceProcessorModel(this);
        }

        private final long convertToUs(long tsNanos) {
            return TimeUnit.NANOSECONDS.toMicros(tsNanos);
        }

        public Builder() {
            boolean bl = false;
            this.processById = new LinkedHashMap();
            bl = false;
            this.danglingThreads = new LinkedHashMap();
            bl = false;
            this.threadToEventsMap = new LinkedHashMap();
            bl = false;
            this.threadToScheduling = new LinkedHashMap();
            bl = false;
            this.coreToScheduling = new LinkedHashMap();
            bl = false;
            this.coreToCpuCounters = new LinkedHashMap();
            bl = false;
            this.processToCounters = new LinkedHashMap();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel$Companion;", "", "()V", "serialVersionUID", "", "getSerialVersionUID$annotations", "getSerialVersionUID", "()J", "intellij.android.profilers"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getSerialVersionUID$annotations() {
        }

        public final long getSerialVersionUID() {
            return serialVersionUID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

