/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.perfetto;

import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.MainProcessSelector;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.systemtrace.AtraceParser;
import com.android.tools.profilers.cpu.systemtrace.ProcessListSorter;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceCpuCaptureBuilder;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorService;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/profilers/perfetto/PerfettoParser;", "Lcom/android/tools/profilers/cpu/TraceParser;", "mainProcessSelector", "Lcom/android/tools/profilers/cpu/MainProcessSelector;", "ideProfilerServices", "Lcom/android/tools/profilers/IdeProfilerServices;", "(Lcom/android/tools/profilers/cpu/MainProcessSelector;Lcom/android/tools/profilers/IdeProfilerServices;)V", "parse", "Lcom/android/tools/profilers/cpu/CpuCapture;", "file", "Ljava/io/File;", "traceId", "", "parseUsingTraceProcessor", "parseUsingTrebuchet", "Companion", "intellij.android.profilers"})
public final class PerfettoParser
implements TraceParser {
    private final MainProcessSelector mainProcessSelector;
    private final IdeProfilerServices ideProfilerServices;
    @NotNull
    private static final Object TPD_LOCK;
    public static final Companion Companion;

    @Override
    @NotNull
    public CpuCapture parse(@NotNull File file, long traceId) {
        if (this.ideProfilerServices.getFeatureConfig().isUseTraceProcessor()) {
            return this.parseUsingTraceProcessor(file, traceId);
        }
        return this.parseUsingTrebuchet(file, traceId);
    }

    private final CpuCapture parseUsingTrebuchet(File file, long traceId) {
        AtraceParser atraceParser = new AtraceParser(Cpu.CpuTraceType.PERFETTO, this.mainProcessSelector);
        return atraceParser.parse(file, traceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CpuCapture parseUsingTraceProcessor(File file, long traceId) {
        Object object = TPD_LOCK;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Object v0;
            boolean bl32;
            Object object222;
            List pidsToQuery;
            Integer selectedProcess;
            TraceProcessorService traceProcessor;
            block8: {
                boolean bl4 = false;
                traceProcessor = this.ideProfilerServices.getTraceProcessorService();
                boolean traceLoaded = traceProcessor.loadTrace(traceId, file, this.ideProfilerServices.getFeatureTracker());
                if (!traceLoaded) {
                    String string = "Unable to load trace with TPD.";
                    boolean bl5 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                List<ProcessModel> processList = traceProcessor.getProcessMetadata(traceId, this.ideProfilerServices.getFeatureTracker());
                Collection collection = processList;
                boolean bl6 = false;
                boolean bl7 = !collection.isEmpty();
                bl6 = false;
                boolean bl8 = false;
                if (!bl7) {
                    boolean object222 = false;
                    String string = "Invalid trace without any process information.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                ProcessListSorter processListSorter = new ProcessListSorter(this.mainProcessSelector.getNameHint());
                selectedProcess = this.mainProcessSelector.apply(processListSorter.sort(processList));
                bl8 = false;
                boolean object222 = false;
                if (selectedProcess == null) {
                    boolean bl32 = false;
                    String object222 = "It was not possible to select a process for this trace.";
                    throw (Throwable)new IllegalStateException(object222.toString());
                }
                pidsToQuery = CollectionsKt.mutableListOf((Object[])new Integer[]{selectedProcess});
                object222 = processList;
                bl32 = false;
                Iterable iterable = object222;
                boolean bl9 = false;
                for (Object t : iterable) {
                    ProcessModel it = (ProcessModel)t;
                    boolean bl10 = false;
                    if (!StringsKt.endsWith$default((String)it.getSafeProcessName(), (String)"surfaceflinger", (boolean)false, (int)2, null)) continue;
                    v0 = t;
                    break block8;
                }
                v0 = null;
            }
            ProcessModel processModel = v0;
            if (processModel != null) {
                object222 = processModel;
                bl32 = false;
                boolean bl11 = false;
                Object it = object222;
                boolean bl12 = false;
                pidsToQuery.add(((ProcessModel)it).getId());
            }
            SystemTraceModelAdapter model = traceProcessor.loadCpuData(traceId, pidsToQuery, this.ideProfilerServices.getFeatureTracker());
            SystemTraceCpuCaptureBuilder builder = new SystemTraceCpuCaptureBuilder(model);
            CpuCapture cpuCapture = builder.build(traceId, selectedProcess);
            return cpuCapture;
        }
    }

    public PerfettoParser(@NotNull MainProcessSelector mainProcessSelector, @NotNull IdeProfilerServices ideProfilerServices) {
        this.mainProcessSelector = mainProcessSelector;
        this.ideProfilerServices = ideProfilerServices;
    }

    static {
        Companion = new Companion(null);
        TPD_LOCK = new Object();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/perfetto/PerfettoParser$Companion;", "", "()V", "TPD_LOCK", "getTPD_LOCK", "()Ljava/lang/Object;", "intellij.android.profilers"})
    public static final class Companion {
        @NotNull
        public final Object getTPD_LOCK() {
            return TPD_LOCK;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

