/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.httpdata;

import com.android.tools.profilers.network.httpdata.HttpData;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.StackFrameParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import org.jetbrains.annotations.NotNull;

public final class StackTrace {
    private final ImmutableList<CodeLocation> myLocations;
    private final String myTrace;

    public StackTrace(@NotNull HttpData httpData) {
        this.myTrace = httpData.getTrace();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (String line : this.myTrace.split("\\n")) {
            if (line.trim().isEmpty()) continue;
            builder.add((Object)new StackFrameParser(line).toCodeLocation());
        }
        this.myLocations = builder.build();
    }

    @NotNull
    public ImmutableList<CodeLocation> getCodeLocations() {
        return this.myLocations;
    }

    @VisibleForTesting
    public String getTrace() {
        return this.myTrace;
    }
}

