/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.MethodSet;
import com.android.tools.profilers.stacktrace.ThreadId;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    @NotNull
    private final ThreadId myThreadId;

    @NotNull
    public static Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        return new ThreadClassifier(captureObject);
    }

    public ThreadSet(@NotNull CaptureObject captureObject, @NotNull ThreadId threadId) {
        super(threadId.toString());
        this.myCaptureObject = captureObject;
        this.myThreadId = threadId;
    }

    @NotNull
    public ThreadId getThreadId() {
        return this.myThreadId;
    }

    @Override
    @NotNull
    public Classifier createSubClassifier() {
        return MethodSet.createDefaultClassifier(this.myCaptureObject);
    }

    private static final class ThreadClassifier
    extends Classifier {
        @NotNull
        private final CaptureObject myCaptureObject;
        @NotNull
        private final Map<ThreadId, ThreadSet> myThreadSets = new LinkedHashMap<ThreadId, ThreadSet>();
        @NotNull
        private final Classifier myMethodSetClassifier;

        private ThreadClassifier(@NotNull CaptureObject captureObject) {
            this.myCaptureObject = captureObject;
            this.myMethodSetClassifier = MethodSet.createDefaultClassifier(this.myCaptureObject);
        }

        @Override
        @Nullable
        public ClassifierSet getClassifierSet(@NotNull InstanceObject instance, boolean createIfAbsent) {
            if (instance.getAllocationThreadId() != ThreadId.INVALID_THREAD_ID) {
                ThreadId threadId = instance.getAllocationThreadId();
                ThreadSet threadSet = this.myThreadSets.get(threadId);
                if (threadSet == null && createIfAbsent) {
                    threadSet = new ThreadSet(this.myCaptureObject, threadId);
                    this.myThreadSets.put(threadId, threadSet);
                }
                return threadSet;
            }
            return this.myMethodSetClassifier.getClassifierSet(instance, createIfAbsent);
        }

        @Override
        @NotNull
        public List<ClassifierSet> getFilteredClassifierSets() {
            return Stream.concat(this.myThreadSets.values().stream(), this.myMethodSetClassifier.getFilteredClassifierSets().stream()).filter(child -> !child.getIsFiltered()).collect(Collectors.toList());
        }

        @Override
        @NotNull
        protected List<ClassifierSet> getAllClassifierSets() {
            return Stream.concat(this.myThreadSets.values().stream(), this.myMethodSetClassifier.getAllClassifierSets().stream()).collect(Collectors.toList());
        }
    }
}

