/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.ext.NativeRegistryPostProcessor;
import com.android.tools.perflib.heap.io.InMemoryBuffer;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.CaptureObjectUtils;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.HeapDumpInstanceObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.memory.adapters.classifiers.AllHeapSet;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.android.tools.profilers.memory.adapters.instancefilters.ActivityFragmentLeakInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.ProjectClassesInstanceFilter;
import com.android.tools.proguard.ProguardMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gnu.trove.TLongObjectHashMap;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapDumpCaptureObject
implements CaptureObject {
    @NotNull
    private final ProfilerClient myClient;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final FeatureTracker myFeatureTracker;
    @NotNull
    private final Map<Integer, HeapSet> myHeapSets = new HashMap<Integer, HeapSet>();
    @NotNull
    private final TLongObjectHashMap<InstanceObject> myInstanceIndex = new TLongObjectHashMap();
    @NotNull
    private final ClassDb myClassDb = new ClassDb();
    @NotNull
    private final Memory.HeapDumpInfo myHeapDumpInfo;
    @Nullable
    private final ProguardMap myProguardMap;
    @Nullable
    private volatile boolean hasLoaded = false;
    private volatile boolean myIsLoadingError = false;
    private boolean myHasNativeAllocations;
    @NotNull
    private final IdeProfilerServices myIdeProfilerServices;
    private final ActivityFragmentLeakInstanceFilter myActivityFragmentLeakFilter;
    private final Set<CaptureObjectInstanceFilter> mySupportedInstanceFilters;
    private final Set<CaptureObjectInstanceFilter> myCurrentInstanceFilters = new HashSet<CaptureObjectInstanceFilter>();
    private final ListeningExecutorService myExecutorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("memory-heapdump-instancefilters").build()));

    public HeapDumpCaptureObject(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.HeapDumpInfo heapDumpInfo, @Nullable ProguardMap proguardMap, @NotNull FeatureTracker featureTracker, @NotNull IdeProfilerServices ideProfilerServices) {
        this.myClient = client;
        this.mySession = session;
        this.myHeapDumpInfo = heapDumpInfo;
        this.myProguardMap = proguardMap;
        this.myFeatureTracker = featureTracker;
        this.myIdeProfilerServices = ideProfilerServices;
        this.myActivityFragmentLeakFilter = new ActivityFragmentLeakInstanceFilter(this.myClassDb);
        this.mySupportedInstanceFilters = ImmutableSet.of((Object)this.myActivityFragmentLeakFilter, (Object)new ProjectClassesInstanceFilter(ideProfilerServices));
    }

    @Override
    @NotNull
    public String getName() {
        return "Heap Dump";
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return "hprof";
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) {
        MemoryProfiler.saveHeapDumpToFile(this.myClient, this.mySession, this.myHeapDumpInfo, outputStream, this.myFeatureTracker);
    }

    @VisibleForTesting
    @NotNull
    ClassDb getClassDb() {
        return this.myClassDb;
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        return this.hasLoaded ? this.myHeapSets.values() : Collections.emptyList();
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        return this.myHeapSets.getOrDefault(heapId, null);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        return this.hasLoaded ? this.getHeapSets().stream().map(ClassifierSet::getInstancesStream).flatMap(Function.identity()) : Stream.empty();
    }

    @Override
    public long getStartTimeNs() {
        return this.myHeapDumpInfo.getStartTime();
    }

    @Override
    public long getEndTimeNs() {
        return this.myHeapDumpInfo.getEndTime();
    }

    public boolean getHasNativeAllocations() {
        return this.myHasNativeAllocations;
    }

    @Override
    public ClassDb getClassDatabase() {
        return this.myClassDb;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        Transport.BytesResponse response = this.myClient.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(Long.toString(this.myHeapDumpInfo.getStartTime())).build());
        if (response.getContents() == ByteString.EMPTY) {
            this.myIsLoadingError = true;
            return false;
        }
        this.load(new InMemoryBuffer(response.getContents().asReadOnlyByteBuffer()));
        return true;
    }

    @VisibleForTesting
    public final void load(InMemoryBuffer buffer) {
        NativeRegistryPostProcessor nativeRegistryPostProcessor = new NativeRegistryPostProcessor();
        Snapshot snapshot = Snapshot.createSnapshot((DataBuffer)buffer, (ProguardMap)(this.myProguardMap != null ? this.myProguardMap : new ProguardMap()), Collections.singletonList(nativeRegistryPostProcessor));
        snapshot.computeDominators();
        this.myHasNativeAllocations = nativeRegistryPostProcessor.getHasNativeAllocations();
        this.hasLoaded = true;
        InstanceObject javaLangClassObject = snapshot.getHeaps().stream().flatMap(h -> h.getClasses().stream().filter(obj -> "java.lang.Class".equals(obj.getClassName()))).map(cl -> this.createClassObjectInstance(null, (ClassObj)cl)).findAny().orElse(null);
        if (this.myIdeProfilerServices.getFeatureConfig().isSeparateHeapDumpUiEnabled()) {
            Map heapSets = snapshot.getHeaps().stream().collect(Collectors.toMap(Function.identity(), heap -> new HeapSet(this, heap.getName(), heap.getId())));
            AllHeapSet superHeap = new AllHeapSet(this, heapSets.values().toArray(new HeapSet[0]));
            superHeap.clearClassifierSets();
            this.myHeapSets.put(superHeap.getId(), superHeap);
            heapSets.forEach((heap, heapSet) -> {
                heap.getClasses().forEach(cl -> this.addInstance(superHeap, cl.getId(), this.createClassObjectInstance(javaLangClassObject, (ClassObj)cl)));
                heap.forEachInstance(instance -> {
                    assert (!"java.lang.Class".equals(instance.getClassObj().getClassName()));
                    ClassObj classObj = instance.getClassObj();
                    ClassDb.ClassEntry classEntry = classObj.getSuperClassObj() != null ? this.myClassDb.registerClass(classObj.getId(), classObj.getSuperClassObj().getId(), classObj.getClassName()) : this.myClassDb.registerClass(classObj.getId(), classObj.getClassName());
                    this.addInstance(superHeap, instance.getId(), new HeapDumpInstanceObject(this, (Instance)instance, classEntry, null));
                    return true;
                });
                if (!"default".equals(heap.getName()) || snapshot.getHeaps().size() == 1 || heap.getInstancesCount() > 0) {
                    this.myHeapSets.put(heap.getId(), (HeapSet)heapSet);
                }
            });
        } else {
            snapshot.getHeaps().forEach(heap -> {
                HeapSet heapSet = new HeapSet(this, heap.getName(), heap.getId());
                heap.getClasses().forEach(cl -> this.addInstance(heapSet, cl.getId(), this.createClassObjectInstance(javaLangClassObject, (ClassObj)cl)));
                heap.forEachInstance(instance -> {
                    assert (!"java.lang.Class".equals(instance.getClassObj().getClassName()));
                    ClassObj classObj = instance.getClassObj();
                    ClassDb.ClassEntry classEntry = classObj.getSuperClassObj() != null ? this.myClassDb.registerClass(classObj.getId(), classObj.getSuperClassObj().getId(), classObj.getClassName()) : this.myClassDb.registerClass(classObj.getId(), classObj.getClassName());
                    this.addInstance(heapSet, instance.getId(), new HeapDumpInstanceObject(this, (Instance)instance, classEntry, null));
                    return true;
                });
                if (!"default".equals(heap.getName()) || snapshot.getHeaps().size() == 1 || heap.getInstancesCount() > 0) {
                    this.myHeapSets.put(heap.getId(), heapSet);
                }
            });
        }
    }

    private void addInstance(HeapSet heapSet, long id, InstanceObject instObj) {
        assert (!this.myInstanceIndex.containsKey(id));
        this.myInstanceIndex.put(id, (Object)instObj);
        heapSet.addDeltaInstanceObject(instObj);
    }

    @Override
    public boolean isDoneLoading() {
        return this.hasLoaded || this.myIsLoadingError;
    }

    @Override
    public boolean isError() {
        return this.myIsLoadingError;
    }

    @Override
    public void unload() {
        this.myExecutorService.shutdownNow();
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        return this.myHasNativeAllocations ? Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.NATIVE_SIZE, CaptureObject.ClassifierAttribute.SHALLOW_SIZE, CaptureObject.ClassifierAttribute.RETAINED_SIZE) : Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.SHALLOW_SIZE, CaptureObject.ClassifierAttribute.RETAINED_SIZE);
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        return this.myHasNativeAllocations ? Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.DEPTH, CaptureObject.InstanceAttribute.NATIVE_SIZE, CaptureObject.InstanceAttribute.SHALLOW_SIZE, CaptureObject.InstanceAttribute.RETAINED_SIZE) : Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.DEPTH, CaptureObject.InstanceAttribute.SHALLOW_SIZE, CaptureObject.InstanceAttribute.RETAINED_SIZE);
    }

    @Nullable
    public InstanceObject findInstanceObject(@NotNull Instance instance) {
        return this.hasLoaded ? (InstanceObject)this.myInstanceIndex.get(instance.getId()) : null;
    }

    @NotNull
    InstanceObject createClassObjectInstance(@Nullable InstanceObject javaLangClass, @NotNull ClassObj classObj) {
        String className = javaLangClass == null ? "java.lang.Class" : classObj.getClassName();
        ClassDb.ClassEntry classEntry = classObj.getSuperClassObj() != null ? this.myClassDb.registerClass(classObj.getId(), classObj.getSuperClassObj().getId(), className) : this.myClassDb.registerClass(classObj.getId(), className);
        return new HeapDumpInstanceObject(this, (Instance)classObj, javaLangClass == null ? classEntry : javaLangClass.getClassEntry(), ValueObject.ValueType.CLASS);
    }

    @Override
    public ActivityFragmentLeakInstanceFilter getActivityFragmentLeakFilter() {
        return this.myActivityFragmentLeakFilter;
    }

    @Override
    @NotNull
    public Set<CaptureObjectInstanceFilter> getSupportedInstanceFilters() {
        return this.mySupportedInstanceFilters;
    }

    @Override
    @NotNull
    public Set<CaptureObjectInstanceFilter> getSelectedInstanceFilters() {
        return this.myCurrentInstanceFilters;
    }

    @VisibleForTesting
    ExecutorService getInstanceFilterExecutor() {
        return this.myExecutorService;
    }

    @Override
    public ListenableFuture<Void> addInstanceFilter(@NotNull CaptureObjectInstanceFilter filterToAdd, @NotNull Executor analyzeJoiner) {
        assert (this.mySupportedInstanceFilters.contains(filterToAdd));
        this.myCurrentInstanceFilters.add(filterToAdd);
        return this.myExecutorService.submit(() -> {
            Set currentInstances = this.myHeapSets.values().stream().flatMap(ClassifierSet::getInstancesStream).collect(Collectors.toSet());
            return this.refreshInstances(filterToAdd.filter(currentInstances), analyzeJoiner);
        });
    }

    @Override
    public ListenableFuture<Void> removeInstanceFilter(@NotNull CaptureObjectInstanceFilter filterToRemove, @NotNull Executor analyzeJoiner) {
        if (!this.myCurrentInstanceFilters.contains(filterToRemove)) {
            return CaptureObjectUtils.makeEmptyTask();
        }
        this.myCurrentInstanceFilters.remove(filterToRemove);
        return this.myExecutorService.submit(() -> {
            Set<InstanceObject> matchedInstances = this.getAllInstances();
            for (CaptureObjectInstanceFilter filter : this.myCurrentInstanceFilters) {
                matchedInstances = filter.filter(matchedInstances);
            }
            return this.refreshInstances(matchedInstances, analyzeJoiner);
        });
    }

    @Override
    public ListenableFuture<Void> setSingleFilter(@NotNull CaptureObjectInstanceFilter filter, @NotNull Executor analyzeJoiner) {
        this.myCurrentInstanceFilters.clear();
        this.myCurrentInstanceFilters.add(filter);
        return this.myExecutorService.submit(() -> this.refreshInstances(filter.filter(this.getAllInstances()), analyzeJoiner));
    }

    @Override
    public ListenableFuture<Void> removeAllFilters(@NotNull Executor analyzeJoiner) {
        this.myCurrentInstanceFilters.clear();
        return this.myExecutorService.submit(() -> this.refreshInstances(this.getAllInstances(), analyzeJoiner));
    }

    private Set<InstanceObject> getAllInstances() {
        HashSet<InstanceObject> allInstances = new HashSet<InstanceObject>(this.myInstanceIndex.size());
        this.myInstanceIndex.forEachValue(allInstances::add);
        return allInstances;
    }

    private Void refreshInstances(@NotNull Set<InstanceObject> instances, @NotNull Executor executor) {
        executor.execute(() -> {
            this.myHeapSets.values().forEach(ClassifierSet::clearClassifierSets);
            Consumer<InstanceObject> onInst = this.myHeapSets.values().stream().filter(heap -> heap instanceof AllHeapSet).map(h -> h::addDeltaInstanceObject).findAny().orElse(inst -> this.myHeapSets.get(inst.getHeapId()).addDeltaInstanceObject((InstanceObject)inst));
            instances.forEach(onInst);
        });
        return null;
    }

    @Override
    public boolean canSafelyLoad() {
        Transport.BytesResponse response = this.myClient.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(Long.toString(this.myHeapDumpInfo.getStartTime())).build());
        return MemoryProfilerStage.canSafelyLoadHprof(response.getSerializedSize());
    }
}

