/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.CaptureDataSeries;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureEntry;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.HeapDumpCaptureObject;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HeapDumpSampleDataSeries
extends CaptureDataSeries<CaptureObject> {
    @NotNull
    private final IdeProfilerServices myIdeProfilerServices;

    public HeapDumpSampleDataSeries(@NotNull ProfilerClient client, @Nullable Common.Session session, @NotNull FeatureTracker featureTracker, @NotNull IdeProfilerServices ideProfilerServices) {
        super(client, session, featureTracker);
        this.myIdeProfilerServices = ideProfilerServices;
    }

    public List<SeriesData<CaptureDurationData<CaptureObject>>> getDataForRange(Range range) {
        List<Memory.HeapDumpInfo> infos = MemoryProfiler.getHeapDumpsForSession(this.myClient, this.mySession, range, this.myIdeProfilerServices);
        ArrayList<SeriesData<CaptureDurationData<CaptureObject>>> seriesData = new ArrayList<SeriesData<CaptureDurationData<CaptureObject>>>();
        for (Memory.HeapDumpInfo info : infos) {
            seriesData.add((SeriesData<CaptureDurationData<CaptureObject>>)new SeriesData(HeapDumpSampleDataSeries.getHostTime(info.getStartTime()), new CaptureDurationData<CaptureObject>(HeapDumpSampleDataSeries.getDurationUs(info.getStartTime(), info.getEndTime()), false, false, new CaptureEntry<CaptureObject>(info, () -> new HeapDumpCaptureObject(this.myClient, this.mySession, info, null, this.myFeatureTracker, this.myIdeProfilerServices)), true)));
        }
        return seriesData;
    }
}

