/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.energy.EnergyDuration;
import com.google.common.annotations.VisibleForTesting;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyEventsTableTooltipInfoModel
extends AspectModel<Aspect> {
    @NotNull
    private final Range myGlobalRange;
    private final long mySystemTimeDelta;
    @Nullable
    private EnergyDuration myDuration;
    @Nullable
    private Common.Event myCurrentSelectedEvent;

    @VisibleForTesting
    EnergyEventsTableTooltipInfoModel(@NotNull Range globalRange, long systemTimeDelta) {
        this.myGlobalRange = globalRange;
        this.mySystemTimeDelta = systemTimeDelta;
    }

    public EnergyEventsTableTooltipInfoModel(@NotNull Range globalRange) {
        this(globalRange, TimeUnit.MICROSECONDS.toMillis((long)globalRange.getMax()) - System.currentTimeMillis());
    }

    public void update(@NotNull EnergyDuration duration, @NotNull Range range) {
        Common.Event firstEvent = (Common.Event)duration.getEventList().get(0);
        Common.Event lastEvent = (Common.Event)duration.getEventList().get(duration.getEventList().size() - 1);
        if (range.getMax() < (double)TimeUnit.NANOSECONDS.toMicros(firstEvent.getTimestamp()) || lastEvent.getIsEnded() && range.getMin() > (double)TimeUnit.NANOSECONDS.toMicros(lastEvent.getTimestamp())) {
            duration = null;
        }
        Common.Event newSelectedEvent = null;
        if (duration != null) {
            for (Common.Event event : duration.getEventList()) {
                long minTimestamp = TimeUnit.MICROSECONDS.toNanos((long)range.getMin());
                long maxTimestamp = TimeUnit.MICROSECONDS.toNanos((long)range.getMax());
                if (event.getTimestamp() < minTimestamp || event.getTimestamp() > maxTimestamp) continue;
                newSelectedEvent = event;
                break;
            }
        }
        if (duration != this.myDuration || newSelectedEvent != this.myCurrentSelectedEvent) {
            this.myDuration = duration;
            this.myCurrentSelectedEvent = newSelectedEvent;
            this.changed(Aspect.EVENT);
        }
    }

    @Nullable
    public EnergyDuration getDuration() {
        return this.myDuration;
    }

    @Nullable
    public Common.Event getCurrentSelectedEvent() {
        return this.myCurrentSelectedEvent;
    }

    @Nullable
    public String getStatusString() {
        return this.myCurrentSelectedEvent == null ? "Active" : EnergyDuration.getMetadataName(this.myCurrentSelectedEvent.getEnergyEvent().getMetadataCase());
    }

    public String getDateFormattedString(long timestampMs) {
        SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm a");
        return timeFormat.format(new Date(timestampMs - this.mySystemTimeDelta));
    }

    public String getSimplifiedClockFormattedString(long timestampUs) {
        return TimeFormatter.getSimplifiedClockString((long)(timestampUs - (long)this.myGlobalRange.getMin()));
    }

    public String getRangeString() {
        String unknownString;
        if (this.myDuration == null) {
            return null;
        }
        Common.Event firstEvent = (Common.Event)this.myDuration.getEventList().get(0);
        Common.Event lastEvent = (Common.Event)this.myDuration.getEventList().get(this.myDuration.getEventList().size() - 1);
        String startTime = this.getSimplifiedClockFormattedString(TimeUnit.NANOSECONDS.toMicros(firstEvent.getTimestamp()));
        switch (this.myDuration.getKind()) {
            case WAKE_LOCK: {
                unknownString = "Unreleased";
                break;
            }
            case JOB: {
                unknownString = "Unfinished";
                break;
            }
            default: {
                unknownString = "Alive";
            }
        }
        String endTime = lastEvent.getIsEnded() ? this.getSimplifiedClockFormattedString(TimeUnit.NANOSECONDS.toMicros(lastEvent.getTimestamp())) : unknownString;
        return startTime + " - " + endTime;
    }

    public String getDurationString() {
        if (this.myDuration == null) {
            return null;
        }
        Common.Event firstEvent = (Common.Event)this.myDuration.getEventList().get(0);
        Common.Event lastEvent = (Common.Event)this.myDuration.getEventList().get(this.myDuration.getEventList().size() - 1);
        if (!lastEvent.getIsEnded()) {
            return null;
        }
        return TimeFormatter.getSingleUnitDurationString((long)TimeUnit.NANOSECONDS.toMicros(lastEvent.getTimestamp() - firstEvent.getTimestamp()));
    }

    public static enum Aspect {
        EVENT;

    }
}

