/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profiler.proto.EnergyServiceGrpc;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.energy.EnergyDuration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyEventsFetcher {
    private final AspectObserver myAspectObserver = new AspectObserver();
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myTransportClient;
    @NotNull
    private final EnergyServiceGrpc.EnergyServiceBlockingStub myEnergyClient;
    @NotNull
    private final Common.Session mySession;
    private final boolean myIsUnifiedPipeline;
    @NotNull
    private final List<Listener> myListeners = new ArrayList<Listener>();
    @NotNull
    private final Range myRange;
    @Nullable
    private List<EnergyDuration> myDurationList;

    public EnergyEventsFetcher(@NotNull ProfilerClient profilerClient, @NotNull Common.Session session, @NotNull Range range, boolean isUnifiedPipeline) {
        this.myTransportClient = profilerClient.getTransportClient();
        this.myEnergyClient = profilerClient.getEnergyClient();
        this.mySession = session;
        this.myIsUnifiedPipeline = isUnifiedPipeline;
        this.myRange = range;
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::handleRangeUpdated);
        this.handleRangeUpdated();
    }

    public void addListener(@NotNull Listener listener) {
        this.myListeners.add(listener);
        if (this.myDurationList != null) {
            this.fireListeners(this.myDurationList);
        }
    }

    private void handleRangeUpdated() {
        ArrayList<EnergyDuration> durationList = new ArrayList<EnergyDuration>();
        long minNS = TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMin());
        long maxNs = TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMax());
        if (!this.myRange.isEmpty()) {
            if (this.myIsUnifiedPipeline) {
                Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setKind(Common.Event.Kind.ENERGY_EVENT).setGroupId(0L).setFromTimestamp(minNS).setToTimestamp(maxNs).build();
                Transport.GetEventGroupsResponse response = this.myTransportClient.getEventGroups(request);
                for (Transport.EventGroup eventGroup : response.getGroupsList()) {
                    durationList.add(new EnergyDuration(eventGroup.getEventsList()));
                }
            } else {
                EnergyProfiler.EnergyRequest request = EnergyProfiler.EnergyRequest.newBuilder().setSession(this.mySession).setStartTimestamp(minNS).setEndTimestamp(maxNs).build();
                List eventList = this.myEnergyClient.getEvents(request).getEventsList();
                List<EnergyDuration> partialDurations = EnergyDuration.groupById(eventList);
                for (EnergyDuration partialDuration : partialDurations) {
                    EnergyProfiler.EnergyEventGroupRequest eventGroupRequest = EnergyProfiler.EnergyEventGroupRequest.newBuilder().setSession(this.mySession).setEventId(((Common.Event)partialDuration.getEventList().get(0)).getGroupId()).build();
                    durationList.add(new EnergyDuration(this.myEnergyClient.getEventGroup(eventGroupRequest).getEventsList()));
                }
            }
        }
        if (this.myDurationList == null || !this.myDurationList.equals(durationList)) {
            this.myDurationList = durationList;
            this.fireListeners(this.myDurationList);
        }
    }

    private void fireListeners(@NotNull List<EnergyDuration> list) {
        for (Listener l : this.myListeners) {
            l.onUpdated(list);
        }
    }

    public static interface Listener {
        public void onUpdated(@NotNull List<EnergyDuration> var1);
    }
}

