/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.energy.EnergyDuration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class EnergyEventsCountDataSeries
implements DataSeries<Long> {
    private final TransportServiceGrpc.TransportServiceBlockingStub myClient;
    private final long myStreamId;
    private final int myPid;
    private final Predicate<EnergyDuration.Kind> myKindFilter;

    public EnergyEventsCountDataSeries(TransportServiceGrpc.TransportServiceBlockingStub client, long streamId, int pid, Predicate<EnergyDuration.Kind> kindFilter) {
        this.myClient = client;
        this.myStreamId = streamId;
        this.myPid = pid;
        this.myKindFilter = kindFilter;
    }

    public List<SeriesData<Long>> getDataForRange(Range range) {
        long minUs = (long)range.getMin();
        long maxUs = (long)range.getMax();
        long minNs = TimeUnit.MICROSECONDS.toNanos(minUs);
        long maxNs = TimeUnit.MICROSECONDS.toNanos(maxUs);
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.myStreamId).setPid(this.myPid).setKind(Common.Event.Kind.ENERGY_EVENT).setGroupId(0L).setFromTimestamp(minNs).setToTimestamp(maxNs).build();
        Transport.GetEventGroupsResponse response = this.myClient.getEventGroups(request);
        long count2 = response.getGroupsList().stream().filter(group -> this.myKindFilter.test(EnergyDuration.Kind.from(group.getEvents(0).getEnergyEvent()))).count();
        return Arrays.asList(new SeriesData(minUs, (Object)count2), new SeriesData(maxUs, (Object)count2));
    }
}

