/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.systemtrace.CpuFramesModel;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SliceStream;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrame;
import com.android.tools.profilers.cpu.systemtrace.ThreadModel;
import com.android.tools.profilers.cpu.systemtrace.TraceEventModel;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class SystemTraceFrameManager {
    private final List<SystemTraceFrame> myMainThreadFrames;
    private final List<SystemTraceFrame> myRenderThreadFrames;
    private final int myRenderThreadId;

    public SystemTraceFrameManager(@NotNull ProcessModel process) {
        this.myMainThreadFrames = SystemTraceFrameManager.buildFramesList(SystemTraceFrame.FrameThread.MAIN, process, process.getId());
        this.myRenderThreadId = SystemTraceFrameManager.findRenderThreadId(process);
        this.myRenderThreadFrames = SystemTraceFrameManager.buildFramesList(SystemTraceFrame.FrameThread.RENDER, process, this.myRenderThreadId);
        this.findAssociatedFrames();
    }

    private void findAssociatedFrames() {
        int mainFramesIterator = 0;
        int renderFramesIterator = 0;
        while (mainFramesIterator < this.myMainThreadFrames.size() && renderFramesIterator < this.myRenderThreadFrames.size()) {
            SystemTraceFrame mainThreadFrame = this.myMainThreadFrames.get(mainFramesIterator);
            SystemTraceFrame renderThreadFrame = this.myRenderThreadFrames.get(renderFramesIterator);
            if (renderThreadFrame == SystemTraceFrame.EMPTY || renderThreadFrame.getEndUs() < mainThreadFrame.getEndUs()) {
                ++renderFramesIterator;
                continue;
            }
            if (mainThreadFrame == SystemTraceFrame.EMPTY || renderThreadFrame.getStartUs() > mainThreadFrame.getEndUs() || renderThreadFrame.getStartUs() < mainThreadFrame.getStartUs()) {
                ++mainFramesIterator;
                continue;
            }
            mainThreadFrame.setAssociatedFrame(renderThreadFrame);
            renderThreadFrame.setAssociatedFrame(mainThreadFrame);
            ++mainFramesIterator;
            ++renderFramesIterator;
        }
    }

    @NotNull
    private static List<SystemTraceFrame> buildFramesList(SystemTraceFrame.FrameThread frameThread, ProcessModel processModel, int threadId) {
        ArrayList<SystemTraceFrame> frames = new ArrayList<SystemTraceFrame>();
        Optional<ThreadModel> activeThread = processModel.getThreads().stream().filter(thread2 -> thread2.getId() == threadId).findFirst();
        if (!activeThread.isPresent()) {
            return frames;
        }
        new SliceStream(activeThread.get().getTraceEvents()).matchPattern(Pattern.compile(frameThread.getIdentifierRegEx())).enumerate(sliceGroup -> {
            SystemTraceFrame frame = new SystemTraceFrame((TraceEventModel)sliceGroup, CpuFramesModel.SLOW_FRAME_RATE_US, frameThread);
            frames.add(frame);
            return SliceStream.EnumerationResult.SKIP_CHILDREN;
        });
        return frames;
    }

    @VisibleForTesting
    List<SystemTraceFrame> getFramesList(@NotNull SystemTraceFrame.FrameThread thread2) {
        switch (thread2) {
            case MAIN: {
                return this.myMainThreadFrames;
            }
            case RENDER: {
                return this.myRenderThreadFrames;
            }
        }
        return new ArrayList<SystemTraceFrame>();
    }

    public int getRenderThreadId() {
        return this.myRenderThreadId;
    }

    @NotNull
    public List<SeriesData<SystemTraceFrame>> getFrames(@NotNull SystemTraceFrame.FrameThread thread2) {
        ArrayList<SeriesData<SystemTraceFrame>> framesSeries = new ArrayList<SeriesData<SystemTraceFrame>>();
        List<SystemTraceFrame> framesList = this.getFramesList(thread2);
        for (int i2 = 1; i2 < framesList.size(); ++i2) {
            SystemTraceFrame current = framesList.get(i2);
            SystemTraceFrame past = framesList.get(i2 - 1);
            framesSeries.add((SeriesData<SystemTraceFrame>)new SeriesData(past.getStartUs(), (Object)past));
            if (past.getEndUs() >= current.getStartUs()) continue;
            framesSeries.add((SeriesData<SystemTraceFrame>)new SeriesData(past.getEndUs(), (Object)SystemTraceFrame.EMPTY));
        }
        if (!framesList.isEmpty()) {
            SystemTraceFrame lastFrame = framesList.get(framesList.size() - 1);
            framesSeries.add((SeriesData<SystemTraceFrame>)new SeriesData(lastFrame.getStartUs(), (Object)lastFrame));
            framesSeries.add((SeriesData<SystemTraceFrame>)new SeriesData(lastFrame.getEndUs(), (Object)SystemTraceFrame.EMPTY));
        }
        return framesSeries;
    }

    private static int findRenderThreadId(@NotNull ProcessModel process) {
        Optional<ThreadModel> renderThread = process.getThreads().stream().filter(thread2 -> thread2.getName().equalsIgnoreCase("RenderThread")).findFirst();
        return renderThread.map(ThreadModel::getId).orElse(Integer.MAX_VALUE);
    }
}

