/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.profilers.cpu.systemtrace.TraceEventModel;
import com.google.common.annotations.VisibleForTesting;
import org.jetbrains.annotations.NotNull;

public class SystemTraceFrame
extends EventAction<PerfClass>
implements DurationData {
    public static final SystemTraceFrame EMPTY = new SystemTraceFrame(0L, 0L, 0.0, 0L, FrameThread.OTHER);
    private static final String APP_MAIN_THREAD_FRAME_ID_MPLUS = "Choreographer#doFrame";
    private static final String APP_RENDER_THREAD_FRAME_ID_MPLUS = "(DrawFrame|doFrame|queueBuffer)";
    private SystemTraceFrame myAssociatedFrame;
    private final double myCpuTimeUs;
    private final long myLongFrameTimeUs;
    @NotNull
    private final PerfClass myPerfClass;
    private final FrameThread myThread;

    public SystemTraceFrame(@NotNull TraceEventModel eventModel, long longFrameTimeUs, FrameThread thread2) {
        this(eventModel.getStartTimestampUs(), eventModel.getEndTimestampUs(), eventModel.getCpuTimeUs(), longFrameTimeUs, thread2);
    }

    @VisibleForTesting
    public SystemTraceFrame(long startUs, long endUs, double cpuTimeUs, long longFrameTimeUs, FrameThread thread2) {
        super(startUs, endUs, (Object)PerfClass.NOT_SET);
        this.myCpuTimeUs = cpuTimeUs;
        this.myLongFrameTimeUs = longFrameTimeUs;
        this.myThread = thread2;
        this.myPerfClass = this.getDurationUs() > this.myLongFrameTimeUs ? PerfClass.BAD : PerfClass.GOOD;
    }

    public FrameThread getThread() {
        return this.myThread;
    }

    public void setAssociatedFrame(SystemTraceFrame associatedFrame) {
        this.myAssociatedFrame = associatedFrame;
    }

    public SystemTraceFrame getAssociatedFrame() {
        return this.myAssociatedFrame;
    }

    @NotNull
    public PerfClass getPerfClass() {
        return this.myPerfClass;
    }

    public PerfClass getTotalPerfClass() {
        double associatedFrameLengthUs;
        if (this == EMPTY || this.myPerfClass == PerfClass.NOT_SET) {
            return PerfClass.NOT_SET;
        }
        double d = associatedFrameLengthUs = this.myAssociatedFrame == null ? 0.0 : (double)this.myAssociatedFrame.getDurationUs();
        if (associatedFrameLengthUs + (double)this.getDurationUs() > (double)this.myLongFrameTimeUs) {
            return PerfClass.BAD;
        }
        return PerfClass.GOOD;
    }

    public long getDurationUs() {
        return this.getEndUs() - this.getStartUs();
    }

    public double getCpuTimeUs() {
        return this.myCpuTimeUs;
    }

    @NotNull
    public PerfClass getType() {
        return this.getPerfClass();
    }

    public static enum FrameThread {
        MAIN("Choreographer#doFrame"),
        RENDER("(DrawFrame|doFrame|queueBuffer)"),
        OTHER("");

        private final String myIdentifierRegEx;

        public String getIdentifierRegEx() {
            return this.myIdentifierRegEx;
        }

        private FrameThread(String identifierRegEx) {
            this.myIdentifierRegEx = identifierRegEx;
        }
    }

    public static enum PerfClass {
        NOT_SET,
        GOOD,
        BAD;

    }
}

