/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.BaseCpuCapture;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.systemtrace.CpuSystemTraceData;
import com.android.tools.profilers.cpu.systemtrace.CpuThreadSliceInfo;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerEvent;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrame;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrameManager;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceSurfaceflingerManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SystemTraceCpuCapture
extends BaseCpuCapture
implements CpuSystemTraceData {
    @NotNull
    private final Map<Integer, List<SeriesData<ThreadState>>> myThreadStateDataSeries;
    @NotNull
    private final Map<Integer, List<SeriesData<CpuThreadSliceInfo>>> myCpuThreadSliceInfoStates;
    @NotNull
    private final List<SeriesData<Long>> myCpuUtilizationSeries;
    @NotNull
    private final Map<String, List<SeriesData<Long>>> myProcessMemoryCountersMap;
    @NotNull
    private final List<Map<String, List<SeriesData<Long>>>> myCpuCounters;
    private final boolean myIsMissingData;
    @NotNull
    private final SystemTraceFrameManager myFrameManager;
    @NotNull
    private final SystemTraceSurfaceflingerManager mySurfaceflingerManager;

    public SystemTraceCpuCapture(long traceId, @NotNull SystemTraceModelAdapter model, @NotNull Map<CpuThreadInfo, CaptureNode> captureNodes, @NotNull Map<Integer, List<SeriesData<ThreadState>>> threadStateData, @NotNull Map<Integer, List<SeriesData<CpuThreadSliceInfo>>> cpuSchedData, @NotNull List<SeriesData<Long>> cpuUtilizationData, @NotNull List<Map<String, List<SeriesData<Long>>>> cpuCounters, @NotNull Map<String, List<SeriesData<Long>>> processMemoryCountersMap, @NotNull SystemTraceFrameManager frameManager, @NotNull SystemTraceSurfaceflingerManager surfaceflingerManager) {
        super(traceId, model.getSystemTraceTechnology(), new Range((double)model.getCaptureStartTimestampUs(), (double)model.getCaptureEndTimestampUs()), captureNodes);
        this.myThreadStateDataSeries = threadStateData;
        this.myCpuThreadSliceInfoStates = cpuSchedData;
        this.myCpuUtilizationSeries = cpuUtilizationData;
        this.myCpuCounters = cpuCounters;
        this.myProcessMemoryCountersMap = processMemoryCountersMap;
        this.myIsMissingData = model.isCapturePossibleCorrupted();
        this.myFrameManager = frameManager;
        this.mySurfaceflingerManager = surfaceflingerManager;
    }

    @Override
    public CpuSystemTraceData getSystemTraceData() {
        return this;
    }

    @Override
    @NotNull
    public List<SeriesData<ThreadState>> getThreadStatesForThread(int threadId) {
        return this.myThreadStateDataSeries.getOrDefault(threadId, new ArrayList());
    }

    @Override
    @NotNull
    public List<SeriesData<CpuThreadSliceInfo>> getCpuThreadSliceInfoStates(int cpu) {
        return this.myCpuThreadSliceInfoStates.getOrDefault(cpu, new ArrayList());
    }

    @Override
    @NotNull
    public List<SeriesData<Long>> getCpuUtilizationSeries() {
        return this.myCpuUtilizationSeries;
    }

    @Override
    @NotNull
    public List<Map<String, List<SeriesData<Long>>>> getCpuCounters() {
        return this.myCpuCounters;
    }

    @Override
    public int getCpuCount() {
        return this.myCpuThreadSliceInfoStates.size();
    }

    @Override
    @NotNull
    public Map<String, List<SeriesData<Long>>> getMemoryCounters() {
        return this.myProcessMemoryCountersMap;
    }

    @Override
    public boolean isMissingData() {
        return this.myIsMissingData;
    }

    @Override
    @NotNull
    public List<SeriesData<SystemTraceFrame>> getFrames(@NotNull SystemTraceFrame.FrameThread threadType) {
        return this.myFrameManager.getFrames(threadType);
    }

    @Override
    @NotNull
    public List<SeriesData<SurfaceflingerEvent>> getSurfaceflingerEvents() {
        return this.mySurfaceflingerManager.getSurfaceflingerEvents();
    }

    @Override
    @NotNull
    public List<SeriesData<Long>> getVsyncCounterValues() {
        return this.mySurfaceflingerManager.getVsyncCounterValues();
    }

    @Override
    @NotNull
    public List<SeriesData<Long>> getBufferQueueCounterValues() {
        return this.mySurfaceflingerManager.getBufferQueueValues();
    }

    @Override
    public int getRenderThreadId() {
        return this.myFrameManager.getRenderThreadId();
    }
}

