/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.idea.protobuf.CodedInputStream;
import com.android.tools.idea.protobuf.ExtensionRegistryLite;
import com.android.tools.profilers.cpu.systemtrace.PerfettoPacketDBSorter;
import com.android.tools.profilers.cpu.systemtrace.TrebuchetBufferProducer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.Predicate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import perfetto.protos.PerfettoTrace;
import trebuchet.io.DataSlice;

public class PerfettoProducer
implements TrebuchetBufferProducer {
    private static final String FTRACE_HEADER = "# tracer: nop";
    private static final Predicate<PerfettoTrace.FtraceEvent> IS_SUPPORTED_EVENT = event -> event.hasSchedSwitch() || event.hasSchedWakeup() || event.hasSchedWaking() || event.hasPrint();
    private final ArrayDeque<String> myGeneratedTrebuchetLines = new ArrayDeque();
    private final PerfettoPacketDBSorter mySorter = new PerfettoPacketDBSorter();
    private final HashMap<Integer, String> myMappedState = new HashMap();

    private static double nanosToSeconds(double nanos) {
        return nanos / (double)TimeUnit.SECONDS.toNanos(1L);
    }

    private static double nanosToMillis(double nanos) {
        return nanos / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    }

    public static boolean verifyFileHasPerfettoTraceHeader(@NotNull File file) {
        try {
            CodedInputStream inputStream = CodedInputStream.newInstance((InputStream)new FileInputStream(file));
            ExtensionRegistryLite packetRegistry = ExtensionRegistryLite.newInstance();
            PerfettoTrace.registerAllExtensions((ExtensionRegistryLite)packetRegistry);
            PerfettoTrace.TracePacket packet = PerfettoProducer.readOnePacket(inputStream, packetRegistry);
            return packet != null;
        }
        catch (IOException ex) {
            PerfettoProducer.getLogger().error((Throwable)ex);
            return false;
        }
    }

    private static PerfettoTrace.TracePacket readOnePacket(CodedInputStream stream, ExtensionRegistryLite packetRegistry) {
        try {
            stream.resetSizeCounter();
            int tag = stream.readTag();
            if (tag == 0) {
                return null;
            }
            if (tag != 10) {
                PerfettoProducer.getLogger().error(String.format("Encountered unknown tag (%d) when attempting to parse perfetto capture.", tag));
                return null;
            }
            return (PerfettoTrace.TracePacket)stream.readMessage(PerfettoTrace.TracePacket.parser(), packetRegistry);
        }
        catch (IOException ex) {
            PerfettoProducer.getLogger().error((Throwable)ex);
            return null;
        }
    }

    private static Logger getLogger() {
        return Logger.getInstance(PerfettoProducer.class);
    }

    public PerfettoProducer() {
        this.myMappedState.put(1, "S");
        this.myMappedState.put(2, "D");
        this.myMappedState.put(4, "T");
        this.myMappedState.put(8, "t");
        this.myMappedState.put(16, "Z");
        this.myMappedState.put(32, "X");
        this.myMappedState.put(64, "x");
        this.myMappedState.put(128, "K");
        this.myMappedState.put(256, "W");
        this.myMappedState.put(512, "P");
        this.myMappedState.put(1024, "N");
    }

    @Override
    public boolean parseFile(File file) {
        try {
            this.convertToTraceLines(file);
            return true;
        }
        catch (IOException ex) {
            PerfettoProducer.getLogger().error((Throwable)ex);
            return false;
        }
    }

    private void convertToTraceLines(File file) throws IOException {
        PerfettoTrace.TracePacket packet;
        HashMap<Integer, Integer> myTidToTgid = new HashMap<Integer, Integer>();
        HashMap<Integer, String> myTidToName = new HashMap<Integer, String>();
        myTidToName.put(0, "<idle>");
        PerfettoTrace.TracePacket clockSyncPacket = null;
        ExtensionRegistryLite packetRegistry = ExtensionRegistryLite.newInstance();
        PerfettoTrace.registerAllExtensions((ExtensionRegistryLite)packetRegistry);
        CodedInputStream inputStream = CodedInputStream.newInstance((InputStream)new FileInputStream(file));
        while ((packet = PerfettoProducer.readOnePacket(inputStream, packetRegistry)) != null) {
            if (packet.hasFtraceEvents()) {
                PerfettoTrace.FtraceEventBundle bundle = packet.getFtraceEvents();
                for (PerfettoTrace.FtraceEvent event : bundle.getEventList()) {
                    if (!event.hasSchedSwitch()) continue;
                    PerfettoTrace.SchedSwitchFtraceEvent schedSwitch = event.getSchedSwitch();
                    myTidToName.putIfAbsent(schedSwitch.getPrevPid(), schedSwitch.getPrevComm());
                    myTidToName.putIfAbsent(schedSwitch.getNextPid(), schedSwitch.getNextComm());
                }
                continue;
            }
            if (packet.hasProcessTree()) {
                PerfettoTrace.ProcessTree processTree = packet.getProcessTree();
                for (PerfettoTrace.ProcessTree.Process process : processTree.getProcessesList()) {
                    myTidToTgid.putIfAbsent(process.getPid(), process.getPid());
                }
                for (PerfettoTrace.ProcessTree.Thread thread2 : processTree.getThreadsList()) {
                    myTidToTgid.putIfAbsent(thread2.getTid(), thread2.getTgid());
                    if (!thread2.hasName()) continue;
                    myTidToName.putIfAbsent(thread2.getTid(), thread2.getName());
                }
                continue;
            }
            if (!packet.hasClockSnapshot() || clockSyncPacket != null) continue;
            clockSyncPacket = packet;
        }
        LineFormatter formatter = new LineFormatter(myTidToTgid, myTidToName);
        inputStream = CodedInputStream.newInstance((InputStream)new FileInputStream(file));
        while ((packet = PerfettoProducer.readOnePacket(inputStream, packetRegistry)) != null) {
            if (!packet.hasFtraceEvents()) continue;
            PerfettoTrace.FtraceEventBundle bundle = packet.getFtraceEvents();
            for (PerfettoTrace.FtraceEvent event : bundle.getEventList()) {
                if (!IS_SUPPORTED_EVENT.apply((Object)event)) continue;
                this.mySorter.addLine(event.getTimestamp(), formatter.formatLine(event, bundle.getCpu()));
            }
        }
        this.myGeneratedTrebuchetLines.add("# Initial Data Required by Importer");
        this.myGeneratedTrebuchetLines.add(FTRACE_HEADER);
        assert (clockSyncPacket != null);
        this.addClockSyncLines(clockSyncPacket, formatter);
        this.mySorter.resetForIterator();
    }

    private void addClockSyncLines(@NotNull PerfettoTrace.TracePacket clockSyncPacket, LineFormatter formatter) {
        PerfettoTrace.ClockSnapshot snapshot = clockSyncPacket.getClockSnapshot();
        PerfettoTrace.ClockSnapshot.Clock monotonicClock = null;
        PerfettoTrace.ClockSnapshot.Clock realtimeClock = null;
        PerfettoTrace.ClockSnapshot.Clock boottimeClock = null;
        for (PerfettoTrace.ClockSnapshot.Clock clock : snapshot.getClocksList()) {
            PerfettoTrace.ClockSnapshot.Clock.BuiltinClocks clockType = PerfettoTrace.ClockSnapshot.Clock.BuiltinClocks.forNumber((int)clock.getClockId());
            if (clockType == null) continue;
            switch (clockType) {
                case MONOTONIC: {
                    monotonicClock = clock;
                    break;
                }
                case REALTIME: {
                    realtimeClock = clock;
                    break;
                }
                case BOOTTIME: {
                    boottimeClock = clock;
                    break;
                }
            }
        }
        assert (monotonicClock != null && realtimeClock != null && boottimeClock != null);
        this.myGeneratedTrebuchetLines.add(formatter.formatEventPrefix(boottimeClock.getTimestamp(), 0, Short.MAX_VALUE) + String.format("tracing_mark_write: trace_event_clock_sync: parent_ts=%.6f", PerfettoProducer.nanosToSeconds(monotonicClock.getTimestamp())));
        this.myGeneratedTrebuchetLines.add(formatter.formatEventPrefix(boottimeClock.getTimestamp(), 0, Short.MAX_VALUE) + "tracing_mark_write: trace_event_clock_sync: realtime_ts=" + PerfettoProducer.nanosToMillis(realtimeClock.getTimestamp()));
    }

    @Override
    @Nullable
    public DataSlice next() {
        String line;
        if (!this.myGeneratedTrebuchetLines.isEmpty()) {
            line = this.myGeneratedTrebuchetLines.poll();
        } else {
            if (!this.mySorter.hasNext()) {
                return null;
            }
            line = this.mySorter.next();
        }
        assert (line != null);
        byte[] data = String.format("%s\n", line.substring(0, Math.min(1022, line.length()))).getBytes(Charsets.UTF_8);
        return new DataSlice(data);
    }

    @Override
    public void close() {
        this.myGeneratedTrebuchetLines.clear();
        this.mySorter.close();
    }

    private String formatEvent(PerfettoTrace.FtraceEvent event) {
        if (event.hasSchedSwitch()) {
            PerfettoTrace.SchedSwitchFtraceEvent sched = event.getSchedSwitch();
            return String.format("sched_switch: prev_comm=%s prev_pid=%d prev_prio=%d prev_state=%s ==> next_comm=%s next_pid=%d next_prio=%d", sched.getPrevComm(), sched.getPrevPid(), sched.getPrevPrio(), this.mapStateToString(sched.getPrevState()), sched.getNextComm(), sched.getNextPid(), sched.getNextPrio());
        }
        if (event.hasSchedCpuHotplug()) {
            PerfettoTrace.SchedCpuHotplugFtraceEvent sched = event.getSchedCpuHotplug();
            return String.format("sched_cpu_hotplug: cpu %d %s error=%d", sched.getAffectedCpu(), sched.getStatus() == 0 ? "offline" : "online", sched.getError());
        }
        if (event.hasSchedBlockedReason()) {
            PerfettoTrace.SchedBlockedReasonFtraceEvent sched = event.getSchedBlockedReason();
            return String.format("sched_blocked_reason: pid=%d iowait=%d caller=%s", sched.getPid(), sched.getIoWait(), sched.getCaller());
        }
        if (event.hasSchedWaking()) {
            PerfettoTrace.SchedWakingFtraceEvent sched = event.getSchedWaking();
            return String.format("sched_waking: comm=%s pid=%d prio=%d success=%d target_cpu=%03d", sched.getComm(), sched.getPid(), sched.getPrio(), sched.getSuccess(), sched.getTargetCpu());
        }
        if (event.hasSchedWakeup()) {
            PerfettoTrace.SchedWakeupFtraceEvent sched = event.getSchedWakeup();
            return String.format("sched_wakeup: comm=%s pid=%d prio=%d success=%d target_cpu=%03d", sched.getComm(), sched.getPid(), sched.getPrio(), sched.getSuccess(), sched.getTargetCpu());
        }
        if (event.hasPrint()) {
            return String.format("tracing_mark_write: %s", event.getPrint().getBuf().replace("\n", ""));
        }
        PerfettoProducer.getLogger().assertTrue(IS_SUPPORTED_EVENT.apply((Object)event), (Object)"Attempted to format a non-supported event.");
        return "";
    }

    @VisibleForTesting
    public String mapStateToString(long state) {
        int TASK_STATE_HIGH_BIT_MASK = 2048;
        int TASK_STATE_LOW_BITS_MASK = 2047;
        StringBuilder mappedState = new StringBuilder();
        if ((state & (long)TASK_STATE_LOW_BITS_MASK) == 0L) {
            mappedState.append("R");
        } else {
            for (int i2 = 0; i2 < 11; ++i2) {
                int flag = (int)(state & (long)(1 << i2));
                if (flag == 0) continue;
                mappedState.append(this.myMappedState.get(flag));
            }
        }
        if ((state & (long)TASK_STATE_HIGH_BIT_MASK) != 0L) {
            mappedState.append("+");
        }
        return mappedState.toString();
    }

    private class LineFormatter {
        private final Map<Integer, Integer> myTidToTgid;
        private final Map<Integer, String> myTidToName;

        private LineFormatter(Map<Integer, Integer> tidToTgid, Map<Integer, String> tidToName) {
            this.myTidToTgid = tidToTgid;
            this.myTidToName = tidToName;
        }

        private String formatLine(PerfettoTrace.FtraceEvent event, int cpu) {
            return this.formatEventPrefix(event.getTimestamp(), cpu, event.getPid()) + PerfettoProducer.this.formatEvent(event);
        }

        private String formatEventPrefix(long timestampNs, int cpu, int pid) {
            String name = this.myTidToName.getOrDefault(pid, "<...>");
            String timeSeconds = String.format("%.6f", PerfettoProducer.nanosToSeconds(timestampNs));
            String tgid = "-----";
            if (this.myTidToTgid.containsKey(pid)) {
                tgid = String.format("%5d", this.myTidToTgid.get(pid));
            }
            return String.format("%s-%d     (%s) [%3d] d..3 %s: ", name, pid, tgid, cpu, timeSeconds);
        }
    }
}

