/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.systemtrace.CpuSystemTraceData;
import com.android.tools.profilers.cpu.systemtrace.CpuThreadSliceInfo;
import javax.swing.DefaultListModel;
import org.jetbrains.annotations.NotNull;

public class CpuKernelModel
extends DefaultListModel<CpuState> {
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final Range myRange;
    @NotNull
    private final AspectObserver myAspectObserver;

    public CpuKernelModel(@NotNull Range range, @NotNull CpuProfilerStage stage) {
        this.myRange = range;
        this.myStage = stage;
        this.myAspectObserver = new AspectObserver();
        this.myStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this::captureStateChanged);
        range.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::contentsChanged);
    }

    private void captureStateChanged() {
        this.removeAllElements();
        CpuCapture capture = this.myStage.getCapture();
        if (capture != null && capture.getSystemTraceData() != null) {
            CpuSystemTraceData systemTraceData = capture.getSystemTraceData();
            int count2 = systemTraceData.getCpuCount();
            for (int i2 = 0; i2 < count2; ++i2) {
                this.addElement(new CpuState(i2, systemTraceData));
            }
        }
        this.contentsChanged();
    }

    private void contentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public class CpuState {
        private final int myCpuId;
        @NotNull
        private final DataSeries<CpuThreadSliceInfo> myCpuStateDataSeries;
        @NotNull
        private final StateChartModel<CpuThreadSliceInfo> myModel;

        public CpuState(@NotNull int cpuId, CpuSystemTraceData systemTraceData) {
            this.myCpuId = cpuId;
            this.myModel = new StateChartModel();
            this.myCpuStateDataSeries = new LazyDataSeries<CpuThreadSliceInfo>(() -> systemTraceData.getCpuThreadSliceInfoStates(this.myCpuId));
            this.myModel.addSeries(new RangedSeries(CpuKernelModel.this.myRange, this.myCpuStateDataSeries));
        }

        public int getCpuId() {
            return this.myCpuId;
        }

        @NotNull
        public DataSeries<CpuThreadSliceInfo> getSeries() {
            return this.myCpuStateDataSeries;
        }

        @NotNull
        public StateChartModel<CpuThreadSliceInfo> getModel() {
            return this.myModel;
        }
    }
}

