/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeNode;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class TopDownNode
extends CpuTreeNode<TopDownNode> {
    private static final String INVALID_ID = "";

    public TopDownNode(@NotNull CaptureNode node) {
        super(node.getData() == null ? INVALID_ID : node.getData().getId());
        this.addNode(node);
        this.addChildren(node, false);
        this.addChildren(node, true);
    }

    private void addChildren(@NotNull CaptureNode node, boolean unmatched) {
        HashMap<String, TopDownNode> children2 = new HashMap<String, TopDownNode>();
        for (CaptureNode child : node.getChildren()) {
            assert (child.getData() != null);
            if (unmatched != child.isUnmatched()) continue;
            TopDownNode prev = (TopDownNode)children2.get(child.getData().getId());
            TopDownNode other = new TopDownNode(child);
            if (prev == null) {
                children2.put(child.getData().getId(), other);
                this.addChild(other);
                continue;
            }
            prev.merge(other);
        }
    }

    private void merge(TopDownNode other) {
        this.addNodes(other.getNodes());
        HashMap<String, TopDownNode> children2 = new HashMap<String, TopDownNode>();
        HashMap<String, TopDownNode> unmatchedChildren = new HashMap<String, TopDownNode>();
        for (TopDownNode child : this.getChildren()) {
            if (child.isUnmatched()) {
                unmatchedChildren.put(child.getId(), child);
                continue;
            }
            children2.put(child.getId(), child);
        }
        for (TopDownNode otherChild : other.getChildren()) {
            TopDownNode existing = otherChild.isUnmatched() ? (TopDownNode)unmatchedChildren.get(otherChild.getId()) : (TopDownNode)children2.get(otherChild.getId());
            if (existing != null) {
                existing.merge(otherChild);
                continue;
            }
            this.addChild(otherChild);
        }
    }

    @Override
    @NotNull
    public CaptureNodeModel getMethodModel() {
        CaptureNodeModel model = this.getNodes().get(0).getData();
        assert (model != null);
        return model;
    }

    @Override
    public CaptureNode.FilterType getFilterType() {
        return this.getNodes().get(0).getFilterType();
    }
}

